<?php
/**
 * The template for displaying singular post-types: posts, pages and user-defined custom post types.
 *
 * @package Harika
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}


use HarikaTheme\Classes\Harika_Helper as Helper;

// $single_sidebar_show = Helper::get_option('single_sidebar_show', false);

// $sidebar_layout = '';
// if ($single_sidebar_show != 'yes') {
// 	$sidebar_layout = ' no-sidebar';
// }

// $single_breadcrumb_show = Helper::get_option('single_breadcrumb_show', false);
// $single_tags_show = Helper::get_option('single_tags_show', false);
// $single_authorbox_show = Helper::get_option('single_authorbox_show', false);





while (have_posts()):
	the_post();
	?>

	<?php harika_breadcrumb(); ?>


	<main id="content" <?php post_class('site-main post-single main-max' . $sidebar_layout . ''); ?> role="main">
		<div class="main-col">

			<div class="post-content-section single-section">
				<div class="head">
					<?php if (apply_filters('harika_page_title', true)): ?>
						<div class="title">
							<?php the_title('<h1 class="entry-title single-title">', '</h1>'); ?>
						</div>
					<?php endif; ?>

					<div class="categories harika-exc-cat-color">
						<?php echo Helper::harika_get_category(); ?>
					</div>
				</div>

				<?php if (has_post_thumbnail()): ?>
					<div class="featured">
						<?php

						$featured_img_url = get_the_post_thumbnail_url('', 'single-image');
						if (has_post_format('video')) {


							$harika_meta_video = get_post_meta(get_the_ID(), 'harika-meta-direct-video', true);
							if (!empty($harika_meta_video)) { ?>
								<video id="player" preload="none" playsinline controls data-poster="<?php echo $featured_img_url ?>"
									poster="<?php echo $featured_img_url ?>">
									<source src="<?php echo $harika_meta_video; ?>" type="video/mp4" />
								</video>
								<?php
							} elseif (!empty($aparat_video)) {
								echo $aparat_video;
							} else {
								the_post_thumbnail('single-image');
							}



						} else if (has_post_format('audio')) {


							$harika_meta_audio = get_post_meta(get_the_ID(), 'harika-meta-direct-audio', true);
							if (!empty($harika_meta_audio)) { ?>
									<div class="featured-with-audio">
										<?php the_post_thumbnail('single-image');
										echo '<audio width="100%" controls><source src="' . $harika_meta_audio . '" type="audio/mpeg"></audio>'; ?>
									</div>
								<?php
							} else {
								the_post_thumbnail('single-image');
							}

						} else {
							the_post_thumbnail('single-image');
						}

						?>

						<div class="meta">

							<div class="right">
								<span class="author"><?php echo get_avatar(get_the_author_meta('user_email'), '34', ''); ?>
									توسط: <?php the_author_posts_link(); ?></span>
								<span class="date"><i class="date-icon"></i> تاریخ انتشار: <?php echo get_the_date(); ?></span>
								<span class="comments-count"><i class="comments-icon"></i> <?php echo get_comments_number(); ?>
								<?php echo __('دیدگاه', 'harika'); ?></span>
							</div>

							<div class="left">
								<?php share_button(); ?>
							</div>

						</div>
					</div>

				<?php endif; ?>

				<div class="content wp-editor-content">
					<?php the_content(); ?>
					<?php wp_link_pages(); ?>
				</div>



			</div>

			<?php if ( has_tag() ): ?>
				<div class="tags">
					<span class="title">برچسب ها :</span>
					<?php the_tags('<span class="tag-links">', null, '</span>'); ?>
				</div>
			<?php endif; ?>


				<div class="harika-authorbox-widget author-box-section single-section">
					<div class="avatar">
						<?php echo get_avatar(get_the_author_meta('user_email'), '150', ''); ?>
					</div>
					<div class="info">
						<div class="top-content">
							<h3><?php the_author_link(); ?></h3>
							<div class="author-social-links">
								<?php echo harika_get_user_social_links(); ?>
							</div>
						</div>
						<div class="description">
							<?php the_author_meta('description'); ?>
						</div>
					</div>
				</div>



			<?php comments_template(); ?>

		</div>


			<div class="sidebar-col">
				<?php dynamic_sidebar('primary_sidebar'); ?>
			</div>


	</main>



	<?php
endwhile;





