<?php
/**
 * The template for displaying header.
 *
 * @package harika
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
use HarikaTheme\Classes\Harika_Helper as Helper;

$site_logo_type  = Helper::get_option( 'site_logo_type', 'image' );
$site_text_logo  = Helper::get_option( 'site_text_logo', __( 'هاریکا', 'harika' ) );
$site_image_logo = Helper::get_option( 'site_image_logo', ['url' => HARIKA_ASSETS . '/img/harika-logo.svg'] );

$panel_logo_type  = Helper::get_option( 'panel_logo_type', 'image' );
$panel_text_logo  = Helper::get_option( 'panel_text_logo', __( 'هاریکا', 'harika' ) );
$panel_image_logo = Helper::get_option( 'panel_image_logo', ['url' => HARIKA_ASSETS . '/img/harika-logo.svg'] );

$header_button  = Helper::get_option( 'header_button', 'disabled' );
$button_text    = Helper::get_option( 'button_text', __( 'تماس بگیرید', 'harika' ) );
$button_url     = Helper::get_option( 'button_url', '#' );
$button_icon    = Helper::get_option( 'button_icon', 'fas fa-long-arrow-left' );

$breakpoint = Helper::get_option( 'mobile_breakpoint', 'mobile-expand-xl' );

$site_name = get_bloginfo( 'name' );
$tagline   = get_bloginfo( 'description', 'display' );
$header_nav_menu = wp_nav_menu( [
	'theme_location' => 'primary_menu',
	'fallback_cb' => false,
	'echo' => false,
] );
?>

<header id="site-header" class="site-header default-code-header" role="banner">
    <div class="container">
        <div class="site-branding">
            <?php
            if ( has_custom_logo() ) {
                $site_image_logo['url'];
            } elseif ( $site_name ) {
                ?>
                <h1 class="site-title">
                    <a href="<?php echo esc_url( home_url() ) ?>">
                    <?php if ( 'text' === $site_logo_type && ! empty ( $site_text_logo ) ) : ?>
                        <?php echo esc_html( $site_text_logo )?>
                    <?php elseif ( 'image' === $site_logo_type && ! empty ( $site_image_logo['url'] ) ) : ?>
                        <img src="<?php echo esc_url( $site_image_logo['url'] ) ?>" alt="<?php echo esc_html( get_bloginfo() ) ?>">
                    <?php endif; ?>
                    </a>
                </h1>
                <p class="site-description">
                    <?php
                    if ( $tagline ) {
                        echo esc_html( $tagline );
                    }
                    ?>
                </p>
            <?php } ?>
        </div>

        <?php if ( $header_nav_menu ) : ?>
                <div class="harika-menu-widget header-menu harika-menu-default" data-harika-nav="{id:n-1111111}">
                    <nav class="harika-navigation" role="navigation">
                        <?php
                        // PHPCS - escaped by WordPress with "wp_nav_menu"
                        echo $header_nav_menu; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                        ?>
                    </nav>
                    <div class="harika-navigation-toggle-holder n-1111111">
                        <div class="harika-navigation-toggle">
                            <i class="eicon-menu-bar"></i>
                            <span class="close-screen"></span>
                        </div>
                    </div>
                    <nav class="harika-navigation-dropdown n-1111111 closed" role="navigation">
                        <?php
                        wp_nav_menu( [
                            'theme_location'  => 'primary_menu',
                            'fallback_cb'     => false,
                            'menu_class'      => 'menu side menu-ul n-1111111',
                            'container_class' => 'sidemenu-container',
                        ] );

                        ?>
                    </nav>
                </div>
            <?php endif; ?>
        </div>
</header>
