<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @package Harika
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use HarikaTheme\Classes\Harika_Helper as Helper;

$error_title = Helper::get_option( 'error_title', 'متاسفیم ، نوشته ای یافت نشد!' );
$error_text 	 = Helper::get_option( 'error_text', 'جهت بازگشت به صفحه اصلی از دکمه زیر استفاده فرمایید' );
$error_button_text 	 = Helper::get_option( 'error_button_text', false );

$error_button_show 	 = Helper::get_option( 'error_button_show', 'yes' );


?>
<main id="content" class="site-main main-max" role="main">
	<div class="harika-404-page">
		
		<div class="error-code">
			<strong>404</strong>
			</div>
			<div class="error-message">
			<h3><?php echo $error_title; ?></h3>
			</div>
			<div class="error-body">
			<span><?php echo $error_text; ?></span>
			<?php if($error_button_show == 'yes'): ?>
			<a href="<?php echo esc_url( home_url( '/' ) ) ?>" class="btn"><i class="fa fa-arrow-circle-left"> </i> <?php echo $error_button_text; ?></a>
			<?php endif; ?>
		</div>
		
	</div>
</main>
