<?php
/**
 * Template for displaying search forms
 *
 * @package Harika
 */
use HarikaTheme\Classes\Harika_svg;
?>
<form role="search" method="get" class="harika-search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<input type="search" class="search-field"
			placeholder="<?php echo esc_attr_x( 'جستجو ...', 'placeholder', 'harika' ); ?>"
			value="<?php echo get_search_query() ?>" name="s"
			title="<?php echo esc_attr_x( 'کلمه کلیدی را وارد کنید', 'label', 'harika' ); ?>"/>
	<button type="submit" class="search-submit"><?php echo Harika_svg::get_icon_svg('search'); ?></button>
</form>