<?php





///*******************************************************///
///                *Default Slider Config*                ///
///*******************************************************///


if ( ! function_exists( 'harika_slider_config_default' ) ) {

	function harika_slider_config_default( $args = array() ) {
		$args_default = array(
			'speed'          => 10,
			'effect'         => 'slide',
            'loop'           => true,
			'autoHeight'     => false,
			'autoplay'       => false,
			'delay'          => 10,
			'pagination'     => false,
			'navigation'     => false,
			'responsive'     => false,
			'slidesPerView'  => 4,
			'tSlidesPerView' => 2,
			'mSlidesPerView' => 1,
			'spaceBetween'   => 15,
			'tSpaceBetween'  => 15,
			'mSpaceBetween'  => 15,
            
		);

		return array_merge( $args, array_diff_key( $args_default, $args ) );
	}
}







///*******************************************************///
///                *breadcrumb*                  ///
///*******************************************************///
function harika_breadcrumb() {
$sep = '<span class="sep"> > </span>';
    echo '<div class="harika-breadcrumb">';
        echo '<div class="box">';

            if (!is_front_page()) {
            
            // Start the breadcrumb with a link to your homepage
                echo '<a href="';
                echo get_option('home');
                echo '">';
                echo 'صفحه اصلی';
                echo '</a>' . $sep;
            
            // Check if the current page is a category, an archive or a single page. If so show the category or archive name.
                if (is_category() || is_single() ){
                    the_category('<span class="and">'.__(' و ', 'harika').'</span>');
                } elseif (is_archive() || is_single()){
                    if ( is_day() ) {
                        printf( __( '%s', 'harika' ), get_the_date() );
                    } elseif ( is_month() ) {
                        printf( __( '%s', 'harika' ), get_the_date( _x( 'F Y', 'فرمت تاریخ آرشیو ماهانه', 'harika' ) ) );
                    } elseif ( is_year() ) {
                        printf( __( '%s', 'harika' ), get_the_date( _x( 'Y', 'فرمت تاریخ آرشیو سالانه', 'harika' ) ) );
                    } else {
                        _e( 'آرشیو وبلاگ', 'harika' );
                    }
                }
            
            // If the current page is a single post, show its title with the separator
                if (is_single()) {
                    echo ' : ';
                    echo '<span class="title">';
                    the_title();
                    echo '</span>';
                }
            
            // If the current page is a static page, show its title.
                if (is_page()) {
                    echo the_title();
                }
            
            // if you have a static page assigned to be you posts list page. It will find the title of the static page and display it. i.e Home >> Blog
                if (is_home()){
                    global $post;
                    $page_for_posts_id = get_option('page_for_posts');
                    if ( $page_for_posts_id ) { 
                        $post = get_page($page_for_posts_id);
                        setup_postdata($post);
                        the_title();
                        rewind_posts();
                    }
                }

            }
        
        
        echo '</div>';
    echo '</div>';
}




///*******************************************************///
///                *single share btn*                  ///
///*******************************************************///
function share_button() {
?>
    <div id="open-share-box" class="share-post default">
        <i class="open-share-box-icon"></i>
    </div>

    <span id="share-box-back" class="default"></span>

    <div id="share-box" class="social-share default">
        <div class="info">

            <h5 class="modal-title" id="shareModalLabel">اشتراک گذاری</h5>

            <button id="close-share-box" type="button" class="close default" data-dismiss="modal" aria-label="Close">
                <i class="fas fa-xmark"></i>
            </button>

        </div>
        <div class="share-body">
            <p>با استفاده از روش‌های زیر می‌توانید این صفحه را با دوستان خود به اشتراک بگذارید.</p>
            <div class="socials">
                <a class="share_button_facebook" target="_blank" href="http://www.facebook.com/share.php?u=<?php esc_url(the_permalink());?>title=<?php echo get_the_title(); ?>"><i class="fab fa-facebook-f"></i></a>
                <a class="share_button_twitter" target="_blank" href="http://twitter.com/intent/tweet?status=<?php echo get_the_title(); ?>+<?php esc_url(the_permalink());?>"><i class="fab fa-twitter"></i></a>
                <a class="share_button_linkedin" target="_blank" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php esc_url(the_permalink());?>&title=<?php echo get_the_title(); ?>&source=<?php echo esc_url(home_url('/'));?>"><i class="fab fa-linkedin-in"></i></a>
                <a class="share_button_pinterest" target="_blank" href="http://pinterest.com/pin/create/bookmarklet/?url=<?php esc_url(the_permalink());?>&is_video=false&description=<?php echo get_the_title(); ?>"><i class="fab fa-pinterest-p"></i></a>
                <a class="share_button_telegram" target="_blank" href="https://t.me/share/url?url=<?php esc_url(the_permalink());?>"><i class="fab fa-telegram"></i></a>
                <a class="share_button_whatsapp" target="_blank" href="https://api.whatsapp.com/send?text=<?php echo get_the_title(); ?>%20<?php esc_url(the_permalink());?>"><i class="fab fa-whatsapp"></i></a>
                <a class="share_button_mailto" target="_blank" href="mailto:<?php esc_url(the_permalink());?>"><i class="fas fa-envelope"></i></a>
            </div>
        </div>
        <div class="filed-link dir-ltr copy-text">
            <label class="input-prepend">
                <i class="fas fa-link"></i>
            </label>

            <input class="shareLink" type="text" value="<?php esc_url(the_permalink());?>" readonly="">

            <span class="copy-text-btn" data-toggle="tooltip" data-placement="right" title="" data-original-title="کپی لینک">
                <i class="fas fa-copy"></i>
            </span>
        </div>
    </div>


<?php
}




  
///*******************************************************///
///                   *ADD IMAGE SIZES*                   ///
///*******************************************************///
// add_action( 'after_setup_theme', 'wpdocs_theme_setup' );
// function wpdocs_theme_setup() {
//     add_image_size( 'harika-80', 80, 80, true );
//     add_image_size( 'single-image', 1200 );
//     add_image_size( 'archives-image', 400 );
//     add_image_size( 'harika-700-450', 700, 450, false );
//     add_image_size( 'harika-300', 300, 300, true );
    
// }


  

///*******************************************************///
///             *CUSTOM FONT FOR ELEMENTOR*               ///
///*******************************************************///

add_filter( 'elementor/fonts/groups', function( $font_groups ) {
	$font_groups['HARIKA'] = __( 'هاریکا' );
	return $font_groups;
} );
add_filter( 'elementor/fonts/additional_fonts', function( $additional_fonts ) {
	$additional_fonts['IRANSansX'] = 'HARIKA';
	return $additional_fonts;
} );







///*******************************************************///
///                      *Allow SVG*                      ///
///*******************************************************///

add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {

	global $wp_version;
	if ( $wp_version !== '4.7.1' ) {
	   return $data;
	}
  
	$filetype = wp_check_filetype( $filename, $mimes );
  
	return [
		'ext'             => $filetype['ext'],
		'type'            => $filetype['type'],
		'proper_filename' => $data['proper_filename']
	];
  
  }, 10, 4 );
  
  function cc_mime_types( $mimes ){
	$mimes['svg'] = 'image/svg+xml';
	return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
  








///*******************************************************///
///               *Add User Social Links*                 ///
///*******************************************************///

function harika_add_user_social_links( $user_contact ) {

    /* Add user contact methods */
    $user_contact['x-twitter'] = __('لینک اکس', 'textdomain');
    $user_contact['facebook']  = __('لینک فیس بوک', 'textdomain');
    $user_contact['linkedin']  = __('لینک لینکدین', 'textdomain');
    $user_contact['github']    = __('لینک گیت هاب', 'textdomain');
    $user_contact['instagram'] = __('لینک اینستاگرام', 'textdomain');
    $user_contact['dribbble']  = __('لینک دریبل', 'textdomain');
    $user_contact['behance']   = __('لینک بیهانس', 'textdomain');
    $user_contact['skype']     = __('لینک اسکایپ', 'textdomain');

    return $user_contact;
}
add_filter('user_contactmethods', 'harika_add_user_social_links');

function harika_get_user_social_links() {
    $return  = '<ul class="list-inline">';
    if(!empty(get_the_author_meta('x-twitter'))) {
        $return .= '<li><a href="'.get_the_author_meta('x-twitter').'" title="X" target="_blank" id="x-twitter"><i class="fab fa-x-twitter"></i></a></li>';
    }
    if(!empty(get_the_author_meta('facebook'))) {
        $return .= '<li><a href="'.get_the_author_meta('facebook').'" title="Facebook" target="_blank" id="facebook"><i class="fab fa-facebook-f"></i></a></li>';
    }
    if(!empty(get_the_author_meta('linkedin'))) {
        $return .= '<li><a href="'.get_the_author_meta('linkedin').'" title="LinkedIn" target="_blank" id="linkedin"><i class="fab fa-linkedin-in"></i></a></li>';
    }
    if(!empty(get_the_author_meta('github'))) {
        $return .= '<li><a href="'.get_the_author_meta('github').'" title="Github" target="_blank" id="github"><i class="fab fa-github"></i></a></li>';
    }
    if(!empty(get_the_author_meta('instagram'))) {
        $return .= '<li><a href="'.get_the_author_meta('instagram').'" title="Instagram" target="_blank" id="instagram"><i class="fab fa-instagram"></i></a></li>';
    }
    if(!empty(get_the_author_meta('dribbble'))) {
        $return .= '<li><a href="'.get_the_author_meta('dribbble').'" title="Dribbble" target="_blank" id="dribbble"><i class="fab fa-dribbble"></i></a></li>';
    }
    if(!empty(get_the_author_meta('behance'))) {
        $return .= '<li><a href="'.get_the_author_meta('behance').'" title="Behance" target="_blank" id="behance"><i class="fab fa-behance"></i></a></li>';
    }
    if(!empty(get_the_author_meta('skype'))) {
        $return .= '<li><a href="'.get_the_author_meta('skype').'" title="Skype" target="_blank" id="skype"><i class="fab fa-skype"></i></a></li>';
    }
    $return .= '</ul>';

    return $return;
}











