<?php
/**
 * The template for maintenance mode
 *
 * @package Harika
 */

use HarikaTheme\Classes\Harika_Helper as Helper;

wp_head();

$maintenance_img      = Helper::get_option( 'maintenance_img', ['url' => HARIKA_ASSETS . '/img/maintenance.png'] );
$maintenance_title    = Helper::get_option( 'maintenance_title', __( 'سایت در حال حاضر جهت تعمیر غیرفعال می باشد', 'harika' ) );
$maintenance_subtitle = Helper::get_option( 'maintenance_subtitle', __( 'ما از هر ناراحتی پدید آمده پوزش می خواهیم', 'harika' ) );
$maintenance_page     = Helper::get_option( 'maintenance_page' );
?>
<div class="harika-maintenance-page">
	<div class="container">
		<div class="maintenance-content">
			<div class="maintenance-img">
				<img src="<?php echo esc_url( $maintenance_img['url'] ) ?>" alt="<?php esc_html_e( 'حالت تعمیر', 'harika' )?>">
			</div>
			<h2 class="maintenance-title">
				<?php echo esc_html( $maintenance_title ); ?>
			</h2>
			<p><?php echo esc_html( $maintenance_subtitle ); ?></p>
		</div>
	</div>
</div>
<?php
wp_footer();
