<?php


if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

$elementor_settings = get_post_meta(get_option('elementor_active_kit'), '_elementor_page_settings', true);


get_header();

$is_elementor_theme_exist = function_exists('elementor_theme_do_location');


if (is_archive() || is_home()) {
	if (harika_get_post_cat_template_id() == '0' || harika_get_post_cat_template_id() == '' || harika_get_post_cat_template_id() == 'default') {
		if (! $is_elementor_theme_exist || ! elementor_theme_do_location('archive')) {
			get_template_part('template-parts/archive');
		}
	} else {
		echo do_shortcode('[harika-tb-post_cat id="'.harika_get_post_cat_template_id().'"]');
	}
} elseif (is_page()) {
	if (! $is_elementor_theme_exist || ! elementor_theme_do_location('single')) {
		get_template_part('template-parts/page');
	}
} elseif (is_singular()) { 

	if (harika_get_post_single_template_id() == '0' || harika_get_post_single_template_id() == '' || harika_get_post_single_template_id() == 'default') {
		if (! $is_elementor_theme_exist || ! elementor_theme_do_location('single')) {
			get_template_part('template-parts/single');
		}
	} else {
		echo do_shortcode('[harika-tb-post_single id="'.harika_get_post_single_template_id().'"]');
	}
} elseif (is_search()) {
	if (! $is_elementor_theme_exist || ! elementor_theme_do_location('archive')) {
		get_template_part('template-parts/search');
	}
} elseif (is_404()) {
	if (! $is_elementor_theme_exist || ! elementor_theme_do_location('single')) {
		get_template_part('template-parts/404');
	}
}

get_footer();
