<?php
if (!defined('ABSPATH')) {
    exit('No direct script access allowed');
}

if (class_exists('CSF')) {
    CSF::createWidget('harika_recent_post_widget', [
        'title' => esc_html__('*هاریکا - آخرین پست ها', 'harika'),
        'classname' => 'harika-wp-recent-posts',
        'description' => esc_html__('نمایش آخرین پست ها', 'harika'),
        'fields' => [
            [
                'id' => 'title',
                'type' => 'text',
                'title' => esc_html('عنوان', 'harika'),
                'default' => esc_html__('آخرین پست ها', 'harika'),
            ],
            [
                'id' => 'post_count',
                'type' => 'number',
                'title' => esc_html('تعداد پست ها برای نمایش', 'harika'),
                'default' => 3,
            ],
        ],
    ]);

    function harika_recent_post_widget($args, $instance)
    {
        $post_count = (!empty($instance['post_count'])) ? absint($instance['post_count']) : 3;

        $query = new WP_Query(apply_filters('widget_posts_args', [
            'posts_per_page' => $post_count,
            'no_found_rows' => true,
            'post_status' => 'publish',
            'ignore_sticky_posts' => true,
        ], $instance));

        if (!$query->have_posts()) {
            return;
        }

        $allowed_html = [
            'div' => [
                'id' => [],
                'class' => [],
            ],
            'h3' => [
                'class' => [],
            ],
            'h4' => [
                'class' => [],
            ],
            'h5' => [
                'class' => [],
            ],
            'h6' => [
                'class' => [],
            ],
        ];

        echo wp_kses($args['before_widget'], $allowed_html);

        if (!empty($instance['title'])) {
            echo wp_kses($args['before_title'], $allowed_html) . apply_filters('widget_title', $instance['title']) . wp_kses($args['after_title'], $allowed_html);
        }
        ?>
        <div class="lastposts-widget">
            <ul class="lastposts-ul" style="display:block;">
                <?php while ($query->have_posts()):
                    $query->the_post();
                    $post_title = get_the_title();
                    ?>
                    <li>
                        <?php echo get_the_post_thumbnail('', 'harika-80', array('class' => 'attachment-sidebar size-sidebar')); ?>
                        <a href="<?php echo get_permalink() ?>" title="<?php echo $post_title ?>"><?php echo $post_title ?></a>
                        <span><?php esc_html_e('تاریخ انتشار: ', 'harika'); ?><?php echo get_the_date('j F Y'); ?></span>
                    </li>
                <?php endwhile;
                wp_reset_postdata(); ?>
            </ul>
        </div>



        <?php echo wp_kses($args['after_widget'], $allowed_html);
    }
}