<?php

if (!defined('ABSPATH')) {
    exit('No direct script access allowed');
}

if (class_exists('CSF')) {

    CSF::createWidget('harika_wp_link_box_widget', [
        'title' => esc_html__('*هاریکا - جعبه لینک', 'harika'),
        'classname' => 'harika-wp-link-box',
        'description' => esc_html__('جعبه لینک', 'harika'),
        'fields' => [
            [
                'id' => 'title',
                'type' => 'text',
                'title' => esc_html('عنوان', 'harika'),
                'default' => esc_html__('فیس بوک', 'harika'),
            ],
            [
                'id' => 'text',
                'type' => 'text',
                'title' => esc_html('متن دکمه', 'harika'),
                'default' => esc_html__('دنبال کنید', 'harika'),
            ],
            [
                'id' => 'url',
                'type' => 'text',
                'title' => esc_html('آدرس دکمه', 'harika'),
                'default' => esc_html('#', 'harika'),
            ],
            [
                'id' => 'icon',
                'type' => 'icon',
                'title' => esc_html('آیکن', 'harika'),
                'default' => 'fab fa-facebook-square',
            ],
            [
                'id' => 'color',
                'type' => 'color',
                'title' => esc_html('رنگ متن', 'harika'),
                'default' => '#fff'
            ],
            [
                'id' => 'bg_color',
                'type' => 'color',
                'title' => esc_html('رنگ پس زمینه', 'harika'),
                'default' => '#222222'
            ],
            [
                'id' => 'mgButtom',
                'type' => 'number',
                'title' => esc_html('فاصله از پایین', 'harika'),
                'default' => 20,
            ],

        ],
    ]);

    function harika_wp_link_box_widget($args, $instance)
    {



?>


        <a class="harika-iconlink-widget its-wp-widget " href="<?php echo $instance['url'] ?>" target="_blank" rel="nofollow" style="--var-widget-bg: <?php echo $instance['bg_color'] ?>; --var-widget-color: <?php echo $instance['color'] ?>; margin-bottom: <?php echo $instance['mgButtom'] . 'px' ?>;">
            <div class="content">
                <i aria-hidden="true" class="<?php echo $instance['icon'] ?>"></i>
                <span class="title"><?php echo $instance['title'] ?></span>
            </div>
            <span class="btn"><?php echo $instance['text'] ?></span>
        </a>


<?php
    }
}
