<?php
namespace HarikaTheme\TemplateBuilder;

use CSF;

defined( 'ABSPATH' ) || exit;

class Template_Metaboxes {

    protected static $instance = null;
    private $prefix            = 'harika_template_meta';

    public static function instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function initialize() {
        if ( ! class_exists( 'CSF' ) ) {
            return;
        }

        $this->init_metaboxes();
    }

    public function init_metaboxes() {
        CSF::createMetabox( $this->prefix, [
            'title'        => esc_html__( 'تنظیمات تمپلیت', 'harika' ),
            'post_type'    => 'harika_template',
            'show_restore' => true,
            'theme'        => 'dark',
            'data_type'    => 'unserialize',
        ] );

        CSF::createSection( $this->prefix, [
            'fields' => [
                [
                    'id'     => 'harika_tb_settings',
                    'type'   => 'fieldset',
                    'title'  => esc_html__( 'گزینه های اصلی', 'harika' ),
                    'fields' => [
                        [
                            'id'          => 'template_type',
                            'type'        => 'select',
                            'title'       => esc_html__( 'نوع تمپلیت', 'harika' ),
                            'placeholder' => esc_html__( 'انتخاب نوع', 'harika' ),
                            'options'     => [
                                'header'         => esc_html__( 'هدر', 'harika' ),
                                'footer'         => esc_html__( 'فوتر', 'harika' ),
                                'post_single'    => esc_html__( 'سینگل پست', 'harika' ),
                                'post_cat'       => esc_html__( 'آرشیو وبلاگ', 'harika' ),
                                'block'          => esc_html__( 'بلوک', 'harika' ),
                                'megamenu'       => esc_html__( 'مگامنو', 'harika' ),
                            ],
                            'default'     => 'block',
                        ],


                    ],
                ],
                
                
            ],
        ] );
    }
}

Template_Metaboxes::instance()->initialize();