<?php
namespace HarikaTheme\TemplateBuilder;

defined( 'ABSPATH' ) || exit;

/**
 * Builder Header CPT Class
 */
class Template_CPT {
    /**
     * @var string
     *
     * Set post type params
     */
    private $type = 'harika_template';
    private $slug = 'harika_template';
    private $name;
    private $singular_name;
    private $plural_name;

    /**
     * Class Constructor
     */
    public function __construct() {
        $this->name          = __( 'سازنده تمپلیت', 'harika' );
        $this->singular_name = __( 'تمپلیت', 'harika' );
        $this->plural_name   = __( 'تمپلیت ها', 'harika' );

        add_action( 'init', [$this, 'register_post_type'] );
        add_filter( 'single_template', [$this, 'custom_templates'] );
    }

    /**
     * Register post type
     */
    public function register_post_type() {
        $labels = [
            'name'               => $this->name,
            'singular_name'      => $this->singular_name,
            'add_new'            => sprintf( esc_html__( '%s جدید', 'harika' ), $this->singular_name ),
            'add_new_item'       => sprintf( esc_html__( 'افزودن %s جدید', 'harika' ), $this->singular_name ),
            'edit_item'          => sprintf( esc_html__( 'ویرایش %s', 'harika' ), $this->singular_name ),
            'new_item'           => sprintf( esc_html__( '%s جدید', 'harika' ), $this->singular_name ),
            'all_items'          => sprintf( esc_html__( 'همه %s', 'harika' ), $this->plural_name ),
            'view_item'          => sprintf( esc_html__( 'مشاهده %s', 'harika' ), $this->name ),
            'search_items'       => sprintf( esc_html__( 'جستجو %s', 'harika' ), $this->name ),
            'not_found'          => sprintf( esc_html__( 'هیچ تمپلیتی یافت نشد', 'harika' ), $this->name ),
            'not_found_in_trash' => sprintf( esc_html__( 'هیچ تمپلیتی در زباله دان یافت نشد', 'harika' ), $this->name ),
            'parent_item_colon'  => '',
            'menu_name'          => $this->name,
        ];

        $args = [
            'labels'              => $labels,
            'has_archive'         => false,
            'show_ui'             => true,
            'show_in_menu'        => false,
            'show_in_admin_bar'   => false,
            'show_in_nav_menu'    => true,
            'public'              => true,
            'rewrite'             => ['slug' => $this->slug],
            'show_in_rest'        => false,
            'exclude_from_search' => true,
            'capability_type'     => 'post',
            'hierarchical'        => false,
            'menu_icon'           => 'dashicons-layout',
            'supports'            => ['title', 'author', 'elementor'],
        ];

        register_post_type( $this->type, $args );
    }

    /**
     * Custom Template
     *
     * @param $single_template
     * @link https://codex.wordpress.org/Plugin_API/Filter_Reference/single_template;
     */
    public function custom_templates( $single_template ) {
        global $post;

        if ( $post->post_type == $this->type ) {
            $meta = get_post_meta( $post->ID, 'harika_tb_settings', true );

            if ( isset( $meta['template_type'] ) ) {
                $template_type = $meta['template_type'];
            } else {
                $template_type = '';
            }

            if ( 'post_single' === $template_type ) {
                $single_template = HARIKA_INCLUDES . '/template-builder/templates/post-single.php';
            } else if ( 'post_cat' === $template_type ) {
                $single_template = HARIKA_INCLUDES . '/template-builder/templates/post-cat.php';
            } else if ( 'megamenu' === $template_type ) {
                $single_template = HARIKA_INCLUDES . '/template-builder/templates/megamenu.php';
            } else {
                $single_template = HARIKA_INCLUDES . '/template-builder/templates/canvas.php';
            }
        }

        return $single_template;
    }
}

new Template_CPT();