<?php
namespace HarikaTheme\TemplateBuilder;

defined( 'ABSPATH' ) || exit;

/**
 * Builder Admin Class
 *
 * @since 2.0.0
 */
class Template_Admin {

    /**
     * Constructor
     */
    public function __construct() {

        add_action( 'admin_menu', [$this, 'admin_menu'] );

        add_filter( 'manage_harika_template_posts_columns', [$this, 'custom_columns'] );
        add_filter( 'manage_harika_template_posts_custom_column', [$this, 'display_custom_columns'] );
    }

    /**
     * Register admin menu
     *
     * @return void
     */
    public function admin_menu() {
        add_menu_page(
            __( 'سازنده تمپلیت', 'harika' ),
            __( 'سازنده تمپلیت', 'harika' ),
            'manage_options',
            'edit.php?post_type=harika_template',
            '',
            HARIKA_ASSETS . '/img/harika-tb.svg',
            3
        );
    }

    /**
     * Add Custom Columns in admin view table
     *
     * @param [type] $columns
     * @return void
     */
    public function custom_columns( $columns ) {
        $columns['type'] = __( 'نوع', 'harika' );
        $columns['info'] = __( 'اطلاعات', 'harika' );

        return $columns;
    }

    /**
     * Admin Custom Columns view table content
     *
     * @param [type] $name
     *
     * @return void
     */
    public function display_custom_columns( $name ) {
        global $post;

        switch ( $name ) {

        case 'type':
            $get_type = $this->get_template_type( $post->ID );
            switch ($get_type) {
                case 'header':
                    echo esc_html__( 'هدر', 'harika' );
                break;
                
                case 'footer':
                    echo esc_html__( 'فوتر', 'harika' );
                break;

                case 'post_single':
                    echo esc_html__( 'سینگل پست', 'harika' );
                break;

                case 'post_cat':
                    echo esc_html__( 'آرشیو وبلاگ', 'harika' );
                break;

                case 'block':
                    echo esc_html__( 'بلوک', 'harika' );
                break;

                case 'megamenu':
                    echo esc_html__( 'مگامنو', 'harika' );
                break;
            }
        break;


        case 'info':
            echo $this->get_item_info( $post->ID );
        break;
        }
    }

    /**
     * Get Template Type
     *
     * @param int $post_id
     *
     * @return string
     */
    public function get_template_type( $post_id ) {

        $meta = get_post_meta( $post_id, 'harika_tb_settings', true );

        if ( isset( $meta['template_type'] ) ) {
            $template_type = $meta['template_type'];
        } else {
            $template_type = '';
        }

        return $template_type;
    }

    /**
     * Get Item Info to Display in admin table
     *
     * @param int $post_id
     *
     * @return void
     */
    public function get_item_info( $post_id ) {
        $type = $this->get_template_type( $post_id );
        $info = '';

        if ( $type == 'header' ) {
            $info = '<input class="wp-ui-text-highlight code widefat" type="text" onfocus="this.select();" readonly="readonly" value="[harika-tb-header id=&quot;' . $post_id . '&quot;]">';
        } elseif ( $type == 'footer' ) {
            $info = '<input class="wp-ui-text-highlight code widefat" type="text" onfocus="this.select();" readonly="readonly" value="[harika-tb-footer id=&quot;' . $post_id . '&quot;]">';
        } elseif ( $type == 'post_single' ) {
            $info = '<input class="wp-ui-text-highlight code widefat" type="text" onfocus="this.select();" readonly="readonly" value="[harika-tb-post_single id=&quot;' . $post_id . '&quot;]">';
        } elseif ( $type == 'post_cat' ) {
            $info = '<input class="wp-ui-text-highlight code widefat" type="text" onfocus="this.select();" readonly="readonly" value="[harika-tb-post_cat id=&quot;' . $post_id . '&quot;]">';
        } elseif ( $type == 'block' ) {
            $info = '<input class="wp-ui-text-highlight code widefat" type="text" onfocus="this.select();" readonly="readonly" value="[harika-tb-block id=&quot;' . $post_id . '&quot;]">';
        } elseif ( $type == 'megamenu' ) {
            $info = '<input class="wp-ui-text-highlight code widefat" type="text" onfocus="this.select();" readonly="readonly" value="[harika-tb-megamenu id=&quot;' . $post_id . '&quot;]">';
        } else {
            $info = $this->get_pretty_condition( 'include', $post_id ) . '</br>' . $this->get_pretty_condition( 'exclude', $post_id );
        }

        return $info;
    }

    /**
     * Get pretty condition to display in admin table
     *
     * @param string $type
     * @param [type] $post_id
     *
     * @return void
     *
     */
    public function get_pretty_condition( $type, $post_id ) {
        $info    = null;
        $include = get_post_meta( $post_id, 'harika_tb_' . $type, true );

        if ( is_array( $include ) ) {
            $lastKey = array_keys( $include );
            $lastKey = \end( $lastKey );
            
            if($type == 'include'){
                $type = esc_html__( 'شامل', 'harika' );
            } else if($type == 'exclude'){
                $type = esc_html__( 'عدم شامل', 'harika' );
            } 

            $info .= '<b>' . ucfirst( $type ) . ': </b>';
            $index = 0;

            foreach ( $include as $rule ) {
                $index++;

                if ( $index != 1 ) {
                    $info .= ', ';
                }


                    $get_rule = $rule['rule'];

                    switch ($get_rule) {
                    case 'entire_website':
                        $rule['rule'] = esc_html__( 'کل سایت', 'harika' );
                    break;
                    case 'all_pages':
                        $rule['rule'] = esc_html__( 'همه صفحات', 'harika' );
                    break;
                    case 'front_page':
                        $rule['rule'] = esc_html__( 'صفحه اصلی', 'harika' );
                    break;
                    case 'post_page':
                        $rule['rule'] = esc_html__( 'صفحه پست', 'harika' );
                    break;
                    case 'post_details':
                        $rule['rule'] = esc_html__( 'جزئیات پست', 'harika' );
                    break;
                    case 'all_archive':
                        $rule['rule'] = esc_html__( 'همه آرشیو ها', 'harika' );
                    break;
                    case 'date_archive':
                        $rule['rule'] = esc_html__( 'آرشیو تاریخ', 'harika' );
                    break;
                    case 'author_archive':
                        $rule['rule'] = esc_html__( 'آرشیو نویسنده', 'harika' );
                    break;
                    case 'search_page':
                        $rule['rule'] = esc_html__( 'صفحه جستجو', 'harika' );
                    break;
                    case '404_page':
                        $rule['rule'] = esc_html__( 'صفحه 404', 'harika' );
                    break;
                    case 'specific_pages':
                        $rule['rule'] = esc_html__( 'صفحات خاص', 'harika' );
                    break;
                    case 'specific_posts':
                        $rule['rule'] = esc_html__( 'پست های خاص', 'harika' );
                    break;
                    case 'shop_page':
                        $rule['rule'] = esc_html__( 'صفحه فروشگاه', 'harika' );
                    break;
                    case 'product_details':
                        $rule['rule'] = esc_html__( 'جزئیات محصول', 'harika' );
                    break;
                    case 'specific_products':
                        $rule['rule'] = esc_html__( 'محصولات خاص', 'harika' );
                    break;
                    case 'portfolio_details':
                        $rule['rule'] = esc_html__( 'جزئیات نمونه کار', 'harika' );
                    break;
                    case 'specific_portfolio':
                        $rule['rule'] = esc_html__( 'نمونه کار های خاص', 'harika' );
                    break;
                    default:
                        
                    }




                $info .= ucwords( str_replace( '_', ' ', $rule['rule'] ) );
            }
        }

        return $info;
    }
}

new Template_Admin();
