<?php
/**
 * Required Plugin for Harika theme
 *
 * @package Harika
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit( 'No direct script access allowed' );
}

add_action( 'tgmpa_register', 'harika_register_required_plugins' );
function harika_register_required_plugins() {
    $plugins = [
        [
            'name'     => esc_html__( 'المنتور', 'harika' ),
            'slug'     => 'elementor',
            'required' => true,
            'version'  => '3.0',
        ],
        [
            'name'     => esc_html__( 'فرم تماس 7', 'harika' ),
            'slug'     => 'contact-form-7',
            'required' => false,
            'version'  => '3.0',
        ],
    ];

    $config = [
        'id'           => 'harika_theme_plugins',
        'default_path' => '',
        'menu'         => 'harika_required_plugins',
        'parent_slug'  => 'harika_dashboard',
        'capability'   => 'manage_options',
        'has_notices'  => true,
        'dismissable'  => true,
        'dismiss_msg'  => '',
        'is_automatic' => false,
        'message'      => '',
        'strings'      => [
            'menu_title' => esc_html__( 'افزونه های ضروری', 'harika' ),
            'page_title' => esc_html__( 'افزونه های ضروری', 'harika' ),
        ],
    ];

    tgmpa( $plugins, $config );
}
