<?php

namespace HarikaTheme\Helper;

use CSF;
use HarikaTheme\Admin\Harika_Admin_Panel;
use HarikaTheme\Classes\Harika_Helper;
use HarikaTheme\Classes\Harika_svg;

defined('ABSPATH') || exit;

/**
 * Harika Toolkit Helper
 */
class Harika_Theme_Options
{
    protected static $instance = null;

    private $options_prefix = 'harika_options';
    private $menu_slug = 'harika_options';
    private $template_builder_url;

    public static function instance()
    {
        if (null === self::$instance) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function initialize()
    {
        if (!class_exists('CSF')) {
            return;
        }

        $this->template_builder_url = admin_url('edit.php?post_type=harika_template');

        $this->theme_options();


        $this->general_section();
        $this->header_section();
        $this->colors_section();
        $this->table_of_content_section();
        $this->error_section();
        $this->elementor_section();
        $this->maintenance_section();
        $this->custom_scrips_section();
        $this->backup_section();

        add_filter('csf_color_palette', [$this, 'custom_color_palette']);
        add_filter('csf_options_before', [$this, 'add_dashboard_banner']);
    }







    /**
     * Create Theme Option
     */
    public function theme_options()
    {
        CSF::createOptions($this->options_prefix, [
            'menu_title' => esc_html__('پنل تنظیمات', 'harika'),
            'menu_slug' => $this->menu_slug,
            'framework_title' => esc_html__('پنل تنظیمات', 'harika'),
            'show_in_customizer' => true,
            'menu_type' => 'submenu',
            'menu_parent' => 'harika_dashboard',
            'admin_bar_menu_icon'     => 'dashicons-admin-generic',
            'footer_text'             => 'قالب هاریکا - طراحی و کدنویسی شده توسط حمید اسلامی',
        ]);
    }




    /**
     * General Option
     */
    public function general_section()
    {




        CSF::createSection($this->options_prefix, [
            'title' => Harika_svg::get_icon_svg('op-icon-general') . esc_html__('عمومی', 'harika'),
            'slug' => 'ho-general',
            'fields' => [



                [
                    'type' => 'heading',
                    'content' => esc_html__('عرض سایت', 'harika'),
                    'class' => 'harika-opt-title',

                ],
                [
                    'id' => 'container_width_widescreen',
                    'type' => 'number',
                    'title' => esc_html__('صفحه عریض', 'harika'),
                    'subtitle' => esc_html__('عرض بیشتر از 1400px', 'harika'),
                    'default' => '1300',

                ],
                [
                    'id' => 'container_width_desktop',
                    'type' => 'number',
                    'title' => esc_html__('دسکتاپ', 'harika'),
                    'subtitle' => esc_html__('عرض کمتر از 1400px', 'harika'),
                    'default' => '1140',

                ],
                [
                    'id' => 'container_width_tablet',
                    'type' => 'number',
                    'title' => esc_html__('حالت عمودی تبلت', 'harika'),
                    'subtitle' => esc_html__('عرض کمتر از 1024px', 'harika'),
                    'default' => '1024',

                ],
                [
                    'id' => 'container_width_mobile',
                    'type' => 'number',
                    'title' => esc_html__('حالت عمودی موبایل', 'harika'),
                    'subtitle' => esc_html__('عرض کمتر از 768px', 'harika'),
                    'default' => '768',

                ],



                [
                    'type' => 'heading',
                    'content' => esc_html__('فیوآیکن', 'harika'),
                    'class' => 'harika-opt-title',

                ],

                [
                    'id' => 'site_fav_image',
                    'type' => 'media',
                    'title' => esc_html__('تصویر فاوآیکن', 'harika'),
                    'subtitle' => esc_html__('تصویر فاوآیکن را آپلود یا انتخاب کنید', 'harika'),
                    'library' => 'image',
                    'url' => true,

                ],



                [
                    'type' => 'heading',
                    'content' => esc_html__('بازگشت به بالا', 'harika'),
                    'class' => 'harika-opt-title',
                ],
                [
                    'id' => 'back_to_top',
                    'type' => 'switcher',
                    'title' => esc_html__('بازگشت به بالا', 'harika'),
                    'subtitle' => esc_html__('اضافه کردن دکمه بازگشت به بالا به قسمت پایین سمت چپ سایت.', 'harika'),
                    'default' => true,
                ],
                [
                    'id' => 'back_to_top_mobile',
                    'type' => 'switcher',
                    'title' => esc_html__('نمایش در موبایل', 'harika'),
                    'subtitle' => esc_html__('نمایش دکمه بازگشت به بالا در دستگاه های موبایل..', 'harika'),
                    'default' => false,
                ],
                // [
                //     'id'          => 'back_to_top_color',
                //     'type'        => 'color',
                //     'title'       => esc_html__( 'رنگ آیکن', 'harika' ),
                //     'subtitle'    => esc_html__( 'رنگ آیکن بازگشت به بالا' ),
                //     'output'      => '.back-to-top i',
                //     'output_mode' => 'color',
                //     'dependency'  => ['back_to_top', '==', true],
                // ],
                // [
                //     'id'          => 'back_to_top_bg',
                //     'type'        => 'color',
                //     'title'       => esc_html__( 'پس زمینه آیکن', 'harika' ),
                //     'subtitle'    => esc_html__( 'رنگ پس زمینه آیکن دکمه بازگشت به بالا' ),
                //     'output'      => '.back-to-top i',
                //     'output_mode' => 'background-color',
                //     'dependency'  => ['back_to_top', '==', true],
                // ],
            ],
        ]);
    }



    /**
     * Header Options
     */
    public function header_section()
    {
        CSF::createSection($this->options_prefix, [
            'title' => Harika_svg::get_icon_svg('op-icon-dashboard') . esc_html__('طرح بندی ها', 'harika'),
            'slug' => 'ho-layout',
            'fields' => [
                [
                    'type' => 'heading',
                    'content' => esc_html__('انتخاب طرح بندی سایت', 'harika'),
                    'class' => 'harika-opt-title',
                ],
                [
                    'id' => 'select_default_header',
                    'type' => 'select',
                    'title' => esc_html__('هدر پیش فرض سایت', 'harika'),
                    'options' => st_select_builder_header(),
                    'default' => '0',
                    'class' => 'p-option-featured-box ten-padding',
                ],

                [
                    'id' => 'select_default_footer',
                    'type' => 'select',
                    'title' => esc_html__('فوتر پیش فرض سایت', 'harika'),
                    'options' => st_select_builder_footer(),
                    'default' => '0',
                    'class' => 'p-option-featured-box ten-padding',
                ],
                [
                    'id' => 'select_default_single_template',
                    'type' => 'select',
                    'title' => esc_html__('تمپلیت سینگل پست', 'harika'),
                    'options' => st_select_builder_single_template(),
                    'default' => '0',
                    'class' => 'p-option-featured-box ten-padding',
                ],
                [
                    'id' => 'select_default_blog_archive_template',
                    'type' => 'select',
                    'title' => esc_html__('تمپلیت آرشیو وبلاگ', 'harika'),
                    'options' => st_select_builder_post_cat_template(),
                    'default' => '0',
                    'class' => 'p-option-featured-box ten-padding',
                ],
                [
                    'id' => 'select_sidebar_title_layout',
                    'type' => 'select',
                    'title' => esc_html__('استایل عنوان سایدبار', 'harika'),
                    'options' => array(
                        'default' => 'پیش فرض',
                        '1' => 'یک',
                        '2' => 'دو',
                        '3' => 'سه',
                        '4' => 'چهار',
                        '5' => 'پنج',
                    ),
                    'default' => 'default',
                    'class' => 'p-option-featured-box ten-padding',
                ],


            ],
        ]);
    }






    /**
     * Colors Options
     */
    public function colors_section()
    {

        CSF::createSection($this->options_prefix, [
            'title' => Harika_svg::get_icon_svg('op-icon-color') . esc_html__('رنگ سایت', 'harika'),
            'slug' => 'ho-colors',
            'fields' => [
                [
                    'type' => 'heading',
                    'content' => esc_html__('رنگ بندی', 'harika'),
                    'class' => 'harika-opt-title',
                ],
                [
                    'id' => 'harika_default_skin',
                    'type' => 'select',
                    'title' => esc_html__('طرح اولیه سایت', 'harika'),
                    'options' => array(
                        'light' => 'روشن',
                        'dark' => 'تاریک',
                    ),
                    'default' => 'light',
                ],
                [
                    'id' => 'primary_color',
                    'type' => 'color',
                    'title' => esc_html__('رنگ اصلی', 'harika'),
                    'default' => '#2B39BE',
                    'subtitle' => esc_html__('رنگ اصلی برند شما. مورد استفاده در بیشترین المان های سایت.', 'harika'),
                    'desc' => esc_html__('پیش فرض: #2B39BE', 'harika'),
                ],
                [
                    'id' => 'secondary_color',
                    'type' => 'color',
                    'title' => esc_html__('رنگ ثانویه', 'harika'),
                    'default' => '#ebebed',
                    'subtitle' => esc_html__('رنگ ثانویه برند شما. مورد استفاده معمولا برای هاور ها و المان های ثانویه.', 'harika'),
                    'desc' => esc_html__('پیش فرض: #ebebed', 'harika'),
                ],
                [
                    'id' => 'body_color',
                    'type' => 'color',
                    'title' => esc_html__('رنگ پس زمینه', 'harika'),
                    'default' => '#f9f9f9',
                    'subtitle' => esc_html__('یک رنگ سفید برای پس زمینه سایت.', 'harika'),
                    'desc' => esc_html__('پیش فرض: #ffffff', 'harika'),
                ],




            ],
        ]);
    }





    /**
     * Table of content Options
     */
    public function table_of_content_section()
    {
        CSF::createSection($this->options_prefix, [
            'title' => Harika_svg::get_icon_svg('op-icon-blog') . esc_html__('جدول محتوا', 'harika'),
            'slug' => 'ho-toc',
            'fields' => [
                [
                    'type' => 'heading',
                    'content' => esc_html__('جدول محتوای پست ها', 'harika'),
                    'class' => 'harika-opt-title',
                ],

                [
                    'id' => 'harika_table_of_content',
                    'type' => 'button_set',
                    'title' => esc_html__('فعال سازی جدول محتوای هاریکا', 'harika'),
                    'options' => [
                        'yes' => esc_html__('بله', 'harika'),
                        'no' => esc_html__('خیر', 'harika'),
                    ],
                    'default' => 'yes',
                ],
                [
                    'type'    => 'content',
                    'content' => 'میتوانید از <code>[harika_table_of_content]</code> برای نمایش جدول محتوا استفاده کنید.<br>
                    این کد کوتاه رو در داخل محتوای پست خود قرار دهید تا هنگام نمایش پست، جدول محتوا در آن قسمت نمایش داده شود!',
                ],
                


            ],
        ]);
    }




    /**
     * Error Options
     */
    public function error_section()
    {
        CSF::createSection($this->options_prefix, [
            'title' => Harika_svg::get_icon_svg('op-icon-404') . esc_html__('صفحه 404', 'harika'),
            'slug' => 'ho-404',
            'fields' => [
                [
                    'type' => 'heading',
                    'content' => esc_html__('صفحه 404', 'harika'),
                    'class' => 'harika-opt-title',
                ],
                [
                    'id' => 'error_title',
                    'type' => 'text',
                    'title' => esc_html__('عنوان خطا', 'harika'),
                    'default' => esc_html__('متاسفیم ، برگه مورد نظر یافت نشد!', 'harika'),
                ],
                [
                    'id' => 'error_text',
                    'type' => 'textarea',
                    'title' => esc_html__('متن خطا', 'harika'),
                    'default' => esc_html__('جهت بازگشت به صفحه اصلی از دکمه زیر استفاده فرمایید', 'harika'),
                ],

                [
                    'id' => 'error_button_show',
                    'type' => 'button_set',
                    'title' => esc_html__('نمایش دکمه', 'harika'),
                    'options' => [
                        'yes' => esc_html__('بله', 'harika'),
                        'no' => esc_html__('خیر', 'harika'),
                    ],
                    'default' => 'yes',
                ],
                [
                    'id' => 'error_button_text',
                    'type' => 'text',
                    'title' => esc_html__('متن دکمه', 'harika'),
                    'default' => esc_html__('بازگشت به صفحه اصلی', 'harika'),
                ],

            ],
        ]);
    }


    /**
     * Elementor Option
     */
    public function elementor_section()
    {

        CSF::createSection($this->options_prefix, [
            'title' => Harika_svg::get_icon_svg('op-icon-elementor') . esc_html__('المنتور', 'harika'),
            'slug' => 'ho-elementor',
            'fields' => [



                [
                    'type' => 'heading',
                    'content' => esc_html__('تنظیمات المنتور', 'harika'),
                    'class' => 'harika-opt-title',

                ],

                [
                    'id'      => 'set_elementor_experiment',
                    'type'    => 'checkbox',
                    'title'   => esc_html__('تنظیم ویژگی های المنتور برای سازگاری با قالب', 'harika'),
                    'label'   => 'تنظیم کن!',
                    'default' => true // or false
                ],
                [
                    'type'     => 'callback',
                    'function' => 'check_elementor_experiment_like_harika',
                    'class'   => '',
                ],



            ],
        ]);
    }

    /**
     * Maintenance Options
     */
    public function maintenance_section()
    {
        CSF::createSection($this->options_prefix, [
            'title' => Harika_svg::get_icon_svg('op-icon-maintenance') . esc_html__('حالت در حال تعمیر', 'harika'),
            'slug' => 'ho-maintenance',
            'fields' => [
                [
                    'type' => 'heading',
                    'content' => esc_html__('حالت در حال تعمیر', 'harika'),
                    'class' => 'harika-opt-title',
                ],
                [
                    'id' => 'maintenance_mode',
                    'type' => 'button_set',
                    'title' => esc_html__('حالت در حال تعمیر', 'harika'),
                    'subtitle' => esc_html__('حالت در حال تعمیر را وب سایت خود فعال کنید.', 'harika'),
                    'options' => [
                        'enabled' => esc_html__('فعال', 'harika'),
                        'disabled' => esc_html__('غیرفعال', 'harika'),
                    ],
                    'default' => 'disabled',
                ],
                [
                    'id' => 'maintenance_page',
                    'type' => 'select',
                    'title' => esc_html__('صفحه در حال تعمیر', 'harika'),
                    'placeholder' => esc_html__('از تنظیمات', 'harika'),
                    'options' => 'pages',
                    'dependency' => ['maintenance_mode', '==', 'enabled'],
                ],
                [
                    'id' => 'maintenance_title',
                    'type' => 'text',
                    'title' => esc_html__('عنوان در حال تعمیر', 'harika'),
                    'default' => esc_html__('سایت در حال حاضر جهت تعمیر غیرفعال می باشد', 'harika'),
                    'dependency' => [
                        ['maintenance_mode', '==', 'enabled'],
                        ['maintenance_page', '==', ''],
                    ],
                ],
                [
                    'id' => 'maintenance_subtitle',
                    'type' => 'textarea',
                    'title' => esc_html__('زیرنویس در حال تعمیر', 'harika'),
                    'default' => esc_html__('از هر ناراحتی پدید آمده پوزش می خواهیم', 'harika'),
                    'dependency' => [
                        ['maintenance_mode', '==', 'enabled'],
                        ['maintenance_page', '==', ''],
                    ],
                ],
                [
                    'id' => 'maintenance_img',
                    'type' => 'media',
                    'title' => esc_html__('تصویر در حال تعمیر', 'harika'),
                    'subtitle' => esc_html__('یک تصویر برای صفحه در حال تعمیر انتخاب یا آپلود کنید', 'harika'),
                    'library' => 'image',
                    'url' => false,
                    'default' => [
                        'url' => HARIKA_ASSETS . '/img/maintenance.png',
                        'thumbnail' => HARIKA_ASSETS . '/img/maintenance.png',
                    ],
                    'dependency' => [
                        ['maintenance_mode', '==', 'enabled'],
                        ['maintenance_page', '==', ''],
                    ],
                ],
            ],
        ]);
    }

    /**
     * Custom Script Options
     */
    public function custom_scrips_section()
    {
        CSF::createSection($this->options_prefix, [
            'title' => Harika_svg::get_icon_svg('op-icon-custom') . esc_html__('اسکریپت های سفارشی', 'harika'),
            'slug' => 'ho-customscripts',
            'fields' => [
                [
                    'type' => 'heading',
                    'content' => esc_html__('اسکریپت های سفارشی', 'harika'),
                    'class' => 'harika-opt-title',
                ],
                [
                    'id' => 'custom_header_scripts',
                    'type' => 'code_editor',
                    'title' => esc_html__('کد جاوااسکریپت(Head)', 'harika'),
                    'settings' => [
                        'theme' => 'mbo',
                        'mode' => 'javascript',
                    ],
                    'subtitle' => esc_html__('کد جاوااسکریپت سفارشی خود را اینجا اضافه کنید. باید بدون تگ اسکریپت و همچنین کد معتبر تایپ شود، کد را در هوک wp_head قرار می دهیم.
                    ', 'harika'),
                ],
                [
                    'id' => 'custom_footer_scripts',
                    'type' => 'code_editor',
                    'title' => esc_html__('کد جاوااسکریپت(فوتر)', 'harika'),
                    'settings' => [
                        'theme' => 'mbo',
                        'mode' => 'javascript',
                    ],
                    'subtitle' => esc_html__('کد جاوااسکریپت سفارشی خود را اینجا اضافه کنید. باید بدون تگ اسکریپت و همچنین کد معتبر تایپ شود، کد را در هوک wp_footer قرار می دهیم.
                    ', 'harika'),
                ],
                [
                    'type' => 'submessage',
                    'style' => 'info',
                    'content' => esc_html__('همچنین می توانید کد های سفارشی  css را در  (نمایش -> سفارشی سازی -> css های اضافی) اضافه کنید', 'harika'),
                ],
            ],
        ]);
    }

    /**
     * Backup Options
     */
    public function backup_section()
    {
        CSF::createSection($this->options_prefix, [
            'title' => Harika_svg::get_icon_svg('op-icon-backup') . esc_html__('بکاپ', 'harika'),
            'slug' => 'ho-backup',
            'fields' => [
                [
                    'type' => 'heading',
                    'content' => esc_html__('بکاپ', 'harika'),
                    'class' => 'harika-opt-title',
                ],
                [
                    'type' => 'backup',
                ],
            ],
        ]);
    }

    public function custom_color_palette()
    {
        $colors = Harika_Helper::get_global_colors();

        $new_color = [];

        foreach ($colors as $color) {
            array_push($new_color, $color['value']);
        }

        return $new_color;
    }

    public function add_dashboard_banner()
    {
        Harika_Admin_Panel::render_heading();
    }
}

Harika_Theme_Options::instance()->initialize();
