<?php

namespace HarikaTheme\Helper;

use CSF;

defined('ABSPATH') || exit;

/**
 * Harika Toolkit Helper
 */
class Harika_Category_Metaboxes
{
    protected static $instance = null;

    private $category_prefix      = 'harika_category_meta';

    private $template_builder_url;

    public static function instance()
    {
        if (null === self::$instance) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function initialize()
    {
        if (! class_exists('CSF')) {
            return;
        }

        $this->template_builder_url = admin_url('edit.php?post_type=harika_template');

        $this->category_metaboxes();

        //$this->user_metaboxes();
    }

    /**
     * Post Meta
     *
     * @return void
     */
    public function category_metaboxes()
    {

        // Create taxonomy options
        CSF::createTaxonomyOptions($this->category_prefix, array(
            'title'        => esc_html__('گزینه های دسته بندی هاریکا', 'harika'),
            'taxonomy'  => 'category',
            'data_type' => 'serialize', // The type of the database save options. `serialize` or `unserialize`
        ));


        // options
        CSF::createSection($this->category_prefix, [
            'title'  => esc_html__('تنظیمات دسته بندی', 'harika'),
            'fields' => [
                // [
                //     'id'      => 'category_text_example',
                //     'type'    => 'text',
                //     'title'   => 'متن اصلی دسته بندی',
                // ],

                [
                    'id'      => 'select_post_cat_header_meta',
                    'type'    => 'select',
                    'title'   => esc_html__( 'هدر مخصوص این دسته', 'harika' ),
                    'options' => st_select_builder_header(),
                    'default' => '0',
                ],
                [
                    'id'      => 'select_post_cat_footer_meta',
                    'type'    => 'select',
                    'title'   => esc_html__( 'فوتر مخصوص این دسته', 'harika' ),
                    'options' => st_select_builder_footer(),
                    'default' => '0',
                ],

                [
                    'id'      => 'select_blog_archive_template_meta',
                    'type'    => 'select',
                    'title'   => esc_html__( 'تمپلیت آرشیو مخصوص این دسته', 'harika' ),
                    'options' => st_select_builder_post_cat_template(),
                    'default' => '0',
                ],


            ],
        ]);
    }
}

Harika_Category_Metaboxes::instance()->initialize();
