<?php
namespace HarikaTheme\Helper;

use CSF;

defined( 'ABSPATH' ) || exit;

/**
 * Harika Toolkit Helper
 */
class Harika_Metaboxes {
    protected static $instance = null;

    private $post_prefix      = 'harika_post_meta';
    private $page_prefix      = 'harika_page_meta';
    //private $user_prefix      = 'harika_user_meta';

    private $template_builder_url;

    public static function instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function initialize() {
        if ( ! class_exists( 'CSF' ) ) {
            return;
        }

        $this->template_builder_url = admin_url( 'edit.php?post_type=harika_template' );

        $this->post_metaboxes();
        $this->page_metaboxes();

        //$this->user_metaboxes();
    }

    /**
     * Post Meta
     *
     * @return void
     */
    public function post_metaboxes() {
        CSF::createMetabox( $this->post_prefix, [
            'title'        => esc_html__( 'گزینه های پست هاریکا', 'harika' ),
            'post_type'    => 'post',
            'show_restore' => true,
        ] );


        // options
        CSF::createSection( $this->post_prefix, [
            'title'  => esc_html__( 'تنظیمات صفحه', 'harika' ),
            'fields' => [
                [
                    'type'    => 'heading',
                    'content' => esc_html__( 'هدر ، فوتر و رنگ پیش فرض', 'harika' ),
                ],
                [
                    'id'      => 'select_post_header_meta',
                    'type'    => 'select',
                    'title'   => esc_html__( 'هدر مخصوص این پست', 'harika' ),
                    'options' => st_select_builder_header(),
                    'default' => '0',
                ],
                [
                    'id'      => 'select_post_footer_meta',
                    'type'    => 'select',
                    'title'   => esc_html__( 'فوتر مخصوص این پست', 'harika' ),
                    'options' => st_select_builder_footer(),
                    'default' => '0',
                ],
                [
                    'id' => 'select_post_single_template_meta',
                    'type' => 'select',
                    'title' => esc_html__('تمپلیت سینگل پست', 'harika'),
                    'options' => st_select_builder_single_template(),
                    'default' => '0',
                ],
                [
                    'id' => 'select_post_sidebar_title_layout',
                    'type' => 'select',
                    'title' => esc_html__('استایل عنوان سایدبار', 'harika'),
                    'options' => array(
                        'default' => 'پیش فرض',
                        '1' => 'یک',
                        '2' => 'دو',
                        '3' => 'سه',
                        '4' => 'چهار',
                        '5' => 'پنج',
                    ),
                    'default' => 'default'
                ],
                [
                    'id'       => 'primary_post_color_meta',
                    'type'     => 'color',
                    'title'    => esc_html__( 'رنگ اصلی', 'harika' ),
                    'subtitle' => esc_html__( 'مورد استفاده در بیشترین المان های سایت.', 'harika' ),
                    'desc'     => esc_html__( 'پیش فرض: #2B39BE', 'harika' ),
                ],
                [
                    'id'       => 'secondary_post_color_meta',
                    'type'     => 'color',
                    'title'    => esc_html__( 'رنگ ثانویه', 'harika' ),
                    'subtitle' => esc_html__( 'مورد استفاده معمولا برای هاور ها و المان های ثانویه.', 'harika' ),
                    'desc'     => esc_html__( 'پیش فرض: #ebebed', 'harika' ),
                ],
                [
                    'id'       => 'body_post_color_meta',
                    'type'     => 'color',
                    'title'    => esc_html__( 'رنگ پس زمینه', 'harika' ),
                    'subtitle' => esc_html__( 'یک رنگ سفید برای پس زمینه سایت.', 'harika' ),
                    'desc'     => esc_html__( 'پیش فرض: #ffffff', 'harika' ),
                ],

            ],
        ] );

    }

    /**
     * Page Meta
     *
     * @return void
     */
    public function page_metaboxes() {
        CSF::createMetabox( $this->page_prefix, [
            'title'        => esc_html__( 'گزینه های صفحه هاریکا', 'harika' ),
            'post_type'    => 'page',
            'show_restore' => true,
        ] );


        // options
        CSF::createSection( $this->page_prefix, [
            'title'  => esc_html__( 'تنظیمات صفحه', 'harika' ),
            'fields' => [
                [
                    'type'    => 'heading',
                    'content' => esc_html__( 'هدر ، فوتر و رنگ پیش فرض', 'harika' ),
                ],
                [
                    'id'      => 'select_page_header_meta',
                    'type'    => 'select',
                    'title'   => esc_html__( 'هدر مخصوص این پست', 'harika' ),
                    'options' => st_select_builder_header(),
                    'default' => '0',
                ],
                [
                    'id'      => 'select_page_footer_meta',
                    'type'    => 'select',
                    'title'   => esc_html__( 'فوتر مخصوص این پست', 'harika' ),
                    'options' => st_select_builder_footer(),
                    'default' => '0',
                ],
                [
                    'id' => 'select_page_sidebar_title_layout',
                    'type' => 'select',
                    'title' => esc_html__('استایل عنوان سایدبار', 'harika'),
                    'options' => array(
                        'default' => 'پیش فرض',
                        '1' => 'یک',
                        '2' => 'دو',
                        '3' => 'سه',
                        '4' => 'چهار',
                        '5' => 'پنج',
                    ),
                    'default' => 'default'
                ],
                [
                    'id'       => 'primary_page_color_meta',
                    'type'     => 'color',
                    'title'    => esc_html__( 'رنگ اصلی', 'harika' ),
                    'subtitle' => esc_html__( 'مورد استفاده در بیشترین المان های سایت.', 'harika' ),
                    'desc'     => esc_html__( 'پیش فرض: #2B39BE', 'harika' ),
                ],
                [
                    'id'       => 'secondary_page_color_meta',
                    'type'     => 'color',
                    'title'    => esc_html__( 'رنگ ثانویه', 'harika' ),
                    'subtitle' => esc_html__( 'مورد استفاده معمولا برای هاور ها و المان های ثانویه.', 'harika' ),
                    'desc'     => esc_html__( 'پیش فرض: #ebebed', 'harika' ),
                ],
                [
                    'id'       => 'body_page_color_meta',
                    'type'     => 'color',
                    'title'    => esc_html__( 'رنگ پس زمینه', 'harika' ),
                    'subtitle' => esc_html__( 'یک رنگ سفید برای پس زمینه سایت.', 'harika' ),
                    'desc'     => esc_html__( 'پیش فرض: #ffffff', 'harika' ),
                ],

            ],
        ] );
    }



    // /**
    //  * User Meta
    //  *
    //  * @return void
    //  */
    // public function user_metaboxes() {
    //     CSF::createProfileOptions( $this->user_prefix, [
    //         'data_type' => 'serialize',
    //     ] );

    //     CSF::createSection( $this->user_prefix, [
    //         'fields' => [
    //             [
    //                 'title' => esc_html__( 'گزینه های نویسنده هاریکا', 'harika' ),
    //                 'type'  => 'heading',
    //             ],
    //             [
    //                 'id'           => 'user_social_links',
    //                 'type'         => 'repeater',
    //                 'title'        => esc_html__( 'لینک های اجتماعی کاربر', 'harika' ),
    //                 'button_title' => esc_html__( 'افزودن جدید', 'harika' ),
    //                 'fields'       => [
    //                     [
    //                         'id'    => 'social_icon',
    //                         'type'  => 'icon',
    //                         'title' => esc_html__( 'آیکن', 'harika' ),
    //                     ],
    //                     [
    //                         'id'    => 'social_link',
    //                         'type'  => 'text',
    //                         'title' => esc_html__( 'لینک', 'harika' ),
    //                     ],
    //                 ],
    //             ],
    //         ],
    //     ] );
    // }

}

Harika_Metaboxes::instance()->initialize();