<?php

use HarikaTheme\Classes\Harika_Helper as Helper;

$elementor_settings = get_post_meta(get_option('elementor_active_kit'), '_elementor_page_settings', true);



if ($elementor_settings !== '') {









    ///*******************************************************///
    ///        *set theme options colors to elementor*        ///
    ///*******************************************************///

    function harika_set_theme_options_colors_to_elementor()
    {

        $opt_primary_color   = Helper::get_option('primary_color', false);
        $opt_secondary_color = Helper::get_option('secondary_color', false);

        /** get elementor settings and elementor system colors array  */
        $elementor_settings = get_post_meta(get_option('elementor_active_kit'), '_elementor_page_settings', true);
        $system_colors = $elementor_settings['system_colors'];

        /** get andise by _id */
        function harika_get_system_color_id($system_colors, $key)
        {

            if (is_array($system_colors) || is_object($system_colors)) {
                foreach ($system_colors as $id => $color) {
                    if ($color['_id'] == $key) {
                        return $id;
                    }
                }
            }
        }

        /** change the colors */
        $system_colors[harika_get_system_color_id($system_colors, 'primary')]['color'] = $opt_primary_color;
        $system_colors[harika_get_system_color_id($system_colors, 'secondary')]['color'] = $opt_secondary_color;
        $elementor_settings['system_colors'] = $system_colors;


        update_post_meta(get_option('elementor_active_kit'), '_elementor_page_settings', $elementor_settings);
    }

    add_action('csf_harika_options_save_after', 'harika_set_theme_options_colors_to_elementor');





    ///*******************************************************///
    ///     *set theme options width screen to elementor*     ///
    ///*******************************************************///

    function harika_set_theme_options_width_screen_to_elementor()
    {

        $container_width_widescreen   = Helper::get_option('container_width_widescreen', false);
        $container_width_desktop      = Helper::get_option('container_width_desktop', false);
        $container_width_tablet       = Helper::get_option('container_width_tablet', false);
        $container_width_mobile       = Helper::get_option('container_width_mobile', false);

        $elementor_settings = get_post_meta(get_option('elementor_active_kit'), '_elementor_page_settings', true);


        $elementor_settings['viewport_widescreen'] = '1400';

        $elementor_settings['container_width_widescreen'] = array(
            'unit'   => 'px',
            'size'   => $container_width_widescreen,
        );
        $elementor_settings['container_width'] = array(
            'unit'   => 'px',
            'size'   => $container_width_desktop,
        );
        $elementor_settings['container_width_tablet'] = array(
            'unit'   => 'px',
            'size'   => $container_width_tablet,
        );
        $elementor_settings['container_width_mobile'] = array(
            'unit'   => 'px',
            'size'   => $container_width_mobile,
        );



        $elementor_settings['active_breakpoints'] = array('viewport_mobile', 'viewport_tablet', 'viewport_widescreen');


        update_post_meta(get_option('elementor_active_kit'), '_elementor_page_settings', $elementor_settings);
    }





    add_action('csf_harika_options_save_after', 'harika_set_theme_options_width_screen_to_elementor');














    ///*******************************************************///
    ///        *set theme options favicon to elementor*       ///
    ///*******************************************************///

    function harika_set_theme_options_favicon_to_elementor()
    {


        $site_favicon   = Helper::get_option('site_fav_image', false);
        $elementor_settings = get_post_meta(get_option('elementor_active_kit'), '_elementor_page_settings', true);

        if (!empty($site_favicon['url'])) {

            $site_favicon_url = $site_favicon['url'];
            $site_favicon_id  = $site_favicon['id'];
            $site_favicon_alt = $site_favicon['alt'];






            $elementor_settings['site_favicon'] = array(
                'url'   => $site_favicon_url,
                'id'   => $site_favicon_id,
                'size'   => '',
                'alt'   => $site_favicon_alt,
                'source'   => 'library',
            );

            update_post_meta(get_option('elementor_active_kit'), '_elementor_page_settings', $elementor_settings);

            update_option('site_icon', $site_favicon_id);
        } else {
            update_option('site_icon', '');
        }
    }





    add_action('csf_harika_options_save_after', 'harika_set_theme_options_favicon_to_elementor');
}












function elementor_clear_cache()
{
    if (did_action('elementor/loaded')) {
        // clear Elementor cache
        \Elementor\Plugin::instance()->files_manager->clear_cache();
    }
}



add_action('csf_harika_options_save_after', 'elementor_clear_cache');



function update_elementor_options() {
    // به‌روزرسانی گزینه‌ها
    update_option('elementor_disable_color_schemes', 'yes');
    update_option('elementor_disable_typography_schemes', 'yes');
    update_option('elementor_experiment-e_font_icon_svg', 'inactive');
    update_option('elementor_experiment-inline_font_icons', 'inactive');
    update_option('elementor_experiment-container', 'active');
    update_option('elementor_experiment-nested-elements', 'active');
    update_option('elementor_experiment-additional_custom_breakpoints', 'active');
    update_option('elementor_experiment-editor_v2', 'active');

}
$set_elementor_experiment = Helper::get_option('set_elementor_experiment');
if ($set_elementor_experiment == true) {
    add_action('csf_harika_options_save_after', 'update_elementor_options');
}
