<?php
namespace TW_F6;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

/*--------------------------
*   Class Scripts Manager
* -------------------------*/
class TW_F6_Scripts{

    private static $instance = null;

    public static function instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    function __construct(){
        $this->init();
    }

    public function init() {


        // Admin Scripts
        add_action( 'elementor/editor/after_enqueue_styles',    array( $this, 'editor_styles' ) );
		add_action( 'elementor/editor/after_enqueue_styles', [ $this, 'editor_styles' ] );

        // Frontend Scripts
        add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_frontend_scripts' ], 15 );
        add_action( 'admin_enqueue_scripts', [$this, 'enqueue_frontend_scripts'], 15 );
        

    }

    /*----------------
    *   Admin Scripts
    * ----------------*/    
    public function editor_styles() {

			wp_enqueue_style('fa6-editor-style', get_template_directory_uri() . '/includes/font-awesome-pro/assets/style.css', NULL, 1.0 );
            

	}

    /*----------------
    *   Enqueue frontend scripts
    * ----------------*/  
    public function enqueue_frontend_scripts() {
        // fa6 icon css
            wp_enqueue_style( 'fa6_icon', get_template_directory_uri() . '/includes/font-awesome-pro/fonts/all.css', NULL, 1.0);    
            add_editor_style( get_template_directory_uri() . '/includes/font-awesome-pro/fonts/all.css' );
    }

}

TW_F6_Scripts::instance();



