<?php

use Harika\Elementor\Controls\Dynamic_Select;
use Harika\Traits\Global_Widget_Controls;
use Harika\Traits\Global_Slider_Controls;
use HarikaTheme\Classes\Harika_svg;
use HarikaTheme\Classes\Harika_Helper as Helper;

class post_slider_2 extends \Elementor\Widget_Base
{

    use Global_Widget_Controls;
    use Global_Slider_Controls;

    private $_query = null;

    public function get_name()
    {
        return 'harika-post_slider_2';
    }

    public function get_script_depends()
    {
        return ['elementor-swiper', 'elementor-frontend'];
    }

    public function get_title()
    {
        return __('اسلایدر پست ها 2', 'harika');
    }

    public function get_icon()
    {
        return 'eicon-favorite harika-icon';
    }

    public function get_categories()
    {
        return ['harika_elements'];
    }





    public function get_query()
    {
        return $this->_query;
    }

    public function controls_general()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'harika'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'item_limit',
            [
                'label' => esc_html__('تعداد پست ها', 'harika'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1
                    ],
                ],
                'default' => [
                    'size' => 3,
                ],
            ]
        );


        $this->add_responsive_control(
            'slider_height',
            [
                'label' => __('ارتفاع اسلایدر', 'harika'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['%', 'px', 'vw'],
                'range' => [
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .harika-posts-slider-2-widget' => 'height: {{SIZE}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'hr1_1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_responsive_control(
            'slider_var_x_spacing',
            [
                'label' => __('فاصله محور x', 'harika'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .harika-posts-slider-2-widget' => '--slider-x-spacing: {{SIZE}}{{UNIT}};',
                ],

            ]
        );
        $this->add_responsive_control(
            'slider_var_Y_spacing',
            [
                'label' => __('فاصله محور Y', 'harika'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .harika-posts-slider-2-widget' => '--slider-y-spacing: {{SIZE}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'slider_var_ba_width',
            [
                'label' => __('عرض سایه های کناری', 'harika'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .harika-posts-slider-2-widget' => '--slider-ba-width: {{SIZE}}{{UNIT}};',
                ],

            ]
        );


        $this->add_control(
            'hr2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'image', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `image_size` and `image_custom_dimension`.
                'default' => 'large',
                'separator' => 'none',
            ]
        );

        $this->add_responsive_control(
            'pic_height',
            [
                'label' => __('ارتفاع تصویر', 'harika'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['%', 'px', 'vw'],
                'range' => [
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .harika-posts-slider-2-widget .article .featured-image' => 'height: {{SIZE}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'hr3',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'image_hover_scale',
            [
                'label' => __('بزرگنمایی تصویر در هاور', 'harika'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '1' => 'بدون بزرگنمایی',
                    '1.1' => '1.1',
                    '1.2' => '1.2',
                    '1.3' => '1.3',
                    '1.4' => '1.4',
                    '1.5' => '1.5',
                    '1.6' => '1.6',
                    '1.7' => '1.7',
                    '1.8' => '1.8',
                    '1.9' => '1.9',
                ],
                'default' => '1.2',
                'selectors' => [
                    '{{WRAPPER}} .harika-posts-slider-2-widget .article:hover .featured-image img' => 'transform: scale({{VALUE}});',
                ],
            ]
        );
        $this->add_responsive_control(
            'scale_speed',
            [
                'label' => __('سرعت بزرگنمایی', 'harika'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0.1,
                        'max' => 3,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .harika-posts-slider-2-widget .featured-image img' => 'transition: {{SIZE}}s;',
                ],

            ]
        );

        $this->add_control(
            'hr41',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'show_date',
            [
                'label' => __('تاریخ', 'harika'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'harika'),
                'label_off' => __('مخفی', 'harika'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'date_type',
            [
                'label' => __('نوع تاریخ', 'harika'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'published',
                'options' => [
                    'published' => esc_html__('تاریخ انتشار', 'harika'),
                    'modified' => esc_html__('آخرین ویرایش', 'harika'),
                ],
            ]
        );
        $this->add_control(
            'date_format',
            [
                'label' => esc_html__('فرمت تاریخ', 'harika'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'show_date_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'show_comments_count',
            [
                'label' => __('تعداد نظرات', 'harika'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'harika'),
                'label_off' => __('مخفی', 'harika'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_categories',
            [
                'label' => __('دسته بندی ها', 'harika'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'harika'),
                'label_off' => __('مخفی', 'harika'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_post_type_icon',
            [
                'label' => __('آیکن پست فرمت', 'harika'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'harika'),
                'label_off' => __('مخفی', 'harika'),
                'default' => 'yes',
            ]
        );


        $this->add_control(
            'hr5',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'title_wrap',
            [
                'label' => __('عنوان تک خطی', 'harika'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'harika'),
                'label_off' => __('مخفی', 'harika'),
                'default' => false,
            ]
        );

        $this->add_control(
            'show_excerpt',
            [
                'label' => __('چکیده', 'harika'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'harika'),
                'label_off' => __('مخفی', 'harika'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'excerpt_length',
            [
                'label' => __('طول چکیده', 'harika'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => apply_filters('excerpt_length', 6),
                'condition' => [
                    'show_excerpt' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
    }

    public function controls_style()
    {

        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل', 'harika'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('عنوان پست', 'harika'),
                'name' => 'post_title_typography',
                'selector' => '{{WRAPPER}} .harika-posts-slider-2-widget .content .title, {{WRAPPER}} .harika-posts-slider-2-widget .content .title a',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('تایپوگرافی چکیده', 'harika'),
                'name' => 'excerpt_typography',
                'selector' => '{{WRAPPER}} .harika-posts-slider-2-widget .content .excerpt, {{WRAPPER}} .harika-posts-slider-2-widget .content .excerpt p',
                'condition' => [
                    'show_excerpt' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'post_box_border_radius',
            [
                'label' => __('حاشیه مدور', 'harika'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .harika-posts-slider-2-widget .featured-image, {{WRAPPER}} .harika-posts-slider-2-widget .article' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }


    protected function register_controls()
    {


        $this->controls_general();

        /////////////////////////////////////////////////////////
        //Global query Controls
        $this->register_query_controls();
        /////////////////////////////////////////////////////////



        /////////////////////////////////////////////////////////
        //Global slider Controls
        $this->register_slider_controls();
        /////////////////////////////////////////////////////////


        $this->controls_style();
    }










    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $title_wrap = ' nowrap';
        if ($settings['title_wrap'] === 'yes') {
            $title_wrap = ' wrap';
        }



        $id = substr($this->get_id_int(), 0, 3);

        /* get slider settings and save in vars */
        //$as_is_slider = $settings['as_is_slider'];



        /* switch */
        $as_autoplay = 'yes' == $settings['as_autoplay'] ? true : false;
        $as_pauseOnMouseEnter = 'yes' == $settings['as_pauseOnMouseEnter'] ? true : false;
        $stopOnLastSlide = 'yes' == $settings['as_stopOnLastSlide'] ? true : false;
        $as_loop = 'yes' == $settings['as_loop'] ? true : false;
        $as_rewind = 'yes' == $settings['as_rewind'] ? true : false;
        $as_arrows = 'yes' == $settings['as_arrows'] ? true : false;
        $as_pagination = 'yes' == $settings['as_pagination'] ? true : false;

        $as_grabCursor = 'yes' == $settings['as_grabCursor'] ? true : false;
        $as_mousewheel = 'yes' == $settings['as_mousewheel'] ? true : false;

        /* select */
        $as_breakpointsBase = $settings['as_breakpointsBase'];
        $as_effect = $settings['as_effect'];

        /* number */
        $as_autoplay_speed = $settings['as_autoplay_speed'];
        $as_swipe_speed = $settings['as_swipe_speed'];



        /* Slider Config */
        $slider_config = array(
            'slider_id' => $id,
            'autoplay' => $as_autoplay,
            'pauseOnMouseEnter' => $as_pauseOnMouseEnter,
            'stopOnLastSlide' => $stopOnLastSlide,
            'loop' => $as_loop,
            'rewind' => $as_rewind,
            'navigation' => $as_arrows,
            'pagination' => $as_pagination,
            'centeredSlides' => false,
            'grabCursor' => $as_grabCursor,
            'mousewheel' => $as_mousewheel,

            'breakpointsBase' => $as_breakpointsBase,
            'effect' => $as_effect,

            'autoplay_speed' => $as_autoplay_speed,
            'swipe_speed' => $as_swipe_speed,




        );


        $slider_config['slidesPerView'] = 1;
        $slider_config['tSlidesPerView'] = 1;
        $slider_config['mSlidesPerView'] = 1;

        $slider_config['spaceBetween'] = 0;
        $slider_config['tSpaceBetween'] = 0;
        $slider_config['mSpaceBetween'] = 0;


        if ($settings['as_effect'] == 'cards') {
            $slider_config['cardsEffect_perSlideOffset'] = $settings['as_cardsEffect_perSlideOffset'];
            $slider_config['cardsEffect_perSlideRotate'] = $settings['as_cardsEffect_perSlideRotate'];
            $slider_config['cardsEffect_rotate'] = $settings['as_cardsEffect_rotate'];
            $slider_config['cardsEffect_slideShadows'] = $settings['as_cardsEffect_slideShadows'];
        }












        /* Slider Atts */
        $direction = 'ltr';
        if(is_rtl()) {
            $direction = 'rtl';
        }

        $slider_atts = array(
            'id' => 'slider-' . $id,
            'dir' => $direction,
            'class' => 'harika-slider full-width-slider harika-posts-slider-2-widget swiper harika-posts-slider slider-' . $id . ' loading' . $title_wrap . '',

        );

        // 'yes' == $settings['slider_nav'] && 'yes' == $settings['slider_nav_on_hover'] ? 'nav-show-onhover' : ''



        $default = $this->getGroupControlQueryArgs();

        $args = array_merge($default);
        $this->_query = new WP_Query($args);

        $this->query_posts($settings['item_limit']['size']);

        $wp_query = $this->get_query(); ?>

        <div <?php echo harika_stringify_attributes($slider_atts); ?>
            data-settings='<?php echo esc_attr(wp_json_encode(harika_slider_config_default($slider_config))); ?>'>

            <?php

            if ($wp_query->have_posts()): ?>

                <div class="swiper-wrapper">
                    <?php
                    while ($wp_query->have_posts()):
                        $wp_query->the_post(); ?>



















                        <div class="article swiper-slide">



                            <div class="cover">
                                <?php the_post_thumbnail($settings['image_size']); ?>
                            </div>

                            <div class="post">
                                <a class="featured-image" href="<?php the_permalink(); ?>" target="_top">
                                    <?php the_post_thumbnail('medium_large'); ?>
                                </a>

                                <div class="content">

                                    <div class="text">
                                        <h3 class="title">
                                            <a href="<?php the_permalink(); ?>" target="_top">
                                                <?php the_title(); ?>
                                            </a>
                                        </h3>
                                        <?php $this->render_excerpt(); ?>
                                    </div>

                                    <div class="meta harika-global">



                                        <?php if ($settings['show_categories'] === 'yes'): ?>
                                            <div class="categories harika-exc-cat-color">
                                                <?php echo Helper::harika_get_category(); ?>
                                            </div>
                                        <?php endif; ?>

                                        <?php if ($settings['show_date'] === 'yes'): ?>
                                            <span class="date"><?php echo Harika_svg::get_icon_svg('post-calender'); ?>
                                                <?php if ($settings['date_type'] === 'published') {
                                                    echo get_the_date($settings['date_format']);
                                                } else if ($settings['date_type'] === 'modified') {
                                                    echo get_the_modified_date($settings['date_format']);
                                                }
                                                ?>
                                            </span>
                                        <?php endif; ?>

                                        <?php if ($settings['show_comments_count'] === 'yes') : ?>
                                            <span class="comments-count"><?php echo Harika_svg::get_icon_svg('post-comments'); ?>
                                                <?php
                                                $comments_number = get_comments_number();
                                                printf(
                                                    esc_html( /* translators: 1: number of comments */
                                                        _nx(
                                                            __('1 دیدگاه', 'harika'),
                                                            __('%1$s دیدگاه', 'harika'),
                                                            $comments_number,
                                                            'comments title'
                                                        )
                                                    ),
                                                    esc_html(number_format_i18n($comments_number))
                                                );

                                                ?>

                                            </span>
                                        <?php endif; ?>





                                    </div>

                                </div>

                            </div>


                        </div>


























                    <?php
                    endwhile; ?>
                </div>


            <?php
                if ($as_arrows == true) {
                    echo '<div class="swiper-nav">';
                    echo '<div class="harika-swiper-arrow swiper-prev swiper-prev-slider-' . absint($id) . '"></div>';
                    echo '<div class="harika-swiper-arrow swiper-next swiper-next-slider-' . absint($id) . '"></div>';
                    echo '</div>';
                }

                if ($as_pagination == true) {
                    $pagi_classes = array(
                        'harika-swiper-pagination',
                        'swiper-pagination-slider-' . absint($id),
                    );
                    echo '<div class="' . esc_attr(implode(' ', array_filter($pagi_classes))) . '"></div>';
                }
            endif;
            wp_reset_postdata(); ?>






        </div>



    <?php
    }












    protected function content_template() {}

    public function harika_filter_excerpt_length($length)
    {

        $settings = $this->get_settings();

        $excerpt_length = (!empty($settings['excerpt_length'])) ? absint($settings['excerpt_length']) : 25;

        return absint($excerpt_length);
    }

    public function harika_filter_excerpt_more($more)
    {
        return '…';
    }


    protected function render_excerpt()
    {

        $settings = $this->get_settings();

        $show_excerpt = $settings['show_excerpt'];

        if ('yes' !== $show_excerpt) {
            return;
        }

        add_filter('excerpt_more', [$this, 'harika_filter_excerpt_more'], 20);
        add_filter('excerpt_length', [$this, 'harika_filter_excerpt_length'], 9999);

    ?>

        <div class="excerpt">
            <?php
            if (\Elementor\Plugin::$instance->editor->is_edit_mode()) {
                echo '<p>' . wp_trim_words(get_the_excerpt(), $settings['excerpt_length']) . '</p>';
            } else {
                the_excerpt();
            }
            ?>
        </div>
<?php

        remove_filter('excerpt_length', [$this, 'harika_filter_excerpt_length'], 9999);
        remove_filter('excerpt_more', [$this, 'harika_filter_excerpt_more'], 20);
    }
}
