<?php
use Harika\Elementor\Controls\Dynamic_Select;
use Harika\Traits\Global_Widget_Controls;

class post_list_2 extends \Elementor\Widget_Base {

    use Global_Widget_Controls;

    private $_query = null;

	public function get_name() {
		return 'HarikaList2';
	}

	public function get_title() {
		return __( 'پست لیست 2', 'harika' );
	}

	public function get_icon() {
		return 'eicon-favorite harika-icon';
	}

	public function get_categories() {
		return [ 'harika_elements' ];
	}


    // public function get_widget_css_config( $widget_name ) {

	// 	// The URL of the widget's external CSS file that is loaded in case that the CSS content is too large to be printed inline.
	// 	$file_url = HARIKA_URI . '/includes/elementor/css/harika-post-list2-widget.css';

	// 	// The local path of the widget's CSS file that is being read and saved in the DB when the CSS content should be printed inline.
	// 	$file_path = HARIKA_INCLUDES . '/elementor/css/harika-post-list2-widget.css';

	// 	return [
	// 		'key' => $widget_name,
	// 		'version' => ELEMENTOR_VERSION,
	// 		'file_path' => $file_path,
	// 		'data' => [
	// 			'file_url' => $file_url,
	// 		],
	// 	];
	// }


    public function get_query() {
		return $this->_query;
	}
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'harika' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

	    $this->add_control(
			'item_limit',
			[
				'label'     => esc_html__('تعداد پست ها', 'harika'),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1
					],
				],
				'default'   => [
					'size' => 3,
				],
			]
		);

        $this->add_control(
			'hr1',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);


        $this->add_responsive_control(
			'columns_number',
			[
				'label'     => esc_html__('تعداد ستون ها', 'harika'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 1,
                'selectors' => [
					'{{WRAPPER}} .harika-posts-list-2-widget' => 'grid-template-columns: repeat({{SIZE}},1fr);',
				],
			]
		);

        $this->add_control(
			'hr2',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

        $this->add_control(
			'image_position',
			[
				'label' => __('موقعیت تصویر', 'harika'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'image-right',
				'options' => [
					'image-right' => esc_html__( 'راست', 'harika' ),
					'image-left' => esc_html__( 'چپ', 'harika' ),
                ],
			]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'image', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `image_size` and `image_custom_dimension`.
				'default' => 'large',
				'separator' => 'none',
			]
		);
		
		$this->add_responsive_control(
			'pic_height',
			[
				'label' => __( 'ارتفاع تصویر', 'harika' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px', 'vw' ],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
					'vw' => [
						'min' => 1,
						'max' => 100,
					],
				],
                'selectors' => [
					'{{WRAPPER}} .harika-posts-list-2-widget .article .featured-image' => 'height: {{SIZE}}{{UNIT}};',
				],
                
			]
		);

        
        $this->add_responsive_control(
			'pic_width',
			[
				'label' => __( 'عرض تصویر', 'harika' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
				],
                'selectors' => [
					'{{WRAPPER}} .harika-posts-list-2-widget .article .featured-image' => 'width: {{SIZE}}px;',
				],
                
			]
		);
        $this->add_control(
			'hr3',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
        $this->add_control(
			'image_hover_scale',
			[
				'label' => __( 'بزرگنمایی تصویر در هاور', 'harika' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => 'بدون بزرگنمایی',
					'1.1' => '1.1',
					'1.2' => '1.2',
					'1.3' => '1.3',
					'1.4' => '1.4',
					'1.5' => '1.5',
					'1.6' => '1.6',
					'1.7' => '1.7',
					'1.8' => '1.8',
					'1.9' => '1.9',
				],
				'default' => '1.2',
				'selectors' => [
					'{{WRAPPER}} .harika-posts-list-2-widget .article:hover .featured-image img' => 'transform: scale({{VALUE}});',
				],
			]
		);
        $this->add_responsive_control(
			'scale_speed',
			[
				'label' => __( 'سرعت بزرگنمایی', 'harika' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0.1,
						'max' => 3,
                        'step' => 0.1,
					],
				],
                'selectors' => [
					'{{WRAPPER}} .harika-posts-list-2-widget .featured-image img' => 'transition: {{SIZE}}s;',
				],
                
			]
		);

        $this->add_control(
			'hr4',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

        
        $this->add_control(
			'show_post_type_icon',
			[
				'label' => __('آیکن پست فرمت', 'harika'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'harika' ),
				'label_off' => __( 'مخفی', 'harika' ),
				'default' => 'yes',
			]
		);
        

        $this->add_control(
			'hr5',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

        $this->add_control(
			'show_excerpt',
			[
				'label' => __('چکیده', 'harika'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'harika' ),
				'label_off' => __( 'مخفی', 'harika' ),
				'default' => 'yes',
			]
		);
        
		$this->add_control(
			'excerpt_length',
			[
				'label' => __('طول چکیده', 'harika'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => apply_filters( 'excerpt_length', 6 ),
				'condition' => [
					'show_excerpt' => 'yes',
                ],
			]
		);

	    $this->end_controls_section();



        /////////////////////////////////////////////////////////
		//Global query Controls
		$this->register_query_controls();
		/////////////////////////////////////////////////////////
		
		
		
        $this->start_controls_section(
            'style_section',
            [
                'label' => __( 'استایل', 'harika' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // Columns margin.
		$this->add_responsive_control(
			'grid_style_columns_gap',
			[
				'label'     => __( 'فاصله ستون ها' , 'harika' ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .harika-posts-list-2-widget' => 'grid-column-gap: {{SIZE}}{{UNIT}}',
					
				],
			]
		);

		// Row margin.
		$this->add_responsive_control(
			'grid_style_rows_gap',
			[
				'label'     => __( 'فاصله ردیف ها' , 'harika' ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .harika-posts-list-2-widget' => 'grid-row-gap: {{SIZE}}{{UNIT}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
			    'label'     => __( 'عنوان پست' , 'harika' ),
				'name'     => 'post_title_typography',
				'selector' => '{{WRAPPER}} .harika-posts-list-2-widget .content .title, {{WRAPPER}} .harika-posts-list-2-widget .content .title a',
			]
		);
		
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
			    'label'     => __( 'تایپوگرافی چکیده' , 'harika' ),
				'name'     => 'excerpt_typography',
				'selector' => '{{WRAPPER}} .harika-posts-list-2-widget .content .excerpt, {{WRAPPER}} .harika-posts-list-2-widget .content .excerpt p',
				'condition' => [
					'show_excerpt' => 'yes',
                ],
			]
		);
		
		$this->add_control(
			'post_box_border_radius',
			[
				'label'      => __( 'حاشیه مدور' , 'harika' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .harika-posts-list-2-widget .featured-image, {{WRAPPER}} .harika-posts-list-2-widget .article' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

	}








    





	protected function render() {
		$settings = $this->get_settings_for_display();

        $item_limit = 'item-limit-'.$settings['item_limit']['size'];


        $image_position = $settings['image_position'];


        $default = $this->getGroupControlQueryArgs();

		$args         = array_merge($default);
		$this->_query = new WP_Query($args);

		$this->query_posts($settings['item_limit']['size']);
		
		$wp_query = $this->get_query();


		echo '<div class="harika-posts-list-2-widget harika-post-widget harika-post-grid a-list-layout '.$item_limit.' '.$image_position.'">';
            if ( $wp_query->have_posts() ) :
                while ($wp_query->have_posts()) :
                $wp_query->the_post(); ?>
                    <div class="article">
                        

                        <a class="featured-image" href="<?php the_permalink(); ?>" target="_top">
                        
                            <?php if ( 'yes' === $settings['show_post_type_icon'] ) : ?>
                                <?php if ( has_post_format( 'video' )) : ?>
                                <span class="post-format-icon post-is-video"><?php echo post_is_video_svg(); ?></span>
                                <?php endif; ?>
                                
                                <?php if ( has_post_format( 'audio' )) : ?>
                                <span class="post-format-icon post-is-audio"><?php echo post_is_audio_svg(); ?></span>
                                <?php endif;
                            endif; ?>

                            <?php the_post_thumbnail($settings['image_size']); ?>

                        </a>


                        <div class="content">
                            <h3 class="title"><a href="<?php the_permalink(); ?>" target="_top"><?php the_title(); ?></a></h3>
                            <?php if($settings['show_excerpt'] === 'yes') { $this->render_excerpt(); } ?>
                        </div>
                    </div>
                <?php
                endwhile;
            endif;
            wp_reset_postdata();
        echo '</div>';
	}












	protected function content_template() {

	}

    public function harika_filter_excerpt_length( $length ) {

		$settings = $this->get_settings();

		$excerpt_length = (!empty( $settings['excerpt_length'] ) ) ? absint( $settings['excerpt_length'] ) : 6;

		return absint( $excerpt_length );
	}
    
    public function harika_filter_excerpt_more( $more ) {
		return '…';
	}
    
    
	protected function render_excerpt() {

		$settings = $this->get_settings();

		$show_excerpt = $settings['show_excerpt'];

		if ( 'yes' !== $show_excerpt ) {
			return;
		}
		
		add_filter( 'excerpt_more', [ $this, 'harika_filter_excerpt_more' ], 20 );
		add_filter( 'excerpt_length', [ $this, 'harika_filter_excerpt_length' ], 9999 );

		?>
		
		<div class="excerpt">
            <?php
                if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
                    echo '<p>'.wp_trim_words(get_the_excerpt(), $settings['excerpt_length']).'</p>';
                } else {
                    the_excerpt();
                }
            ?>
		</div>
		<?php

		remove_filter( 'excerpt_length', [ $this, 'harika_filter_excerpt_length' ], 9999 );
		remove_filter( 'excerpt_more', [ $this, 'harika_filter_excerpt_more' ], 20 );
	}

}