<?php

class ps_the_content extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'HarikaSAPostContent';
    }

    public function get_title()
    {
        return __('محتوای پست', 'harika');
    }

    public function get_icon()
    {
        return 'eicon-favorite harika-icon';
    }

    public function get_categories()
    {
        return ['harika_post_single_elements'];
    }


	// public function get_widget_css_config( $widget_name ) {

	// 	// The URL of the widget's external CSS file that is loaded in case that the CSS content is too large to be printed inline.
	// 	$file_url = HARIKA_URI . '/includes/elementor/css/ggggggggggggggggggggg';

	// 	// The local path of the widget's CSS file that is being read and saved in the DB when the CSS content should be printed inline.
	// 	$file_path = HARIKA_INCLUDES . '/elementor/css/ggggggggggggggggggggg';

	// 	return [
	// 		'key' => $widget_name,
	// 		'version' => ELEMENTOR_VERSION,
	// 		'file_path' => $file_path,
	// 		'data' => [
	// 			'file_url' => $file_url,
	// 		],
	// 	];
	// }



    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('تنظیمات', 'harika'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'تایپوگرافی p', 'harika' ),
                'name' => 'harika_content_typography_p',
				'selector' => 'body {{WRAPPER}} .harika-post-content-widget p',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'تایپوگرافی a', 'harika' ),
                'name' => 'harika_content_typography_a',
				'selector' => 'body {{WRAPPER}} .harika-post-content-widget a',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'تایپوگرافی span', 'harika' ),
                'name' => 'harika_content_typography_span',
				'selector' => 'body {{WRAPPER}} .harika-post-content-widget span',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'تایپوگرافی div', 'harika' ),
                'name' => 'harika_content_typography_div',
				'selector' => 'body {{WRAPPER}} .harika-post-content-widget div',
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'تایپوگرافی li', 'harika' ),
                'name' => 'harika_content_typography_li',
				'selector' => 'body {{WRAPPER}} .harika-post-content-widget li',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'تایپوگرافی h1', 'harika' ),
                'name' => 'harika_content_typography_h1',
				'selector' => 'body {{WRAPPER}} .harika-post-content-widget h1',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'تایپوگرافی h2', 'harika' ),
                'name' => 'harika_content_typography_h2',
				'selector' => 'body {{WRAPPER}} .harika-post-content-widget h2',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'تایپوگرافی h3', 'harika' ),
                'name' => 'harika_content_typography_h3',
				'selector' => 'body {{WRAPPER}} .harika-post-content-widget h3',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'تایپوگرافی h4', 'harika' ),
                'name' => 'harika_content_typography_h4',
				'selector' => 'body {{WRAPPER}} .harika-post-content-widget h4',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'تایپوگرافی h5', 'harika' ),
                'name' => 'harika_content_typography_h5',
				'selector' => 'body {{WRAPPER}} .harika-post-content-widget h5',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'تایپوگرافی h6', 'harika' ),
                'name' => 'harika_content_typography_h6',
				'selector' => 'body {{WRAPPER}} .harika-post-content-widget h6',
			]
		);
        $this->add_control(
			'harika_content_color_content',
			[
				'label' => esc_html__( 'رنگ کلی', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body {{WRAPPER}} .harika-post-content-widget, body {{WRAPPER}} .harika-post-content-widget > ul li, body {{WRAPPER}} .harika-post-content-widget > ol li' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_p',
			[
				'label' => esc_html__( 'رنگ p', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body {{WRAPPER}} .harika-post-content-widget p' => 'color: {{VALUE}} !important',
				],
			]
		);
        $this->add_control(
			'harika_content_color_p_darkmode',
			[
				'label' => esc_html__( 'رنگ p (دارک مود)', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-post-content-widget p' => 'color: {{VALUE}} !important',
				],
			]
		);
        
		$this->add_control(
			'harika_content_color_a',
			[
				'label' => esc_html__( 'رنگ a', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body {{WRAPPER}} .harika-post-content-widget a' => 'color: {{VALUE}} !important',
				],
			]
		);
        $this->add_control(
			'harika_content_color_a_darkmode',
			[
				'label' => esc_html__( 'رنگ a (دارک مود)', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-post-content-widget a' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_span',
			[
				'label' => esc_html__( 'رنگ span', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body {{WRAPPER}} .harika-post-content-widget span' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_span_darkmode',
			[
				'label' => esc_html__( 'رنگ span (دارک مود)', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-post-content-widget span' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_div',
			[
				'label' => esc_html__( 'رنگ div', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body {{WRAPPER}} .harika-post-content-widget div' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_div_darkmode',
			[
				'label' => esc_html__( 'رنگ div (دارک مود)', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-post-content-widget div' => 'color: {{VALUE}} !important',
				],
			]
		);
        $this->add_control(
			'harika_content_color_li',
			[
				'label' => esc_html__( 'رنگ li', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body {{WRAPPER}} .harika-post-content-widget li' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_li_darkmode',
			[
				'label' => esc_html__( 'رنگ li (دارک مود)', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-post-content-widget li' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_h_all',
			[
				'label' => esc_html__( 'رنگ همه تگ های h', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body {{WRAPPER}} .harika-post-content-widget h1, body {{WRAPPER}} .harika-post-content-widget h2, body {{WRAPPER}} .harika-post-content-widget h3, body {{WRAPPER}} .harika-post-content-widget h4, body {{WRAPPER}} .harika-post-content-widget h5, body {{WRAPPER}} .harika-post-content-widget h6' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_h_all_darkmode',
			[
				'label' => esc_html__( 'رنگ همه تگ های h (دارک مود)', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-post-content-widget h1, body.dark_mode {{WRAPPER}} .harika-post-content-widget h2, body.dark_mode {{WRAPPER}} .harika-post-content-widget h3, body.dark_mode {{WRAPPER}} .harika-post-content-widget h4, body.dark_mode {{WRAPPER}} .harika-post-content-widget h5, body.dark_mode {{WRAPPER}} .harika-post-content-widget h6' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_h1',
			[
				'label' => esc_html__( 'رنگ h1', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body {{WRAPPER}} .harika-post-content-widget h1' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_h1_darkmode',
			[
				'label' => esc_html__( 'رنگ h1 (دارک مود)', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-post-content-widget h1' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_h2',
			[
				'label' => esc_html__( 'رنگ h2', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body {{WRAPPER}} .harika-post-content-widget h2' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_h2_darkmode',
			[
				'label' => esc_html__( 'رنگ h2 (دارک مود)', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-post-content-widget h2' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_h3',
			[
				'label' => esc_html__( 'رنگ h3', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body {{WRAPPER}} .harika-post-content-widget h3' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_h3_darkmode',
			[
				'label' => esc_html__( 'رنگ h3 (دارک مود)', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-post-content-widget h3' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_h4',
			[
				'label' => esc_html__( 'رنگ h4', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body {{WRAPPER}} .harika-post-content-widget h4' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_h4_darkmode',
			[
				'label' => esc_html__( 'رنگ h4 (دارک مود)', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-post-content-widget h4' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_h5',
			[
				'label' => esc_html__( 'رنگ h5', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body {{WRAPPER}} .harika-post-content-widget h5' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_h5_darkmode',
			[
				'label' => esc_html__( 'رنگ h5 (دارک مود)', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-post-content-widget h5' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_h6',
			[
				'label' => esc_html__( 'رنگ h6', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body {{WRAPPER}} .harika-post-content-widget h6' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'harika_content_color_h6_darkmode',
			[
				'label' => esc_html__( 'رنگ h6 (دارک مود)', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-post-content-widget h6' => 'color: {{VALUE}} !important',
				],
			]
		);


        $this->end_controls_section();



        // $this->start_controls_section(
        //     'style_section',
        //     [
        //         'label' => __('استایل', 'harika'),
        //         'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        //     ]
        // );

        // // insert style controls here ...

        // $this->end_controls_section();
    }











    public function template()
    {
        $settings = $this->get_settings_for_display(); ?>

        <div class="harika-post-content-widget content wp-editor-content">
            <?php the_content(); ?>
            <?php wp_link_pages(); ?>
        </div>


<?php
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();


        if (\Elementor\Plugin::$instance->editor->is_edit_mode()):

            $query_args = array(
                'posts_per_page'         => 1,

            );


            $all_posts = new \WP_Query($query_args);

            if ($all_posts->have_posts()) :


                while ($all_posts->have_posts()) :

                    $all_posts->the_post();

                    $this->template();

                endwhile;
                wp_reset_postdata();
            endif;;
        else:


            $this->template();


        endif;
    }


    protected function content_template() {}
}
