<?php

class ps_post_title extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'HarikaSAPostTitle';
    }

    public function get_title()
    {
        return __('عنوان پست', 'harika');
    }

    public function get_icon()
    {
        return 'eicon-favorite harika-icon';
    }

    public function get_categories()
    {
        return ['harika_post_single_elements'];
    }


    // public function get_widget_css_config( $widget_name ) {

	// 	// The URL of the widget's external CSS file that is loaded in case that the CSS content is too large to be printed inline.
	// 	$file_url = HARIKA_URI . '/includes/elementor/css/harika-posttitle-widget.css';

	// 	// The local path of the widget's CSS file that is being read and saved in the DB when the CSS content should be printed inline.
	// 	$file_path = HARIKA_INCLUDES . '/elementor/css/harika-posttitle-widget.css';

	// 	return [
	// 		'key' => $widget_name,
	// 		'version' => ELEMENTOR_VERSION,
	// 		'file_path' => $file_path,
	// 		'data' => [
	// 			'file_url' => $file_url,
	// 		],
	// 	];
	// }



    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('تنظیمات', 'harika'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'title_tag',
			[
				'label' => esc_html__( 'تگ عنوان', 'elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
					'div' => 'div',
					'span' => 'span',
					'p' => 'p',
				],
				'default' => 'h1',
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'تایپوگرافی', 'harika' ),
                'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .harika-post-title-widget .entry-title',
			]
		);
        $this->add_control(
			'color',
			[
				'label' => esc_html__( 'رنگ', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .harika-post-title-widget .entry-title' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'darkmode_color',
			[
				'label' => esc_html__( 'رنگ دارک مود', 'harika' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-post-title-widget .entry-title' => 'color: {{VALUE}}',
				],
			]
		);

        $this->end_controls_section();



        // $this->start_controls_section(
        //     'style_section',
        //     [
        //         'label' => __('استایل', 'harika'),
        //         'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        //     ]
        // );

        // // insert style controls here ...

        // $this->end_controls_section();
    }











    public function template()
    {
        $settings = $this->get_settings_for_display(); ?>

        <?php if (apply_filters('harika_page_title', true)): ?>
            <div class="harika-post-title-widget">
                <?php the_title('<'.$settings['title_tag'].' class="entry-title single-title">', '</'.$settings['title_tag'].'>'); ?>
            </div>
        <?php endif; ?>


<?php
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();


        if (\Elementor\Plugin::$instance->editor->is_edit_mode()):

            $query_args = array(
                'posts_per_page'         => 1,

            );


            $all_posts = new \WP_Query($query_args);

            if ($all_posts->have_posts()) :


                while ($all_posts->have_posts()) :

                    $all_posts->the_post();

                    $this->template();

                endwhile;
                wp_reset_postdata();
            endif;
        ;else:


            $this->template();


        endif;
    }


    protected function content_template() {}
}
