<?php

class ps_meta_data extends \Elementor\Widget_Base
{

	public function get_name()
	{
		return 'HarikaSAMetaData';
	}

	public function get_title()
	{
		return __('متا داده', 'harika');
	}

	public function get_icon()
	{
		return 'eicon-favorite harika-icon';
	}

	public function get_categories()
	{
		return ['harika_post_single_elements'];
	}


	// public function get_widget_css_config( $widget_name ) {

	// 	// The URL of the widget's external CSS file that is loaded in case that the CSS content is too large to be printed inline.
	// 	$file_url = HARIKA_URI . '/includes/elementor/css/harika-metadata.css';

	// 	// The local path of the widget's CSS file that is being read and saved in the DB when the CSS content should be printed inline.
	// 	$file_path = HARIKA_INCLUDES . '/elementor/css/harika-metadata.css';

	// 	return [
	// 		'key' => $widget_name,
	// 		'version' => ELEMENTOR_VERSION,
	// 		'file_path' => $file_path,
	// 		'data' => [
	// 			'file_url' => $file_url,
	// 		],
	// 	];
	// }



	protected function register_controls()
	{

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('محتوا', 'harika'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'date_icon',
			[
				'label' => esc_html__('آیکن تاریخ', 'harika'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-calendar',
					'library' => 'fas',
				],
			]
		);

		$this->add_control(
			'comments_icon',
			[
				'label' => esc_html__('آیکن دیدگاه ها', 'harika'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-comment',
					'library' => 'fas',
				],
			]
		);

		$this->add_control(
			'views_icon',
			[
				'label' => esc_html__('آیکن تعداد بازدید', 'harika'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-fire',
					'library' => 'fas',
				],
			]
		);

		$this->add_control(
			'author_show',
			[
				'label' => esc_html__('نمایش نویسنده', 'harika'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('نمایش', 'harika'),
				'label_off' => esc_html__('مخفی', 'harika'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'author_before',
			[
				'label' => esc_html__('متن قبل از نویسنده', 'harika'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'توسط : ',
			]
		);

		$this->add_control(
			'show_date_hr1',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'date_show',
			[
				'label' => esc_html__('نمایش تاریخ', 'harika'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('نمایش', 'harika'),
				'label_off' => esc_html__('مخفی', 'harika'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'date_before',
			[
				'label' => esc_html__('متن قبل از تاریخ', 'harika'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'تاریخ انتشار : ',
			]
		);

		$this->add_control(
			'date_after',
			[
				'label' => esc_html__('متن بعد از تاریخ', 'harika'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'date_type',
			[
				'label' => __('نوع تاریخ', 'harika'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'published',
				'options' => [
					'published' => esc_html__('تاریخ انتشار', 'harika'),
					'modified' => esc_html__('آخرین ویرایش', 'harika'),
				],
			]
		);
		$this->add_control(
			'date_format',
			[
				'label' => esc_html__('فرمت تاریخ', 'harika'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'show_date_hr2',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'comments_show',
			[
				'label' => esc_html__('نمایش دیدگاه ها', 'harika'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('نمایش', 'harika'),
				'label_off' => esc_html__('مخفی', 'harika'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'views_show',
			[
				'label' => esc_html__('نمایش تعداد بازدید', 'harika'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('نمایش', 'harika'),
				'label_off' => esc_html__('مخفی', 'harika'),
				'return_value' => 'yes',
				'default' => false,
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'style_section',
			[
				'label' => __('استایل', 'harika'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'meta_text_typography',
				'label' => esc_html__('تایپوگرافی متن', 'harika'),
				'selector' => '{{WRAPPER}} .harika-metadata-widget span',
			]
		);
		$this->add_control(
			'meta_text_color',
			[
				'label' => esc_html__('رنگ متن', 'harika'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .harika-metadata-widget span, {{WRAPPER}} .harika-metadata-widget span a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'meta_text_color_dark',
			[
				'label' => esc_html__('رنگ متن (دارک مود)', 'harika'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-metadata-widget span, body.dark_mode {{WRAPPER}} .harika-metadata-widget span a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'meta_icons_typography',
				'label' => esc_html__('تایپوگرافی آیکن ها', 'harika'),
				'selector' => '{{WRAPPER}} .harika-metadata-widget span i',
			]
		);
		$this->add_control(
			'meta_icons_color',
			[
				'label' => esc_html__('رنگ آیکن ها', 'harika'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .harika-metadata-widget span i' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'meta_icons_color_dark',
			[
				'label' => esc_html__('رنگ آیکن ها (دارک مود)', 'harika'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-metadata-widget span i' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
	}










	public function template($author_id = null)
	{
		$settings = $this->get_settings_for_display();

		// تعیین آیدی پست جاری به صورت امن
		$post_id = get_the_ID();
		if (!$post_id && isset($GLOBALS['post'])) {
			$post_id = $GLOBALS['post']->ID;
		}

		// گرفتن آیدی نویسنده
		if (!$author_id && $post_id) {
			$author_id = get_post_field('post_author', $post_id);
		}

?>
		<div class="harika-metadata-widget">

			<?php if ($settings['author_show'] === 'yes' && $author_id) : ?>
				<span class="author">
					<?php
					$author_email   = get_the_author_meta('user_email', $author_id);
					$author_display = get_the_author_meta('display_name', $author_id);
					$author_url     = get_author_posts_url($author_id);
					echo get_avatar($author_email, 34, '');
					echo esc_html($settings['author_before']);
					echo '<a href="' . esc_url($author_url) . '">' . esc_html($author_display) . '</a>';
					?>
				</span>
			<?php endif; ?>

			<?php if ($settings['date_show'] === 'yes') : ?>
				<span class="date"><?php \Elementor\Icons_Manager::render_icon($settings['date_icon'], ['aria-hidden' => 'true']); ?>
					<?php echo esc_html($settings['date_before']); ?>
					<?php
					if ($settings['date_type'] === 'published') {
						echo esc_html(get_the_date($settings['date_format']));
					} else if ($settings['date_type'] === 'modified') {
						echo esc_html(get_the_modified_date($settings['date_format']));
					}
					?>
					<?php echo esc_html($settings['date_after']); ?>
				</span>
			<?php endif; ?>

			<?php if ($settings['comments_show'] === 'yes') : ?>
				<span class="comments-count"><?php \Elementor\Icons_Manager::render_icon($settings['comments_icon'], ['aria-hidden' => 'true']); ?>
					<?php
					$comments_number = get_comments_number();
					printf(
						esc_html(
							_nx(
								__('1 دیدگاه', 'harika'),
								__('%1$s دیدگاه', 'harika'),
								$comments_number,
								'comments title'
							)
						),
						esc_html(number_format_i18n($comments_number))
					);
					?>
				</span>
			<?php endif; ?>

			<?php if ($settings['views_show'] === 'yes') : ?>
				<span class="views"><?php \Elementor\Icons_Manager::render_icon($settings['views_icon'], ['aria-hidden' => 'true']); ?>
					<?php
					echo esc_html(get_post_views($post_id));
					?>
				</span>
			<?php endif; ?>
		</div>
<?php
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();

		if (\Elementor\Plugin::$instance->editor->is_edit_mode()) {
			// نمایش پیش‌نمایش ویجت در ویرایشگر المنتور با یک پست نمونه
			$query_args = array(
				'posts_per_page' => 1,
				'post_type'      => 'post', // مطمئن شو post type درست ست شده
			);
			$all_posts = new \WP_Query($query_args);

			if ($all_posts->have_posts()) {
				while ($all_posts->have_posts()) {
					$all_posts->the_post();
					$author_id = get_post_field('post_author', get_the_ID());
					$this->template($author_id);
				}
				wp_reset_postdata();
			}
		} else {
			// حالت عادی: نمایش برای پست جاری
			$post_id = get_the_ID();
			$author_id = $post_id ? get_post_field('post_author', $post_id) : null;
			$this->template($author_id);
		}
	}


	protected function content_template() {}
}
