<?php

class ps_author_box extends \Elementor\Widget_Base
{

	public function get_name()
	{
		return 'HarikaSAAuthorBox';
	}

	public function get_title()
	{
		return __('باکس نویسنده', 'harika');
	}

	public function get_icon()
	{
		return 'eicon-favorite harika-icon';
	}

	public function get_categories()
	{
		return ['harika_post_single_elements'];
	}


	// public function get_widget_css_config( $widget_name ) {

	// 	// The URL of the widget's external CSS file that is loaded in case that the CSS content is too large to be printed inline.
	// 	$file_url = HARIKA_URI . '/includes/elementor/css/harika-authorbox-widget.css';

	// 	// The local path of the widget's CSS file that is being read and saved in the DB when the CSS content should be printed inline.
	// 	$file_path = HARIKA_INCLUDES . '/elementor/css/harika-authorbox-widget.css';

	// 	return [
	// 		'key' => $widget_name,
	// 		'version' => ELEMENTOR_VERSION,
	// 		'file_path' => $file_path,
	// 		'data' => [
	// 			'file_url' => $file_url,
	// 		],
	// 	];
	// }



	protected function register_controls()
	{

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('محتوا', 'harika'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		// insert content controls here ...

		$this->end_controls_section();



		$this->start_controls_section(
			'style_section',
			[
				'label' => __('استایل', 'harika'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs(
			'style_tabs'
		);
		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => esc_html__('عادی', 'harika'),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'name_typography',
				'label' => esc_html__('تایپوگرافی نام نویسنده', 'harika'),
				'selector' => '{{WRAPPER}} .harika-authorbox-widget .info .top-content h3, {{WRAPPER}} .harika-authorbox-widget .info .top-content h3 a',
			]
		);
		$this->add_control(
			'name_color',
			[
				'label' => esc_html__('رنگ نام نویسنده', 'harika'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .harika-authorbox-widget .info .top-content h3, {{WRAPPER}} .harika-authorbox-widget .info .top-content h3 a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'disc_typography',
				'label' => esc_html__('تایپوگرافی توضیحات', 'harika'),
				'selector' => '{{WRAPPER}} .harika-authorbox-widget .info .top-content h3, {{WRAPPER}} .harika-authorbox-widget .info .top-content h3 a',
			]
		);
		$this->add_control(
			'disc_color',
			[
				'label' => esc_html__('رنگ توضیحات', 'harika'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .harika-authorbox-widget .info .top-content h3, {{WRAPPER}} .harika-authorbox-widget .info .top-content h3 a' => 'color: {{VALUE}}',
				],
			]
		);




		$this->add_control(
			'heading_box',
			[
				'label' => esc_html__('باکس کلی', 'harika'),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'box_background',
				'label' => esc_html__('پس زمینه', 'harika'),
				'types' => ['classic', 'gradient', 'video'],
				'selector' => '{{WRAPPER}} .harika-authorbox-widget',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'label' => esc_html__('کادر دور', 'harika'),
				'selector' => '{{WRAPPER}} .harika-authorbox-widget',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_box_shadow',
				'label' => esc_html__('سایه کادر', 'harika'),
				'selector' => '{{WRAPPER}} .harika-authorbox-widget',
			]
		);

		$this->add_control(
			'box_border_radius',
			[
				'label' => esc_html__('شعاع کادر', 'harika'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .harika-authorbox-widget' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'box_padding',
			[
				'label' => esc_html__('فاصله داخلی', 'harika'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .harika-authorbox-widget' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'style_normal_tab_dark',
			[
				'label' => esc_html__('دارک', 'harika'),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'name_typography_dark',
				'label' => esc_html__('تایپوگرافی نام نویسنده', 'harika'),
				'selector' => 'body.dark_mode {{WRAPPER}} .harika-authorbox-widget .info .top-content h3, body.dark_mode {{WRAPPER}} .harika-authorbox-widget .info .top-content h3 a',
			]
		);
		$this->add_control(
			'name_color_dark',
			[
				'label' => esc_html__('رنگ نام نویسنده', 'harika'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-authorbox-widget .info .top-content h3, body.dark_mode {{WRAPPER}} .harika-authorbox-widget .info .top-content h3 a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'disc_typography_dark',
				'label' => esc_html__('تایپوگرافی توضیحات', 'harika'),
				'selector' => 'body.dark_mode {{WRAPPER}} .harika-authorbox-widget .info .top-content h3, body.dark_mode {{WRAPPER}} .harika-authorbox-widget .info .top-content h3 a',
			]
		);
		$this->add_control(
			'disc_color_dark',
			[
				'label' => esc_html__('رنگ توضیحات', 'harika'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-authorbox-widget .info .top-content h3, body.dark_mode {{WRAPPER}} .harika-authorbox-widget .info .top-content h3 a' => 'color: {{VALUE}}',
				],
			]
		);




		$this->add_control(
			'heading_box_dark',
			[
				'label' => esc_html__('باکس کلی', 'harika'),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'box_background_dark',
				'label' => esc_html__('پس زمینه', 'harika'),
				'types' => ['classic', 'gradient', 'video'],
				'selector' => 'body.dark_mode {{WRAPPER}} .harika-authorbox-widget',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'box_border_dark',
				'label' => esc_html__('کادر دور', 'harika'),
				'selector' => 'body.dark_mode {{WRAPPER}} .harika-authorbox-widget',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_box_shadow_dark',
				'label' => esc_html__('سایه کادر', 'harika'),
				'selector' => 'body.dark_mode {{WRAPPER}} .harika-authorbox-widget',
			]
		);

		$this->add_control(
			'box_border_radius_dark',
			[
				'label' => esc_html__('شعاع کادر', 'harika'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-authorbox-widget' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'box_padding_dark',
			[
				'label' => esc_html__('فاصله داخلی', 'harika'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'body.dark_mode {{WRAPPER}} .harika-authorbox-widget' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}











	public function template($author_id = null)
	{
		// اگر آیدی نیومد، از پست فعال بگیر
		if (!$author_id) {
			$author_id = get_post_field('post_author', get_the_ID());
		}
?>
		<div class="harika-authorbox-widget">
			<div class="avatar">
				<?php echo get_avatar(get_the_author_meta('user_email', $author_id), 150, ''); ?>
			</div>
			<div class="info">
				<div class="top-content">
					<h3>
						<?php
						// نام نویسنده با لینک پروفایل
						$display_name = get_the_author_meta('display_name', $author_id);
						$author_posts_url = get_author_posts_url($author_id);
						echo '<a href="' . esc_url($author_posts_url) . '">' . esc_html($display_name) . '</a>';
						?>
					</h3>
					<div class="author-social-links">
						<?php
						if (function_exists('harika_get_user_social_links')) {
							echo harika_get_user_social_links($author_id);
						}
						?>
					</div>
				</div>
				<div class="description">
					<?php echo esc_html(get_the_author_meta('description', $author_id)); ?>
				</div>
			</div>
		</div>
<?php
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();

		if (\Elementor\Plugin::$instance->editor->is_edit_mode()) {
			// در ویرایشگر المنتور، یک پست نمونه لود کن
			$query_args = array(
				'posts_per_page' => 1,
				'post_type' => 'post',
			);
			$all_posts = new \WP_Query($query_args);

			if ($all_posts->have_posts()) {
				while ($all_posts->have_posts()) {
					$all_posts->the_post();
					$author_id = get_post_field('post_author', get_the_ID());
					$this->template($author_id);
				}
				wp_reset_postdata();
			}
		} else {
			// در حالت عادی، از پست جاری
			$author_id = get_post_field('post_author', get_the_ID());
			$this->template($author_id);
		}
	}


	protected function content_template() {}
}
