<?php

class H_heading extends \Elementor\Widget_Base {

	public function get_name() {
		return 'HarikaHeading';
	}

	public function get_title() {
		return __( 'سرتیتر', 'harika' );
	}

	public function get_icon() {
		return 'eicon-favorite harika-icon';
	}

	public function get_categories() {
		return [ 'harika_elements' ];
	}


	// public function get_widget_css_config( $widget_name ) {

	// 	// The URL of the widget's external CSS file that is loaded in case that the CSS content is too large to be printed inline.
	// 	$file_url = HARIKA_URI . '/includes/elementor/css/harika-heading-widget.css';

	// 	// The local path of the widget's CSS file that is being read and saved in the DB when the CSS content should be printed inline.
	// 	$file_path = HARIKA_INCLUDES . '/elementor/css/harika-heading-widget.css';

	// 	return [
	// 		'key' => $widget_name,
	// 		'version' => ELEMENTOR_VERSION,
	// 		'file_path' => $file_path,
	// 		'data' => [
	// 			'file_url' => $file_url,
	// 		],
	// 	];
	// }



	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'harika' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

	    $this->add_control(
			'title', [
				'label' => esc_html__( 'عنوان', 'harika' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'نمونه عنوان' , 'harika' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'icon',
			[
				'label' => esc_html__( 'آیکن', 'harika' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-circle-notch',
					'library' => 'fa-solid',
				],
			]
		);


	    $this->end_controls_section();
		
		
		
        $this->start_controls_section(
            'style_section',
            [
                'label' => __( 'استایل', 'harika' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'تایپوگرافی عنوان', 'harika' ),
                'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .harika-heading-widget .title',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'تایپوگرافی آیکن', 'harika' ),
                'name' => 'icon_typography',
				'selector' => '{{WRAPPER}} .harika-heading-widget i',
			]
		);
        
        
		$this->end_controls_section();

	}











	protected function render() {
		$settings = $this->get_settings_for_display();


		echo '<div class="harika-heading-widget">';

            echo '<span class="title">'.$settings['title'].'</span>';
			\Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] );

        echo '</div>';
	}

	protected function content_template() {
    ?>
    <div class="harika-heading-widget">
        <span class="title">{{{ settings.title }}}</span>
        <# if ( settings.icon && settings.icon.value ) { #>
            <i class="{{ settings.icon.value }}" aria-hidden="true"></i>
        <# } #>
    </div>
    <?php
}

	

}