<?php

use HarikaTheme\Classes\Harika_svg;
use HarikaTheme\Classes\Harika_Helper as Helper;

class ba_archive_posts extends \Elementor\Widget_Base
{

	public function get_name()
	{
		return 'HarikaBAArchivePosts';
	}

	public function get_title()
	{
		return __('پست های آرشیو', 'harika');
	}

	public function get_icon()
	{
		return 'eicon-favorite harika-icon';
	}

	public function get_categories()
	{
		return ['harika_blog_archive_elements'];
	}



	// public function get_widget_css_config( $widget_name ) {

	// 	// The URL of the widget's external CSS file that is loaded in case that the CSS content is too large to be printed inline.
	// 	$file_url = HARIKA_URI . '/includes/elementor/css/harika-archive-posts-widget.css';

	// 	// The local path of the widget's CSS file that is being read and saved in the DB when the CSS content should be printed inline.
	// 	$file_path = HARIKA_INCLUDES . '/elementor/css/harika-archive-posts-widget.css';

	// 	return [
	// 		'key' => $widget_name,
	// 		'version' => ELEMENTOR_VERSION,
	// 		'file_path' => $file_path,
	// 		'data' => [
	// 			'file_url' => $file_url,
	// 		],
	// 	];
	// }


	protected function register_controls()
	{

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('محتوا', 'harika'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'image_position',
			[
				'label' => __('موقعیت تصویر', 'harika'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'row' => esc_html__('راست', 'harika'),
					'row-reverse' => esc_html__('چپ', 'harika'),
				],
				'selectors' => [
					'{{WRAPPER}} .harika-ba-archive-posts-widget.harika-post-widget .article' => 'flex-direction: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'image', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `image_size` and `image_custom_dimension`.
				'default' => 'large',
				'separator' => 'none',
			]
		);

		$this->add_responsive_control(
			'pic_height',
			[
				'label' => __('ارتفاع تصویر', 'harika'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['%', 'px', 'vw'],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
					'vw' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .harika-ba-archive-posts-widget .article .featured-image' => 'height: {{SIZE}}{{UNIT}};',
				],

			]
		);
		$this->add_control(
			'hr3',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'image_hover_scale',
			[
				'label' => __('بزرگنمایی تصویر در هاور', 'harika'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => 'بدون بزرگنمایی',
					'1.1' => '1.1',
					'1.2' => '1.2',
					'1.3' => '1.3',
					'1.4' => '1.4',
					'1.5' => '1.5',
					'1.6' => '1.6',
					'1.7' => '1.7',
					'1.8' => '1.8',
					'1.9' => '1.9',
				],
				'default' => '1.2',
				'selectors' => [
					'{{WRAPPER}} .harika-ba-archive-posts-widget .article:hover .featured-image img' => 'transform: scale({{VALUE}});',
				],
			]
		);
		$this->add_responsive_control(
			'scale_speed',
			[
				'label' => __('سرعت بزرگنمایی', 'harika'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0.1,
						'max' => 3,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .harika-ba-archive-posts-widget .featured-image img' => 'transition: {{SIZE}}s;',
				],

			]
		);

		$this->add_control(
			'hr4',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'show_date',
			[
				'label' => __('تاریخ', 'harika'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('نمایش', 'harika'),
				'label_off' => __('مخفی', 'harika'),
				'default' => 'yes',
			]
		);
		$this->add_control(
			'date_type',
			[
				'label' => __('نوع تاریخ', 'harika'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'published',
				'options' => [
					'published' => esc_html__('تاریخ انتشار', 'harika'),
					'modified' => esc_html__('آخرین ویرایش', 'harika'),
				],
			]
		);
		$this->add_control(
			'date_format',
			[
				'label' => esc_html__('فرمت تاریخ', 'harika'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'show_date_hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'show_comments_count',
			[
				'label' => __('تعداد نظرات', 'harika'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('نمایش', 'harika'),
				'label_off' => __('مخفی', 'harika'),
				'default' => 'yes',
			]
		);
		$this->add_control(
			'views_show',
			[
				'label' => esc_html__('نمایش تعداد بازدید', 'harika'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('نمایش', 'harika'),
				'label_off' => esc_html__('مخفی', 'harika'),
				'return_value' => 'yes',
				'default' => false,
			]
		);
		$this->add_control(
			'show_categories',
			[
				'label' => __('دسته بندی ها', 'harika'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('نمایش', 'harika'),
				'label_off' => __('مخفی', 'harika'),
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_post_type_icon',
			[
				'label' => __('آیکن پست فرمت', 'harika'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('نمایش', 'harika'),
				'label_off' => __('مخفی', 'harika'),
				'default' => 'yes',
			]
		);


		$this->add_control(
			'hr5',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'show_excerpt',
			[
				'label' => __('چکیده', 'harika'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('نمایش', 'harika'),
				'label_off' => __('مخفی', 'harika'),
				'default' => 'yes',
			]
		);

		$this->add_control(
			'excerpt_length',
			[
				'label' => __('طول چکیده', 'harika'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => apply_filters('excerpt_length', 6),
				'condition' => [
					'show_excerpt' => 'yes',
				],
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'style_section',
			[
				'label' => __('استایل', 'harika'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		// Columns margin.
		$this->add_responsive_control(
			'grid_style_columns_gap',
			[
				'label'     => __('فاصله ستون ها', 'harika'),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .harika-ba-archive-posts-widget' => 'grid-column-gap: {{SIZE}}{{UNIT}}',

				],
			]
		);

		// Row margin.
		$this->add_responsive_control(
			'grid_style_rows_gap',
			[
				'label'     => __('فاصله ردیف ها', 'harika'),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .harika-ba-archive-posts-widget' => 'grid-row-gap: {{SIZE}}{{UNIT}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'label'     => __('عنوان پست', 'harika'),
				'name'     => 'post_title_typography',
				'selector' => '{{WRAPPER}} .harika-ba-archive-posts-widget .content .title, {{WRAPPER}} .harika-ba-archive-posts-widget .content .title a',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'label'     => __('تایپوگرافی چکیده', 'harika'),
				'name'     => 'excerpt_typography',
				'selector' => '{{WRAPPER}} .harika-ba-archive-posts-widget .content .excerpt, {{WRAPPER}} .harika-ba-archive-posts-widget .content .excerpt p',
				'condition' => [
					'show_excerpt' => 'yes',
				],
			]
		);

		$this->add_control(
			'post_box_border_radius',
			[
				'label'      => __('حاشیه مدور', 'harika'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .harika-ba-archive-posts-widget .featured-image, {{WRAPPER}} .harika-ba-archive-posts-widget .article' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}











	public function template()
	{
		$settings = $this->get_settings_for_display();
		$cat_show = ' no-cat';

		if ($settings['show_categories'] === 'yes') {
			$cat_show = ' cat-show';
		}

?>

		<?php
		$post_link = get_permalink();
		?>
		<div class="article">


			<a class="featured-image" href="<?php the_permalink(); ?>" target="_top">

				<?php if ('yes' === $settings['show_post_type_icon']) : ?>
					<?php if (has_post_format('video')) : ?>
						<span class="post-format-icon post-is-video"><?php echo post_is_video_svg(); ?></span>
					<?php endif; ?>

					<?php if (has_post_format('audio')) : ?>
						<span class="post-format-icon post-is-audio"><?php echo post_is_audio_svg(); ?></span>
				<?php endif;
				endif; ?>

				<?php the_post_thumbnail($settings['image_size']); ?>

			</a>


			<div class="content <?php echo $cat_show; ?>">
				<h3 class="title"><a href="<?php the_permalink(); ?>" target="_top"><?php the_title(); ?></a></h3>
				<?php if ($settings['show_excerpt'] === 'yes') {
					$this->render_excerpt();
				} ?>

				<div class="meta">
					<div class="right">
						<?php if ($settings['show_categories'] === 'yes') : ?>
							<div class="categories harika-exc-cat-color">
								<?php echo Helper::harika_get_category(); ?>
							</div>
						<?php endif; ?>
					</div>

					<div class="left">
						<?php if ($settings['show_date'] === 'yes') : ?>
							<span class="date"><i class="date-icon"></i>
								<?php if ($settings['date_type'] === 'published') {
									echo get_the_date($settings['date_format']);
								} else if ($settings['date_type'] === 'modified') {
									echo get_the_modified_date($settings['date_format']);
								}
								?>
							</span>
						<?php endif; ?>

						<?php if ($settings['show_comments_count'] === 'yes') : ?>
							<span class="comments-count"><i class="comments-icon"></i>
								<?php
								$comments_number = get_comments_number();
								printf(
									esc_html( /* translators: 1: number of comments */
										_nx(
											__('1 دیدگاه', 'harika'),
											__('%1$s دیدگاه', 'harika'),
											$comments_number,
											'comments title'
										)
									),
									esc_html(number_format_i18n($comments_number))
								);

								?>

							</span>
						<?php endif; ?>
						<?php if ($settings['views_show'] === 'yes') : ?>
							<span class="views harika-global-views"><?php echo Harika_svg::get_icon_svg('fire-flame-icon'); ?>
								<?php
								$comments_number = get_comments_number();

								echo get_post_views(get_the_ID());
								?>

							</span>
						<?php endif; ?>
					</div>

				</div>

			</div>
		</div>



		<?php
	}


	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$image_position = ' image-position-right';
		if ($settings['image_position'] === 'row-reverse') {
			$image_position = ' image-position-left';
		}





		if (\Elementor\Plugin::$instance->editor->is_edit_mode()):

			$query_args = array(
				'posts_per_page'         => get_option('posts_per_page'),

			);


			$all_posts = new \WP_Query($query_args);

			if ($all_posts->have_posts()) :

		?><div class="harika-ba-archive-posts-widget harika-post-widget<?php echo $image_position; ?>"><?php
																												while ($all_posts->have_posts()) :

																													$all_posts->the_post();

																													$this->template();

																												endwhile;
																												wp_reset_postdata();
																												?></div><?php
					endif;;
				else: ?>
			<div class="harika-ba-archive-posts-widget harika-post-widget<?php echo $image_position; ?>">
				<?php
					while (have_posts()) {
						the_post();
						$post_link = get_permalink();
						$this->template();
					} ?>
			</div>
		<?php
				endif;
			}


			protected function content_template() {}








			public function harika_filter_excerpt_length($length)
			{

				$settings = $this->get_settings();

				$excerpt_length = (!empty($settings['excerpt_length'])) ? absint($settings['excerpt_length']) : 25;

				return absint($excerpt_length);
			}

			public function harika_filter_excerpt_more($more)
			{
				return '…';
			}


			protected function render_excerpt()
			{

				$settings = $this->get_settings();

				$show_excerpt = $settings['show_excerpt'];

				if ('yes' !== $show_excerpt) {
					return;
				}

				add_filter('excerpt_more', [$this, 'harika_filter_excerpt_more'], 20);
				add_filter('excerpt_length', [$this, 'harika_filter_excerpt_length'], 9999);

		?>

		<div class="excerpt">
			<?php
				if (\Elementor\Plugin::$instance->editor->is_edit_mode()) {
					echo '<p>' . wp_trim_words(get_the_excerpt(), $settings['excerpt_length']) . '</p>';
				} else {
					the_excerpt();
				}
			?>
		</div>
<?php

				remove_filter('excerpt_length', [$this, 'harika_filter_excerpt_length'], 9999);
				remove_filter('excerpt_more', [$this, 'harika_filter_excerpt_more'], 20);
			}
		}
