<?php

class ba_archive_description extends \Elementor\Widget_Base
{

	public function get_name()
	{
		return 'HarikaBAArchiveDescription';
	}

	public function get_title()
	{
		return __('توضیحات آرشیو', 'harika');
	}

	public function get_icon()
	{
		return 'eicon-favorite harika-icon';
	}

	public function get_categories()
	{
		return ['harika_blog_archive_elements'];
	}


	// public function get_widget_css_config( $widget_name ) {

	// 	// The URL of the widget's external CSS file that is loaded in case that the CSS content is too large to be printed inline.
	// 	$file_url = HARIKA_URI . '/includes/elementor/css/harika-archive-description-widget.css';

	// 	// The local path of the widget's CSS file that is being read and saved in the DB when the CSS content should be printed inline.
	// 	$file_path = HARIKA_INCLUDES . '/elementor/css/harika-archive-description-widget.css';

	// 	return [
	// 		'key' => $widget_name,
	// 		'version' => ELEMENTOR_VERSION,
	// 		'file_path' => $file_path,
	// 		'data' => [
	// 			'file_url' => $file_url,
	// 		],
	// 	];
	// }



	protected function register_controls()
	{

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('تنظیمات', 'harika'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_responsive_control(
			'p_margin_bottom',
			[
				'label'     => __('فاصله بین پاراگراف ها', 'harika'),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .harika-ba-archive-title-widget.archive-description p:not(:last-child)' => 'margin: 0 0 {{SIZE}}px 0',

				],
			]
		);

		$this->start_controls_tabs(
			'style_tabs'
		);
		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => esc_html__('عادی', 'harika'),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('تایپوگرافی', 'harika'),
				'name' => 'typography',
				'selector' => '{{WRAPPER}} .harika-ba-archive-title-widget.archive-description p',
			]
		);


		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'box_background',
				'label' => esc_html__('پس زمینه', 'harika'),
				'types' => ['classic', 'gradient', 'video'],
				'selector' => '{{WRAPPER}} .harika-ba-archive-title-widget.archive-description',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'label' => esc_html__('کادر دور', 'harika'),
				'selector' => '{{WRAPPER}} .harika-ba-archive-title-widget.archive-description',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_box_shadow',
				'label' => esc_html__('سایه کادر', 'harika'),
				'selector' => '{{WRAPPER}} .harika-ba-archive-title-widget.archive-description',
			]
		);


		$this->end_controls_tab();

		$this->start_controls_tab(
			'style_normal_tab_dark',
			[
				'label' => esc_html__('دارک', 'harika'),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('تایپوگرافی', 'harika'),
				'name' => 'typography_dark',
				'selector' => 'body.dark_mode {{WRAPPER}} .harika-ba-archive-title-widget.archive-description p',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'box_background_dark',
				'label' => esc_html__('پس زمینه', 'harika'),
				'types' => ['classic', 'gradient', 'video'],
				'selector' => 'body.dark_mode {{WRAPPER}} .harika-ba-archive-title-widget.archive-description',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'box_border_dark',
				'label' => esc_html__('کادر دور', 'harika'),
				'selector' => 'body.dark_mode {{WRAPPER}} .harika-ba-archive-title-widget.archive-description',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_box_shadow_dark',
				'label' => esc_html__('سایه کادر', 'harika'),
				'selector' => 'body.dark_mode {{WRAPPER}} .harika-ba-archive-title-widget.archive-description',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'box_border_radius',
			[
				'label' => esc_html__('شعاع کادر', 'harika'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .harika-ba-archive-title-widget.archive-description' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'box_margin',
			[
				'label' => esc_html__('فاصله خارجی', 'harika'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .harika-ba-archive-title-widget.archive-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'box_padding',
			[
				'label' => esc_html__('فاصله داخلی', 'harika'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .harika-ba-archive-title-widget.archive-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);



		$this->end_controls_section();



		// $this->start_controls_section(
		//     'style_section',
		//     [
		//         'label' => __('استایل', 'harika'),
		//         'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		//     ]
		// );

		// // insert style controls here ...

		// $this->end_controls_section();
	}











	public function template()
	{
		$settings = $this->get_settings_for_display();
		$harika_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

?>

		<?php if (get_the_archive_description() !== '' && $harika_paged <= 1) : ?>
			<div class="harika-ba-archive-title-widget archive-description">
				<?php echo get_the_archive_description(); ?>
			</div>
		<?php endif; ?>


<?php
	}


	protected function render()
	{
		$settings = $this->get_settings_for_display();


		if (\Elementor\Plugin::$instance->editor->is_edit_mode()):

			echo category_description();
			if (apply_filters('harika_page_title', true)) :
				echo '<div class="harika-ba-archive-title-widget archive-description">';
				echo '<p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد. کتابهای زیادی در شصت و سه درصد گذشته، حال و آینده شناخت فراوان جامعه و متخصصان را می طلبد تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی و فرهنگ پیشرو در زبان فارسی ایجاد کرد. در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها و شرایط سخت تایپ به پایان رسد وزمان مورد نیاز شامل حروفچینی دستاوردهای اصلی و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</p>';
				echo '<p>در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها و شرایط سخت تایپ به پایان رسد وزمان مورد نیاز شامل حروفچینی دستاوردهای اصلی و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</p>';
				echo '</div>';

			endif;;
		else:


			$this->template();


		endif;
	}


	protected function content_template() {}
}
