<?php

namespace Custom_Css_FEle\Inc;

// If this file is called directly, abort.
defined('ABSPATH') || exit;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Core\DynamicTags\Dynamic_CSS;
use Elementor\Plugin as Elementor_Plugin;

use Wikimedia\CSS\Parser\Parser;
use Wikimedia\CSS\Sanitizer\StylesheetSanitizer;
use Wikimedia\CSS\Util;

class Hook_Action {

    /**
     * @var Singleton The reference the *Singleton* instance of this class
     */
    public static $instance;

    /**
     * this class initialize function
     *
     * @return void
     */
    public function init() {
        add_action('elementor/element/common/_section_responsive/after_section_end', [$this, 'register_controls'], 10, 2);
        add_action('elementor/element/section/_section_responsive/after_section_end', [$this, 'register_controls'], 10, 2);
        add_action('elementor/element/column/_section_responsive/after_section_end', [$this, 'register_controls'], 10, 2);

        add_action('elementor/element/container/_section_responsive/after_section_end', [$this, 'register_controls'], 10, 2);

        add_action('elementor/element/parse_css', [$this, 'add_post_css'], 10, 2);
        add_action('elementor/css-file/post/parse', [$this, 'add_page_settings_css']);

        add_action('elementor/frontend/after_enqueue_scripts', [$this, 'add_custom_css_for_editor']);
    }

    /**
     * register controls to elementor widget function
     *
     * @param Controls_Stack $element
     * @param [type] $section_id
     * @return void
     */
    public function register_controls( $section ) {



        $section->start_controls_section(
            '_custom_css_f_ele',
            [
                'label' => esc_html__('CSS سفارشی', 'harika').'<span class="harika-label">هاریکا</span>',
                'tab' => Controls_Manager::TAB_ADVANCED,
            ]
        );


        $section->add_control(
            '_custom_css_f_ele_css_desktop',
            [
                'label' => esc_html__('CSS سفارشی', 'harika'),
                'type' => Controls_Manager::CODE,
                'language' => 'css',
                'render_type' => 'ui',
                'show_label' => false,
                'separator' => 'none',
            ]
        );

        $section->add_control(
            '_custom_css_f_ele_description',
            [
                'raw' => esc_html__('از "selector" برای هدف قرار دادن ورپر المان استفاده کنید.', 'harika'),
                'type' => Controls_Manager::RAW_HTML,
                'content_classes' => 'elementor-descriptor',
            ]
        );


        $section->end_controls_section();
    }

    /**
     * add custom css function to post function
     *
     * @param [type] $post_css
     * @param [type] $element
     * @return void
     */
    public function add_post_css($post_css, $element) {
        if ($post_css instanceof Dynamic_CSS) {
            return;
        }
    
        $element_settings = $element->get_settings();
    
        $sanitize_css = $this->parse_css_to_remove_injecting_code(
            $element_settings,
            $post_css->get_element_unique_selector($element)
        );
    
        // مطمئن شوید که null یا خالی ارسال نمی‌شود
        if (!empty($sanitize_css) && is_string($sanitize_css)) {
            $post_css->get_stylesheet()->add_raw_css($sanitize_css);
        }
    }
    

    /**
     * add custom css function to page function
     *
     * @param [type] $post_css
     * @return void
     */
    public function add_page_settings_css($post_css) {

        $document = Elementor_Plugin::instance()->documents->get($post_css->get_post_id());
    
        $element_settings = $document->get_settings();
    
        $sanitize_css = $this->parse_css_to_remove_injecting_code(
            $element_settings,
            $document->get_css_wrapper_selector()
        );
    
        // اطمینان از اینکه مقدار null یا خالی ارسال نمی‌شود
        if (!empty($sanitize_css) && is_string($sanitize_css)) {
            $post_css->get_stylesheet()->add_raw_css($sanitize_css);
        }
    }
    

    /**
     * validate css and sanitize css for avoiding injection of malicious code function
     *
     * @param [type] $raw_css
     * @return void
     */
    public function parse_css_to_remove_injecting_code($element_settings, $unique_selector) {

        if (empty($element_settings['_custom_css_f_ele_css_desktop'])) {
            return;
        }
    
        $custom_css_desktop = trim((string) ($element_settings['_custom_css_f_ele_css_desktop'] ?? ''));
    
        if (empty($custom_css_desktop)) {
            return;
        }
    
        $custom_css = str_replace('selector', $unique_selector, $custom_css_desktop);
    
        return $custom_css;
    }
    

    public function get_script_depends() {
        return ['editor-css-script'];
    }

    public function add_custom_css_for_editor() {
        wp_enqueue_script(
            'purify',
            get_template_directory_uri(). '/includes/elementor/custom-css-for-elementor/assets/js/purify.min.js',
            [],
            '3.0.6',
            true
        );

        wp_enqueue_script(
            'editor-css-script',
            get_template_directory_uri(). '/includes/elementor/custom-css-for-elementor/assets/js/editor-css-script.js',
            ['elementor-frontend', 'purify'],
            CUSTOM_CSS_FELE_VERSION,
            true
        );

        wp_localize_script(
            'editor-css-script',
            'modelData',
            array(
                'postID' => get_the_ID()
            )
        );
    }

    /**
     * Returns the *Singleton* instance of this class.
     *
     * @return Singleton The *Singleton* instance.
     */
    public static function instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
}
