<?php

namespace HarikaTheme\Classes;

defined('ABSPATH') || exit;

/**
 * Initial SVG ICONS functions for this theme.
 */
class Harika_svg {


    public static function icons() {
        return [
            'op-icon-dashboard'         => '<svg xmlns="http://www.w3.org/2000/svg" width="14px" height="21px" viewBox="0 -3 14 21" fill="none"><path d="M5.72222 0.777778V13.2222C5.72222 13.3756 5.59786 13.5 5.44444 13.5H0.777778C0.624366 13.5 0.5 13.3756 0.5 13.2222V0.777778C0.5 0.624365 0.624365 0.5 0.777778 0.5H5.44444C5.59786 0.5 5.72222 0.624365 5.72222 0.777778ZM13.2222 4.16667H8.55556C8.40214 4.16667 8.27778 4.0423 8.27778 3.88889V0.777778C8.27778 0.624365 8.40214 0.5 8.55556 0.5H13.2222C13.3756 0.5 13.5 0.624365 13.5 0.777778V3.88889C13.5 4.0423 13.3756 4.16667 13.2222 4.16667ZM13.2222 13.5H8.55556C8.40214 13.5 8.27778 13.3756 8.27778 13.2222V7C8.27778 6.84659 8.40214 6.72222 8.55556 6.72222H13.2222C13.3756 6.72222 13.5 6.84659 13.5 7V13.2222C13.5 13.3756 13.3756 13.5 13.2222 13.5Z" stroke="var(--harika-svg-color)"/></svg>',
            'op-icon-import'            => '<svg width="14px" height="21px" viewBox="0 0 14 21" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><g id="icon-import" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"> <path d="M12.4444444,4 C13.3035541,4 14,4.69644594 14,5.55555556 L14,16.4444444 C14,17.3035541 13.3035541,18 12.4444444,18 L1.55555556,18 C0.696445945,18 0,17.3035541 0,16.4444444 L0,5.55555556 C0,4.69644594 0.696445945,4 1.55555556,4 L12.4444444,4 Z M10.0255556,13.1230298 C10.1747203,12.9862928 10.1747203,12.7689854 10.0255556,12.6322484 L9.86222222,12.4870877 C9.789163,12.4245009 9.69147185,12.3897722 9.59,12.3903139 L8.55555556,12.3903139 L8.55555556,9.79124631 C8.55555556,9.60036527 8.38144407,9.44562561 8.16666667,9.44562561 L5.83333333,9.44562561 C5.61855593,9.44562561 5.44444444,9.60036527 5.44444444,9.79124631 L5.44444444,12.3903139 L4.41,12.3903139 C4.30852815,12.3897722 4.210837,12.4245009 4.13777778,12.4870877 L3.97444444,12.6322484 C3.82527966,12.7689854 3.82527966,12.9862928 3.97444444,13.1230298 L6.72777778,15.5631119 C6.79834815,15.6299392 6.89687763,15.6678478 7,15.6678478 C7.10312237,15.6678478 7.20165185,15.6299392 7.27222222,15.5631119 L10.0255556,13.1230298 Z M2.33333333,5.55555556 C1.90377853,5.55555556 1.55555556,5.90377853 1.55555556,6.33333333 C1.55555556,6.76288814 1.90377853,7.11111111 2.33333333,7.11111111 L11.6666667,7.11111111 C12.0962215,7.11111111 12.4444444,6.76288814 12.4444444,6.33333333 C12.4444444,5.90377853 12.0962215,5.55555556 11.6666667,5.55555556 L2.33333333,5.55555556 Z" id="Combined-Shape" fill="var(--harika-svg-color)" fill-rule="nonzero"></path> </g> </svg>',
            'op-icon-general'           => '<svg width="14px" height="21px" viewBox="0 0 14 21" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><g id="icon-general" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"> <g id="tune-copy" transform="translate(0.000000, 4.000000)" fill="var(--harika-svg-color)"> <path d="M1.55555556,12.4444444 L3.11111111,12.4444444 L3.11111111,13.6111111 C3.11111111,13.8258885 2.93699962,14 2.72222222,14 L1.94444444,14 C1.72966704,14 1.55555556,13.8258885 1.55555556,13.6111111 L1.55555556,12.4444444 Z M6.22222222,13.6111111 C6.22222222,13.8258885 6.39633371,14 6.61111111,14 L7.38888889,14 C7.60366629,14 7.77777778,13.8258885 7.77777778,13.6111111 L7.77777778,4.66666667 L6.22222222,4.66666667 L6.22222222,13.6111111 Z M10.8888889,13.6111111 C10.8888889,13.8258885 11.0630004,14 11.2777778,14 L12.0555556,14 C12.270333,14 12.4444444,13.8258885 12.4444444,13.6111111 L12.4444444,9.33333333 L10.8888889,9.33333333 L10.8888889,13.6111111 Z M4.27777778,9.33333333 L3.11111111,9.33333333 L3.11111111,0.388888889 C3.11111111,0.174111486 2.93699962,0 2.72222222,0 L1.94444444,0 C1.72966704,0 1.55555556,0.174111486 1.55555556,0.388888889 L1.55555556,9.33333333 L0.388888889,9.33333333 C0.174111486,9.33333333 0,9.50744482 0,9.72222222 L0,10.5 C0,10.7147774 0.174111486,10.8888889 0.388888889,10.8888889 L4.27777778,10.8888889 C4.49255518,10.8888889 4.66666667,10.7147774 4.66666667,10.5 L4.66666667,9.72222222 C4.66666667,9.50744482 4.49255518,9.33333333 4.27777778,9.33333333 Z M9.33333333,1.94444444 C9.33333333,1.72966704 9.15922185,1.55555556 8.94444444,1.55555556 L7.77777778,1.55555556 L7.77777778,0.388888889 C7.77777778,0.174111486 7.60366629,0 7.38888889,0 L6.61111111,0 C6.39633371,0 6.22222222,0.174111486 6.22222222,0.388888889 L6.22222222,1.55555556 L5.05555556,1.55555556 C4.84077815,1.55555556 4.66666667,1.72966704 4.66666667,1.94444444 L4.66666667,2.72222222 C4.66666667,2.93699962 4.84077815,3.11111111 5.05555556,3.11111111 L8.94444444,3.11111111 C9.15922185,3.11111111 9.33333333,2.93699962 9.33333333,2.72222222 L9.33333333,1.94444444 Z M13.6111111,6.22222222 L12.4444444,6.22222222 L12.4444444,0.388888889 C12.4444444,0.174111486 12.270333,0 12.0555556,0 L11.2777778,0 C11.0630004,0 10.8888889,0.174111486 10.8888889,0.388888889 L10.8888889,6.22222222 L9.72222222,6.22222222 C9.50744482,6.22222222 9.33333333,6.39633371 9.33333333,6.61111111 L9.33333333,7.38888889 C9.33333333,7.60366629 9.50744482,7.77777778 9.72222222,7.77777778 L13.6111111,7.77777778 C13.8258885,7.77777778 14,7.60366629 14,7.38888889 L14,6.61111111 C14,6.39633371 13.8258885,6.22222222 13.6111111,6.22222222 Z" id="Icon-color" fill-rule="nonzero"></path> <path d="M1.55555556,12.4444444 L3.11111111,12.4444444 L3.11111111,13.6111111 C3.11111111,13.8258885 2.93699962,14 2.72222222,14 L1.94444444,14 C1.72966704,14 1.55555556,13.8258885 1.55555556,13.6111111 L1.55555556,12.4444444 Z" id="Path"></path> <path d="M6.22222222,13.6111111 C6.22222222,13.8258885 6.39633371,14 6.61111111,14 L7.38888889,14 C7.60366629,14 7.77777778,13.8258885 7.77777778,13.6111111 L7.77777778,4.66666667 L6.22222222,4.66666667 L6.22222222,13.6111111 Z" id="Path"></path> <path d="M10.8888889,13.6111111 C10.8888889,13.8258885 11.0630004,14 11.2777778,14 L12.0555556,14 C12.270333,14 12.4444444,13.8258885 12.4444444,13.6111111 L12.4444444,9.33333333 L10.8888889,9.33333333 L10.8888889,13.6111111 Z" id="Path"></path> </g> </g> </svg>',
            'op-icon-blog'              => '<svg width="14px" height="21px" viewBox="0 0 14 21" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><g id="icon-blog" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"> <path d="M12.6,4 L1.4,4 C0.62680135,4 0,4.62680135 0,5.4 L0,16.6 C0,17.3731986 0.62680135,18 1.4,18 L12.6,18 C13.3731986,18 14,17.3731986 14,16.6 L14,5.4 C14,4.62680135 13.3731986,4 12.6,4 Z M12.6,16.6 L1.4,16.6 L1.4,6.8 L12.6,6.8 L12.6,16.6 Z M3.15,12.4 L5.95,12.4 C6.14329966,12.4 6.3,12.2432997 6.3,12.05 L6.3,8.55 C6.3,8.35670034 6.14329966,8.2 5.95,8.2 L3.15,8.2 C2.95670034,8.2 2.8,8.35670034 2.8,8.55 L2.8,12.05 C2.8,12.2432997 2.95670034,12.4 3.15,12.4 Z M8.05,9.6 L10.85,9.6 C11.0432997,9.6 11.2,9.44329966 11.2,9.25 L11.2,8.55 C11.2,8.35670034 11.0432997,8.2 10.85,8.2 L8.05,8.2 C7.85670034,8.2 7.7,8.35670034 7.7,8.55 L7.7,9.25 C7.7,9.44329966 7.85670034,9.6 8.05,9.6 Z M8.05,12.4 L9.45,12.4 C9.64329966,12.4 9.8,12.2432997 9.8,12.05 L9.8,11.35 C9.8,11.1567003 9.64329966,11 9.45,11 L8.05,11 C7.85670034,11 7.7,11.1567003 7.7,11.35 L7.7,12.05 C7.7,12.2432997 7.85670034,12.4 8.05,12.4 Z" id="Icon-color" fill="var(--harika-svg-color)" fill-rule="nonzero"></path> </g> </svg>',
            'op-icon-color'             => '<svg xmlns:xlink="http://www.w3.org/1999/xlink" width="14" height="21" viewBox="0 0 14 21"> <defs> <path id="a" d="M12.2 13.3c.1 0 .2 0 .2.1.6.6 1.6 1.7 1.6 2.4 0 1-.8 1.8-1.8 1.8s-1.8-.8-1.8-1.8c0-.7 1-1.8 1.6-2.4.1-.1.2-.1.2-.1zM6.3 6.1l4.3 4.4H1.9l4.4-4.4zM0 10.9v1.2c0 .3.1.5.3.7l4.3 4.3c.2.2.5.3.7.3h.5c.3 0 .5-.1.7-.3l5.8-5.8c.3-.3.3-.7 0-1L5.7 3.6c0-.1-.1-.1-.2-.1s-.2 0-.2.1l-.6.5c-.1.1-.1.4 0 .5l.6.6-5 5c-.2.1-.3.4-.3.7z"></path> </defs> <use xlink:href="#a" overflow="visible" fill="var(--harika-svg-color)"></use> <clipPath id="b"> <use xlink:href="#a" overflow="visible"></use> </clipPath> <g clip-path="url(#b)"> <defs> <path id="c" d="M-249.2-1022.7h1120V700.7h-1120z"></path> </defs> <use xlink:href="#c" overflow="visible" fill="var(--harika-svg-color)"></use> <clipPath id="d"> <use xlink:href="#c" overflow="visible"></use> </clipPath> <path clip-path="url(#d)" fill="var(--harika-svg-color)" d="M-3.5 0h21v21h-21z"></path> </g> </svg>',
            'op-icon-custom'            => '<svg width="14px" height="21px" viewBox="0 0 14 21" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><g id="icon-custom" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"> <g id="code-copy" transform="translate(0.000000, 5.000000)" fill="var(--harika-svg-color)" fill-rule="nonzero"> <path d="M14,5.47443191 L14,5.7398542 C13.9983872,5.87844244 13.9432188,6.01105951 13.846,6.11004844 L10.948,8.99476965 C10.8822817,9.06088517 10.7928231,9.09807421 10.6995,9.09807421 C10.6061769,9.09807421 10.5167183,9.06088517 10.451,8.99476965 L9.954,8.49884905 C9.88815515,8.43447466 9.85104999,8.34636373 9.85104999,8.25438115 C9.85104999,8.16239857 9.88815515,8.07428765 9.954,8.00991326 L12.369,5.60714305 L9.954,3.20437285 C9.88774057,3.13879727 9.85047059,3.04953301 9.85047059,2.95641255 C9.85047059,2.8632921 9.88774057,2.77402784 9.954,2.70845226 L10.451,2.21951646 C10.5167183,2.15340094 10.6061769,2.1162119 10.6995,2.1162119 C10.7928231,2.1162119 10.8822817,2.15340094 10.948,2.21951646 L13.846,5.10423766 C13.9444847,5.20238619 13.9998775,5.33554247 14,5.47443191 L14,5.47443191 Z M1.631,5.60714305 L4.039,3.20437285 C4.10484485,3.13999846 4.14195001,3.05188753 4.14195001,2.95990495 C4.14195001,2.86792237 4.10484485,2.77981145 4.039,2.71543705 L3.542,2.21951646 C3.47628169,2.15340094 3.38682314,2.1162119 3.2935,2.1162119 C3.20017686,2.1162119 3.11071831,2.15340094 3.045,2.21951646 L0.154,5.10423766 C0.0567812159,5.20322659 0.00161280384,5.33584366 0,5.47443191 L0,5.7398542 C0.000122536428,5.87874364 0.0555152588,6.01189992 0.154,6.11004844 L3.052,8.99476965 C3.11771831,9.06088517 3.20717686,9.09807421 3.3005,9.09807421 C3.39382314,9.09807421 3.48328169,9.06088517 3.549,8.99476965 L4.046,8.50583385 C4.11225943,8.44025827 4.14952941,8.35099401 4.14952941,8.25787355 C4.14952941,8.1647531 4.11225943,8.07548884 4.046,8.00991326 L1.631,5.60714305 Z M9.331,0.277742866 L8.652,0.019305373 C8.46861955,-0.0427197973 8.26867128,0.0493635944 8.197,0.228849286 L4.48,10.496501 C4.41436167,10.6778043 4.50835471,10.8778872 4.69,10.943528 L5.348,11.1810111 C5.52949354,11.2424875 5.72725096,11.1499901 5.796,10.9714672 L9.513,0.717785083 C9.57409885,0.538554582 9.48095816,0.343383931 9.303,0.277742866 L9.331,0.277742866 Z" id="Icon-color"></path> </g> </g> </svg>',
            'op-icon-maintenance'       => '<svg xmlns="http://www.w3.org/2000/svg" width="18px" height="18px" viewBox="0 0 18 18" fill="none"><mask id="mask0_1385_467" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="20" height="20"><rect width="20" height="20" fill="#D9D9D9"/></mask><g mask="url(#mask0_1385_467)"><path d="M12.4326 9.30578H7.56763C7.06596 9.30578 6.68098 9.10745 6.50598 8.76912C6.33098 8.42495 6.40096 7.99912 6.69263 7.59662L9.12514 4.18995C9.55681 3.57162 10.4493 3.57162 10.8868 4.19579L13.3193 7.59662C13.611 7.99912 13.681 8.42495 13.506 8.76912C13.3193 9.10745 12.9343 9.30578 12.4326 9.30578ZM10.0001 4.57495C9.94764 4.57495 9.88931 4.62162 9.83681 4.69162L7.4043 8.10412C7.28763 8.26162 7.28181 8.35495 7.28764 8.37245C7.29348 8.38412 7.37514 8.43078 7.57347 8.43078H12.4385C12.631 8.43078 12.7126 8.37828 12.7243 8.36662C12.7243 8.35495 12.7185 8.26162 12.6076 8.10412L10.1751 4.69745C10.111 4.61579 10.0526 4.57495 10.0001 4.57495Z" fill="var(--harika-svg-color)"/><path d="M13.2609 13.9375H6.7451C5.91093 13.9375 5.57842 13.535 5.45592 13.2958C5.33342 13.0566 5.20509 12.555 5.69509 11.8783L8.02258 8.61162C8.10425 8.49496 8.23842 8.43079 8.37842 8.43079H11.6276C11.7676 8.43079 11.9018 8.50079 11.9834 8.61162L14.3109 11.8841C14.8009 12.555 14.6668 13.0566 14.5443 13.2958C14.4218 13.535 14.0951 13.9375 13.2609 13.9375ZM8.60009 9.30579L6.40091 12.3916C6.21425 12.6483 6.19676 12.8233 6.23176 12.8991C6.27259 12.975 6.42426 13.0625 6.73926 13.0625H13.2551C13.5701 13.0625 13.7276 12.975 13.7626 12.8991C13.8034 12.8233 13.7801 12.6483 13.5934 12.3916L11.3943 9.29996H8.60009V9.30579Z" fill="var(--harika-svg-color)"/><path d="M10 16.2708C9.76083 16.2708 9.5625 16.0725 9.5625 15.8333V13.5C9.5625 13.2608 9.76083 13.0625 10 13.0625C10.2392 13.0625 10.4375 13.2608 10.4375 13.5V15.8333C10.4375 16.0725 10.2392 16.2708 10 16.2708Z" fill="var(--harika-svg-color)"/></g></svg>',
            'op-icon-404'               => '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none"><mask id="mask0_1373_472" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="20" height="20"><rect width="20" height="20" fill="var(--harika-svg-color)"/></mask><g mask="url(#mask0_1373_472)"><path d="M9.99861 11.4C9.73184 11.4 9.51062 11.1788 9.51062 10.912V7.65877C9.51062 7.392 9.73184 7.17078 9.99861 7.17078C10.2654 7.17078 10.4866 7.392 10.4866 7.65877V10.912C10.4866 11.1788 10.2654 11.4 9.99861 11.4Z" fill="var(--harika-svg-color)"/><path d="M9.99868 13.5146C9.95964 13.5146 9.91409 13.5081 9.86855 13.5016C9.82951 13.4951 9.79047 13.4821 9.75143 13.4626C9.71239 13.4495 9.67335 13.43 9.63431 13.404C9.60178 13.378 9.56925 13.3519 9.53671 13.3259C9.41959 13.2023 9.34802 13.0331 9.34802 12.864C9.34802 12.6948 9.41959 12.5256 9.53671 12.402C9.56925 12.376 9.60178 12.3499 9.63431 12.3239C9.67335 12.2979 9.71239 12.2784 9.75143 12.2653C9.79047 12.2458 9.82951 12.2328 9.86855 12.2263C9.95313 12.2068 10.0442 12.2068 10.1223 12.2263C10.1678 12.2328 10.2069 12.2458 10.2459 12.2653C10.285 12.2784 10.324 12.2979 10.363 12.3239C10.3956 12.3499 10.4281 12.376 10.4606 12.402C10.5778 12.5256 10.6493 12.6948 10.6493 12.864C10.6493 13.0331 10.5778 13.2023 10.4606 13.3259C10.4281 13.3519 10.3956 13.378 10.363 13.404C10.324 13.43 10.285 13.4495 10.2459 13.4626C10.2069 13.4821 10.1678 13.4951 10.1223 13.5016C10.0833 13.5081 10.0377 13.5146 9.99868 13.5146Z" fill="var(--harika-svg-color)"/><path d="M13.9416 16.2213H6.05569C4.78691 16.2213 3.81743 15.7593 3.32294 14.9265C2.83494 14.0937 2.90001 13.0201 3.51813 11.9075L7.4611 4.81533C8.11176 3.64415 9.00966 3 9.99865 3C10.9877 3 11.8856 3.64415 12.5362 4.81533L16.4792 11.914C17.0973 13.0266 17.1689 14.0937 16.6744 14.933C16.1799 15.7593 15.2104 16.2213 13.9416 16.2213ZM9.99865 3.97598C9.38704 3.97598 8.78844 4.44445 8.31346 5.29031L4.377 12.3889C3.93455 13.1827 3.86298 13.9115 4.16879 14.4385C4.47459 14.9655 5.15128 15.2518 6.06219 15.2518H13.9481C14.859 15.2518 15.5292 14.9655 15.8415 14.4385C16.1538 13.9115 16.0758 13.1893 15.6333 12.3889L11.6839 5.29031C11.2089 4.44445 10.6103 3.97598 9.99865 3.97598Z" fill="var(--harika-svg-color)"/></g></svg>',
            'op-icon-backup'            => '<svg fill="none" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><mask id="a" x="0" y="0" width="20" height="20" style="mask-type:alpha" maskUnits="userSpaceOnUse"><rect width="20" height="20" fill="#D9D9D9"/></mask><g fill="var(--harika-svg-color)" mask="url(#a)"><path d="m8.0067 16.167c-0.12667 0-0.25334-0.0467-0.35334-0.1467l-3.34-3.34c-0.19333-0.1933-0.19333-0.5133 0-0.7066 0.19334-0.1934 0.51334-0.1934 0.70667 0l3.34 3.34c0.19334 0.1933 0.19334 0.5133 0 0.7066-0.1 0.0934-0.22666 0.1467-0.35333 0.1467z"/><path d="m8.0067 16.167c-0.27333 0-0.5-0.2267-0.5-0.5v-11.333c0-0.27333 0.22667-0.5 0.5-0.5 0.27334 0 0.5 0.22667 0.5 0.5v11.333c0 0.2733-0.22666 0.5-0.5 0.5z"/><path d="m15.34 8.1733c-0.1266 0-0.2533-0.04666-0.3533-0.14666l-3.34-3.34c-0.1933-0.19334-0.1933-0.51334 0-0.70667s0.5133-0.19333 0.7067 0l3.34 3.34c0.1933 0.19333 0.1933 0.51333 0 0.70667-0.1 0.1-0.2267 0.14666-0.3534 0.14666z"/><path d="m11.993 16.167c-0.2733 0-0.5-0.2267-0.5-0.5v-11.333c0-0.27333 0.2267-0.5 0.5-0.5s0.5 0.22667 0.5 0.5v11.333c0 0.2733-0.22 0.5-0.5 0.5z"/></g></svg>',
            'op-icon-elementor'         => '<svg class="elementor-svg-icon" xmlns="http://www.w3.org/2000/svg" width="42" height="42" viewBox="0 0 42 42" fill="none"><rect x="1" y="1" width="40" height="40" rx="20" stroke="var(--harika-svg-color)" stroke-width="2"/><rect x="12" y="12" width="3.375" height="18" fill="var(--harika-svg-color)"/><rect x="18.75" y="19.3125" width="11.25" height="3.375" fill="var(--harika-svg-color)"/><rect x="18.75" y="26.625" width="11.25" height="3.375" fill="var(--harika-svg-color)"/><rect x="18.75" y="12" width="11.25" height="3.375" fill="var(--harika-svg-color)"/></svg>',
            'search'                    => '<svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19" fill="none"><path d="M1 8.6087C1 11.8704 1.58736 13.6624 2.65066 14.6878C3.72256 15.7214 5.52412 16.2174 8.6087 16.2174C11.6933 16.2174 13.4948 15.7214 14.5667 14.6878C15.63 13.6624 16.2174 11.8704 16.2174 8.6087C16.2174 5.34704 15.63 3.55494 14.5667 2.52963C13.4948 1.49601 11.6933 1 8.6087 1C5.52412 1 3.72256 1.49601 2.65066 2.52963C1.58736 3.55494 1 5.34704 1 8.6087Z" stroke="var(--harika-svg-color)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path><path d="M17.2175 17.2174L15.261 15.2609" stroke="var(--harika-svg-color)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path></svg>',
            'back-to-top'               => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path d="M15.3699 12.32C15.3699 12.51 15.2999 12.7 15.1499 12.85C14.8599 13.14 14.3799 13.14 14.0899 12.85L12.0599 10.82L10.0299 12.85C9.73994 13.14 9.25994 13.14 8.96994 12.85C8.67994 12.56 8.67994 12.08 8.96994 11.79L11.5299 9.23C11.8199 8.94 12.2999 8.94 12.5899 9.23L15.1499 11.79C15.2999 11.93 15.3699 12.13 15.3699 12.32Z" fill="var(--harika-svg-color)"/><path d="M12.8101 9.83L12.8101 20C12.8101 20.41 12.4701 20.75 12.0601 20.75C11.6501 20.75 11.3101 20.41 11.3101 20L11.3101 9.83C11.3101 9.42 11.6501 9.08 12.0601 9.08C12.4701 9.08 12.8101 9.42 12.8101 9.83Z" fill="var(--harika-svg-color)"/><path d="M20.75 12C20.75 12.41 20.41 12.75 20 12.75C19.59 12.75 19.25 12.41 19.25 12C19.25 7.73 16.27 4.75 12 4.75C7.73 4.75 4.75 7.73 4.75 12C4.75 12.41 4.41 12.75 4 12.75C3.59 12.75 3.25 12.41 3.25 12C3.25 6.85 6.85 3.25 12 3.25C17.15 3.25 20.75 6.85 20.75 12Z" fill="var(--harika-svg-color)"/></svg>',
            'post-calender'             => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 15 17" fill="none"><path d="M3.7498 10.8462L5.6248 10.8462" stroke="var(--harika-svg-color)" stroke-linecap="round" stroke-linejoin="round"/><path d="M3.7498 13.3077L5.6248 13.3077" stroke="var(--harika-svg-color)" stroke-linecap="round" stroke-linejoin="round"/><path fill-rule="evenodd" clip-rule="evenodd" d="M4.9998 0.615387C5.55209 0.615387 5.9998 1.0631 5.9998 1.61539V2.26246C6.46483 2.24058 6.96406 2.23077 7.4998 2.23077C8.03555 2.23077 8.53478 2.24058 8.9998 2.26246V1.61539C8.9998 1.0631 9.44752 0.615387 9.9998 0.615387C10.5521 0.615387 10.9998 1.0631 10.9998 1.61539V2.47342C13.6095 2.95834 14.6199 4.26961 14.9064 7.26923C14.9218 7.43095 14.9351 7.59757 14.9465 7.76923C14.9572 7.93113 14.9662 8.09753 14.9736 8.26851C14.9916 8.68909 14.9998 9.13748 14.9998 9.61539C14.9998 10.0931 14.9916 10.5413 14.9736 10.9618C14.9662 11.1329 14.9573 11.2995 14.9465 11.4615C14.9352 11.6326 14.9219 11.7987 14.9065 11.9599C14.5822 15.3592 13.3289 16.5909 9.87331 16.9088C9.71199 16.9237 9.54586 16.9365 9.3748 16.9475C9.21264 16.958 9.04604 16.9667 8.8749 16.9739C8.44568 16.9919 7.98789 17 7.4998 17C1.32355 17 -0.000198364 15.6966 -0.000198364 9.61539C-0.000198364 9.13748 0.00797671 8.68909 0.0260401 8.26851C0.0333837 8.09753 0.042362 7.93113 0.0530894 7.76923C0.0644636 7.59757 0.0778045 7.43095 0.0932493 7.26923C0.379734 4.26961 1.39009 2.95834 3.9998 2.47342V1.61539C3.9998 1.0631 4.44752 0.615387 4.9998 0.615387ZM3.9998 3.49242C3.30329 3.63773 2.79472 3.84552 2.41364 4.12059C1.72515 4.61758 1.2818 5.47526 1.09814 7.26923H13.9015C13.7178 5.47526 13.2745 4.61758 12.586 4.12059C12.2049 3.84552 11.6963 3.63773 10.9998 3.49242V4.07693C10.9998 4.62921 10.5521 5.07693 9.9998 5.07693C9.44752 5.07693 8.9998 4.62921 8.9998 4.07693V3.2642C8.54724 3.24178 8.04897 3.23077 7.4998 3.23077C6.95063 3.23077 6.45236 3.24178 5.9998 3.2642V4.07693C5.9998 4.62921 5.55209 5.07693 4.9998 5.07693C4.44752 5.07693 3.9998 4.62921 3.9998 4.07693V3.49242ZM13.4362 11.9958C13.5998 11.9745 13.7565 11.9602 13.9025 11.951C13.7441 13.5079 13.3907 14.3573 12.8643 14.8756C12.3332 15.3985 11.4598 15.749 9.86508 15.9051C9.87442 15.7664 9.88861 15.6181 9.9094 15.4635C10.0201 14.6402 10.3085 13.7054 10.9756 13.0486C11.6439 12.3906 12.5967 12.1052 13.4362 11.9958ZM8.91832 15.3302C8.88743 15.56 8.86923 15.777 8.85935 15.9736C8.43991 15.9917 7.98771 16 7.4998 16C5.97817 16 4.82269 15.9185 3.93609 15.7244C3.06 15.5327 2.51029 15.2448 2.13531 14.8756C1.36477 14.1169 0.999802 12.6916 0.999802 9.61539C0.999802 9.13178 1.00838 8.68407 1.02697 8.26923H13.9726C13.9912 8.68407 13.9998 9.13178 13.9998 9.61539C13.9998 10.0928 13.9914 10.5352 13.9733 10.9456C13.7703 10.9551 13.5454 10.9731 13.307 11.0042C12.3763 11.1255 11.1682 11.4556 10.274 12.336C9.37858 13.2177 9.042 14.4104 8.91832 15.3302Z" fill="var(--harika-svg-color)"/></svg>',
            'post-view-more-arrow'      => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none"><path d="M8.29256 11.0811C8.46628 11.0811 8.63999 11.0171 8.77713 10.88C9.04228 10.6149 9.04228 10.176 8.77713 9.91085L6.92113 8.05485L8.77713 6.19885C9.04228 5.93371 9.04228 5.49485 8.77713 5.22971C8.51199 4.96457 8.07313 4.96457 7.80799 5.22971L5.46742 7.57028C5.20228 7.83542 5.20228 8.27428 5.46742 8.53942L7.80799 10.88C7.93599 11.0171 8.11885 11.0811 8.29256 11.0811Z" fill="var(--harika-svg-color)"/><path d="M6.016 8.74057L15.3143 8.74057C15.6891 8.74057 16 8.42971 16 8.05485C16 7.68 15.6891 7.36914 15.3143 7.36914L6.016 7.36914C5.64114 7.36914 5.33029 7.68 5.33029 8.05485C5.33029 8.42971 5.64114 8.74057 6.016 8.74057Z" fill="var(--harika-svg-color)"/><path d="M7.99995 16C8.3748 16 8.68566 15.6891 8.68566 15.3143C8.68566 14.9394 8.3748 14.6286 7.99995 14.6286C4.09595 14.6286 1.37138 11.904 1.37138 8C1.37138 4.096 4.09595 1.37143 7.99995 1.37143C8.3748 1.37143 8.68566 1.06057 8.68566 0.685714C8.68566 0.310857 8.3748 0 7.99995 0C3.29138 0 -5.34058e-05 3.29143 -5.34058e-05 8C-5.34058e-05 12.7086 3.29138 16 7.99995 16Z" fill="var(--harika-svg-color)"/></svg>',
            'post-comments'             => '<svg xmlns="http://www.w3.org/2000/svg" width="17" height="16" viewBox="0 0 17 16" fill="none"><path d="M8.06498 0.5C9.70492 0.5 10.992 0.574206 12.0046 0.768797C13.0147 0.962908 13.7145 1.27007 14.2126 1.70862C15.204 2.58147 15.5743 4.13469 15.5743 7.11112C15.5743 9.03335 15.403 10.4823 14.9188 11.4413C14.6837 11.907 14.3806 12.2447 13.9925 12.4707C13.6016 12.6984 13.0888 12.8333 12.4035 12.8333C11.5747 12.8333 10.9675 13.0188 10.4989 13.3359C10.0392 13.647 9.75898 14.0558 9.5411 14.3983C9.50871 14.4492 9.47803 14.4979 9.44864 14.5446C9.26581 14.8349 9.13292 15.0459 8.94873 15.211C8.76824 15.3728 8.52128 15.5 8.06515 15.5C7.60906 15.5 7.3621 15.3728 7.1816 15.211C6.99742 15.0459 6.86454 14.8349 6.68171 14.5446C6.65231 14.4979 6.62162 14.4492 6.58922 14.3982C6.37132 14.0558 6.09105 13.647 5.63139 13.3359C5.16278 13.0188 4.55562 12.8333 3.72678 12.8333C3.04406 12.8333 2.53245 12.6947 2.1416 12.4623C1.75281 12.2312 1.44824 11.8863 1.21205 11.4144C0.726602 10.4446 0.555695 8.99379 0.555695 7.11112C0.555695 4.17184 0.92521 2.61574 1.91894 1.73345C2.41807 1.29029 3.11862 0.977281 4.12778 0.778153C5.13962 0.578498 6.42608 0.5 8.06498 0.5Z" stroke="var(--harika-svg-color)" stroke-linecap="round" stroke-linejoin="round"/><path d="M8.73242 6H11.4022" stroke="var(--harika-svg-color)" stroke-linecap="round" stroke-linejoin="round"/><path d="M4.72778 8.66669H11.4022" stroke="var(--harika-svg-color)" stroke-linecap="round" stroke-linejoin="round"/></svg>',
            'sidebar5-t-icon'           => '<svg xmlns="http://www.w3.org/2000/svg" width="15" height="14" viewBox="0 0 15 14" fill="none"><path d="M14.4231 1.68182H0.576923C0.261538 1.68182 0 1.41394 0 1.09091C0 0.767879 0.261538 0.5 0.576923 0.5H14.4231C14.7385 0.5 15 0.767879 15 1.09091C15 1.41394 14.7385 1.68182 14.4231 1.68182Z" fill="var(--harika-svg-color)"/><path d="M7.86154 5.62127H0.576923C0.261538 5.62127 0 5.35339 0 5.03036C0 4.70733 0.261538 4.43945 0.576923 4.43945H7.86154C8.17692 4.43945 8.43846 4.70733 8.43846 5.03036C8.43846 5.35339 8.18462 5.62127 7.86154 5.62127Z" fill="var(--harika-svg-color)"/><path d="M14.4231 9.5606H0.576923C0.261538 9.5606 0 9.29272 0 8.96969C0 8.64666 0.261538 8.37878 0.576923 8.37878H14.4231C14.7385 8.37878 15 8.64666 15 8.96969C15 9.29272 14.7385 9.5606 14.4231 9.5606Z" fill="var(--harika-svg-color)"/><path d="M7.86154 13.5001H0.576923C0.261538 13.5001 0 13.2322 0 12.9091C0 12.5861 0.261538 12.3182 0.576923 12.3182H7.86154C8.17692 12.3182 8.43846 12.5861 8.43846 12.9091C8.43846 13.2322 8.18462 13.5001 7.86154 13.5001Z" fill="var(--harika-svg-color)"/></svg>',
            'fire-flame-icon'            => '<svg xmlns="http://www.w3.org/2000/svg" width="12" height="16" viewBox="0 0 12 16" fill="none"><path d="M1.68438 5.81563C0.60625 6.89375 0 8.35625 0 9.88125V10.2406C0 13.4219 2.57812 16 5.75938 16H6.23125C9.41875 16 12 13.4187 12 10.2312C12 8.16562 11.1531 6.19375 9.65938 4.76875L7.21562 2.44375C6.91875 2.15937 6.75 1.76875 6.75 1.35625V0.665625C6.75 0.3 6.45 0 6.08437 0C5.875 0 5.67813 0.1 5.55 0.265625L4.94063 1.07812C4.49063 1.68125 4.21562 2.39687 4.15312 3.14687L4.125 3.48438C4.09688 3.8375 4.1125 4.1875 4.175 4.53125C4.2625 5.00938 4.43437 5.46563 4.6875 5.88438C4.70625 5.91875 4.72813 5.95 4.75 5.98438C4.8 6.0625 4.85625 6.14062 4.9125 6.21875L5.9125 7.55312C6.13125 7.84375 6.25 8.2 6.25 8.56563V9.00313C6.25 9.69375 5.69063 10.2531 5 10.2531C4.30937 10.2531 3.75 9.69375 3.75 9.00313V6.2625V5.8875C3.75 5.55 3.55937 5.25625 3.28125 5.10625C3.15625 5.04062 3.01562 5.00313 2.86562 5.00313C2.63125 5.00313 2.40625 5.09687 2.24062 5.2625L1.68438 5.81563ZM5.76562 1.64375C5.83125 2.22187 6.1 2.7625 6.525 3.16563L8.96875 5.49375C10.2656 6.72813 11 8.44062 11 10.2312C11 12.8656 8.86562 15 6.23125 15H5.75938C3.13125 15 1 12.8688 1 10.2406V9.88125C1 8.62188 1.5 7.4125 2.39062 6.52187L2.75 6.16563V9C2.75 10.2437 3.75625 11.25 5 11.25C6.24375 11.25 7.25 10.2437 7.25 9V8.5625C7.25 7.98125 7.0625 7.41562 6.7125 6.95L5.7125 5.61562C5.27188 5.02812 5.0625 4.3 5.12187 3.56562L5.15 3.22813C5.19688 2.66563 5.4 2.12813 5.74062 1.67813L5.76562 1.64375Z" fill="var(--harika-svg-color)"/></svg>',
            ''            => '',
        ];
    }

    public static function get_icon_svg($name) {
        if (isset($_SERVER['REQUEST_URI']) && strpos($_SERVER['REQUEST_URI'], 'wp-admin/customize.php') == false){
            return self::icons()[$name];
        }
    }

}




