<?php

namespace HarikaTheme\Classes;

defined('ABSPATH') || exit;

/**
 * Post Helper Function
 */
class Harika_Post_Helper
{

    /**
     * harika post list 1 element template for pagination ajax request
     * @since 4.2
     */
    public static function harika_post_list_1($settings)
    {
        $has_thumb = ' no-thumb';
        if (has_post_thumbnail()) {
            $has_thumb = '';
        }

        $cat_show = 'no-cat';
        if ($settings['show_categories'] === 'yes') {
            $cat_show = 'cat-show';
        }
?>
        <div class="article<?php echo $has_thumb; ?>">

            <?php if (has_post_thumbnail()): ?>
                <a class="featured-image" href="<?php the_permalink(); ?>" target="_top">

                    <?php if ('yes' === $settings['show_post_type_icon']) : ?>
                        <?php if (has_post_format('video')) : ?>
                            <span class="post-format-icon post-is-video"><?php echo post_is_video_svg(); ?></span>
                        <?php endif; ?>

                        <?php if (has_post_format('audio')) : ?>
                            <span class="post-format-icon post-is-audio"><?php echo post_is_audio_svg(); ?></span>
                    <?php endif;
                    endif; ?>

                    <?php the_post_thumbnail($settings['image_size']); ?>

                </a>
            <?php endif; ?>


            <div class="content <?php echo $cat_show; ?>">
                <h3 class="title"><a href="<?php the_permalink(); ?>" target="_top"><?php the_title(); ?></a></h3>


                <?php if ($settings['show_excerpt'] === 'yes') : ?>
                    <div class="excerpt">
                        <?php echo '<p>' . wp_trim_words(get_the_excerpt(), $settings['excerpt_length']) . '</p>'; ?>
                    </div>
                <?php endif; ?>



                <div class="meta">
                    <div class="right">
                        <?php if ($settings['show_categories'] === 'yes') : ?>
                            <div class="categories harika-exc-cat-color">
                                <?php echo Harika_Helper::harika_get_category(); ?>
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="left">
                        <?php if ($settings['show_date'] === 'yes') : ?>
                            <span class="date"><i class="date-icon"></i>
                                <?php if ($settings['date_type'] === 'published') {
                                    echo get_the_date($settings['date_format']);
                                } else if ($settings['date_type'] === 'modified') {
                                    echo get_the_modified_date($settings['date_format']);
                                }
                                ?>
                            </span>
                        <?php endif; ?>

                        <?php if ($settings['show_comments_count'] === 'yes') : ?>
                            <span class="comments-count"><i class="comments-icon"></i>
                                <?php
                                $comments_number = get_comments_number();
                                printf(
                                    esc_html( /* translators: 1: number of comments */
                                        _nx(
                                            __('1 دیدگاه', 'harika'),
                                            __('%1$s دیدگاه', 'harika'),
                                            $comments_number,
                                            'comments title'
                                        )
                                    ),
                                    esc_html(number_format_i18n($comments_number))
                                );

                                ?>

                            </span>
                        <?php endif; ?>
                        <?php if ($settings['views_show'] === 'yes') : ?>
                            <span class="views harika-global-views"><?php echo Harika_svg::get_icon_svg('fire-flame-icon'); ?>
                                <?php
                                $comments_number = get_comments_number();

                                echo get_post_views(get_the_ID());
                                ?>

                            </span>
                        <?php endif; ?>
                    </div>

                </div>

            </div>
        </div>
<?php
    }
}
