<?php
/**
 * Template Welcome
 *
 * Welcome Template for admin panel
 *
 * @package Harika
 */

$allowed_html = [
    'a' => [
        'href'   => true,
        'target' => true,
    ],
];

?>

<div class="harika-dashboard-pages harika-welcome-page">
	<div class="harika-welcome-wrapper">
		<div class="wrapper-left">
			<div class="theme-screenshot">
				<img src="<?php echo esc_url( get_template_directory_uri() . "/screenshot.png" ); ?>">
			</div>
		</div>
		<div class="wrapper-right">
			<div class="harika-welcome-title">
				<h3>
					<?php esc_html_e( 'به', 'harika' );?>
					<?php echo esc_html( wp_get_theme()->get( 'Name' ) ); ?>
					<?php esc_html_e( 'خوش آمدید!', 'harika' );?>

					<span class="version-theme">
						<?php esc_html_e( 'نسخه - ', 'harika' );?>
						<?php echo esc_html( wp_get_theme()->get( 'Version' ) ); ?>
					</span>
					<?php if ( is_child_theme() ) : ?>
					<span class="version-theme">
						<?php esc_html_e( 'نسخه قالب والد - ', 'harika' );?>
						<?php echo HARIKA_VERSION; ?>
					</span>
					<?php endif; ?>
				</h3>
				<p>
				قالب هاریکا یک پوسته خبری و وبلاگی ایرانی وردپرس است که بر پایه المنتور طراحی و کدنویسی شده است.<br>
مورد نیاز است که افزونه المنتور نصب و فعال باشد.<br>
برای بهینه سازی قالب هم می توانید از افزونه wp rocket استفاده کنید.<br>
و در نهایت بسیار خوشحالیم که قالب ما را برای راه اندازی وب سایت خود انتخاب کرده اید، اگر انتقاد یا پیشنهادی برای بهبودی قالب دارید، حتما با ما در میان بگذارید.<br>
همچنین اگر سوالی خارج از پشتیبانی داشتید هم راحت باشید و با ما در میان بگذارید، خوشحال میشیم که در راه اندازی هر چه بهتر سایتتون کمکتون کنیم. اردات!
				</p>
			</div>
		</div>
	</div>
</div>