<?php
/**
 * Template Requirements
 *
 * Requirements Template for admin panel
 *
 * @package Harika
 */

global $wpdb;
$php_requirements                = 7.0;
$memory_limit_requirements       = 134217728;
$max_upload_size                 = 134217728;
$max_execution_time_requirements = 600;
$max_input_time_requirements     = 600;
$max_input_vars_requirements     = 3000;
?>
<div class="harika-dashboard-pages harika-server-status-page">
	<div class="harika-server-status-boxes">
		<div class="status-box">
			<h4><?php esc_html_e( 'اطلاعات وردپرس', 'harika' ) ?>:</h4>
			<div class="status-lists">
				<div class="single-status">
					<div class="title"><?php esc_html_e( 'نشانی خانه', 'harika' );?>:</div>
					<div  class="content" style="direction: ltr; text-align: right;"><?php echo esc_html( home_url( '/' ) ); ?></div>
				</div>
				<div class="single-status">
					<div class="title"><?php esc_html_e( 'نشانی سایت', 'harika' );?>:</div>
					<div class="content" style="direction: ltr; text-align: right;"><?php echo esc_html( site_url( '/' ) ); ?></div>
				</div>
				<div class="single-status">
					<div class="title"><?php esc_html_e( 'نسخه', 'harika' );?>:</div>
					<div class="content"><?php echo esc_html( get_bloginfo( 'version' ) ); ?></div>
				</div>
				<div class="single-status">
					<div class="title"><?php esc_html_e( 'زبان', 'harika' );?>:</div>
					<div class="content"><?php echo get_locale(); ?></div>
				</div>
				<div class="single-status">
					<div class="title"><?php esc_html_e( 'محدودیت حافظه', 'harika' );?>:</div>
					<div  class="content">
						<?php if ( $memory_limit_requirements > $this->memory_limit() ): ?>
						<span class="message-info-error">
							<span class="dashicons dashicons-warning"></span>
							<?php
								echo esc_html( size_format( $this->memory_limit() ) );
								esc_html_e( ' - توصیه می کنیم حافظه را حداقل 128 مگابایت تنظیم کنید', 'harika' );
							?>
						</span>
						<p class="note">
							<a target="_blank" href="https://www.wpbeginner.com/wp-tutorials/fix-wordpress-memory-exhausted-error-increase-php-memory/">
								<?php esc_html_e( 'نحوه تغییر حافظه.', 'harika' );?>
							</a>
						</p>
						<?php else:
							echo esc_html( size_format( $this->memory_limit() ) );
						endif; ?>
					</div>
				</div>
				<div class="single-status">
					<div class="title"><?php echo esc_html( 'دیباگ وردپرس' );?></div>
					<div  class="content">
						<?php if ( defined( 'WP_DEBUG' ) and WP_DEBUG === true ): ?>
						<?php echo esc_html__( 'فعال است', 'harika' ); ?>
						<p class="note">
							<a target="_blank" href="https://wordpress.org/support/article/debugging-in-wordpress/">
								<?php echo esc_html__( ' نحوه غیرفعال سازی دیباگ وردپرس', 'harika' ); ?>
							</a>
						</p>
						<?php else: ?>
						<?php echo esc_html__( 'غیرفعال است', 'harika' ); ?>
						<?php endif;?>
					</div>
				</div>
			</div>
			<h5><?php esc_html_e( 'اطلاعات قالب', 'harika' ) ?>:</h5>
			<div class="status-lists">
				<div class="single-status">
					<div class="title"><?php esc_html_e( 'نام قالب', 'harika' );?>:</div>
					<div class="content"><?php echo esc_html( wp_get_theme()->get( 'Name' ) ); ?></div>
				</div>
				<div class="single-status">
					<div class="title"><?php esc_html_e( 'نسخه', 'harika' );?>:</div>
					<div class="content"><?php echo esc_html( wp_get_theme()->get( 'Version' ) ); ?></div>
				</div>
				<?php if( is_child_theme() ) : ?>
				<div class="single-status">
					<div class="title"><?php esc_html_e( 'نسخه قالب والد', 'harika' );?>:</div>
					<div class="content"><?php echo HARIKA_VERSION; ?></div>
				</div>
				<?php endif; ?>
				<div class="single-status">
					<div class="title"><?php esc_html_e( 'طراح قالب', 'harika' );?>:</div>
					<div class="content">
						<a href="<?php echo esc_url_raw( wp_get_theme()->get( 'AuthorURI' ) ) ?>" target="_blank">
							<?php echo esc_html( wp_get_theme()->get( 'Author' ) ); ?>
						</a>
					</div>
				</div>
			</div>
		</div>
		<div class="status-box">
			<h4><?php esc_html_e( 'اطلاعات سرور', 'harika' ) ?></h4>
			<div class="status-lists">
				<div class="single-status">
					<div class="title"><?php esc_html_e( 'نسخه PHP', 'harika' );?>:</div>
					<div  class="content">
						<?php if ( version_compare( phpversion(), $php_requirements, '<' ) ): ?>
						<span class="message-info-error">
							<span class="dashicons dashicons-warning"></span>
							<?php
								echo esc_html( phpversion() );
								esc_html_e( ' - ما حداقل نسخه PHP که توصیه می کنیم: ', 'harika' );
								echo esc_html( $php_requirements );
							?>
						</span>
						<?php else:
							echo esc_html( phpversion() );
						endif;?>
					</div>
				</div>
				<div class="single-status">
					<div class="title"><?php esc_html_e( 'حداکثر اندازه ارسال', 'harika' );?>:</div>
					<div class="content">
						<?php echo esc_html( size_format( $this->let_to_num(  ( ini_get( 'post_max_size' ) ) ) ) ) ?>
						<p class="note">
							<?php esc_html_e( 'شما نمی توانید تصاویر، قالب ها و افزونه هایی را که اندازه آنها بزرگتر از این مقدار است آپلود کنید.', 'harika' ); ?>
							<a target="_blank" href="http://www.wpbeginner.com/wp-tutorials/how-to-increase-the-maximum-file-upload-size-in-wordpress/">
								<?php esc_html_e( 'نحوه تغییر این مقدار را در این مقاله مطاله کنید', 'harika' );?>
							</a>
						</p>
					</div>
				</div>
				<div class="single-status">
					<div class="title"><?php esc_html_e( 'حداکثر زمان اجرا', 'harika' );?>:</div>
					<div class="content">
						<?php if ( $max_execution_time_requirements > ini_get( 'max_execution_time' ) ): ?>
						<span class="message-info-error">
							<span class="dashicons dashicons-warning"></span>
							<?php
								echo esc_html( ini_get( 'max_execution_time' ) );
								esc_html_e( ' - حداقل حداکثر زمان اجرا که ما توصیه می کنیم: ', 'harika' );
								echo esc_html( $max_execution_time_requirements );
							?>
						</span>
						<p class="note">
							<a target="_blank" href="https://code.tutsplus.com/tutorials/how-to-increase-max_execution_time-in-php--cms-37017">
								<?php echo esc_html__( 'نحوه تغییر این مقدار را در این مقاله مطاله کنید', 'harika' ); ?>
							</a>
						</p>
						<?php else:
							echo esc_html( ini_get( 'max_execution_time' ) );
						endif; ?>
					</div>
				</div>
				<div class="single-status">
					<div class="title"><?php esc_html_e( 'حداکثر زمان ورودی PHP', 'harika' );?>:</div>
					<div class="content">
						<?php if ( $max_input_time_requirements > ini_get( 'max_input_time' ) ): ?>
						<span class="message-info-error">
							<span class="dashicons dashicons-warning"></span>
							<?php
								echo esc_html( ini_get( 'max_input_time' ) );
								esc_html_e( ' - حداقل حداکثر زمان ورودی PHP که ما توصیه می کنیم: ', 'harika' );
								echo esc_html( $max_input_time_requirements );
							?>
						</span>
						<p class="note">
							<a target="_blank" href="http://www.wpbeginner.com/wp-tutorials/how-to-increase-the-maximum-file-upload-size-in-wordpress/">
								<?php echo esc_html__( 'نحوه تغییر این مقدار را در این مقاله مطاله کنید', 'harika' ); ?>
							</a>
						</p>
						<?php else:
							echo esc_html( ini_get( 'max_input_time' ) );
						endif; ?>
					</div>
				</div>
				<div class="single-status">
					<div class="title"><?php esc_html_e( 'حداکثر متغیر های ورودی PHP', 'harika' );?>:</div>
					<div class="content">
						<?php if ( $max_input_vars_requirements > ini_get( 'max_input_vars' ) ): ?>
						<span class="message-info-error">
							<span class="dashicons dashicons-warning"></span>
							<?php
								echo esc_html( ini_get( 'max_input_vars' ) );
								esc_html_e( ' - حداقل حداکثر متغیر های ورودی PHP که ما توصیه می کنیم: ', 'harika' );
								echo esc_html( $max_input_vars_requirements );
							?>
						</span>
						<p class="note">
							<a target="_blank" href="http://www.wpbeginner.com/wp-tutorials/how-to-increase-the-maximum-file-upload-size-in-wordpress/">
								<?php echo esc_html__( 'نحوه تغییر این مقدار را در این مقاله مطاله کنید', 'harika' ); ?>
							</a>
						</p>
						<?php else:
							echo esc_html( ini_get( 'max_input_vars' ) );
						endif; ?>
					</div>
				</div>
				<div class="single-status">
					<div class="title"><?php esc_html_e( 'نسخه MySql', 'harika' );?>:</div>
					<div class="content"><?php echo ( ! empty( $wpdb->is_mysql ) ? $wpdb->db_version() : '' ); ?></div>
				</div>
				<div class="single-status">
					<div class="title"><?php esc_html_e( 'حداکثر اندازه آپلود', 'harika' );?>:</div>
					<div class="content">
						<?php if ( $max_upload_size > wp_max_upload_size() ): ?>
						<span class="message-info-error">
							<span class="dashicons dashicons-warning"></span>
							<?php
								echo esc_html( size_format( wp_max_upload_size() ) );
								esc_html_e( ' - حداقل مقدار توصیه شده: 128 MB.', 'harika' );
							?>
						</span>
						<p class="note">
							<a target="_blank" href="http://www.wpbeginner.com/wp-tutorials/how-to-increase-the-maximum-file-upload-size-in-wordpress/">
								<?php esc_html_e( 'نحوه تغییر این مقدار را در این مقاله مطاله کنید', 'harika' );?>
							</a>
						</p>
						<?php else:
							echo esc_html( size_format( wp_max_upload_size() ) );
						endif;?>
					</div>
				</div>
				<div class="single-status">
					<div class="title"><?php esc_html_e( 'XML ساده', 'harika' );?>:</div>
					<div class="content">
						<?php if ( ! extension_loaded( 'simplexml' ) ): ?>
						<span class="message-info-error">
							<?php esc_html_e( 'برای اطمینان از نصب موفقیت آمیز محتوای دمو، پسوند SimpleXML باید بر روی سرور وب شما نصب شود. لطفاً برای نصب و فعال سازی افزونه SimpleXML با ارائه دهنده هاست خود تماس بگیرید.', 'harika' ) ?>
						</span>
						<?php else:
							echo esc_html__( 'فعال است', 'harika' );
						endif;?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>