<?php
namespace HarikaTheme\Admin;

defined( 'ABSPATH' ) || exit;

/**
 * Load Theme Admin
 */
class Harika_Admin_Panel {

    protected static $instance = null;

    public static function instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function initialize() {
        add_action( 'admin_menu', [$this, 'theme_dashboard_menu'] );
        add_action( 'admin_init', [$this, 'redirect_theme_dashboard'] );
    }

    /**
     * Add Dashboard Menu
     *
     * @return void
     */
    public function theme_dashboard_menu() {
        add_menu_page(
            HARIKA_NAME,
            HARIKA_NAME,
            'manage_options',
            'harika_dashboard',
            [$this, 'render_welcome_template'],
            HARIKA_ASSETS . '/img/harika-fav.svg',
            2
        );

        $submenu = [];

        $submenu[] = [
            esc_html__( 'خوش آمدید', 'harika' ),
            esc_html__( 'خوش آمدید', 'harika' ),
            'manage_options',
            'harika_dashboard',
            [$this, 'render_welcome_template'],
        ];

		$submenu[] = [
            esc_html__( 'وضعیت سرور', 'harika' ),
            esc_html__( 'وضعیت سرور', 'harika' ),
            'edit_posts',
            'harika_server_status',
            [$this, 'render_server_status'],
        ];

        $submenu[] = [
            esc_html__( 'مرکز راهنمایی', 'harika' ),
            esc_html__( 'مرکز راهنمایی', 'harika' ),
            'edit_posts',
            'harika_help_center',
            [$this, 'render_help_center'],
        ];

        $submenu = apply_filters( 'harika_dashboard_submenu', [$submenu] );

        foreach ( $submenu[0] as $key => $value ) {
            add_submenu_page(
                'harika_dashboard',
                $value[0],
                $value[1],
                $value[2],
                $value[3],
                $value[4]
            );
        }
    }

    /**
     * Render Heading
     *
     * @return void
     */
    public static function render_heading() {
        global $submenu;

        $menu_items = '';

        if ( isset( $submenu['harika_dashboard'] ) ) {
            $menu_items = $submenu['harika_dashboard'];
        }

        if ( ! empty( $menu_items ) ): ?>
        <div class="wrap harika-dashboard-header">
			<div class="harika-dashboard-banner">
				<h3><?php echo esc_html__( 'به قالب', 'harika' ) . ' ' . HARIKA_NAME. ' <span>'.HARIKA_VERSION.'</span>' . ' ' . esc_html__( 'خوش آمدید!', 'harika' ) ?></h3>
				<p>
					<?php echo sprintf(
						wp_kses( __( 'یک قالب وردپرسی که توسط <a href="%s" target="_blank">حمید اسلامی</a> طراحی و توسعه داده شده است', 'harika' ), ['a' => ['href' => true, 'target' => true]] ),
						esc_url( 'https://www.rtl-theme.com/author/web-developer/products/' )
					); ?>
				</p>
			</div>
            <div class="dashboard-nav-wrapper">
                <?php foreach ( $menu_items as $item ):
                    $class = isset( $_GET['page'] ) && $_GET['page'] == $item[2] ? 'nav-tab-active' : ''; ?>
                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=' . $item[2] . '' ) ); ?>" class="nav-tab <?php echo esc_attr( $class ); ?>">
                        <?php echo esc_html($item[0]); ?>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif;
    }

    /**
     * Render Welcome Template
     *
     * @return void
     */
    public function render_welcome_template() {
		self::render_heading();

        require_once HARIKA_ADMIN . '/templates/welcome.php';
    }

	/**
     * Render Theme Requirements
     *
     * @return void
     */
    public function render_server_status() {
        self::render_heading();

        require_once HARIKA_ADMIN . '/templates/server-status.php';
    }

    /**
     * Render Help Template
     *
     * @return void
     */
    public function render_help_center() {
        $this->render_heading();

        require_once HARIKA_ADMIN . '/templates/help-center.php';
    }

    /**
     * Redirect To Theme Dashboard
     *
     * @return void
     */
    public function redirect_theme_dashboard() {
        global $pagenow;

        if ( is_admin() && isset( $_GET['activated'] ) && 'themes.php' === $pagenow ) {
            wp_safe_redirect( esc_url( admin_url( 'admin.php?page=harika_dashboard' ) ) );

            exit;
        }
    }

	/**
	 * Let to Number
	 *
	 * @return void
	 */
    public function let_to_num( $v ) {
        $l   = substr( $v, -1 );
        $ret = substr( $v, 0, -1 );
        switch ( strtoupper( $l ) ) {
        case 'P':$ret *= 1024;
        case 'T':$ret *= 1024;
        case 'G':$ret *= 1024;
        case 'M':$ret *= 1024;
        case 'K':$ret *= 1024;
            break;
        }

        return $ret;
    }

	/**
	 * Memory Limit
	 *
	 * @return void
	 */
    public function memory_limit() {
        $limit = $this->let_to_num( WP_MEMORY_LIMIT );
        if ( function_exists( 'memory_get_usage' ) ) {
            $limit = max( $limit, $this->let_to_num( @ini_get( 'memory_limit' ) ) );
        }

        return $limit;
    }
}

Harika_Admin_Panel::instance()->initialize();