<?php
/**
 * The header for our theme
 *
 * @package Harika
 */
?>
<!DOCTYPE html>
<html <?php language_attributes();?>>
<head>
	<meta charset="<?php bloginfo( 'charset' );?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(harika_get_page_sidebar_title_layout());?>>



<?php wp_body_open();?>
<div id="harika-page" class="harika-body-content">
    <?php

        do_action( "harika_builder_before_main" );


        if( harika_get_page_header_id() == '0' || harika_get_page_header_id() == '' || harika_get_page_header_id() == 'default' ) {
            get_template_part( 'template-parts/header', 'default' );
        } else {
            echo '<header class="site-header builder-header">';
                echo do_shortcode('[harika-tb-header id="'.harika_get_page_header_id().'"]');
            echo '</header>';
        }
        
    ?>


<?php
