<?php
/**
 * The template for displaying the footer
 *
 * @package Harika
 */

use HarikaTheme\Classes\Harika_Helper as Helper;
use HarikaTheme\Classes\Harika_svg;
$back_to_top = Helper::get_option( 'back_to_top', true );
$back_top_class = 'back-to-top'; ;

if ( Helper::get_option( 'back_to_top_mobile', false ) ) {
    $back_top_class = 'back-to-top show-on-mobile';
}


?>
    </main>
    <?php if( $back_to_top ) : ?>
    <a href="#" id="backToTop" class="<?php echo esc_attr( $back_top_class ) ?>">
        <?php echo Harika_svg::get_icon_svg('back-to-top'); ?>
    </a>
    <?php endif; ?>
    <?php
        
        do_action( "harika_builder_after_main" );
        
        if( harika_get_page_footer_id() == '0' || harika_get_page_footer_id() == '' || harika_get_page_footer_id() == 'default' ) {
            get_template_part( 'template-parts/footer', 'default' );
        } else {
            echo '<footer class="site-footer builder-footer">';
                echo do_shortcode('[harika-tb-footer id="'.harika_get_page_footer_id().'"]');
            echo '</footer>';
        }
        
    ?>
</div>

<?php wp_footer();?>

</body>
</html>
