






(function ($) {
	"use strict";


	// function: get scrollbar width
function getScrollbarWidth() {

	var block1 = jQuery('<div>').css({ 'width': '50px', 'height': '50px' }),
		block2 = jQuery('<div>').css({ 'height': '200px' }),
		width1,
		width2,
		result;

	// scrollbar width calculation
	jQuery("body").append(block1.append(block2));
	width1 = jQuery('div', block1).innerWidth();
	block1.css('overflow-y', 'scroll');
	width2 = jQuery('div', block1).innerWidth();
	$(block1).remove();
	result = width1 - width2; // scrollbar width

	// return result
	return result;

}


	var SwiperSliderWidgets = function ($scope, $) {
		$scope.find('.harika-slider').each(function () {

			var settings = $(this).data('settings');
			var attr = $(this).attr('data-settings');
			var slider_id = settings['slider_id'];
			var slider = jQuery('.swiper.slider-' + settings['slider_id'] + ' ');

			//console.log('.swiper.slider-' + settings['slider_id'] + ' ');

			var options = JSON.parse(attr);
			//console.log('options:');
			//console.log(options);


			var slider_config = [];

			if ($('html').attr('dir') === 'rtl') {
				
			}
			


			slider_config["lazy"] = false;

			if (options.autoplay) {
				slider_config["autoplay"] = {
					delay: '' != options.autoplay_speed ? options.autoplay_speed : 2000,
					pauseOnMouseEnter: '' != options.pauseOnMouseEnter ? options.pauseOnMouseEnter : false,
					stopOnLastSlide: '' != options.stopOnLastSlide ? options.stopOnLastSlide : false,
					disableOnInteraction: false,
				};
			}


			if (options.effect == 'cards') {
				slider_config["cardsEffect"] = {

					perSlideOffset: '' != options.cardsEffect_perSlideOffset ? options.cardsEffect_perSlideOffset : 8,
					perSlideRotate: '' != options.cardsEffect_perSlideRotate ? options.cardsEffect_perSlideRotate : 2,
					rotate: '' != options.cardsEffect_rotate ? options.cardsEffect_rotate : false,
					slideShadows: '' != options.cardsEffect_slideShadows ? options.cardsEffect_slideShadows : false,

				};
			}




			if (options.grid) {
				slider_config["grid"] = {
					rows: options.gridRows,
					fill: 'row',
				};
			}


			slider_config["loop"] = options.loop;

			if (options.loop != true) {
				slider_config["rewind"] = options.rewind;
			}

			if (options.navigation) {
				slider_config["navigation"] = {
					nextEl: '.swiper-next-slider-' + slider_id,
					prevEl: '.swiper-prev-slider-' + slider_id,
				};
			}
			if (options.pagination) {
				slider_config["pagination"] = {
					el: '.swiper-pagination-slider-' + slider_id,
					clickable: true,
				};
			}


			slider_config["centeredSlides"] = options.centeredSlides;
			slider_config["freeMode"] = options.freeMode;
			slider_config["grabCursor"] = options.grabCursor;
			slider_config["mousewheel"] = options.mousewheel;

			slider_config["breakpointsBase"] = options.breakpointsBase;
			slider_config["effect"] = options.effect;

			slider_config["speed"] = '' != options.swipe_speed ? options.swipe_speed : 2000;



			slider_config["responsive"] = true;


			slider_config["slidesPerView"] = options.mSlidesPerView;
			slider_config["spaceBetween"] = options.mSpaceBetween;
			slider_config["breakpoints"] = {
				767: {
					slidesPerView: options.tSlidesPerView,
					spaceBetween: options.tSpaceBetween
				},
				1024: {
					slidesPerView: options.slidesPerView,
					spaceBetween: options.spaceBetween
				},
			};

			slider_config["preloadImages"] = false;







			//console.log('slider_config:');
			//console.log(slider_config);


			// Set6 the Swiper
			const swiper = new Swiper('.swiper.slider-' + settings['slider_id'] + ' ', (
				slider_config
			));



			slider.ready(function () {
				slider.removeClass('loading');
				//console.log('loading deleted');
			});


		});
	};


	var VideoPlayListWidget = function ($scope, $) {
	

		$scope.find('.harika-videoplaylist-widget .item').each(function () {

			var settings = $(this).data('harika-vid');

			var thumb = $('.harika-videoplaylist-widget .item.' + settings['id'] + '');
			var present = $('.harika-videoplaylist-widget .video.' + settings['id'] + '');

			thumb.click(function (j) {
				var allvideos = $(this).closest('.harika-videoplaylist-widget').find('.video');
				var allthumbs = $(this).closest('.harika-videoplaylist-widget').find('.item');
				allvideos.removeClass('active');
				allthumbs.removeClass('active');

				jQuery('.harika-videoplaylist-widget video').trigger('pause');

				present.addClass('active');
				$(this).addClass('active');

				j.preventDefault();
			});


		});

	};

	var StickySide = function ($scope, $) {

		$scope.find('.harika-sticky-side-widget').each(function () {

			var settings = $(this).data('harika-stickyside');

			var toggle = $('.harika-sticky-side-widget.' + settings['id'] + ' ' + '.toggle');
			var back_shadow = $('.harika-sticky-side-widget.' + settings['id'] + ' ' + '.back-shadow');
			var closebtn = $('.harika-sticky-side-widget.' + settings['id'] + ' ' + '.closebtn');



			toggle.click(function (j) {
				j.preventDefault();
				jQuery('.harika-sticky-side-widget.' + settings['id'] + '').addClass('its-open');
				//jQuery("body").addClass('overflow-hidden');

				jQuery("body").css( {
					'overflow-y': 'hidden', // remove scrollbar
					'margin-right': getScrollbarWidth(),
				} );
			});

			back_shadow.click(function (j) {
				j.preventDefault();
				jQuery('.harika-sticky-side-widget.' + settings['id'] + '' + '.its-open').removeClass('its-open');
				///jQuery("body").removeClass('overflow-hidden');
				jQuery("body").css( {
					'overflow-y': 'auto', // remove scrollbar
					'margin-right': 0,
				} );
			});

			closebtn.click(function (j) {
				j.preventDefault();
				jQuery('.harika-sticky-side-widget.' + settings['id'] + '' + '.its-open').removeClass('its-open');
				jQuery("body").css( {
					'overflow-y': 'auto', // remove scrollbar
					'margin-right': 0,
				} );
			});


		});

	};

	var SearchWidget = function () {

		// یافتن تمام عناصر با کلاس 'harika-search-widget'
		var searchWidgets = document.querySelectorAll('.harika-search-widget');

		searchWidgets.forEach(function (widget) {
			var settings = widget.dataset.harikaSearch;

			// یافتن عناصر داخلی
			var toggle = widget.querySelector('.toggle-search-box');
			var backShadow = widget.querySelector('.harika-search .back-shadow');
			var closeBtn = widget.querySelector('.harika-search .close');

			// افزودن event listener به دکمه 'toggle'
			if (toggle) {
				toggle.addEventListener('click', function (event) {
					event.preventDefault();
					widget.querySelector('.harika-search').classList.add('open');
					
					jQuery("body").css( {
						'overflow-y': 'hidden', // remove scrollbar
						'margin-right': getScrollbarWidth(),
					} );
				});
			}

			// افزودن event listener به دکمه 'back-shadow'
			if (backShadow) {
				backShadow.addEventListener('click', function (event) {
					event.preventDefault();
					widget.querySelector('.harika-search').classList.remove('open');
					jQuery("body").css( {
						'overflow-y': 'auto', // remove scrollbar
						'margin-right': 0,
					} );
				});
			}

			// افزودن event listener به دکمه 'close'
			if (closeBtn) {
				closeBtn.addEventListener('click', function (event) {
					event.preventDefault();
					widget.querySelector('.harika-search').classList.remove('open');
					jQuery("body").css( {
						'overflow-y': 'auto', // remove scrollbar
						'margin-right': 0,
					} );
				});
			}

		});

		//console.log('searchWidget');
	};

	// فراخوانی تابع SearchWidget
	SearchWidget();


	var ShareWidget = function ($scope, $) {

		$scope.find('.harika-share-widget').each(function () {

			var settings = $(this).data('harika-share');

			var open_share_box = $('.harika-share-widget.' + settings['id'] + ' ' + '#open-share-box');
			var close_share_box = $('.harika-share-widget.' + settings['id'] + ' ' + '#close-share-box');
			var share_box_back = $('.harika-share-widget.' + settings['id'] + ' ' + '#share-box-back');
			var copy_text_btn = $('.harika-share-widget.' + settings['id'] + ' ' + '.copy-text-btn');



			open_share_box.click(function (j) {
				j.preventDefault();
				jQuery('.harika-share-widget.' + settings['id'] + ' ' + '#share-box').addClass('show');
				jQuery('.harika-share-widget.' + settings['id'] + ' ' + '#share-box-back').addClass('show');
				jQuery("body").addClass('overflow-hidden');
			});
			close_share_box.click(function (j) {
				j.preventDefault();
				jQuery('.harika-share-widget.' + settings['id'] + ' ' + '#share-box').removeClass('show');
				jQuery('.harika-share-widget.' + settings['id'] + ' ' + '#share-box-back').removeClass('show');
				jQuery("body").removeClass('overflow-hidden');
			});
			share_box_back.click(function (j) {
				j.preventDefault();
				jQuery('.harika-share-widget.' + settings['id'] + ' ' + '#share-box').removeClass('show');
				jQuery('.harika-share-widget.' + settings['id'] + ' ' + '#share-box-back').removeClass('show');
				jQuery("body").removeClass('overflow-hidden');
			});
			copy_text_btn.click(function (j) {
				j.preventDefault();
				jQuery(this).parent(".copy-text").find("input").select(), document.execCommand("copy");
				jQuery('body').append("<div class='harika-message-box success'><i class='fa-regular fa-copy'></i> لینک کپی شد!</div>");
				setTimeout(function () {
					jQuery('.harika-message-box').remove();
				}, 4000);
			});


		});

	};




	var HARIKAnav = function ($scope, $) {

		$scope.find('.harika-menu-widget').each(function () {
			var $widget = $(this);
			var settings = $widget.data('harika-nav');
			var id = settings['id'];

			var $toggle = $(`.harika-navigation-toggle-holder.${id} .harika-navigation-toggle`);
			var $dropdown = $(`.harika-navigation-dropdown.${id}`);
			var $closebtn = $(`.harika-navigation-dropdown.${id} .closebtn`);
			var $menuItems = $(`.menu-ul.${id} .menu-item a`);

			// Toggle dropdown and toggle button visibility
			$toggle.click(function (e) {
				e.preventDefault();
				$dropdown.toggleClass('opened closed');
				$(this).toggleClass('show none');
			});

			// Close dropdown
			$closebtn.click(function (e) {
				e.preventDefault();
				$dropdown.removeClass('opened').addClass('closed');
				$toggle.removeClass('show').addClass('none');
			});

			// Open link in the same window
			$menuItems.click(function (e) {
				e.preventDefault();
				open(this.href, '_self');
			});

			// Handle menu item active class

			$(`.menu-ul.${id} .menu-item`).click(function (e) {
				e.preventDefault();
				e.stopPropagation(); // جلوگیری از انتشار رویداد به والدین

				$(this).toggleClass('active');
			});


		});
	};





	var Tabs1Widget = function ($scope, $) {

		$scope.find('.harika-post-tabs-widget .tab-item').each(function () {

			var settings = $(this).data('harika-tab');

			var tab = $('.harika-post-tabs-widget .tab-item.' + settings['id'] + '');
			var content = $('.harika-post-tabs-widget .content-item.' + settings['id'] + '');

			tab.hover(function (j) {
				var allvideos = $(this).closest('.harika-post-tabs-widget').find('.content-item');
				var alltabs = $(this).closest('.harika-post-tabs-widget').find('.tab-item');
				allvideos.removeClass('active');
				alltabs.removeClass('active');

				content.addClass('active');
				$(this).addClass('active');

				j.preventDefault();
			});


		});

	};



	$(window).on('elementor/frontend/init', function () {

		elementorFrontend.hooks.addAction('frontend/element_ready/HarikaHFMenu.default', HARIKAnav);
		elementorFrontend.hooks.addAction('frontend/element_ready/HarikaHFStickySidebar.default', StickySide);
		elementorFrontend.hooks.addAction('frontend/element_ready/HarikaHFSearch.default', SearchWidget);
		elementorFrontend.hooks.addAction('frontend/element_ready/HarikaSAShare.default', ShareWidget);
		elementorFrontend.hooks.addAction('frontend/element_ready/HarikaVideoPlayList.default', VideoPlayListWidget);
		elementorFrontend.hooks.addAction('frontend/element_ready/harika-post_tabs.default', Tabs1Widget);

		elementorFrontend.hooks.addAction('frontend/element_ready/harika-post_slider_1.default', SwiperSliderWidgets);
		elementorFrontend.hooks.addAction('frontend/element_ready/harika-post_slider_2.default', SwiperSliderWidgets);

	});

})(jQuery);




