/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-07-21 13:16:17 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2298 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=447 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=23283 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=13353 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=2240 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_rtl_rsm_logs` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `section` varchar(255) NOT NULL,
  `result` mediumtext NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4439 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `message` longtext NOT NULL,
  `types` varchar(255) NOT NULL,
  `create_at` datetime NOT NULL,
  `form_id` bigint(20) DEFAULT NULL,
  `entry_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_payment_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `payment_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_id` (`payment_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_payments` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT '',
  `subtotal_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `discount_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `total_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `currency` varchar(3) NOT NULL DEFAULT '',
  `entry_id` bigint(20) NOT NULL DEFAULT 0,
  `gateway` varchar(20) NOT NULL DEFAULT '',
  `type` varchar(12) NOT NULL DEFAULT '',
  `mode` varchar(4) NOT NULL DEFAULT '',
  `transaction_id` varchar(40) NOT NULL DEFAULT '',
  `customer_id` varchar(40) NOT NULL DEFAULT '',
  `subscription_id` varchar(40) NOT NULL DEFAULT '',
  `subscription_status` varchar(10) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `date_created_gmt` datetime NOT NULL,
  `date_updated_gmt` datetime NOT NULL,
  `is_published` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `status` (`status`(8)),
  KEY `total_amount` (`total_amount`),
  KEY `type` (`type`(8)),
  KEY `transaction_id` (`transaction_id`(32)),
  KEY `customer_id` (`customer_id`(32)),
  KEY `subscription_id` (`subscription_id`(32)),
  KEY `subscription_status` (`subscription_status`(8)),
  KEY `title` (`title`(64))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_tasks_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) NOT NULL,
  `data` longtext NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpmailsmtp_debug_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` text DEFAULT NULL,
  `initiator` text DEFAULT NULL,
  `event_type` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpmailsmtp_tasks_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) NOT NULL,
  `data` longtext NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("2171", "action_scheduler/migration_hook", "failed", "2024-09-26 12:03:07", "2024-09-26 12:03:07", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727352187;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727352187;}", "3", "1", "2024-09-26 12:03:10", "2024-09-26 15:33:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2174", "action_scheduler/migration_hook", "failed", "2025-06-08 22:54:35", "2025-06-08 22:54:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749423275;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749423275;}", "3", "1", "2025-06-08 22:54:43", "2025-06-09 02:24:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2266", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":780,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2267", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":779,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2268", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":778,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2269", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":777,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2270", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":776,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2271", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":593,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2272", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":589,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2273", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":587,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2274", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":585,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2275", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":582,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2276", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":579,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2277", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":575,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2278", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":550,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2279", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":539,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2280", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":511,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2281", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":510,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2282", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":507,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2283", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":322,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2284", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":321,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2285", "imagify_optimize_media", "complete", "2025-06-08 22:54:09", "2025-06-08 22:54:09", "10", "{\"id\":320,\"context\":\"wp\",\"level\":2}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2025-06-08 22:54:15", "2025-06-09 02:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2286", "action_scheduler/migration_hook", "complete", "2025-07-21 09:43:47", "2025-07-21 09:43:47", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1753091027;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1753091027;}", "3", "1", "2025-07-21 09:44:00", "2025-07-21 13:14:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2287", "wp_mail_smtp_summary_report_email", "canceled", "2025-07-28 10:30:00", "2025-07-28 10:30:00", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753698600;s:18:\"\0*\0first_timestamp\";i:1753698600;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753698600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2288", "wp_mail_smtp_admin_notifications_update", "complete", "2025-07-21 09:45:04", "2025-07-21 09:45:04", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753091104;s:18:\"\0*\0first_timestamp\";i:1753091104;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753091104;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-07-21 09:45:32", "2025-07-21 13:15:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2289", "wpforms_process_forms_locator_scan", "complete", "2025-07-21 09:44:04", "2025-07-21 09:44:04", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753091044;s:18:\"\0*\0first_timestamp\";i:1753091044;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753091044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-21 09:45:31", "2025-07-21 13:15:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2290", "wpforms_process_purge_spam", "complete", "2025-07-21 09:44:04", "2025-07-21 09:44:04", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753091044;s:18:\"\0*\0first_timestamp\";i:1753091044;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753091044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-21 09:45:31", "2025-07-21 13:15:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2291", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-07-15 00:07:22", "2025-07-15 00:07:22", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752538042;s:18:\"\0*\0first_timestamp\";i:1752538042;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752538042;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "7", "1", "2025-07-21 09:45:31", "2025-07-21 13:15:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2292", "wpforms_admin_notifications_update", "complete", "2025-07-21 09:44:07", "2025-07-21 09:44:07", "10", "{\"tasks_meta_id\":3}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2025-07-21 09:45:31", "2025-07-21 13:15:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2293", "wpforms_email_summaries_fetch_info_blocks", "canceled", "2025-07-28 09:45:31", "2025-07-28 09:45:31", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753695931;s:18:\"\0*\0first_timestamp\";i:1752538042;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753695931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2294", "wpforms_process_forms_locator_scan", "canceled", "2025-07-22 09:45:31", "2025-07-22 09:45:31", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753177531;s:18:\"\0*\0first_timestamp\";i:1753091044;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753177531;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2295", "wpforms_process_purge_spam", "canceled", "2025-07-22 09:45:31", "2025-07-22 09:45:31", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753177531;s:18:\"\0*\0first_timestamp\";i:1753091044;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753177531;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2296", "wp_mail_smtp_admin_notifications_update", "canceled", "2025-07-22 09:45:32", "2025-07-22 09:45:32", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753177532;s:18:\"\0*\0first_timestamp\";i:1753091104;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753177532;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("2297", "action_scheduler/migration_hook", "pending", "2025-07-21 09:47:49", "2025-07-21 09:47:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1753091269;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1753091269;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_claims */
INSERT INTO `wp_actionscheduler_claims` VALUES("8", "2024-09-26 12:03:10");
INSERT INTO `wp_actionscheduler_claims` VALUES("12", "2024-09-26 12:04:10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "rocket-preload");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "rocket-performance-hints-warmup");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "rocket-rucss");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "imagify-wp-optimize-media");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "wp_mail_smtp");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "wpforms");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("70", "2171", "action created", "2024-09-26 12:02:07", "2024-09-26 12:02:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("71", "2171", "action started via WP Cron", "2024-09-26 12:03:10", "2024-09-26 12:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("72", "2171", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-09-26 12:03:10", "2024-09-26 12:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("79", "2174", "action created", "2025-06-08 22:53:35", "2025-06-08 22:53:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("171", "2266", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("172", "2267", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("173", "2268", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("174", "2269", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("175", "2270", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("176", "2271", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("177", "2272", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("178", "2273", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("179", "2274", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("180", "2275", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("181", "2276", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("182", "2277", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("183", "2278", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("184", "2279", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("185", "2280", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("186", "2281", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("187", "2282", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("188", "2283", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("189", "2284", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("190", "2285", "action created", "2025-06-08 22:54:09", "2025-06-08 22:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("373", "2266", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("374", "2266", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("375", "2267", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("376", "2267", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("377", "2268", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("378", "2268", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("379", "2269", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("380", "2269", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("381", "2270", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("382", "2270", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("383", "2271", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("384", "2271", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("385", "2272", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("386", "2272", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("387", "2273", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("388", "2273", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("389", "2274", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("390", "2274", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("391", "2275", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("392", "2275", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("393", "2276", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("394", "2276", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("395", "2277", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("396", "2277", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("397", "2278", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("398", "2278", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("399", "2279", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("400", "2279", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("401", "2280", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("402", "2280", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("403", "2281", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("404", "2281", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("405", "2282", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("406", "2282", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("407", "2283", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("408", "2283", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("409", "2284", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("410", "2284", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("411", "2285", "action started via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("412", "2285", "action complete via WP Cron", "2025-06-08 22:54:15", "2025-06-08 22:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("413", "2174", "action started via Async Request", "2025-06-08 22:54:42", "2025-06-08 22:54:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("414", "2174", "action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-06-08 22:54:43", "2025-06-08 22:54:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("415", "2286", "action created", "2025-07-21 09:42:47", "2025-07-21 09:42:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("416", "2286", "action started via WP Cron", "2025-07-21 09:44:00", "2025-07-21 09:44:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("417", "2286", "action complete via WP Cron", "2025-07-21 09:44:00", "2025-07-21 09:44:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("418", "2287", "action created", "2025-07-21 09:44:04", "2025-07-21 09:44:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("419", "2288", "action created", "2025-07-21 09:44:04", "2025-07-21 09:44:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("420", "2289", "action created", "2025-07-21 09:44:04", "2025-07-21 09:44:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("421", "2290", "action created", "2025-07-21 09:44:04", "2025-07-21 09:44:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("422", "2291", "action created", "2025-07-21 09:44:04", "2025-07-21 09:44:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("423", "2292", "action created", "2025-07-21 09:44:07", "2025-07-21 09:44:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("424", "2291", "action started via WP Cron", "2025-07-21 09:45:31", "2025-07-21 09:45:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("425", "2291", "action complete via WP Cron", "2025-07-21 09:45:31", "2025-07-21 09:45:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("426", "2293", "action created", "2025-07-21 09:45:31", "2025-07-21 09:45:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("427", "2289", "action started via WP Cron", "2025-07-21 09:45:31", "2025-07-21 09:45:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("428", "2289", "action complete via WP Cron", "2025-07-21 09:45:31", "2025-07-21 09:45:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("429", "2294", "action created", "2025-07-21 09:45:31", "2025-07-21 09:45:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("430", "2290", "action started via WP Cron", "2025-07-21 09:45:31", "2025-07-21 09:45:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("431", "2290", "action complete via WP Cron", "2025-07-21 09:45:31", "2025-07-21 09:45:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("432", "2295", "action created", "2025-07-21 09:45:31", "2025-07-21 09:45:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("433", "2292", "action started via WP Cron", "2025-07-21 09:45:31", "2025-07-21 09:45:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("434", "2292", "action complete via WP Cron", "2025-07-21 09:45:31", "2025-07-21 09:45:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("435", "2288", "action started via WP Cron", "2025-07-21 09:45:31", "2025-07-21 09:45:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("436", "2288", "action complete via WP Cron", "2025-07-21 09:45:32", "2025-07-21 09:45:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("437", "2296", "action created", "2025-07-21 09:45:32", "2025-07-21 09:45:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("438", "2296", "action canceled", "2025-07-21 09:46:48", "2025-07-21 09:46:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("439", "2287", "action canceled", "2025-07-21 09:46:48", "2025-07-21 09:46:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("440", "2297", "action created", "2025-07-21 09:46:49", "2025-07-21 09:46:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("441", "2294", "action canceled", "2025-07-21 09:47:40", "2025-07-21 09:47:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("442", "2295", "action canceled", "2025-07-21 09:47:40", "2025-07-21 09:47:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("443", "2293", "action canceled", "2025-07-21 09:47:40", "2025-07-21 09:47:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("444", "2294", "action canceled", "2025-07-21 09:47:40", "2025-07-21 09:47:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("445", "2295", "action canceled", "2025-07-21 09:47:40", "2025-07-21 09:47:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("446", "2293", "action canceled", "2025-07-21 09:47:40", "2025-07-21 09:47:40");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("3", "70", "توسعه دهنده وب", "wpthemeir@gmail.com", "https://webdev-demo.ir/harika/harika", "::1", "2023-01-15 23:38:00", "2023-01-15 20:08:00", "تست دیدگاه", "0", "1", "", "comment", "0", "1");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("17", "harika_v42", "446b128a7c7b883c1127_20250721131605", "22", "2025-07-21 13:16:17", "webdev", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-07-21 13:16:05\";s:7:\"Version\";s:6:\"1.5.13\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:7:\"10.6.22\";s:10:\"VersionPHP\";s:6:\"8.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:17;s:4:\"Name\";s:10:\"harika_v42\";s:4:\"Hash\";s:35:\"446b128a7c7b883c1127_20250721131605\";s:8:\"NameHash\";s:46:\"harika_v42_446b128a7c7b883c1127_20250721131605\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:56:\"harika_v42_446b128a7c7b883c1127_20250721131605_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"22.4\";s:6:\"WPUser\";s:6:\"webdev\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:69:\"/home/webdevde/public_html/harika/harika/wp-content/themes/harika.rar\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:58:\"harika_v42_446b128a7c7b883c1127_20250721131605_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:40:\"/home/webdevde/public_html/harika/harika\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1306;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:9601;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-07-21 13:16:05\";s:7:\"Version\";s:6:\"1.5.13\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:7:\"10.6.22\";s:10:\"VersionPHP\";s:6:\"8.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:10:\"harika_v42\";s:4:\"Hash\";s:35:\"446b128a7c7b883c1127_20250721131605\";s:8:\"NameHash\";s:46:\"harika_v42_446b128a7c7b883c1127_20250721131605\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:64:\"harika_v42_446b128a7c7b883c1127_20250721131605_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:54:\"/home/webdevde/public_html/harika/harika/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:59:\"harika_v42_446b128a7c7b883c1127_20250721131605_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:132:\"/home/webdevde/public_html/harika/harika/wp-content/backups-dup-lite/tmp/harika_v42_446b128a7c7b883c1127_20250721131605_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:49:\"/home/webdevde/public_html/harika/harika/wp-admin\";i:1;s:52:\"/home/webdevde/public_html/harika/harika/wp-includes\";i:2;s:61:\"/home/webdevde/public_html/harika/harika/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:40:\"/home/webdevde/public_html/harika/harika\";i:1;s:40:\"/home/webdevde/public_html/harika/harika\";i:2;s:51:\"/home/webdevde/public_html/harika/harika/wp-content\";i:3;s:59:\"/home/webdevde/public_html/harika/harika/wp-content/uploads\";i:4;s:59:\"/home/webdevde/public_html/harika/harika/wp-content/plugins\";i:5;s:62:\"/home/webdevde/public_html/harika/harika/wp-content/mu-plugins\";i:6;s:58:\"/home/webdevde/public_html/harika/harika/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:72:\"/home/webdevde/public_html/harika/harika/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_e_events */
INSERT INTO `wp_e_events` VALUES("1", "{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2024-08-05T11:49:59.544-04:30\"}", "2024-08-05 11:49:59");
INSERT INTO `wp_e_events` VALUES("2", "{\"event\":\"close modal\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\"}\",\"ts\":\"2024-08-05T11:50:17.945-04:30\"}", "2024-08-05 11:50:17");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:17:{i:1753105016;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1753116172;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1753124481;a:1:{s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1753126622;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1753132015;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1753133815;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1753134405;a:1:{s:13:\"rsmAutoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1753137000;a:1:{s:18:\"imagify_sync_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1753169816;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1753169822;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1753169829;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1753176511;a:1:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1753235802;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1753359694;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1753688253;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1753698600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "https://webdev-demo.ir/harika/harika", "on");
INSERT INTO `wp_options` VALUES("3", "home", "https://webdev-demo.ir/harika/harika", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "قالب هاریکا", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "wpthemeir@gmail.com", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "6", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "password", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "j F Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "H:i", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:126:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"harika_template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"harika_template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"harika_template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"harika_template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"harika_template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"harika_template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"harika_template/([^/]+)/embed/?$\";s:48:\"index.php?harika_template=$matches[1]&embed=true\";s:36:\"harika_template/([^/]+)/trackback/?$\";s:42:\"index.php?harika_template=$matches[1]&tb=1\";s:44:\"harika_template/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?harika_template=$matches[1]&paged=$matches[2]\";s:51:\"harika_template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?harika_template=$matches[1]&cpage=$matches[2]\";s:40:\"harika_template/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?harika_template=$matches[1]&page=$matches[2]\";s:32:\"harika_template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"harika_template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"harika_template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"harika_template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"harika_template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"harika_template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=9&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:6:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:33:\"classic-editor/classic-editor.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:23:\"elementor/elementor.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "3.5", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp_options` VALUES("41", "template", "harika", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "harika", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "60421", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:2:{i:2;a:6:{s:5:\"title\";s:14:\"دئتتئغئ\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;s:5:\"width\";b:0;s:6:\"sticky\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "on");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "1414", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "9", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "2147", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1757068342", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "57155", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "WPLANG", "fa_IR", "auto");
INSERT INTO `wp_options` VALUES("105", "user_count", "2", "off");
INSERT INTO `wp_options` VALUES("106", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("107", "sidebars_widgets", "a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"primary_sidebar\";a:3:{i:0;s:8:\"search-2\";i:6;s:12:\"categories-2\";i:7;s:14:\"recent-posts-2\";}s:13:\"pages_sidebar\";a:0:{}s:14:\"footer_widgets\";a:0:{}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_search", "a:2:{i:2;a:3:{s:5:\"title\";s:8:\"زیبب\";s:5:\"width\";b:0;s:6:\"sticky\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-posts", "a:2:{i:2;a:5:{s:5:\"title\";s:14:\"تئتائتئ\";s:6:\"number\";i:5;s:9:\"show_date\";b:0;s:5:\"width\";b:0;s:6:\"sticky\";s:6:\"sticky\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("125", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("156", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("161", "theme_mods_twentytwentyfour", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1722845512;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("162", "current_theme", "هاریکا", "auto");
INSERT INTO `wp_options` VALUES("163", "theme_mods_harika", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:12:\"primary_menu\";i:2;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1752859421;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"primary_sidebar\";a:3:{i:0;s:8:\"search-2\";i:6;s:12:\"categories-2\";i:7;s:14:\"recent-posts-2\";}s:13:\"pages_sidebar\";a:0:{}s:14:\"footer_widgets\";a:0:{}}}}", "off");
INSERT INTO `wp_options` VALUES("164", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("165", "RTL-CareUnit-PIL", "q1bKSS1LzVGyUnJMLsksSyzJzM9T0lEqLkksKS0GigaXJienFhcDhVJSi5OLMgvACqyUlGoB", "off");
INSERT INTO `wp_options` VALUES("166", "auto_update_plugins", "a:1:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";}", "off");
INSERT INTO `wp_options` VALUES("167", "RTL-CareUnit-FPA", "1", "auto");
INSERT INTO `wp_options` VALUES("168", "ayhan_options", "a:33:{s:26:\"container_width_widescreen\";s:4:\"1300\";s:23:\"container_width_desktop\";s:4:\"1140\";s:22:\"container_width_tablet\";s:4:\"1024\";s:22:\"container_width_mobile\";s:3:\"768\";s:15:\"site_logo_image\";a:2:{s:3:\"url\";s:87:\"https://webdev-demo.ir/harika/harika/wp-content/themes/harika/assets/img/ayhan-logo.svg\";s:9:\"thumbnail\";s:87:\"https://webdev-demo.ir/harika/harika/wp-content/themes/harika/assets/img/ayhan-logo.svg\";}s:14:\"logo_dimension\";s:0:\"\";s:14:\"logo_max_width\";s:0:\"\";s:11:\"back_to_top\";b:1;s:18:\"back_to_top_mobile\";b:0;s:21:\"select_default_header\";s:1:\"0\";s:21:\"select_default_footer\";s:1:\"0\";s:23:\"archives_post_meta_show\";s:3:\"yes\";s:19:\"archives_title_wrap\";s:3:\"yes\";s:19:\"single_sidebar_show\";s:3:\"yes\";s:22:\"single_breadcrumb_show\";s:3:\"yes\";s:16:\"single_tags_show\";s:3:\"yes\";s:21:\"single_authorbox_show\";s:3:\"yes\";s:18:\"stories_activation\";s:3:\"yes\";s:18:\"ayhan_default_skin\";s:5:\"light\";s:13:\"primary_color\";s:7:\"#04c550\";s:15:\"secondary_color\";s:7:\"#ebebed\";s:10:\"body_color\";s:7:\"#f9f9f9\";s:11:\"error_title\";s:59:\"متاسفیم ، برگه مورد نظر یافت نشد!\";s:10:\"error_text\";s:93:\"جهت بازگشت به صفحه اصلی از دکمه زیر استفاده فرمایید\";s:17:\"error_button_show\";s:3:\"yes\";s:17:\"error_button_text\";s:35:\"بازگشت به صفحه اصلی\";s:16:\"maintenance_mode\";s:8:\"disabled\";s:16:\"maintenance_page\";s:0:\"\";s:17:\"maintenance_title\";s:76:\"سایت در حال حاضر جهت تعمیر غیرفعال می باشد\";s:20:\"maintenance_subtitle\";s:69:\"از هر ناراحتی پدید آمده پوزش می خواهیم\";s:15:\"maintenance_img\";a:2:{s:3:\"url\";s:88:\"https://webdev-demo.ir/harika/harika/wp-content/themes/harika/assets/img/maintenance.png\";s:9:\"thumbnail\";s:88:\"https://webdev-demo.ir/harika/harika/wp-content/themes/harika/assets/img/maintenance.png\";}s:21:\"custom_header_scripts\";s:0:\"\";s:21:\"custom_footer_scripts\";s:0:\"\";}", "auto");
INSERT INTO `wp_options` VALUES("169", "widget_ayhan_recent_post_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("172", "elementor_disable_color_schemes", "yes", "auto");
INSERT INTO `wp_options` VALUES("173", "elementor_disable_typography_schemes", "yes", "auto");
INSERT INTO `wp_options` VALUES("174", "elementor_experiment-e_font_icon_svg", "inactive", "auto");
INSERT INTO `wp_options` VALUES("175", "elementor_experiment-container", "active", "auto");
INSERT INTO `wp_options` VALUES("176", "elementor_experiment-nested-elements", "active", "auto");
INSERT INTO `wp_options` VALUES("177", "elementor_experiment-additional_custom_breakpoints", "active", "auto");
INSERT INTO `wp_options` VALUES("178", "RTL-CareUnit-PCS", "8wkMrazyMSnJN9KucqxKi8pz1Q-oyi1ITYnysSx1S84IDnTxd_X3zg91zk9ODwoI8jIM9UsKN821zAxIzkx2tPTNdakIK69wiwy0MCkNKS4x8LI0Nw-t8k4xTiryd3ILDUquMA_zrcwLLIq0BQA", "off");
INSERT INTO `wp_options` VALUES("180", "wpcf7", "a:2:{s:7:\"version\";s:3:\"6.1\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1722845992;s:7:\"version\";s:5:\"5.9.8\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "auto");
INSERT INTO `wp_options` VALUES("181", "elementor_active_kit", "6", "auto");
INSERT INTO `wp_options` VALUES("182", "elementor_font_display", "swap", "auto");
INSERT INTO `wp_options` VALUES("185", "recently_activated", "a:2:{s:24:\"wpforms-lite/wpforms.php\";i:1753091260;s:29:\"wp-mail-smtp/wp_mail_smtp.php\";i:1753091208;}", "off");
INSERT INTO `wp_options` VALUES("186", "elementor_version", "3.30.2", "auto");
INSERT INTO `wp_options` VALUES("187", "elementor_install_history", "a:14:{s:6:\"3.23.3\";i:1722845996;s:6:\"3.23.4\";i:1722862042;s:6:\"3.24.2\";i:1726420561;s:6:\"3.24.3\";i:1727003766;s:6:\"3.24.4\";i:1727162340;s:6:\"3.25.6\";i:1731835424;s:6:\"3.25.9\";i:1732129341;s:7:\"3.25.10\";i:1733003254;s:6:\"3.27.6\";i:1741516437;s:6:\"3.28.4\";i:1747260945;s:6:\"3.29.0\";i:1747765860;s:6:\"3.29.1\";i:1748873214;s:6:\"3.29.2\";i:1749397057;s:6:\"3.30.2\";i:1752489679;}", "auto");
INSERT INTO `wp_options` VALUES("188", "elementor_events_db_version", "1.0.0", "off");
INSERT INTO `wp_options` VALUES("190", "elementor_onboarded", "1", "auto");
INSERT INTO `wp_options` VALUES("191", "_elementor_installed_time", "1722846019", "auto");
INSERT INTO `wp_options` VALUES("192", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `wp_options` VALUES("193", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:100:\"Introducing Elementor 3.30: new Editor V4 capabilities, full Website Templates in the cloud, & more!\";s:7:\"excerpt\";s:361:\"Elementor 3.30 is here and it includes upgrades that accelerate your workflow, bring you a step closer to the full power of Editor V4, and help you deliver beautiful, accessible websites faster than ever. From advanced styling tools and smarter editing to full Website Templates in the cloud, this release enhances both the way you design and the way you scale.\";s:7:\"created\";i:1751974442;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-330-v4-alpha-website-templates/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:57:\"Introducing Cloud Templates: your personal design library\";s:7:\"excerpt\";s:153:\"Transform your workflow with Elementor\'s new Cloud Templates – create, save, and access your templates across all your websites with just a few clicks.\";s:7:\"created\";i:1749048239;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:127:\"https://elementor.com/blog/introducing-cloud-templates/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:74:\"Introducing Editor V4 Alpha: The Future of Website Building with Elementor\";s:7:\"excerpt\";s:242:\"Editor V4 Alpha introduces a CSS-first framework with reusable Classes and States, improved performance, a unified styling system, and fully responsive style controls—all designed to make your website building more efficient and consistent.\";s:7:\"created\";i:1748357309;s:5:\"badge\";s:4:\" NEW\";s:3:\"url\";s:119:\"https://elementor.com/blog/editor-v4-1st-alpha/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wp_options` VALUES("203", "harika_options", "a:29:{s:26:\"container_width_widescreen\";s:4:\"1400\";s:23:\"container_width_desktop\";s:4:\"1140\";s:22:\"container_width_tablet\";s:4:\"1024\";s:22:\"container_width_mobile\";s:3:\"768\";s:14:\"site_fav_image\";a:8:{s:3:\"url\";s:72:\"https://webdev-demo.ir/harika/harika/wp-content/uploads/2024/09/fav1.png\";s:2:\"id\";s:4:\"2147\";s:5:\"width\";s:2:\"48\";s:6:\"height\";s:2:\"47\";s:9:\"thumbnail\";s:72:\"https://webdev-demo.ir/harika/harika/wp-content/uploads/2024/09/fav1.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:4:\"fav1\";s:11:\"description\";s:0:\"\";}s:11:\"back_to_top\";s:1:\"1\";s:18:\"back_to_top_mobile\";s:0:\"\";s:21:\"select_default_header\";s:2:\"57\";s:21:\"select_default_footer\";s:4:\"1419\";s:30:\"select_default_single_template\";s:4:\"1422\";s:36:\"select_default_blog_archive_template\";s:4:\"1492\";s:27:\"select_sidebar_title_layout\";s:1:\"1\";s:19:\"harika_default_skin\";s:5:\"light\";s:13:\"primary_color\";s:7:\"#2b39be\";s:15:\"secondary_color\";s:7:\"#ebebed\";s:10:\"body_color\";s:7:\"#f9f9f9\";s:23:\"harika_table_of_content\";s:2:\"no\";s:11:\"error_title\";s:59:\"متاسفیم ، برگه مورد نظر یافت نشد!\";s:10:\"error_text\";s:93:\"جهت بازگشت به صفحه اصلی از دکمه زیر استفاده فرمایید\";s:17:\"error_button_show\";s:3:\"yes\";s:17:\"error_button_text\";s:35:\"بازگشت به صفحه اصلی\";s:24:\"set_elementor_experiment\";s:1:\"1\";s:16:\"maintenance_mode\";s:8:\"disabled\";s:16:\"maintenance_page\";s:0:\"\";s:17:\"maintenance_title\";s:76:\"سایت در حال حاضر جهت تعمیر غیرفعال می باشد\";s:20:\"maintenance_subtitle\";s:69:\"از هر ناراحتی پدید آمده پوزش می خواهیم\";s:15:\"maintenance_img\";a:8:{s:3:\"url\";s:88:\"https://webdev-demo.ir/harika/harika/wp-content/themes/harika/assets/img/maintenance.png\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:88:\"https://webdev-demo.ir/harika/harika/wp-content/themes/harika/assets/img/maintenance.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:21:\"custom_header_scripts\";s:0:\"\";s:21:\"custom_footer_scripts\";s:0:\"\";}", "auto");
INSERT INTO `wp_options` VALUES("204", "widget_harika_recent_post_widget", "a:3:{i:2;a:4:{s:5:\"title\";s:22:\"آخرین پست ها\";s:10:\"post_count\";s:1:\"5\";s:6:\"sticky\";s:0:\"\";s:5:\"width\";b:0;}i:3;a:4:{s:5:\"title\";s:22:\"آخرین پست ها\";s:10:\"post_count\";s:1:\"3\";s:6:\"sticky\";s:0:\"\";s:5:\"width\";b:0;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("205", "recovery_mode_email_last_sent", "1752863332", "auto");
INSERT INTO `wp_options` VALUES("239", "elementor_log", "a:43:{s:32:\"3e7d1e1aaee8757220c01e0599778cd6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-11-20 22:32:21\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.25.6\";s:2:\"to\";s:6:\"3.25.9\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-11-20 22:32:21\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.25.6\";s:2:\"to\";s:6:\"3.25.9\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"63ef3b355c4984628622a6499d736a7a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-01 01:17:34\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-01 01:17:34\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"1789cd4d28c219ec526ba4bc7581df94\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-01 01:17:34\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-01 01:17:34\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"69e99c74932425ec476677a8a31eec6a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-01 01:17:34\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-01 01:17:34\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"152c8e77fd3b60fd65b8534fe2d92467\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-01 01:17:34\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.25.9\";s:2:\"to\";s:7:\"3.25.10\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-01 01:17:34\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.25.9\";s:2:\"to\";s:7:\"3.25.10\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"cf7041215682a69d1f6c6fafa10ebe8e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-01 01:17:34\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.25.9\";s:2:\"to\";s:7:\"3.25.10\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-01 01:17:34\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.25.9\";s:2:\"to\";s:7:\"3.25.10\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"71a91669e0e9d4b31f23daa8e8ccb2fd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-09 14:03:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:7:\"3.25.10\";s:2:\"to\";s:6:\"3.27.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-09 14:03:57\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:7:\"3.25.10\";s:2:\"to\";s:6:\"3.27.6\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"85010bef63158904493cdbeff9dc7bd0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-09 14:03:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-09 14:03:57\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"ea1c65a0f251f7bbe29a1c190625e0ed\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-09 14:03:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-09 14:03:57\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"a2f08e298621cd8e4f7937295f34eb3c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-09 14:03:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-09 14:03:57\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"a02a71f97771279ac57310417b550ac4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-09 14:03:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:42:\"المنتور/Upgrades - _v_3_26_0 Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-09 14:03:57\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:42:\"المنتور/Upgrades - _v_3_26_0 Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"520f8d4a9d9562cbc48d6fb35b4ba06a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-09 14:03:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"المنتور/Upgrades - _v_3_26_0 Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-09 14:03:57\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"المنتور/Upgrades - _v_3_26_0 Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"34e64325895c2f34147db7ea688e0cc3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-09 14:03:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:7:\"3.25.10\";s:2:\"to\";s:6:\"3.27.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-09 14:03:57\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:7:\"3.25.10\";s:2:\"to\";s:6:\"3.27.6\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"9631505a57124b79436a53a932139188\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-03-09 13:06:59\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:28:\"slider_config is not defined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-03-09 13:06:59\";i:1;s:19:\"2025-03-09 13:06:59\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1741525619\";s:7:\"message\";s:28:\"slider_config is not defined\";s:3:\"url\";s:91:\"https://webdev-demo.ir/harika/harika/wp-content/themes/harika/assets/js/elements.js?ver=4.2\";s:4:\"line\";s:2:\"22\";s:6:\"column\";s:2:\"16\";}s:7:\"\0*\0file\";s:91:\"https://webdev-demo.ir/harika/harika/wp-content/themes/harika/assets/js/elements.js?ver=4.2\";s:7:\"\0*\0line\";s:2:\"22\";s:9:\"\0*\0column\";s:2:\"16\";}s:32:\"b323d07acb3742cb33a5bb4ce66bb434\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-03-09 13:30:56\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:28:\"slidesPerView is not defined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-03-09 13:30:56\";i:1;s:19:\"2025-03-09 13:30:56\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1741527056\";s:7:\"message\";s:28:\"slidesPerView is not defined\";s:3:\"url\";s:91:\"https://webdev-demo.ir/harika/harika/wp-content/themes/harika/assets/js/elements.js?ver=4.2\";s:4:\"line\";s:3:\"109\";s:6:\"column\";s:2:\"19\";}s:7:\"\0*\0file\";s:91:\"https://webdev-demo.ir/harika/harika/wp-content/themes/harika/assets/js/elements.js?ver=4.2\";s:7:\"\0*\0line\";s:3:\"109\";s:9:\"\0*\0column\";s:2:\"19\";}s:32:\"d81f2636651290bd7586e17128a115e3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-15 01:45:44\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-15 01:45:44\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"6706d1c2725a778210051950e7552223\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-15 01:45:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-15 01:45:45\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"21bf7cb6dd9609f23634eb71d8a4bbd7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-15 01:45:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-15 01:45:45\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"8fb2710be3ed35250486620cbaa58907\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-15 01:45:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-15 01:45:45\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"99a8b44d11abeaab676b3e32d3a476bc\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-15 01:45:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-15 01:45:45\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"1bafb522949d90b10d36402df0bee704\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-20 22:00:58\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-20 22:00:58\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"a34105216cc51001e3c12035a64dbdca\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-20 22:00:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-20 22:00:59\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"ec48865c00c7d752c488d0b36622e3c5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-20 22:01:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-20 22:01:00\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"2c22a56722d91f9c8beeb8cd94cbe4e3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-20 22:01:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-20 22:01:00\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"c4ec0543ce27a8f09ee1132d8b4433f2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-20 22:01:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-20 22:01:00\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"a465ce98872bf2e92af99d2b87f9f19f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-02 17:36:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-02 17:36:54\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"c940b546dd02e9d51d9c3f8af45a33d8\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-02 17:36:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-02 17:36:54\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"f991660c95c95e203ff553e0369c6f7b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-02 17:36:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-02 17:36:54\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"88200719948e18ba912828a53ec859f4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-02 17:36:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.0\";s:2:\"to\";s:6:\"3.29.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-02 17:36:54\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.0\";s:2:\"to\";s:6:\"3.29.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"da130f76884a3d8deae3ca266422e19d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-02 17:36:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.0\";s:2:\"to\";s:6:\"3.29.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-02 17:36:54\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.0\";s:2:\"to\";s:6:\"3.29.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"9208330ad5085658bccbb1770e61d7b7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-08 19:07:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-08 19:07:36\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"82426b19e8c59db6225e1f7332a9e802\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-08 19:07:37\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-08 19:07:37\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"6ca13b705ad09eade352f13596fb4b2f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-08 19:07:37\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-08 19:07:37\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"323e3e3515e2e8db0158b0c89e6360b9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-08 19:07:37\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-08 19:07:37\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"6442b8a3adf68970e259f054d993bbc6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-08 19:07:37\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-08 19:07:37\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"91797dd07e41cef99af9ea04021e6a60\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-06-25 15:57:57\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:186:\"Failed to read a named property &#039;elementorFrontend&#039; from &#039;Window&#039;: Blocked a frame with origin &quot;https://webdev-demo.ir&quot; from accessing a cross-origin frame.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-25 15:57:57\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1750867077\";s:7:\"message\";s:156:\"Failed to read a named property \'elementorFrontend\' from \'Window\': Blocked a frame with origin \"https://webdev-demo.ir\" from accessing a cross-origin frame.\";s:3:\"url\";s:100:\"https://webdev-demo.ir/harika/harika/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.29.2\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"636103\";}s:7:\"\0*\0file\";s:100:\"https://webdev-demo.ir/harika/harika/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.29.2\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"636103\";}s:32:\"f1397932174caec960adecf729d43bf1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-14 14:11:19\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-14 14:11:19\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"e8c0285c8e9493d208338e1d28a3d98b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-14 14:11:19\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-14 14:11:19\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"88f35be0b61c4501006b550fb459cfba\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-14 14:11:19\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-14 14:11:19\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"f15e88b6736e6e74ce7ce45d49664177\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-14 14:11:19\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-14 14:11:19\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"8eca893055c65e227bfcb05fe74ba979\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-14 14:11:19\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-14 14:11:19\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"8c921c6317fb67e885087da712560c4b\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-07-18 17:00:48\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:63:\"Cannot read properties of undefined (reading &#039;tools&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-18 17:00:48\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1752858048\";s:7:\"message\";s:53:\"Cannot read properties of undefined (reading \'tools\')\";s:3:\"url\";s:82:\"https://webdev-demo.ir/harika/harika/wp-includes/js/jquery/jquery.min.js?ver=3.7.1\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"28760\";}s:7:\"\0*\0file\";s:82:\"https://webdev-demo.ir/harika/harika/wp-includes/js/jquery/jquery.min.js?ver=3.7.1\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:5:\"28760\";}s:32:\"9e0508c5b8a9b2865eb32bd3a0d6e22a\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-07-20 12:35:31\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:59:\"foreach() argument must be of type array|object, null given\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-20 12:35:31\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:59:\"foreach() argument must be of type array|object, null given\";s:4:\"file\";s:100:\"/home/webdevde/public_html/harika/harika/wp-content/plugins/elementor/includes/base/element-base.php\";s:4:\"line\";i:141;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:100:\"/home/webdevde/public_html/harika/harika/wp-content/plugins/elementor/includes/base/element-base.php\";s:7:\"\0*\0line\";i:141;}}", "off");
INSERT INTO `wp_options` VALUES("253", "_elementor_notifications_data", "a:2:{s:7:\"timeout\";i:1753018844;s:5:\"value\";s:15287:\"[{\"id\":\"send-cart-widget\",\"title\":\"Introducing: Cart Widget\",\"description\":\"Show customers exactly what they left behind\\u2014visually. The new Cart Widget adds product images to your emails for smarter, higher-converting cart recovery.\",\"topic\":\"Send: Email & SMS built for WooCommerce\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cart-widget-send.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Explore Cart Widget\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/WN_CartW\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"classes-3.30\",\"title\":\"Better class control\",\"description\":\"Get popovers with your class name, breakpoint, state and possible conflicts. Plus, the exact class names you define are now reflected in the code, making debugging and working with external tools easier!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/classes-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.30-cloud-websites\\/\"},{\"id\":\"tools-3.30\",\"title\":\"Essential Editor tools\",\"description\":\"V4 now includes a long list of essential V3 capabilities, re-engineered to fit the new framework - IDs, custom unit, anchor offset, display none, object fit, clear icons and more!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/tools-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"youtube-3.30\",\"title\":\"YouTube Element\",\"description\":\"The new YouTube Element is purpose-built to support V4 capabilities with faster rendering, better performance, and familiar controls like autoplay, loop, mute, and aspect ratio.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/youtube-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"host-google-cloud\",\"title\":\"Deliver fast, secure websites at scale - free migration included!\",\"description\":\"Host your site on Elementor\\u2019s infrastructure - built for speed, security, and scale. Powered by Google Cloud, with free migration and 24\\/7 expert support.\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/host-google-cloud.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/elementor-host-google-cloud\",\"readMoreText\":\"Read More\"},{\"id\":\"send-notification-june\",\"title\":\"A whole new onboarding experience\",\"description\":\"Try the new onboarding now: Launch abandoned cart recovery, welcome flows & more in minutes. No setup stress\\u2014just smarter automation from day one.\",\"topic\":\"Send: Email & SMS built for WooCommerce\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/send-june.png\",\"chipTags\":[\"New Features\"],\"cta\":\"Check Out\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/New_June\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates\\/\"},{\"id\":\"classes-3.29\",\"title\":\"Classes: Style Once, Apply Everywhere\",\"description\":\"Create Classes to define styling patterns once and apply them across your entire site with a single click. Add States for stunning hover and focus effects\\u2014no coding needed!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"style-tab-3.29\",\"title\":\"Consistent Styling Everywhere\",\"description\":\"Every V4 element shares the same styling capabilities in the same logical order and location. Plus, we\'ve streamlined from 3 tabs to just 2\\u2014content in one, styling in the other!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-style-tab.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"responsive-3.29\",\"title\":\"Fully Responsive Design\",\"description\":\"With Editor V4, every single style property can be customized per device. Complete creative control for desktop, tablet, and mobile!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-responsive.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"performance-3.29\",\"title\":\"Blazing fast performance\",\"description\":\"In Editor V4, each element uses one clean div instead of multiple nested divs like in the current version\\u2014your sites will load lightning-fast with cleaner code!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-performance.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"migration-host\",\"title\":\"Move to Better Cloud Hosting, Painlessly\",\"description\":\"Migrate your Elementor website for free to a home that\\u2019s perfect for it, in minutes, with a combination of\\u2028advanced automation and free expert support\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/migration-host.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\",\"readMoreText\":\"Learn More\",\"cta\":\"Migrate for free\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"introduction_meta\",\"meta\":\"ai_get_started\"}]],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Start Free Trial\",\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"hello-biz-contact\",\"title\":\"New Contact Widget, Visual Layout Presets & more\",\"description\":\"Hello Biz just got an update! Explore the new Contact Widget, Visual Layout Presets, Form Submissions integration, and fresh new kits.\",\"topic\":\"Hello Biz\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/hello-biz-contact.png\",\"chipTags\":[\"New Features\"],\"link\":\"https:\\/\\/go.elementor.com\\/hello-biz-updates\",\"readMoreText\":\"Learn More\"},{\"id\":\"ai-site-planner-colors\",\"title\":\"Style Your Wireframe, Speed Up Your Store Build\",\"description\":\"Site Planner now lets you style your wireframe with fonts and colors - instantly visualizing your site\\u2019s look and feel. Plus, it predesigns pages for WooCommerce like Cart and Checkout, so you can dive straight into customizations\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/site-planner-colors.png\",\"chipTags\":[\"New Feature\"],\"link\":\"http:\\/\\/www.elementor.com\\/ai-site-planner\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"grid-span-3.27\",\"title\":\"Design Grid layouts that fit your exact vision\",\"description\":\"Advanced column and row span controls give you the power to design Grid Container layouts that fit your exact vision.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/grid-span-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-grid-span-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"local-fonts-3.27\",\"title\":\"Load Google Fonts safer and faster\",\"description\":\"Once enabled, Google Fonts are served directly from your server, streamlining the loading process and enhancing security.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/local-google-fonts-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-local-fonts-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"video-shorts-3.27\",\"title\":\"Showcase short-form, vertical videos\",\"description\":\"The Video widget now supports YouTube Shorts in a vertical 9:16 ratio, the go-to format for engaging audiences.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/video-shorts-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-video-shorts-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"dynamic-off-canvas-3.26\",\"title\":\"Dynamic Off-Canvas for Loop Grids\",\"description\":\"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.\",\"topic\":\"Elementor Pro 3.26\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"dynamic-off-canvas-3.26\",\"title\":\"Dynamic Off-Canvas for Loop Grids\",\"description\":\"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.\",\"topic\":\"Elementor Pro 3.26\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-loop-off-canvas\\/\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}", "off");
INSERT INTO `wp_options` VALUES("272", "https_detection_errors", "a:1:{s:23:\"ssl_verification_failed\";a:1:{i:0;s:35:\"تأیید SSL ناموفق بود.\";}}", "off");
INSERT INTO `wp_options` VALUES("352", "_elementor_editor_upgrade_notice_dismissed", "1752492952", "auto");
INSERT INTO `wp_options` VALUES("404", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("473", "_elementor_settings_update_time", "1727181109", "auto");
INSERT INTO `wp_options` VALUES("474", "elementor_cpt_support", "a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}", "auto");
INSERT INTO `wp_options` VALUES("475", "elementor_allow_tracking", "no", "auto");
INSERT INTO `wp_options` VALUES("476", "elementor_google_maps_api_key", "", "auto");
INSERT INTO `wp_options` VALUES("477", "elementor_editor_break_lines", "", "auto");
INSERT INTO `wp_options` VALUES("478", "elementor_unfiltered_files_upload", "1", "auto");
INSERT INTO `wp_options` VALUES("479", "elementor_google_font", "1", "auto");
INSERT INTO `wp_options` VALUES("480", "elementor_load_fa4_shim", "", "auto");
INSERT INTO `wp_options` VALUES("481", "elementor_meta_generator_tag", "", "auto");
INSERT INTO `wp_options` VALUES("482", "elementor_css_print_method", "external", "auto");
INSERT INTO `wp_options` VALUES("483", "elementor_optimized_image_loading", "1", "auto");
INSERT INTO `wp_options` VALUES("484", "elementor_optimized_gutenberg_loading", "1", "auto");
INSERT INTO `wp_options` VALUES("485", "elementor_element_cache_ttl", "24", "auto");
INSERT INTO `wp_options` VALUES("486", "elementor_experiment-e_optimized_control_loading", "default", "auto");
INSERT INTO `wp_options` VALUES("487", "elementor_experiment-editor_v2", "active", "auto");
INSERT INTO `wp_options` VALUES("488", "elementor_experiment-landing-pages", "default", "auto");
INSERT INTO `wp_options` VALUES("489", "elementor_experiment-e_element_cache", "default", "auto");
INSERT INTO `wp_options` VALUES("494", "elementor_experiment-e_swiper_latest", "default", "auto");
INSERT INTO `wp_options` VALUES("623", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `wp_options` VALUES("625", "elementor_library_category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("669", "wpp_settings", "a:12:{s:12:\"persian_date\";s:6:\"enable\";s:12:\"submenu_move\";s:6:\"enable\";s:10:\"conv_title\";s:7:\"disable\";s:13:\"conv_contents\";s:7:\"disable\";s:12:\"conv_excerpt\";s:7:\"disable\";s:13:\"conv_comments\";s:7:\"disable\";s:18:\"conv_comment_count\";s:7:\"disable\";s:10:\"conv_dates\";s:7:\"disable\";s:9:\"conv_cats\";s:7:\"disable\";s:11:\"conv_arabic\";s:7:\"disable\";s:15:\"conv_permalinks\";s:7:\"disable\";s:11:\"news_source\";s:5:\"parsi\";}", "auto");
INSERT INTO `wp_options` VALUES("670", "widget_parsidate_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("671", "widget_parsidate_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("677", "new_admin_email", "wpthemeir@gmail.com", "auto");
INSERT INTO `wp_options` VALUES("741", "widget_harika_wp_cta_widget", "a:2:{i:2;a:5:{s:5:\"title\";s:46:\"وب سایت / قالب عالی بسازید\";s:11:\"button_text\";s:18:\"تماس با ما\";s:10:\"button_url\";s:1:\"#\";s:6:\"sticky\";s:0:\"\";s:5:\"width\";b:0;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("742", "widget_harika_wp_link_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("745", "widget_harika_wp_link_box_widget", "a:5:{i:3;a:9:{s:5:\"title\";s:13:\"فیس بوک\";s:4:\"text\";s:19:\"دنبال کنید\";s:3:\"url\";s:1:\"#\";s:4:\"icon\";s:22:\"fab fa-facebook-square\";s:5:\"color\";s:4:\"#fff\";s:8:\"bg_color\";s:7:\"#3b5998\";s:8:\"mgButtom\";s:3:\"-20\";s:6:\"sticky\";s:0:\"\";s:5:\"width\";b:0;}i:4;a:9:{s:5:\"title\";s:20:\"اینستاگرام\";s:4:\"text\";s:19:\"دنبال کنید\";s:3:\"url\";s:1:\"#\";s:4:\"icon\";s:16:\"fab fa-instagram\";s:5:\"color\";s:4:\"#fff\";s:8:\"bg_color\";s:7:\"#ff0088\";s:8:\"mgButtom\";s:3:\"-20\";s:6:\"sticky\";s:0:\"\";s:5:\"width\";b:0;}i:5;a:9:{s:5:\"title\";s:14:\"پینترست\";s:4:\"text\";s:15:\"پین کنید\";s:3:\"url\";s:1:\"#\";s:4:\"icon\";s:16:\"fab fa-pinterest\";s:5:\"color\";s:4:\"#fff\";s:8:\"bg_color\";s:7:\"#f0002a\";s:8:\"mgButtom\";s:1:\"0\";s:6:\"sticky\";s:0:\"\";s:5:\"width\";b:0;}i:6;a:9:{s:5:\"title\";s:12:\"اسکایپ\";s:4:\"text\";s:21:\"تماس بگیرید\";s:3:\"url\";s:1:\"#\";s:4:\"icon\";s:12:\"fab fa-skype\";s:5:\"color\";s:4:\"#fff\";s:8:\"bg_color\";s:7:\"#00aff0\";s:8:\"mgButtom\";s:3:\"-20\";s:6:\"sticky\";s:0:\"\";s:5:\"width\";b:0;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("954", "harika_menu_options_2", "a:1:{s:11:\"enable_menu\";s:2:\"on\";}", "auto");
INSERT INTO `wp_options` VALUES("1121", "category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("1132", "elementor_tracker_notice", "1", "auto");
INSERT INTO `wp_options` VALUES("1154", "duplicator_version_plugin", "1.5.13", "auto");
INSERT INTO `wp_options` VALUES("1157", "duplicator_uninstall_package", "1", "auto");
INSERT INTO `wp_options` VALUES("1158", "duplicator_uninstall_settings", "1", "auto");
INSERT INTO `wp_options` VALUES("1159", "duplicator_settings", "a:19:{s:7:\"version\";s:6:\"1.5.13\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";s:1:\"0\";s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";s:1:\"0\";s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";s:1:\"2\";s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:17;s:14:\"usage_tracking\";b:0;}", "auto");
INSERT INTO `wp_options` VALUES("1162", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-07-21 13:16:05\";s:7:\"Version\";s:6:\"1.5.13\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:7:\"10.6.22\";s:10:\"VersionPHP\";s:6:\"8.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:10:\"harika_v42\";s:4:\"Hash\";s:35:\"446b128a7c7b883c1127_20250721131605\";s:8:\"NameHash\";s:46:\"harika_v42_446b128a7c7b883c1127_20250721131605\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:56:\"harika_v42_446b128a7c7b883c1127_20250721131605_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:69:\"/home/webdevde/public_html/harika/harika/wp-content/themes/harika.rar\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:40:\"/home/webdevde/public_html/harika/harika\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1306;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:9601;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-07-21 13:16:05\";s:7:\"Version\";s:6:\"1.5.13\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:7:\"10.6.22\";s:10:\"VersionPHP\";s:6:\"8.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:10:\"harika_v42\";s:4:\"Hash\";s:35:\"446b128a7c7b883c1127_20250721131605\";s:8:\"NameHash\";s:46:\"harika_v42_446b128a7c7b883c1127_20250721131605\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:54:\"/home/webdevde/public_html/harika/harika/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:49:\"/home/webdevde/public_html/harika/harika/wp-admin\";i:1;s:52:\"/home/webdevde/public_html/harika/harika/wp-includes\";i:2;s:61:\"/home/webdevde/public_html/harika/harika/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:40:\"/home/webdevde/public_html/harika/harika\";i:1;s:40:\"/home/webdevde/public_html/harika/harika\";i:2;s:51:\"/home/webdevde/public_html/harika/harika/wp-content\";i:3;s:59:\"/home/webdevde/public_html/harika/harika/wp-content/uploads\";i:4;s:59:\"/home/webdevde/public_html/harika/harika/wp-content/plugins\";i:5;s:62:\"/home/webdevde/public_html/harika/harika/wp-content/mu-plugins\";i:6;s:58:\"/home/webdevde/public_html/harika/harika/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:72:\"/home/webdevde/public_html/harika/harika/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "auto");
INSERT INTO `wp_options` VALUES("1163", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[],\"failedPackageIds\":[]}", "auto");
INSERT INTO `wp_options` VALUES("1384", "duplicator_dismissed_admin_notices", "a:1:{s:14:\"review_request\";a:1:{s:4:\"time\";i:1724613532;}}", "on");
INSERT INTO `wp_options` VALUES("2341", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:19:\"wpthemeir@gmail.com\";s:7:\"version\";s:5:\"6.8.1\";s:9:\"timestamp\";i:1746370504;}", "off");
INSERT INTO `wp_options` VALUES("2867", "elementor_experiment-inline_font_icons", "inactive", "auto");
INSERT INTO `wp_options` VALUES("2957", "elementor_lazy_load_background_images", "1", "auto");
INSERT INTO `wp_options` VALUES("3127", "duplicator_pro_exe_safe_mode", "0", "yes");
INSERT INTO `wp_options` VALUES("3128", "duplicator_activate_plugins_after_installation", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("3149", "action_scheduler_hybrid_store_demarkation", "2147", "auto");
INSERT INTO `wp_options` VALUES("3150", "schema-ActionScheduler_StoreSchema", "7.0.1727352058", "auto");
INSERT INTO `wp_options` VALUES("3151", "schema-ActionScheduler_LoggerSchema", "3.0.1727352058", "auto");
INSERT INTO `wp_options` VALUES("3164", "action_scheduler_lock_async-request-runner", "687e0c84a40d28.14067303|1753091264", "no");
INSERT INTO `wp_options` VALUES("3214", "rcuPluginLastHealthyServerIndex", "7", "off");
INSERT INTO `wp_options` VALUES("3220", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("10055", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("10720", "elementor_checklist", "{\"last_opened_timestamp\":-1,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"editor_visit_count\":0,\"should_open_in_editor\":false}", "auto");
INSERT INTO `wp_options` VALUES("10745", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"23.8\";}", "auto");
INSERT INTO `wp_options` VALUES("10746", "wpseo", "a:105:{s:8:\"tracking\";b:1;s:16:\"toggled_tracking\";b:1;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:0;s:16:\"indexing_started\";i:1731835776;s:15:\"indexing_reason\";s:13:\"first_install\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:100:\"TnNRWrq1dexKWIzu5iTVWI1rUfuGmDKHk7AdjMqqVsY3ZoFW9G601c8ud2nE2of2mwMgxYNFz3THK187e-BgDSsRFSSfqbygMmSw\";s:7:\"version\";s:4:\"23.8\";s:16:\"previous_version\";s:0:\"\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:1;s:22:\"ai_enabled_pre_default\";b:0;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1731835712;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:0:\"\";s:8:\"home_url\";s:0:\"\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:0:{}s:29:\"enable_enhanced_slack_sharing\";b:1;s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:0:{}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:18:\"first_time_install\";b:1;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";i:1731835715;s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:19:\"deny_ccbot_crawling\";b:0;s:29:\"deny_google_extended_crawling\";b:0;s:20:\"deny_gptbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:4:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:18:\"e-floating-buttons\";i:3;s:15:\"harika_template\";}s:28:\"last_known_public_taxonomies\";a:3:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";}s:23:\"last_known_no_unindexed\";a:1:{s:40:\"wpseo_total_unindexed_post_type_archives\";i:1731835715;}s:14:\"new_post_types\";a:0:{}s:14:\"new_taxonomies\";a:0:{}s:34:\"show_new_content_type_notification\";b:0;}", "auto");
INSERT INTO `wp_options` VALUES("10747", "wpseo_titles", "a:162:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:51:\"%%name%%, نویسنده در %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:84:\"شما برای %%searchphrase%% جستجو کردید %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:45:\"صفحه پیدا نشد %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:79:\"نوشته %%POSTLINK%% اولین بار در %%BLOGLINK%%. پدیدار شد.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:38:\"خطای 404: صفحه پیدا نشد\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:30:\"بایگانی‌ها برای\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:8:\"خانه\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:39:\"شما جستجو نمودید برای\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:24:\"publishing_principles_id\";i:0;s:25:\"ownership_funding_info_id\";i:0;s:29:\"actionable_feedback_policy_id\";i:0;s:21:\"corrections_policy_id\";i:0;s:16:\"ethics_policy_id\";i:0;s:19:\"diversity_policy_id\";i:0;s:28:\"diversity_staffing_report_id\";i:0;s:15:\"org-description\";s:0:\"\";s:9:\"org-email\";s:0:\"\";s:9:\"org-phone\";s:0:\"\";s:14:\"org-legal-name\";s:0:\"\";s:17:\"org-founding-date\";s:0:\"\";s:20:\"org-number-employees\";s:0:\"\";s:10:\"org-vat-id\";s:0:\"\";s:10:\"org-tax-id\";s:0:\"\";s:7:\"org-iso\";s:0:\"\";s:8:\"org-duns\";s:0:\"\";s:11:\"org-leicode\";s:0:\"\";s:9:\"org-naics\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:24:\"title-e-floating-buttons\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:27:\"metadesc-e-floating-buttons\";s:0:\"\";s:26:\"noindex-e-floating-buttons\";b:0;s:37:\"display-metabox-pt-e-floating-buttons\";b:1;s:37:\"post_types-e-floating-buttons-maintax\";i:0;s:35:\"schema-page-type-e-floating-buttons\";s:7:\"WebPage\";s:38:\"schema-article-type-e-floating-buttons\";s:4:\"None\";s:31:\"social-title-e-floating-buttons\";s:9:\"%%title%%\";s:37:\"social-description-e-floating-buttons\";s:0:\"\";s:35:\"social-image-url-e-floating-buttons\";s:0:\"\";s:34:\"social-image-id-e-floating-buttons\";i:0;s:23:\"title-elementor_library\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-elementor_library\";s:0:\"\";s:25:\"noindex-elementor_library\";b:0;s:36:\"display-metabox-pt-elementor_library\";b:1;s:36:\"post_types-elementor_library-maintax\";i:0;s:34:\"schema-page-type-elementor_library\";s:7:\"WebPage\";s:37:\"schema-article-type-elementor_library\";s:4:\"None\";s:30:\"social-title-elementor_library\";s:9:\"%%title%%\";s:36:\"social-description-elementor_library\";s:0:\"\";s:34:\"social-image-url-elementor_library\";s:0:\"\";s:33:\"social-image-id-elementor_library\";i:0;s:21:\"title-harika_template\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-harika_template\";s:0:\"\";s:23:\"noindex-harika_template\";b:0;s:34:\"display-metabox-pt-harika_template\";b:1;s:34:\"post_types-harika_template-maintax\";i:0;s:32:\"schema-page-type-harika_template\";s:7:\"WebPage\";s:35:\"schema-article-type-harika_template\";s:4:\"None\";s:28:\"social-title-harika_template\";s:9:\"%%title%%\";s:34:\"social-description-harika_template\";s:0:\"\";s:32:\"social-image-url-harika_template\";s:0:\"\";s:31:\"social-image-id-harika_template\";i:0;s:18:\"title-tax-category\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:38:\"بایگانی‌های %%term_title%%\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:26:\"taxonomy-category-ptparent\";i:0;s:18:\"title-tax-post_tag\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:38:\"بایگانی‌های %%term_title%%\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:26:\"taxonomy-post_tag-ptparent\";i:0;s:21:\"title-tax-post_format\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:38:\"بایگانی‌های %%term_title%%\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:29:\"taxonomy-post_format-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:17:\"company_logo_meta\";b:0;s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}", "auto");
INSERT INTO `wp_options` VALUES("10748", "wpseo_social", "a:20:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:0:{}s:12:\"mastodon_url\";s:0:\"\";}", "auto");
INSERT INTO `wp_options` VALUES("10749", "yoast_premium_as_an_addon_installer", "completed", "on");
INSERT INTO `wp_options` VALUES("10750", "yoast_migrations_premium", "a:1:{s:7:\"version\";s:4:\"23.8\";}", "auto");
INSERT INTO `wp_options` VALUES("10751", "wpseo_premium", "a:5:{s:34:\"prominent_words_indexing_completed\";b:0;s:8:\"workouts\";a:1:{s:11:\"cornerstone\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:29:\"should_redirect_after_install\";b:0;s:29:\"activation_redirect_timestamp\";i:1731835715;s:35:\"dismiss_update_premium_notification\";s:1:\"0\";}", "auto");
INSERT INTO `wp_options` VALUES("10753", "wpseo_current_version", "16", "off");
INSERT INTO `wp_options` VALUES("10754", "wpseo_premium_version", "23.8", "auto");
INSERT INTO `wp_options` VALUES("10755", "wpseo-premium-redirects-export-plain", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("10756", "wpseo-premium-redirects-export-regex", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("10782", "wpseo_tracking_last_request", "1731835716", "on");
INSERT INTO `wp_options` VALUES("12949", "rtl_rsm_delayTime", "a:6:{s:8:\"wpLoaded\";i:1753103764;s:10:\"selfUpdate\";i:1753122717;s:22:\"checkUpdateProductList\";i:1750929466;s:7:\"runPing\";i:1753104898;s:14:\"runDebugServer\";i:1753141854;s:18:\"deleteDownloadFile\";i:0;}", "off");
INSERT INTO `wp_options` VALUES("12950", "auto_update_themes", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("12951", "rtl_rsm_autoUpdate", "a:2:{s:7:\"plugins\";a:0:{}s:6:\"themes\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("12954", "rtl_rsm_server", "a:2:{s:18:\"firstHandShakeTime\";i:1753104217;s:11:\"lastChecked\";i:5;}", "off");
INSERT INTO `wp_options` VALUES("12956", "rtl_rsm_localProducts", "XY89C4MwGIT_imRuY9QYo1C6dWqXUjplCS8phvqFRhzE_95ohEiXg7vL5eGdUZIymTClIp4CAM1RMaObrtRb9YNuG1SgCBOcoxN66OYJ4zHPMLH5S5tKWS9Gwmi2arxpEq0KsKrMfU4g2Aw_DOT_gLLtEY39jlI3c0W6GfAFzVyx9_zAoP4T-XGMwEcO6OA7ibncHnfXzdfeVhrTDYUIRThNE-5NdTalqhWGthbhtbtEPCYkR8vyAw", "on");
INSERT INTO `wp_options` VALUES("12957", "rtl_rsm_lastSync", "1733003140", "off");
INSERT INTO `wp_options` VALUES("12981", "rtl_rsm_dashboard", "a:2:{s:13:\"slideshowList\";a:3:{i:0;a:4:{s:4:\"type\";s:6:\"Slider\";s:5:\"title\";s:52:\"پروهاست وردپرس راست چین کلود\";s:8:\"imageUrl\";s:91:\"https://content-marketing.rtlcdn.com/image/2025/06/07ba6c1e-dec7-445b-b005-5e887a784fed.png\";s:7:\"ctaLink\";s:51:\"https://cloud.rtl-theme.com/wordpress-hosting-plans\";}i:1;a:4:{s:4:\"type\";s:6:\"Slider\";s:5:\"title\";s:46:\"گزارس سال وردپرس ایران 1404\";s:8:\"imageUrl\";s:92:\"https://content-marketing.rtlcdn.com/image/2025/06/151ec296-bbca-462c-927e-fca0ebf13410.webp\";s:7:\"ctaLink\";s:48:\"https://www.rtl-theme.com/landings/wpreport1404/\";}i:2;a:4:{s:4:\"type\";s:6:\"Slider\";s:5:\"title\";s:28:\"آکادمی راست چین\";s:8:\"imageUrl\";s:91:\"https://content-marketing.rtlcdn.com/image/2025/06/08f58286-b759-4cf3-878c-8ede408c30cd.png\";s:7:\"ctaLink\";s:30:\"https://academy.rtl-theme.com/\";}}s:17:\"dashboardSyncTime\";i:1753094116;}", "off");
INSERT INTO `wp_options` VALUES("12982", "rtl_rsm_announcements", "a:2:{s:12:\"lastSyncTime\";i:1753094116;s:4:\"List\";a:9:{i:284623;a:10:{s:2:\"id\";i:3;s:15:\"announcement_id\";i:284623;s:5:\"title\";s:49:\"💥 انفجاری بزرگ در راهه…💥\";s:7:\"excerpt\";s:283:\"<p>❌ بزرگ‌ترین بلک فرایدی ایران در راه است&#8230; ❌ 😲 آماده‌ی یک اتفاق هیجان‌انگیز در راست‌چین هستی؟ 💥 این آخر هفته قراره حسابی بترکونیم! 💥 آماده باش 🤩</p>\n\";s:7:\"content\";s:688:\"<p><img loading=\"lazy\" decoding=\"async\" class=\"alignnone size-full \" src=\"https://media.rtlcdn.com/2024/11/a007306ff33005b96e9f140295e96f6ea27741b39fdf21.png\" alt=\"\" width=\"1203\" height=\"294\" /></p>\n<p><strong>❌ بزرگ‌ترین بلک فرایدی ایران در راه است&#8230; ❌</strong></p>\n<p>😲 آماده‌ی یک اتفاق هیجان‌انگیز در <strong>راست‌چین</strong> هستی؟</p>\n<p>💥 این آخر هفته قراره حسابی بترکونیم! 💥</p>\n<p><a href=\"https://www.rtl-theme.com/landings/blackfriday/?utm_source=etelaie&amp;utm_medium=site&amp;utm_campaign=blackfriday1403\"><strong>آماده باش 🤩</strong></a></p>\n\";s:5:\"image\";s:100:\"https://www.rtl-theme.com/wp-content/themes/rtl-theme/assets/images/defaults/product-cover-large.png\";s:8:\"category\";N;s:6:\"sticky\";N;s:10:\"created_at\";s:27:\"2024-11-24T06:03:46.000000Z\";s:10:\"updated_at\";s:27:\"2024-11-24T06:03:46.000000Z\";}i:284590;a:10:{s:2:\"id\";i:2;s:15:\"announcement_id\";i:284590;s:5:\"title\";s:49:\"💥 انفجاری بزرگ در راهه…💥\";s:7:\"excerpt\";s:283:\"<p>❌ بزرگ‌ترین بلک فرایدی ایران در راه است&#8230; ❌ 😲 آماده‌ی یک اتفاق هیجان‌انگیز در راست‌چین هستی؟ 💥 این آخر هفته قراره حسابی بترکونیم! 💥 آماده باش 🤩</p>\n\";s:7:\"content\";s:688:\"<p><img loading=\"lazy\" decoding=\"async\" class=\"alignnone size-full \" src=\"https://media.rtlcdn.com/2024/11/a007306ff33005b96e9f140295e96f6ea27741b39fdf21.png\" alt=\"\" width=\"1203\" height=\"294\" /></p>\n<p><strong>❌ بزرگ‌ترین بلک فرایدی ایران در راه است&#8230; ❌</strong></p>\n<p>😲 آماده‌ی یک اتفاق هیجان‌انگیز در <strong>راست‌چین</strong> هستی؟</p>\n<p>💥 این آخر هفته قراره حسابی بترکونیم! 💥</p>\n<p><a href=\"https://www.rtl-theme.com/landings/blackfriday/?utm_source=etelaie&amp;utm_medium=site&amp;utm_campaign=blackfriday1403\"><strong>آماده باش 🤩</strong></a></p>\n\";s:5:\"image\";s:100:\"https://www.rtl-theme.com/wp-content/themes/rtl-theme/assets/images/defaults/product-cover-large.png\";s:8:\"category\";N;s:6:\"sticky\";N;s:10:\"created_at\";s:27:\"2024-11-24T06:03:22.000000Z\";s:10:\"updated_at\";s:27:\"2024-11-24T06:03:22.000000Z\";}i:284262;a:10:{s:2:\"id\";i:1;s:15:\"announcement_id\";i:284262;s:5:\"title\";s:80:\"بروزرسانی مهم افزونه مدیریت هوشمند راست چین\";s:7:\"excerpt\";s:501:\"<p>با توجه به انتشار و بروزرسانی نسخه جدید وردپرس ( 6.7 ) و تغییرات به وجود آمده در ساختار آن، جهت کارکرد مناسب محصولات خریداری شده از راست چین و رفع مشکلات گزارش شده در رابطه با توابع ترجمه وردپرس، لازم است  افزونه مدیریت هوشمند راست چین را به آخرین نسخه ( 2.3.1 ) بروزرسانی نمایید.</p>\n\";s:7:\"content\";s:563:\"<p>با توجه به انتشار و بروزرسانی نسخه جدید وردپرس ( 6.7 ) و تغییرات به وجود آمده در ساختار آن، جهت کارکرد مناسب محصولات خریداری شده از راست چین و رفع مشکلات گزارش شده در رابطه با توابع ترجمه وردپرس، لازم است  <a href=\"https://www.rtl-theme.com/rtl-smart-management/\">افزونه مدیریت هوشمند راست چین</a> را به آخرین نسخه ( 2.3.1 ) بروزرسانی نمایید.</p>\n\";s:5:\"image\";s:100:\"https://www.rtl-theme.com/wp-content/themes/rtl-theme/assets/images/defaults/product-cover-large.png\";s:8:\"category\";N;s:6:\"sticky\";N;s:10:\"created_at\";s:27:\"2024-11-18T05:16:59.000000Z\";s:10:\"updated_at\";s:27:\"2024-11-18T05:16:59.000000Z\";}i:294627;a:10:{s:2:\"id\";i:9;s:15:\"announcement_id\";i:294627;s:5:\"title\";s:57:\"خدمات اضطراری راست چین سرویس 💚\";s:7:\"excerpt\";s:988:\"<p>💚 همراه کسب و کار شما هستیم! اگر همچنان وبسایت شما با مشکلات دسترس پذیری مواجه هست ، راست چین آماده است که به صورت رایگان وبسایت‌های شما رو بررسی کرده و مشکلاتی مثل عدم دسترس پذیری، بک‌آپ‌ گیری ،سلامت درگاه‌های پرداخت و &#8230; چک کرده  و به اطلاع شما عزیزان برساند. 🔍 در خدمات اضطراری راست چین سرویس چه مواردی انجام می‌شود؟ ✅ بررسی در دسترس بودن سایت ✅ بک‌آپ‌ گیری کامل از سایت ✅ بررسی سلامت درگاه پرداخت ✅ مانیتورینگ آپ‌ تایم همین الان آدرس وبسایتت رو برای ما بفرست تا مجموعه‌ای از اقدامات سریع  و پیشگیرانه در خصوص وبسایت و کسب [&hellip;]</p>\n\";s:7:\"content\";s:1540:\"<p><a href=\"https://www.rtl-theme.com/service/emergency-services/\"><img decoding=\"async\" src=\"https://files.rtl-theme.com/products/content/2025/06/38350_ff7139371177a2d14d77052f2.gif\" /></a></p>\n<p><b>💚 همراه کسب و کار شما هستیم!</b></p>\n<p>اگر همچنان وبسایت شما با مشکلات دسترس پذیری مواجه هست ، راست چین آماده است که <strong>به صورت رایگان</strong> وبسایت‌های شما رو بررسی کرده و مشکلاتی مثل عدم دسترس پذیری، بک‌آپ‌ گیری ،سلامت درگاه‌های پرداخت و &#8230; چک کرده  و به اطلاع شما عزیزان برساند.</p>\n<p><b>🔍 در خدمات اضطراری راست چین سرویس چه مواردی انجام می‌شود؟<br />\n</b>✅ بررسی در دسترس بودن سایت<br />\n✅ بک‌آپ‌ گیری کامل از سایت<br />\n✅ بررسی سلامت درگاه پرداخت<br />\n✅ مانیتورینگ آپ‌ تایم</p>\n<p>همین الان آدرس وبسایتت رو برای ما بفرست تا مجموعه‌ای از اقدامات سریع  و پیشگیرانه در خصوص وبسایت و کسب و کار شما انجام بشه!</p>\n<p><strong>💚 راست‌ چین، پشتیبان کسب‌وکار شما در سخت‌ترین شرایط 💚</strong></p>\n<p><a href=\"https://www.rtl-theme.com/service/emergency-services/\"><strong>✅ ثبت سفارش رایگان</strong></a></p>\n\";s:5:\"image\";s:100:\"https://www.rtl-theme.com/wp-content/themes/rtl-theme/assets/images/defaults/product-cover-large.png\";s:8:\"category\";N;s:6:\"sticky\";N;s:10:\"created_at\";s:27:\"2025-06-24T04:54:55.000000Z\";s:10:\"updated_at\";s:27:\"2025-06-24T06:23:29.000000Z\";}i:292863;a:10:{s:2:\"id\";i:12;s:15:\"announcement_id\";i:292863;s:5:\"title\";s:60:\"🔥 گزارش سال وردپرس ایران ۱۴۰۴ 🔥\";s:7:\"excerpt\";s:1042:\"<p>📣 نشست خبری رونمایی گزارش سال وردپرس ایران ۱۴۰۴ توسط راست چین ⬅️ راست‌چین، بزرگ‌ترین مارکت تخصصی قالب و افزونه وردپرس در ایران، روز پنجشنبه ۱۸ اردیبهشت ۱۴۰۴ نشست خبری رونمایی از &#8220;گزارش سال وردپرس ایران ۱۴۰۴ &#8221; را با حضور بیش از ۱۰۰ نفر از اصحاب رسانه و فعالان حوزه‌ی وردپرس منتشر کرد. ⬅️ این گزارش با نگاهی جامع به تاریخچه وردپرس، آمار‌های کلیدی و چشم‌انداز آینده آن، تصویری روشن از روند رشد این پلتفرم محبوب در ایران و جهان ارائه می‌دهد و منبعی ارزشمند برای توسعه‌دهندگان، طراحان وب و علاقه‌مندان به فناوری و کارآفرینی دیجیتال به‌شمار می‌رود. دانلود [&hellip;]</p>\n\";s:7:\"content\";s:1615:\"<p><a href=\"https://www.rtl-theme.com/landings/wpreport1404/?utm_source=etelaie&amp;utm_medium=site&amp;utm_campaign=wpreport1404\"><img loading=\"lazy\" decoding=\"async\" class=\"alignnone size-full \" src=\"https://media.rtlcdn.com/2025/05/33213e4c796fc1951710e9341811e9f7658a61e429beeb.jpg\" alt=\"\" width=\"1203\" height=\"294\" /></a></p>\n<p><strong>📣 نشست خبری رونمایی گزارش سال وردپرس ایران ۱۴۰۴ توسط راست چین</strong></p>\n<p>⬅️ راست‌چین، بزرگ‌ترین مارکت تخصصی قالب و افزونه وردپرس در ایران، روز پنجشنبه ۱۸ اردیبهشت ۱۴۰۴ نشست خبری رونمایی از &#8220;گزارش سال وردپرس ایران ۱۴۰۴ &#8221; را با حضور بیش از ۱۰۰ نفر از اصحاب رسانه و فعالان حوزه‌ی وردپرس منتشر کرد.</p>\n<p>⬅️ این گزارش با نگاهی جامع به تاریخچه وردپرس، آمار‌های کلیدی و چشم‌انداز آینده آن، تصویری روشن از روند رشد این پلتفرم محبوب در ایران و جهان ارائه می‌دهد و منبعی ارزشمند برای توسعه‌دهندگان، طراحان وب و علاقه‌مندان به فناوری و کارآفرینی دیجیتال به‌شمار می‌رود.</p>\n<p><a href=\"https://www.rtl-theme.com/landings/wpreport1404/?utm_source=etelaie&amp;utm_medium=site&amp;utm_campaign=wpreport1404\"><strong>دانلود رایگان گزارش سال وردپرس ایران ۱۴۰۴ </strong></a></p>\n\";s:5:\"image\";s:100:\"https://www.rtl-theme.com/wp-content/themes/rtl-theme/assets/images/defaults/product-cover-large.png\";s:8:\"category\";N;s:6:\"sticky\";N;s:10:\"created_at\";s:27:\"2025-05-25T10:15:32.000000Z\";s:10:\"updated_at\";s:27:\"2025-05-25T10:15:32.000000Z\";}i:292314;a:10:{s:2:\"id\";i:11;s:15:\"announcement_id\";i:292314;s:5:\"title\";s:38:\"افزایش قیمت متوقف شد!\";s:7:\"excerpt\";s:564:\"<p>📢 افزایش قیمت فعلا متوقف شد! 📌 آخرین فرصت برای خرید محصولات راست چین به قیمت قبل ⏳ فقط تا 15 اردیبهشت فرصت دارید، پس خریدتون رو به تعویق نیندازید و تا وقتی که قیمت‌ها پایین هست، خرید کنید! 🎁 هدیه ویژه ما برای شما 100 هزار تومان هدیه داریم! ❌ همین الان وارد لینک زیرشو و خریدتو نهایی کن که فرصتی نیست! وقت خریده</p>\n\";s:7:\"content\";s:1147:\"<p><a href=\"https://www.rtl-theme.com/landings/price-increase-1404/?utm_source=etelaie&amp;utm_medium=site&amp;utm_campaign=price-increase-1404\"><img loading=\"lazy\" decoding=\"async\" class=\"alignnone size-full \" src=\"https://media.rtlcdn.com/2025/04/2e2170f162e79658a91bee51cbe5f11333c4e029501245.jpg\" alt=\"\" width=\"1203\" height=\"294\" /></a></p>\n<p><strong>📢 افزایش قیمت </strong>فعلا<strong> متوقف شد!</strong></p>\n<p>📌 آخرین فرصت برای خرید محصولات راست چین به قیمت قبل</p>\n<p>⏳ فقط تا 15 اردیبهشت فرصت دارید، پس خریدتون رو به تعویق نیندازید و تا وقتی که قیمت‌ها پایین هست، خرید کنید!</p>\n<p>🎁 هدیه ویژه<br />\nما برای شما 100 هزار تومان هدیه داریم!</p>\n<p>❌ همین الان وارد لینک زیرشو و خریدتو نهایی کن که فرصتی نیست!</p>\n<p><a href=\"https://www.rtl-theme.com/landings/price-increase-1404/?utm_source=etelaie&amp;utm_medium=site&amp;utm_campaign=price-increase-1404\"><strong>وقت خریده</strong></a></p>\n\";s:5:\"image\";s:100:\"https://www.rtl-theme.com/wp-content/themes/rtl-theme/assets/images/defaults/product-cover-large.png\";s:8:\"category\";N;s:6:\"sticky\";N;s:10:\"created_at\";s:27:\"2025-05-25T06:08:41.000000Z\";s:10:\"updated_at\";s:27:\"2025-05-25T06:08:41.000000Z\";}i:286736;a:10:{s:2:\"id\";i:10;s:15:\"announcement_id\";i:286736;s:5:\"title\";s:71:\"جدیدترین قابلیت راست چین رونمایی شد! 💚\";s:7:\"excerpt\";s:592:\"<p>با ست‌آپ راست‌چین، سرعت و راحتی رو تجربه کن!  سریع‌ترین و آسان‌ترین روش نصب قالب و افزونه وردپرس، فقط با یک کلیک! ویژگی‌های خفن این محصول: نصب فوق‌العاده سریع، فقط با یک کلیک صرفه‌جویی در زمان و انرژی امنیت بی‌نظیر با API key و Self Destruct انتخاب دموهای متنوع و حرفه‌ای با ست آپ 5 دقیقه ای سایتت رو بساز ! دانــــلود رایـــــگان</p>\n\";s:7:\"content\";s:1176:\"<p><a href=\"https://www.rtl-theme.com/landings/rtlsp/?utm_source=Smart-etelaie&amp;utm_medium=site&amp;utm_campaign=rtlsp\"><img loading=\"lazy\" decoding=\"async\" class=\"alignnone size-full \" src=\"https://media.rtlcdn.com/2025/01/ea721a86503e6101094326773504f421038d0a1d47d790.jpg\" alt=\"\" width=\"1380\" height=\"290\" /></a></p>\n<p><strong>با ست‌آپ راست‌چین، سرعت و راحتی رو تجربه کن! </strong></p>\n<p><strong>سریع‌ترین </strong>و<strong> آسان‌ترین</strong> روش نصب قالب و افزونه وردپرس، فقط با یک کلیک!</p>\n<p><strong>ویژگی‌های خفن این محصول:</strong><br />\nنصب فوق‌العاده سریع، فقط با یک کلیک<br />\nصرفه‌جویی در زمان و انرژی<br />\nامنیت بی‌نظیر با API key و Self Destruct<br />\nانتخاب دموهای متنوع و حرفه‌ای</p>\n<p>با ست آپ 5 دقیقه ای سایتت رو بساز !</p>\n<p><a href=\"https://www.rtl-theme.com/landings/rtlsp/?utm_source=Smart-etelaie&amp;utm_medium=site&amp;utm_campaign=rtlsp\"><strong>دانــــلود رایـــــگان</strong></a></p>\n\";s:5:\"image\";s:100:\"https://www.rtl-theme.com/wp-content/themes/rtl-theme/assets/images/defaults/product-cover-large.png\";s:8:\"category\";N;s:6:\"sticky\";N;s:10:\"created_at\";s:27:\"2025-01-07T10:35:14.000000Z\";s:10:\"updated_at\";s:27:\"2025-01-07T10:35:14.000000Z\";}i:285893;a:10:{s:2:\"id\";i:9;s:15:\"announcement_id\";i:285893;s:5:\"title\";s:70:\"یلدای شگفت انگیز راست چین رو به پایانه!\";s:7:\"excerpt\";s:258:\"<p>یلدای شگفت انگیز راست چین داره تموم میشه &#8230;👀 ❌ پایان جشنواره یعنی پایان تخفیف‌ها پس همین الان کلیک کن چون دیگه تکرار نمیشه! عجله کن &nbsp;</p>\n\";s:7:\"content\";s:756:\"<p><a href=\"https://www.rtl-theme.com/landings/yalda/?utm_source=etelaie&amp;utm_medium=site&amp;utm_campaign=yalda1403\"><img loading=\"lazy\" decoding=\"async\" class=\"alignnone size-full \" src=\"https://media.rtlcdn.com/2024/12/659135d0721a370824b7e6f63169d4eaab6272323f71c7.jpg\" alt=\"\" width=\"1203\" height=\"294\" /></a></p>\n<p><strong>یلدای شگفت انگیز راست چین داره تموم میشه &#8230;👀</strong></p>\n<p>❌ پایان جشنواره یعنی پایان تخفیف‌ها پس همین الان کلیک کن چون دیگه تکرار نمیشه!</p>\n<p><a href=\"https://www.rtl-theme.com/landings/yalda/?utm_source=etelaie&amp;utm_medium=site&amp;utm_campaign=yalda1403\"><strong>عجله کن</strong></a></p>\n<p>&nbsp;</p>\n\";s:5:\"image\";s:100:\"https://www.rtl-theme.com/wp-content/themes/rtl-theme/assets/images/defaults/product-cover-large.png\";s:8:\"category\";N;s:6:\"sticky\";N;s:10:\"created_at\";s:27:\"2024-12-21T07:40:05.000000Z\";s:10:\"updated_at\";s:27:\"2024-12-21T07:40:05.000000Z\";}i:285758;a:10:{s:2:\"id\";i:8;s:15:\"announcement_id\";i:285758;s:5:\"title\";s:27:\"یلدا شروع شد 🍉\";s:7:\"excerpt\";s:625:\"<p>🍉 یلدای شگفت انگیز راست چین 🍉 شگفتی این یلدات با ما🤩 دوستت رو بیار و جایزه ببر❤️ هیجان یلدات با گردونه شانس راست چین🔸 تا 80% تخفیف روی بهترین محصولات راست چین☄️ انار طلایی رو پیدا کن و هر محصولی که میخوای رو با 80% تخفیف بخر!👀 و کلی شگفتی دیگه فقط در یلدای امسال!💥 🤝 همین الان وارد لینک زیرشو و انتخاب کن چه شگفتی ای رو میخوای! بریم به یلدا</p>\n\";s:7:\"content\";s:1152:\"<p><a href=\"https://www.rtl-theme.com/landings/yalda/?utm_source=etelaie&amp;utm_medium=site&amp;utm_campaign=yalda1403\"><img loading=\"lazy\" decoding=\"async\" class=\"alignnone size-full \" src=\"https://media.rtlcdn.com/2024/12/216a4c0761381e79655a671e6fd2fb1b8533a101397d7.gif\" alt=\"\" width=\"1203\" height=\"294\" /></a></p>\n<p><strong>🍉 یلدای شگفت انگیز راست چین 🍉</strong></p>\n<p>شگفتی این یلدات با ما🤩<br />\nدوستت رو بیار و جایزه ببر❤️<br />\nهیجان یلدات با گردونه شانس راست چین🔸<br />\nتا 80% تخفیف روی بهترین محصولات راست چین☄️<br />\nانار طلایی رو پیدا کن و هر محصولی که میخوای رو با 80% تخفیف بخر!👀<br />\nو کلی شگفتی دیگه فقط در یلدای امسال!💥</p>\n<p>🤝 همین الان وارد لینک زیرشو و انتخاب کن چه شگفتی ای رو میخوای!</p>\n<p><a href=\"https://www.rtl-theme.com/landings/yalda/?utm_source=etelaie&amp;utm_medium=site&amp;utm_campaign=yalda1403\"><strong>بریم به یلد</strong>ا</a></p>\n\";s:5:\"image\";s:100:\"https://www.rtl-theme.com/wp-content/themes/rtl-theme/assets/images/defaults/product-cover-large.png\";s:8:\"category\";N;s:6:\"sticky\";N;s:10:\"created_at\";s:27:\"2024-12-18T05:18:19.000000Z\";s:10:\"updated_at\";s:27:\"2024-12-18T05:18:19.000000Z\";}}}", "off");
INSERT INTO `wp_options` VALUES("12983", "rtl_rsm_themesUpdate", "a:2:{s:4:\"list\";a:0:{}s:9:\"lastCheck\";i:1753122717;}", "off");
INSERT INTO `wp_options` VALUES("12984", "rtl_rsm_pluginsUpdate", "a:2:{s:4:\"list\";a:0:{}s:9:\"lastCheck\";i:1753122717;}", "off");
INSERT INTO `wp_options` VALUES("13018", "rtl_rsm_tryToSendLicenceEmail", "1753112653", "off");
INSERT INTO `wp_options` VALUES("13020", "rtl_rsm_transient", "a:1:{s:13:\"updatePlugins\";a:2:{s:9:\"transient\";O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1741516361;s:8:\"response\";a:6:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"5.3.7\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.5.3.7.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731\";s:2:\"1x\";s:62:\"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"requires_php\";s:6:\"5.6.20\";s:16:\"requires_plugins\";a:0:{}}s:33:\"classic-editor/classic-editor.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:28:\"w.org/plugins/classic-editor\";s:4:\"slug\";s:14:\"classic-editor\";s:6:\"plugin\";s:33:\"classic-editor/classic-editor.php\";s:11:\"new_version\";s:5:\"1.6.7\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/classic-editor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/classic-editor.1.6.7.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-256x256.png?rev=1998671\";s:2:\"1x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-128x128.png?rev=1998671\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/classic-editor/assets/banner-1544x500.png?rev=1998671\";s:2:\"1x\";s:69:\"https://ps.w.org/classic-editor/assets/banner-772x250.png?rev=1998676\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"requires_php\";s:5:\"5.2.4\";s:16:\"requires_plugins\";a:0:{}}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"6.0.4\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.0.4.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:23:\"elementor/elementor.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:6:\"3.27.6\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.3\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:29:\"wp-parsidate/wp-parsidate.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:26:\"w.org/plugins/wp-parsidate\";s:4:\"slug\";s:12:\"wp-parsidate\";s:6:\"plugin\";s:29:\"wp-parsidate/wp-parsidate.php\";s:11:\"new_version\";s:5:\"5.1.5\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/wp-parsidate/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wp-parsidate.5.1.5.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:57:\"https://ps.w.org/wp-parsidate/assets/icon.svg?rev=1036248\";s:3:\"svg\";s:57:\"https://ps.w.org/wp-parsidate/assets/icon.svg?rev=1036248\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:67:\"https://ps.w.org/wp-parsidate/assets/banner-772x250.jpg?rev=2044005\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.2\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:29:\"RTL-CareUnit/RTL-CareUnit.php\";O:8:\"stdClass\":5:{s:4:\"slug\";s:12:\"RTL-CareUnit\";s:6:\"plugin\";s:29:\"RTL-CareUnit/RTL-CareUnit.php\";s:11:\"new_version\";s:5:\"2.5.2\";s:6:\"tested\";s:3:\"6.7\";s:7:\"package\";s:53:\"https://files.rtl-theme.com/plugins/rtlRsm/rtlRsm.zip\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:1:{s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:8:\"1.5.11.2\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/duplicator.1.5.11.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}}}s:9:\"lastCheck\";i:1741602761;}}", "off");
INSERT INTO `wp_options` VALUES("13071", "elementor_connect_site_key", "b8d98fd06dd0bf325877e7ab43d7d0b1", "auto");
INSERT INTO `wp_options` VALUES("13104", "e_editor_counter", "26", "auto");
INSERT INTO `wp_options` VALUES("13105", "_elementor_free_to_pro_upsell", "a:2:{s:7:\"timeout\";i:1753018844;s:5:\"value\";s:593:\"[{\"id\":\"animated_headline\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/animated_headline.jpg\"},{\"id\":\"video_playlist\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/video_playlist.jpg\"},{\"id\":\"cta\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/cta.jpg\"},{\"id\":\"testimonial_widget\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/testimonial_widget.jpg\"},{\"id\":\"image_carousel\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/image_carousel.jpg\"}]\";}", "off");
INSERT INTO `wp_options` VALUES("13432", "elementor_landing_pages_activation", "0", "auto");
INSERT INTO `wp_options` VALUES("13456", "_elementor_local_google_fonts", "a:2:{s:6:\"roboto\";a:2:{s:3:\"url\";s:93:\"https://webdev-demo.ir/harika/harika/wp-content/uploads/elementor/google-fonts/css/roboto.css\";s:7:\"version\";i:1747261966;}s:10:\"robotoslab\";a:2:{s:3:\"url\";s:97:\"https://webdev-demo.ir/harika/harika/wp-content/uploads/elementor/google-fonts/css/robotoslab.css\";s:7:\"version\";i:1747262018;}}", "auto");
INSERT INTO `wp_options` VALUES("13903", "_elementor_element_cache_unique_id", "3a372d4792892bcfa01c250744cab3ea", "auto");
INSERT INTO `wp_options` VALUES("14009", "as_has_wp_comment_logs", "no", "on");
INSERT INTO `wp_options` VALUES("14053", "imagify_optimize_media_batch_16479a5613ad1f01cb92df2fc0eb1bc7", "a:1:{i:0;a:7:{s:4:\"task\";s:5:\"after\";s:2:\"id\";i:1975;s:5:\"sizes\";a:0:{}s:10:\"sizes_done\";a:1:{i:0;s:4:\"full\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:32:\"\\Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14056", "imagify_optimize_media_batch_3d431356f3b7d013993e286656d3f8b4", "a:1:{i:0;a:5:{s:2:\"id\";i:1974;s:5:\"sizes\";a:28:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:22:\"1536x1536@imagify-webp\";i:9;s:25:\"medium_large@imagify-webp\";i:10;s:22:\"thumbnail@imagify-webp\";i:11;s:18:\"large@imagify-webp\";i:12;s:19:\"medium@imagify-webp\";i:13;s:17:\"full@imagify-webp\";i:14;s:4:\"full\";i:15;s:6:\"medium\";i:16;s:5:\"large\";i:17;s:9:\"thumbnail\";i:18;s:12:\"medium_large\";i:19;s:9:\"1536x1536\";i:20;s:14:\"harika_850x565\";i:21;s:15:\"harika_1290x650\";i:22;s:14:\"harika_220x220\";i:23;s:9:\"harika-80\";i:24;s:12:\"single-image\";i:25;s:14:\"archives-image\";i:26;s:14:\"harika-700-450\";i:27;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14059", "imagify_optimize_media_batch_f572f6f480d21a52b9bc5b6d141d8e92", "a:1:{i:0;a:5:{s:2:\"id\";i:1973;s:5:\"sizes\";a:28:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:22:\"1536x1536@imagify-webp\";i:9;s:25:\"medium_large@imagify-webp\";i:10;s:22:\"thumbnail@imagify-webp\";i:11;s:18:\"large@imagify-webp\";i:12;s:19:\"medium@imagify-webp\";i:13;s:17:\"full@imagify-webp\";i:14;s:4:\"full\";i:15;s:6:\"medium\";i:16;s:5:\"large\";i:17;s:9:\"thumbnail\";i:18;s:12:\"medium_large\";i:19;s:9:\"1536x1536\";i:20;s:14:\"harika_850x565\";i:21;s:15:\"harika_1290x650\";i:22;s:14:\"harika_220x220\";i:23;s:9:\"harika-80\";i:24;s:12:\"single-image\";i:25;s:14:\"archives-image\";i:26;s:14:\"harika-700-450\";i:27;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14062", "imagify_optimize_media_batch_8ae887c5e4d003d0dffe478a802d9899", "a:1:{i:0;a:5:{s:2:\"id\";i:1972;s:5:\"sizes\";a:28:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:22:\"1536x1536@imagify-webp\";i:9;s:25:\"medium_large@imagify-webp\";i:10;s:22:\"thumbnail@imagify-webp\";i:11;s:18:\"large@imagify-webp\";i:12;s:19:\"medium@imagify-webp\";i:13;s:17:\"full@imagify-webp\";i:14;s:4:\"full\";i:15;s:6:\"medium\";i:16;s:5:\"large\";i:17;s:9:\"thumbnail\";i:18;s:12:\"medium_large\";i:19;s:9:\"1536x1536\";i:20;s:14:\"harika_850x565\";i:21;s:15:\"harika_1290x650\";i:22;s:14:\"harika_220x220\";i:23;s:9:\"harika-80\";i:24;s:12:\"single-image\";i:25;s:14:\"archives-image\";i:26;s:14:\"harika-700-450\";i:27;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14065", "imagify_optimize_media_batch_3d2df0845deed8a21882c6ea8dbde010", "a:1:{i:0;a:5:{s:2:\"id\";i:1971;s:5:\"sizes\";a:28:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:22:\"1536x1536@imagify-webp\";i:9;s:25:\"medium_large@imagify-webp\";i:10;s:22:\"thumbnail@imagify-webp\";i:11;s:18:\"large@imagify-webp\";i:12;s:19:\"medium@imagify-webp\";i:13;s:17:\"full@imagify-webp\";i:14;s:4:\"full\";i:15;s:6:\"medium\";i:16;s:5:\"large\";i:17;s:9:\"thumbnail\";i:18;s:12:\"medium_large\";i:19;s:9:\"1536x1536\";i:20;s:14:\"harika_850x565\";i:21;s:15:\"harika_1290x650\";i:22;s:14:\"harika_220x220\";i:23;s:9:\"harika-80\";i:24;s:12:\"single-image\";i:25;s:14:\"archives-image\";i:26;s:14:\"harika-700-450\";i:27;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14068", "imagify_optimize_media_batch_bf98da237c2b5555239162e10bc71cd4", "a:1:{i:0;a:5:{s:2:\"id\";i:1878;s:5:\"sizes\";a:18:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:25:\"medium_large@imagify-webp\";i:6;s:22:\"thumbnail@imagify-webp\";i:7;s:19:\"medium@imagify-webp\";i:8;s:17:\"full@imagify-webp\";i:9;s:4:\"full\";i:10;s:6:\"medium\";i:11;s:9:\"thumbnail\";i:12;s:12:\"medium_large\";i:13;s:14:\"harika_220x220\";i:14;s:9:\"harika-80\";i:15;s:14:\"archives-image\";i:16;s:14:\"harika-700-450\";i:17;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14071", "imagify_optimize_media_batch_3c026c1eeeb90e28cc14b9155070b6ec", "a:1:{i:0;a:5:{s:2:\"id\";i:1877;s:5:\"sizes\";a:18:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:25:\"medium_large@imagify-webp\";i:6;s:22:\"thumbnail@imagify-webp\";i:7;s:19:\"medium@imagify-webp\";i:8;s:17:\"full@imagify-webp\";i:9;s:4:\"full\";i:10;s:6:\"medium\";i:11;s:9:\"thumbnail\";i:12;s:12:\"medium_large\";i:13;s:14:\"harika_220x220\";i:14;s:9:\"harika-80\";i:15;s:14:\"archives-image\";i:16;s:14:\"harika-700-450\";i:17;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14074", "imagify_optimize_media_batch_83c87e0303a2fb3bd067d1ebd89ff10f", "a:1:{i:0;a:5:{s:2:\"id\";i:1859;s:5:\"sizes\";a:28:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:22:\"1536x1536@imagify-webp\";i:9;s:25:\"medium_large@imagify-webp\";i:10;s:22:\"thumbnail@imagify-webp\";i:11;s:18:\"large@imagify-webp\";i:12;s:19:\"medium@imagify-webp\";i:13;s:17:\"full@imagify-webp\";i:14;s:4:\"full\";i:15;s:6:\"medium\";i:16;s:5:\"large\";i:17;s:9:\"thumbnail\";i:18;s:12:\"medium_large\";i:19;s:9:\"1536x1536\";i:20;s:14:\"harika_850x565\";i:21;s:15:\"harika_1290x650\";i:22;s:14:\"harika_220x220\";i:23;s:9:\"harika-80\";i:24;s:12:\"single-image\";i:25;s:14:\"archives-image\";i:26;s:14:\"harika-700-450\";i:27;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14077", "imagify_optimize_media_batch_efb8737131c7654fc5749ee8ae3b753d", "a:1:{i:0;a:5:{s:2:\"id\";i:1655;s:5:\"sizes\";a:20:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:27:\"harika_850x565@imagify-webp\";i:6;s:25:\"medium_large@imagify-webp\";i:7;s:22:\"thumbnail@imagify-webp\";i:8;s:19:\"medium@imagify-webp\";i:9;s:17:\"full@imagify-webp\";i:10;s:4:\"full\";i:11;s:6:\"medium\";i:12;s:9:\"thumbnail\";i:13;s:12:\"medium_large\";i:14;s:14:\"harika_850x565\";i:15;s:14:\"harika_220x220\";i:16;s:9:\"harika-80\";i:17;s:14:\"archives-image\";i:18;s:14:\"harika-700-450\";i:19;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14080", "imagify_optimize_media_batch_299a2395a4e1146feb98199894c8daf2", "a:1:{i:0;a:5:{s:2:\"id\";i:1654;s:5:\"sizes\";a:20:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:27:\"harika_850x565@imagify-webp\";i:6;s:25:\"medium_large@imagify-webp\";i:7;s:22:\"thumbnail@imagify-webp\";i:8;s:19:\"medium@imagify-webp\";i:9;s:17:\"full@imagify-webp\";i:10;s:4:\"full\";i:11;s:6:\"medium\";i:12;s:9:\"thumbnail\";i:13;s:12:\"medium_large\";i:14;s:14:\"harika_850x565\";i:15;s:14:\"harika_220x220\";i:16;s:9:\"harika-80\";i:17;s:14:\"archives-image\";i:18;s:14:\"harika-700-450\";i:19;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14083", "imagify_optimize_media_batch_ae59e7bcd3ccc900f04d9ccbc4dc6396", "a:1:{i:0;a:5:{s:2:\"id\";i:1653;s:5:\"sizes\";a:20:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:27:\"harika_850x565@imagify-webp\";i:6;s:25:\"medium_large@imagify-webp\";i:7;s:22:\"thumbnail@imagify-webp\";i:8;s:19:\"medium@imagify-webp\";i:9;s:17:\"full@imagify-webp\";i:10;s:4:\"full\";i:11;s:6:\"medium\";i:12;s:9:\"thumbnail\";i:13;s:12:\"medium_large\";i:14;s:14:\"harika_850x565\";i:15;s:14:\"harika_220x220\";i:16;s:9:\"harika-80\";i:17;s:14:\"archives-image\";i:18;s:14:\"harika-700-450\";i:19;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14086", "imagify_optimize_media_batch_db42135d93fe6ba32da0f44c02adf0f7", "a:1:{i:0;a:5:{s:2:\"id\";i:1639;s:5:\"sizes\";a:28:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:22:\"1536x1536@imagify-webp\";i:9;s:25:\"medium_large@imagify-webp\";i:10;s:22:\"thumbnail@imagify-webp\";i:11;s:18:\"large@imagify-webp\";i:12;s:19:\"medium@imagify-webp\";i:13;s:17:\"full@imagify-webp\";i:14;s:4:\"full\";i:15;s:6:\"medium\";i:16;s:5:\"large\";i:17;s:9:\"thumbnail\";i:18;s:12:\"medium_large\";i:19;s:9:\"1536x1536\";i:20;s:14:\"harika_850x565\";i:21;s:15:\"harika_1290x650\";i:22;s:14:\"harika_220x220\";i:23;s:9:\"harika-80\";i:24;s:12:\"single-image\";i:25;s:14:\"archives-image\";i:26;s:14:\"harika-700-450\";i:27;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14089", "imagify_optimize_media_batch_1c26636d8fbaf508b294044650d7fbf6", "a:1:{i:0;a:5:{s:2:\"id\";i:1638;s:5:\"sizes\";a:22:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:19:\"medium@imagify-webp\";i:10;s:17:\"full@imagify-webp\";i:11;s:4:\"full\";i:12;s:6:\"medium\";i:13;s:9:\"thumbnail\";i:14;s:12:\"medium_large\";i:15;s:14:\"harika_850x565\";i:16;s:15:\"harika_1290x650\";i:17;s:14:\"harika_220x220\";i:18;s:9:\"harika-80\";i:19;s:14:\"archives-image\";i:20;s:14:\"harika-700-450\";i:21;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14092", "imagify_optimize_media_batch_7e056db72bb74a244f20f8708b6456b1", "a:1:{i:0;a:5:{s:2:\"id\";i:1637;s:5:\"sizes\";a:22:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:19:\"medium@imagify-webp\";i:10;s:17:\"full@imagify-webp\";i:11;s:4:\"full\";i:12;s:6:\"medium\";i:13;s:9:\"thumbnail\";i:14;s:12:\"medium_large\";i:15;s:14:\"harika_850x565\";i:16;s:15:\"harika_1290x650\";i:17;s:14:\"harika_220x220\";i:18;s:9:\"harika-80\";i:19;s:14:\"archives-image\";i:20;s:14:\"harika-700-450\";i:21;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14095", "imagify_optimize_media_batch_eb2c88f5c479c39ebdf9e6ea3c26e289", "a:1:{i:0;a:5:{s:2:\"id\";i:1636;s:5:\"sizes\";a:22:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:19:\"medium@imagify-webp\";i:10;s:17:\"full@imagify-webp\";i:11;s:4:\"full\";i:12;s:6:\"medium\";i:13;s:9:\"thumbnail\";i:14;s:12:\"medium_large\";i:15;s:14:\"harika_850x565\";i:16;s:15:\"harika_1290x650\";i:17;s:14:\"harika_220x220\";i:18;s:9:\"harika-80\";i:19;s:14:\"archives-image\";i:20;s:14:\"harika-700-450\";i:21;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14098", "imagify_optimize_media_batch_94935909ad38498f498822faffe0f7e2", "a:1:{i:0;a:5:{s:2:\"id\";i:1635;s:5:\"sizes\";a:22:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:19:\"medium@imagify-webp\";i:10;s:17:\"full@imagify-webp\";i:11;s:4:\"full\";i:12;s:6:\"medium\";i:13;s:9:\"thumbnail\";i:14;s:12:\"medium_large\";i:15;s:14:\"harika_850x565\";i:16;s:15:\"harika_1290x650\";i:17;s:14:\"harika_220x220\";i:18;s:9:\"harika-80\";i:19;s:14:\"archives-image\";i:20;s:14:\"harika-700-450\";i:21;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14101", "imagify_optimize_media_batch_78445c70f78c989d62dfced1eebad0b0", "a:1:{i:0;a:5:{s:2:\"id\";i:1607;s:5:\"sizes\";a:24:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:18:\"large@imagify-webp\";i:10;s:19:\"medium@imagify-webp\";i:11;s:17:\"full@imagify-webp\";i:12;s:4:\"full\";i:13;s:6:\"medium\";i:14;s:5:\"large\";i:15;s:9:\"thumbnail\";i:16;s:12:\"medium_large\";i:17;s:14:\"harika_850x565\";i:18;s:15:\"harika_1290x650\";i:19;s:14:\"harika_220x220\";i:20;s:9:\"harika-80\";i:21;s:14:\"archives-image\";i:22;s:14:\"harika-700-450\";i:23;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14104", "imagify_optimize_media_batch_26763671193080d28438cb89feba563d", "a:1:{i:0;a:5:{s:2:\"id\";i:1606;s:5:\"sizes\";a:14:{i:0;s:4:\"full\";i:1;s:6:\"medium\";i:2;s:5:\"large\";i:3;s:9:\"thumbnail\";i:4;s:12:\"medium_large\";i:5;s:9:\"1536x1536\";i:6;s:14:\"harika_850x565\";i:7;s:15:\"harika_1290x650\";i:8;s:14:\"harika_220x220\";i:9;s:9:\"harika-80\";i:10;s:12:\"single-image\";i:11;s:14:\"archives-image\";i:12;s:14:\"harika-700-450\";i:13;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14107", "imagify_optimize_media_batch_fa8787a935093bf6989bfd1d3d9e4854", "a:1:{i:0;a:5:{s:2:\"id\";i:1605;s:5:\"sizes\";a:28:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:22:\"1536x1536@imagify-webp\";i:9;s:25:\"medium_large@imagify-webp\";i:10;s:22:\"thumbnail@imagify-webp\";i:11;s:18:\"large@imagify-webp\";i:12;s:19:\"medium@imagify-webp\";i:13;s:17:\"full@imagify-webp\";i:14;s:4:\"full\";i:15;s:6:\"medium\";i:16;s:5:\"large\";i:17;s:9:\"thumbnail\";i:18;s:12:\"medium_large\";i:19;s:9:\"1536x1536\";i:20;s:14:\"harika_850x565\";i:21;s:15:\"harika_1290x650\";i:22;s:14:\"harika_220x220\";i:23;s:9:\"harika-80\";i:24;s:12:\"single-image\";i:25;s:14:\"archives-image\";i:26;s:14:\"harika-700-450\";i:27;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14110", "imagify_optimize_media_batch_bbe79c33393f89d80571ba5bf10a7bfb", "a:1:{i:0;a:5:{s:2:\"id\";i:1604;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14113", "imagify_optimize_media_batch_ec60a8da8cf53de0496221213c6d4ee2", "a:1:{i:0;a:5:{s:2:\"id\";i:1584;s:5:\"sizes\";a:20:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:22:\"thumbnail@imagify-webp\";i:8;s:19:\"medium@imagify-webp\";i:9;s:17:\"full@imagify-webp\";i:10;s:4:\"full\";i:11;s:6:\"medium\";i:12;s:9:\"thumbnail\";i:13;s:14:\"harika_850x565\";i:14;s:15:\"harika_1290x650\";i:15;s:14:\"harika_220x220\";i:16;s:9:\"harika-80\";i:17;s:14:\"archives-image\";i:18;s:14:\"harika-700-450\";i:19;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14116", "imagify_optimize_media_batch_2d3607442f4fde310c458f9bcc09a63a", "a:1:{i:0;a:5:{s:2:\"id\";i:1556;s:5:\"sizes\";a:22:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:19:\"medium@imagify-webp\";i:10;s:17:\"full@imagify-webp\";i:11;s:4:\"full\";i:12;s:6:\"medium\";i:13;s:9:\"thumbnail\";i:14;s:12:\"medium_large\";i:15;s:14:\"harika_850x565\";i:16;s:15:\"harika_1290x650\";i:17;s:14:\"harika_220x220\";i:18;s:9:\"harika-80\";i:19;s:14:\"archives-image\";i:20;s:14:\"harika-700-450\";i:21;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14119", "imagify_optimize_media_batch_9b6940fd6a89a378e83d7b0db5e4e20f", "a:1:{i:0;a:5:{s:2:\"id\";i:1473;s:5:\"sizes\";a:20:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:27:\"harika_850x565@imagify-webp\";i:6;s:25:\"medium_large@imagify-webp\";i:7;s:22:\"thumbnail@imagify-webp\";i:8;s:19:\"medium@imagify-webp\";i:9;s:17:\"full@imagify-webp\";i:10;s:4:\"full\";i:11;s:6:\"medium\";i:12;s:9:\"thumbnail\";i:13;s:12:\"medium_large\";i:14;s:14:\"harika_850x565\";i:15;s:14:\"harika_220x220\";i:16;s:9:\"harika-80\";i:17;s:14:\"archives-image\";i:18;s:14:\"harika-700-450\";i:19;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14122", "imagify_optimize_media_batch_3c6c3048ffefc5fdec3975475aa68c41", "a:1:{i:0;a:5:{s:2:\"id\";i:1472;s:5:\"sizes\";a:24:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:18:\"large@imagify-webp\";i:10;s:19:\"medium@imagify-webp\";i:11;s:17:\"full@imagify-webp\";i:12;s:4:\"full\";i:13;s:6:\"medium\";i:14;s:5:\"large\";i:15;s:9:\"thumbnail\";i:16;s:12:\"medium_large\";i:17;s:14:\"harika_850x565\";i:18;s:15:\"harika_1290x650\";i:19;s:14:\"harika_220x220\";i:20;s:9:\"harika-80\";i:21;s:14:\"archives-image\";i:22;s:14:\"harika-700-450\";i:23;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14125", "imagify_optimize_media_batch_d7d71fcd12b6e1c199e0052b959bb64b", "a:1:{i:0;a:5:{s:2:\"id\";i:1471;s:5:\"sizes\";a:20:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:27:\"harika_850x565@imagify-webp\";i:6;s:25:\"medium_large@imagify-webp\";i:7;s:22:\"thumbnail@imagify-webp\";i:8;s:19:\"medium@imagify-webp\";i:9;s:17:\"full@imagify-webp\";i:10;s:4:\"full\";i:11;s:6:\"medium\";i:12;s:9:\"thumbnail\";i:13;s:12:\"medium_large\";i:14;s:14:\"harika_850x565\";i:15;s:14:\"harika_220x220\";i:16;s:9:\"harika-80\";i:17;s:14:\"archives-image\";i:18;s:14:\"harika-700-450\";i:19;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14128", "imagify_optimize_media_batch_eb5852554b77d147b2472fb96e21c779", "a:1:{i:0;a:5:{s:2:\"id\";i:1455;s:5:\"sizes\";a:28:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:22:\"1536x1536@imagify-webp\";i:9;s:25:\"medium_large@imagify-webp\";i:10;s:22:\"thumbnail@imagify-webp\";i:11;s:18:\"large@imagify-webp\";i:12;s:19:\"medium@imagify-webp\";i:13;s:17:\"full@imagify-webp\";i:14;s:4:\"full\";i:15;s:6:\"medium\";i:16;s:5:\"large\";i:17;s:9:\"thumbnail\";i:18;s:12:\"medium_large\";i:19;s:9:\"1536x1536\";i:20;s:14:\"harika_850x565\";i:21;s:15:\"harika_1290x650\";i:22;s:14:\"harika_220x220\";i:23;s:9:\"harika-80\";i:24;s:12:\"single-image\";i:25;s:14:\"archives-image\";i:26;s:14:\"harika-700-450\";i:27;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14131", "imagify_optimize_media_batch_72902a786e466b4dff1106c8ca71dcb2", "a:1:{i:0;a:5:{s:2:\"id\";i:1411;s:5:\"sizes\";a:20:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:27:\"harika_850x565@imagify-webp\";i:6;s:25:\"medium_large@imagify-webp\";i:7;s:22:\"thumbnail@imagify-webp\";i:8;s:19:\"medium@imagify-webp\";i:9;s:17:\"full@imagify-webp\";i:10;s:4:\"full\";i:11;s:6:\"medium\";i:12;s:9:\"thumbnail\";i:13;s:12:\"medium_large\";i:14;s:14:\"harika_850x565\";i:15;s:14:\"harika_220x220\";i:16;s:9:\"harika-80\";i:17;s:14:\"archives-image\";i:18;s:14:\"harika-700-450\";i:19;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14134", "imagify_optimize_media_batch_5d4a787fd5ec09d641ce7f2f8e77fb4b", "a:1:{i:0;a:5:{s:2:\"id\";i:1410;s:5:\"sizes\";a:24:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:18:\"large@imagify-webp\";i:10;s:19:\"medium@imagify-webp\";i:11;s:17:\"full@imagify-webp\";i:12;s:4:\"full\";i:13;s:6:\"medium\";i:14;s:5:\"large\";i:15;s:9:\"thumbnail\";i:16;s:12:\"medium_large\";i:17;s:14:\"harika_850x565\";i:18;s:15:\"harika_1290x650\";i:19;s:14:\"harika_220x220\";i:20;s:9:\"harika-80\";i:21;s:14:\"archives-image\";i:22;s:14:\"harika-700-450\";i:23;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14137", "imagify_optimize_media_batch_8e45495a9f3ac8fe18a3fa6c1c557de5", "a:1:{i:0;a:5:{s:2:\"id\";i:1409;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14140", "imagify_optimize_media_batch_413ba9984b4c0f74edf3f6fd3ea19577", "a:1:{i:0;a:5:{s:2:\"id\";i:1408;s:5:\"sizes\";a:28:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:22:\"1536x1536@imagify-webp\";i:9;s:25:\"medium_large@imagify-webp\";i:10;s:22:\"thumbnail@imagify-webp\";i:11;s:18:\"large@imagify-webp\";i:12;s:19:\"medium@imagify-webp\";i:13;s:17:\"full@imagify-webp\";i:14;s:4:\"full\";i:15;s:6:\"medium\";i:16;s:5:\"large\";i:17;s:9:\"thumbnail\";i:18;s:12:\"medium_large\";i:19;s:9:\"1536x1536\";i:20;s:14:\"harika_850x565\";i:21;s:15:\"harika_1290x650\";i:22;s:14:\"harika_220x220\";i:23;s:9:\"harika-80\";i:24;s:12:\"single-image\";i:25;s:14:\"archives-image\";i:26;s:14:\"harika-700-450\";i:27;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14143", "imagify_optimize_media_batch_c90f927bcdd08673c62e142a6dd3e7a4", "a:1:{i:0;a:5:{s:2:\"id\";i:1407;s:5:\"sizes\";a:24:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:18:\"large@imagify-webp\";i:10;s:19:\"medium@imagify-webp\";i:11;s:17:\"full@imagify-webp\";i:12;s:4:\"full\";i:13;s:6:\"medium\";i:14;s:5:\"large\";i:15;s:9:\"thumbnail\";i:16;s:12:\"medium_large\";i:17;s:14:\"harika_850x565\";i:18;s:15:\"harika_1290x650\";i:19;s:14:\"harika_220x220\";i:20;s:9:\"harika-80\";i:21;s:14:\"archives-image\";i:22;s:14:\"harika-700-450\";i:23;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14146", "imagify_optimize_media_batch_31c4c8e58366530972114b51d05ac779", "a:1:{i:0;a:5:{s:2:\"id\";i:1406;s:5:\"sizes\";a:16:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:22:\"thumbnail@imagify-webp\";i:6;s:19:\"medium@imagify-webp\";i:7;s:17:\"full@imagify-webp\";i:8;s:4:\"full\";i:9;s:6:\"medium\";i:10;s:9:\"thumbnail\";i:11;s:14:\"harika_220x220\";i:12;s:9:\"harika-80\";i:13;s:14:\"archives-image\";i:14;s:14:\"harika-700-450\";i:15;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14149", "imagify_optimize_media_batch_75ff884db7cb2cd0f5f4e1e7b88edce4", "a:1:{i:0;a:5:{s:2:\"id\";i:1405;s:5:\"sizes\";a:28:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:22:\"1536x1536@imagify-webp\";i:9;s:25:\"medium_large@imagify-webp\";i:10;s:22:\"thumbnail@imagify-webp\";i:11;s:18:\"large@imagify-webp\";i:12;s:19:\"medium@imagify-webp\";i:13;s:17:\"full@imagify-webp\";i:14;s:4:\"full\";i:15;s:6:\"medium\";i:16;s:5:\"large\";i:17;s:9:\"thumbnail\";i:18;s:12:\"medium_large\";i:19;s:9:\"1536x1536\";i:20;s:14:\"harika_850x565\";i:21;s:15:\"harika_1290x650\";i:22;s:14:\"harika_220x220\";i:23;s:9:\"harika-80\";i:24;s:12:\"single-image\";i:25;s:14:\"archives-image\";i:26;s:14:\"harika-700-450\";i:27;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14152", "imagify_optimize_media_batch_7508d5c73e42bdf39fa9f181adc85334", "a:1:{i:0;a:5:{s:2:\"id\";i:1404;s:5:\"sizes\";a:16:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:22:\"thumbnail@imagify-webp\";i:6;s:19:\"medium@imagify-webp\";i:7;s:17:\"full@imagify-webp\";i:8;s:4:\"full\";i:9;s:6:\"medium\";i:10;s:9:\"thumbnail\";i:11;s:14:\"harika_220x220\";i:12;s:9:\"harika-80\";i:13;s:14:\"archives-image\";i:14;s:14:\"harika-700-450\";i:15;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14155", "imagify_optimize_media_batch_d791024fd0c5803009a17942ea62f88e", "a:1:{i:0;a:5:{s:2:\"id\";i:1403;s:5:\"sizes\";a:24:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:18:\"large@imagify-webp\";i:10;s:19:\"medium@imagify-webp\";i:11;s:17:\"full@imagify-webp\";i:12;s:4:\"full\";i:13;s:6:\"medium\";i:14;s:5:\"large\";i:15;s:9:\"thumbnail\";i:16;s:12:\"medium_large\";i:17;s:14:\"harika_850x565\";i:18;s:15:\"harika_1290x650\";i:19;s:14:\"harika_220x220\";i:20;s:9:\"harika-80\";i:21;s:14:\"archives-image\";i:22;s:14:\"harika-700-450\";i:23;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14158", "imagify_optimize_media_batch_c61b2df21b59aca1a13d5c29818e9d01", "a:1:{i:0;a:5:{s:2:\"id\";i:1402;s:5:\"sizes\";a:16:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:22:\"thumbnail@imagify-webp\";i:6;s:19:\"medium@imagify-webp\";i:7;s:17:\"full@imagify-webp\";i:8;s:4:\"full\";i:9;s:6:\"medium\";i:10;s:9:\"thumbnail\";i:11;s:14:\"harika_220x220\";i:12;s:9:\"harika-80\";i:13;s:14:\"archives-image\";i:14;s:14:\"harika-700-450\";i:15;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14161", "imagify_optimize_media_batch_9870c6ebad24beda447bf130909a5b8c", "a:1:{i:0;a:5:{s:2:\"id\";i:1401;s:5:\"sizes\";a:20:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:27:\"harika_850x565@imagify-webp\";i:6;s:25:\"medium_large@imagify-webp\";i:7;s:22:\"thumbnail@imagify-webp\";i:8;s:19:\"medium@imagify-webp\";i:9;s:17:\"full@imagify-webp\";i:10;s:4:\"full\";i:11;s:6:\"medium\";i:12;s:9:\"thumbnail\";i:13;s:12:\"medium_large\";i:14;s:14:\"harika_850x565\";i:15;s:14:\"harika_220x220\";i:16;s:9:\"harika-80\";i:17;s:14:\"archives-image\";i:18;s:14:\"harika-700-450\";i:19;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14164", "imagify_optimize_media_batch_8b46a58e0615bbbf4eba8742ecd36a3c", "a:1:{i:0;a:5:{s:2:\"id\";i:1400;s:5:\"sizes\";a:16:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:22:\"thumbnail@imagify-webp\";i:6;s:19:\"medium@imagify-webp\";i:7;s:17:\"full@imagify-webp\";i:8;s:4:\"full\";i:9;s:6:\"medium\";i:10;s:9:\"thumbnail\";i:11;s:14:\"harika_220x220\";i:12;s:9:\"harika-80\";i:13;s:14:\"archives-image\";i:14;s:14:\"harika-700-450\";i:15;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14167", "imagify_optimize_media_batch_1de54a2114bb341948f0353e43b3cc8a", "a:1:{i:0;a:5:{s:2:\"id\";i:1399;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14170", "imagify_optimize_media_batch_c5eca7efe257d76a97c4ca0499d6bcda", "a:1:{i:0;a:5:{s:2:\"id\";i:1398;s:5:\"sizes\";a:28:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:22:\"1536x1536@imagify-webp\";i:9;s:25:\"medium_large@imagify-webp\";i:10;s:22:\"thumbnail@imagify-webp\";i:11;s:18:\"large@imagify-webp\";i:12;s:19:\"medium@imagify-webp\";i:13;s:17:\"full@imagify-webp\";i:14;s:4:\"full\";i:15;s:6:\"medium\";i:16;s:5:\"large\";i:17;s:9:\"thumbnail\";i:18;s:12:\"medium_large\";i:19;s:9:\"1536x1536\";i:20;s:14:\"harika_850x565\";i:21;s:15:\"harika_1290x650\";i:22;s:14:\"harika_220x220\";i:23;s:9:\"harika-80\";i:24;s:12:\"single-image\";i:25;s:14:\"archives-image\";i:26;s:14:\"harika-700-450\";i:27;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14173", "imagify_optimize_media_batch_d50b2129bdaae6a7061b2ba35638ee58", "a:1:{i:0;a:5:{s:2:\"id\";i:1397;s:5:\"sizes\";a:28:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:22:\"1536x1536@imagify-webp\";i:9;s:25:\"medium_large@imagify-webp\";i:10;s:22:\"thumbnail@imagify-webp\";i:11;s:18:\"large@imagify-webp\";i:12;s:19:\"medium@imagify-webp\";i:13;s:17:\"full@imagify-webp\";i:14;s:4:\"full\";i:15;s:6:\"medium\";i:16;s:5:\"large\";i:17;s:9:\"thumbnail\";i:18;s:12:\"medium_large\";i:19;s:9:\"1536x1536\";i:20;s:14:\"harika_850x565\";i:21;s:15:\"harika_1290x650\";i:22;s:14:\"harika_220x220\";i:23;s:9:\"harika-80\";i:24;s:12:\"single-image\";i:25;s:14:\"archives-image\";i:26;s:14:\"harika-700-450\";i:27;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14176", "imagify_optimize_media_batch_8def0cba8737e40cb98f4b93970e68ed", "a:1:{i:0;a:5:{s:2:\"id\";i:1164;s:5:\"sizes\";a:24:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:18:\"large@imagify-webp\";i:10;s:19:\"medium@imagify-webp\";i:11;s:17:\"full@imagify-webp\";i:12;s:4:\"full\";i:13;s:6:\"medium\";i:14;s:5:\"large\";i:15;s:9:\"thumbnail\";i:16;s:12:\"medium_large\";i:17;s:14:\"harika_850x565\";i:18;s:15:\"harika_1290x650\";i:19;s:14:\"harika_220x220\";i:20;s:9:\"harika-80\";i:21;s:14:\"archives-image\";i:22;s:14:\"harika-700-450\";i:23;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14179", "imagify_optimize_media_batch_93bfd52cfd21634a2677c160658770f0", "a:1:{i:0;a:5:{s:2:\"id\";i:1163;s:5:\"sizes\";a:22:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:27:\"harika_850x565@imagify-webp\";i:6;s:25:\"medium_large@imagify-webp\";i:7;s:22:\"thumbnail@imagify-webp\";i:8;s:18:\"large@imagify-webp\";i:9;s:19:\"medium@imagify-webp\";i:10;s:17:\"full@imagify-webp\";i:11;s:4:\"full\";i:12;s:6:\"medium\";i:13;s:5:\"large\";i:14;s:9:\"thumbnail\";i:15;s:12:\"medium_large\";i:16;s:14:\"harika_850x565\";i:17;s:14:\"harika_220x220\";i:18;s:9:\"harika-80\";i:19;s:14:\"archives-image\";i:20;s:14:\"harika-700-450\";i:21;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14182", "imagify_optimize_media_batch_007c9142779e22c321aa1dec77e15350", "a:1:{i:0;a:5:{s:2:\"id\";i:1162;s:5:\"sizes\";a:28:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:22:\"1536x1536@imagify-webp\";i:9;s:25:\"medium_large@imagify-webp\";i:10;s:22:\"thumbnail@imagify-webp\";i:11;s:18:\"large@imagify-webp\";i:12;s:19:\"medium@imagify-webp\";i:13;s:17:\"full@imagify-webp\";i:14;s:4:\"full\";i:15;s:6:\"medium\";i:16;s:5:\"large\";i:17;s:9:\"thumbnail\";i:18;s:12:\"medium_large\";i:19;s:9:\"1536x1536\";i:20;s:14:\"harika_850x565\";i:21;s:15:\"harika_1290x650\";i:22;s:14:\"harika_220x220\";i:23;s:9:\"harika-80\";i:24;s:12:\"single-image\";i:25;s:14:\"archives-image\";i:26;s:14:\"harika-700-450\";i:27;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14185", "imagify_optimize_media_batch_5da2ec7c9a21886a383aebdeb313ffbb", "a:1:{i:0;a:5:{s:2:\"id\";i:1161;s:5:\"sizes\";a:24:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:18:\"large@imagify-webp\";i:10;s:19:\"medium@imagify-webp\";i:11;s:17:\"full@imagify-webp\";i:12;s:4:\"full\";i:13;s:6:\"medium\";i:14;s:5:\"large\";i:15;s:9:\"thumbnail\";i:16;s:12:\"medium_large\";i:17;s:14:\"harika_850x565\";i:18;s:15:\"harika_1290x650\";i:19;s:14:\"harika_220x220\";i:20;s:9:\"harika-80\";i:21;s:14:\"archives-image\";i:22;s:14:\"harika-700-450\";i:23;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14188", "imagify_optimize_media_batch_c089591a527fa8525a088d4cb574de92", "a:1:{i:0;a:5:{s:2:\"id\";i:1160;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14191", "imagify_optimize_media_batch_433cc6e2d94ba0dc5b2e760e0504ec42", "a:1:{i:0;a:5:{s:2:\"id\";i:1159;s:5:\"sizes\";a:24:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:18:\"large@imagify-webp\";i:10;s:19:\"medium@imagify-webp\";i:11;s:17:\"full@imagify-webp\";i:12;s:4:\"full\";i:13;s:6:\"medium\";i:14;s:5:\"large\";i:15;s:9:\"thumbnail\";i:16;s:12:\"medium_large\";i:17;s:14:\"harika_850x565\";i:18;s:15:\"harika_1290x650\";i:19;s:14:\"harika_220x220\";i:20;s:9:\"harika-80\";i:21;s:14:\"archives-image\";i:22;s:14:\"harika-700-450\";i:23;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14194", "imagify_optimize_media_batch_355a3cddc77c5edbce27913fb9ca02a1", "a:1:{i:0;a:5:{s:2:\"id\";i:1158;s:5:\"sizes\";a:22:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:27:\"harika_850x565@imagify-webp\";i:6;s:25:\"medium_large@imagify-webp\";i:7;s:22:\"thumbnail@imagify-webp\";i:8;s:18:\"large@imagify-webp\";i:9;s:19:\"medium@imagify-webp\";i:10;s:17:\"full@imagify-webp\";i:11;s:4:\"full\";i:12;s:6:\"medium\";i:13;s:5:\"large\";i:14;s:9:\"thumbnail\";i:15;s:12:\"medium_large\";i:16;s:14:\"harika_850x565\";i:17;s:14:\"harika_220x220\";i:18;s:9:\"harika-80\";i:19;s:14:\"archives-image\";i:20;s:14:\"harika-700-450\";i:21;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14197", "imagify_optimize_media_batch_0772204c8524c97c17636d2f1b4e3de1", "a:1:{i:0;a:5:{s:2:\"id\";i:1157;s:5:\"sizes\";a:24:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:18:\"large@imagify-webp\";i:10;s:19:\"medium@imagify-webp\";i:11;s:17:\"full@imagify-webp\";i:12;s:4:\"full\";i:13;s:6:\"medium\";i:14;s:5:\"large\";i:15;s:9:\"thumbnail\";i:16;s:12:\"medium_large\";i:17;s:14:\"harika_850x565\";i:18;s:15:\"harika_1290x650\";i:19;s:14:\"harika_220x220\";i:20;s:9:\"harika-80\";i:21;s:14:\"archives-image\";i:22;s:14:\"harika-700-450\";i:23;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14200", "imagify_optimize_media_batch_6664640273b654bd351ba264551999e0", "a:1:{i:0;a:5:{s:2:\"id\";i:1156;s:5:\"sizes\";a:24:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:18:\"large@imagify-webp\";i:10;s:19:\"medium@imagify-webp\";i:11;s:17:\"full@imagify-webp\";i:12;s:4:\"full\";i:13;s:6:\"medium\";i:14;s:5:\"large\";i:15;s:9:\"thumbnail\";i:16;s:12:\"medium_large\";i:17;s:14:\"harika_850x565\";i:18;s:15:\"harika_1290x650\";i:19;s:14:\"harika_220x220\";i:20;s:9:\"harika-80\";i:21;s:14:\"archives-image\";i:22;s:14:\"harika-700-450\";i:23;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14203", "imagify_optimize_media_batch_4bd3986268a11eb49a3417922580e159", "a:1:{i:0;a:5:{s:2:\"id\";i:1155;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14206", "imagify_optimize_media_batch_a04947c2ff88c285071dfd09f01bdbe6", "a:1:{i:0;a:5:{s:2:\"id\";i:1153;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14209", "imagify_optimize_media_batch_6649fc6a509ed2c5d11818d71cfacffd", "a:1:{i:0;a:5:{s:2:\"id\";i:1152;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14212", "imagify_optimize_media_batch_f9629b3be3748bfca9907515f14fda0d", "a:1:{i:0;a:5:{s:2:\"id\";i:1150;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14215", "imagify_optimize_media_batch_1d734d3f1a05324e4babeabe06cbe716", "a:1:{i:0;a:5:{s:2:\"id\";i:1148;s:5:\"sizes\";a:24:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:18:\"large@imagify-webp\";i:10;s:19:\"medium@imagify-webp\";i:11;s:17:\"full@imagify-webp\";i:12;s:4:\"full\";i:13;s:6:\"medium\";i:14;s:5:\"large\";i:15;s:9:\"thumbnail\";i:16;s:12:\"medium_large\";i:17;s:14:\"harika_850x565\";i:18;s:15:\"harika_1290x650\";i:19;s:14:\"harika_220x220\";i:20;s:9:\"harika-80\";i:21;s:14:\"archives-image\";i:22;s:14:\"harika-700-450\";i:23;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14218", "imagify_optimize_media_batch_cae05719267bcf829bae34b3ca53237e", "a:1:{i:0;a:5:{s:2:\"id\";i:1144;s:5:\"sizes\";a:24:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:18:\"large@imagify-webp\";i:10;s:19:\"medium@imagify-webp\";i:11;s:17:\"full@imagify-webp\";i:12;s:4:\"full\";i:13;s:6:\"medium\";i:14;s:5:\"large\";i:15;s:9:\"thumbnail\";i:16;s:12:\"medium_large\";i:17;s:14:\"harika_850x565\";i:18;s:15:\"harika_1290x650\";i:19;s:14:\"harika_220x220\";i:20;s:9:\"harika-80\";i:21;s:14:\"archives-image\";i:22;s:14:\"harika-700-450\";i:23;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14221", "imagify_optimize_media_batch_4c5360cebd86b42a0ca9fb816c5e9afb", "a:1:{i:0;a:5:{s:2:\"id\";i:986;s:5:\"sizes\";a:24:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:18:\"large@imagify-webp\";i:10;s:19:\"medium@imagify-webp\";i:11;s:17:\"full@imagify-webp\";i:12;s:4:\"full\";i:13;s:6:\"medium\";i:14;s:5:\"large\";i:15;s:9:\"thumbnail\";i:16;s:12:\"medium_large\";i:17;s:14:\"harika_850x565\";i:18;s:15:\"harika_1290x650\";i:19;s:14:\"harika_220x220\";i:20;s:9:\"harika-80\";i:21;s:14:\"archives-image\";i:22;s:14:\"harika-700-450\";i:23;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14224", "imagify_optimize_media_batch_16ba8cd42b8c091f7d187a43fb6be216", "a:1:{i:0;a:5:{s:2:\"id\";i:984;s:5:\"sizes\";a:20:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:27:\"harika_850x565@imagify-webp\";i:6;s:25:\"medium_large@imagify-webp\";i:7;s:22:\"thumbnail@imagify-webp\";i:8;s:19:\"medium@imagify-webp\";i:9;s:17:\"full@imagify-webp\";i:10;s:4:\"full\";i:11;s:6:\"medium\";i:12;s:9:\"thumbnail\";i:13;s:12:\"medium_large\";i:14;s:14:\"harika_850x565\";i:15;s:14:\"harika_220x220\";i:16;s:9:\"harika-80\";i:17;s:14:\"archives-image\";i:18;s:14:\"harika-700-450\";i:19;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14227", "imagify_optimize_media_batch_c633124beaa12ee20de77ccdd86b8b8b", "a:1:{i:0;a:5:{s:2:\"id\";i:982;s:5:\"sizes\";a:20:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:27:\"harika_850x565@imagify-webp\";i:6;s:25:\"medium_large@imagify-webp\";i:7;s:22:\"thumbnail@imagify-webp\";i:8;s:19:\"medium@imagify-webp\";i:9;s:17:\"full@imagify-webp\";i:10;s:4:\"full\";i:11;s:6:\"medium\";i:12;s:9:\"thumbnail\";i:13;s:12:\"medium_large\";i:14;s:14:\"harika_850x565\";i:15;s:14:\"harika_220x220\";i:16;s:9:\"harika-80\";i:17;s:14:\"archives-image\";i:18;s:14:\"harika-700-450\";i:19;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14230", "imagify_optimize_media_batch_db48c6b18458386a66ceede62e05f96e", "a:1:{i:0;a:5:{s:2:\"id\";i:980;s:5:\"sizes\";a:16:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:22:\"thumbnail@imagify-webp\";i:6;s:19:\"medium@imagify-webp\";i:7;s:17:\"full@imagify-webp\";i:8;s:4:\"full\";i:9;s:6:\"medium\";i:10;s:9:\"thumbnail\";i:11;s:14:\"harika_220x220\";i:12;s:9:\"harika-80\";i:13;s:14:\"archives-image\";i:14;s:14:\"harika-700-450\";i:15;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14233", "imagify_optimize_media_batch_51dc3350e188c001fd065fb330bfcb3f", "a:1:{i:0;a:5:{s:2:\"id\";i:977;s:5:\"sizes\";a:20:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:27:\"harika_850x565@imagify-webp\";i:6;s:25:\"medium_large@imagify-webp\";i:7;s:22:\"thumbnail@imagify-webp\";i:8;s:19:\"medium@imagify-webp\";i:9;s:17:\"full@imagify-webp\";i:10;s:4:\"full\";i:11;s:6:\"medium\";i:12;s:9:\"thumbnail\";i:13;s:12:\"medium_large\";i:14;s:14:\"harika_850x565\";i:15;s:14:\"harika_220x220\";i:16;s:9:\"harika-80\";i:17;s:14:\"archives-image\";i:18;s:14:\"harika-700-450\";i:19;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14236", "imagify_optimize_media_batch_54e95c575ebd89648a3721c0f2f80769", "a:1:{i:0;a:5:{s:2:\"id\";i:976;s:5:\"sizes\";a:12:{i:0;s:4:\"full\";i:1;s:6:\"medium\";i:2;s:5:\"large\";i:3;s:9:\"thumbnail\";i:4;s:12:\"medium_large\";i:5;s:14:\"harika_850x565\";i:6;s:14:\"harika_220x220\";i:7;s:9:\"harika-80\";i:8;s:12:\"single-image\";i:9;s:14:\"archives-image\";i:10;s:14:\"harika-700-450\";i:11;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14239", "imagify_optimize_media_batch_5a728e033a3b95f02efe5d2cdb8c7f9f", "a:1:{i:0;a:5:{s:2:\"id\";i:975;s:5:\"sizes\";a:13:{i:0;s:4:\"full\";i:1;s:6:\"medium\";i:2;s:5:\"large\";i:3;s:9:\"thumbnail\";i:4;s:12:\"medium_large\";i:5;s:14:\"harika_850x565\";i:6;s:15:\"harika_1290x650\";i:7;s:14:\"harika_220x220\";i:8;s:9:\"harika-80\";i:9;s:12:\"single-image\";i:10;s:14:\"archives-image\";i:11;s:14:\"harika-700-450\";i:12;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14242", "imagify_optimize_media_batch_843652dd068706931c94fd1f354e8ca5", "a:1:{i:0;a:5:{s:2:\"id\";i:971;s:5:\"sizes\";a:13:{i:0;s:4:\"full\";i:1;s:6:\"medium\";i:2;s:5:\"large\";i:3;s:9:\"thumbnail\";i:4;s:12:\"medium_large\";i:5;s:14:\"harika_850x565\";i:6;s:15:\"harika_1290x650\";i:7;s:14:\"harika_220x220\";i:8;s:9:\"harika-80\";i:9;s:12:\"single-image\";i:10;s:14:\"archives-image\";i:11;s:14:\"harika-700-450\";i:12;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14245", "imagify_optimize_media_batch_fe664470d535cda348c670df710273a3", "a:1:{i:0;a:5:{s:2:\"id\";i:970;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14248", "imagify_optimize_media_batch_b532a016a36fbd037a2d0d1f509c0b1a", "a:1:{i:0;a:5:{s:2:\"id\";i:969;s:5:\"sizes\";a:10:{i:0;s:4:\"full\";i:1;s:6:\"medium\";i:2;s:9:\"thumbnail\";i:3;s:12:\"medium_large\";i:4;s:14:\"harika_850x565\";i:5;s:14:\"harika_220x220\";i:6;s:9:\"harika-80\";i:7;s:14:\"archives-image\";i:8;s:14:\"harika-700-450\";i:9;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14251", "imagify_optimize_media_batch_caecb4c54f4b40392ee74c9439393258", "a:1:{i:0;a:5:{s:2:\"id\";i:968;s:5:\"sizes\";a:8:{i:0;s:4:\"full\";i:1;s:6:\"medium\";i:2;s:9:\"thumbnail\";i:3;s:14:\"harika_220x220\";i:4;s:9:\"harika-80\";i:5;s:14:\"archives-image\";i:6;s:14:\"harika-700-450\";i:7;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14254", "imagify_optimize_media_batch_a66fa8bea0744362e40cb5e9cffa1999", "a:1:{i:0;a:5:{s:2:\"id\";i:967;s:5:\"sizes\";a:7:{i:0;s:4:\"full\";i:1;s:6:\"medium\";i:2;s:9:\"thumbnail\";i:3;s:14:\"harika_220x220\";i:4;s:9:\"harika-80\";i:5;s:14:\"archives-image\";i:6;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14257", "imagify_optimize_media_batch_cb81c64a8338574706cf32178ea3dd82", "a:1:{i:0;a:5:{s:2:\"id\";i:966;s:5:\"sizes\";a:10:{i:0;s:4:\"full\";i:1;s:6:\"medium\";i:2;s:9:\"thumbnail\";i:3;s:12:\"medium_large\";i:4;s:14:\"harika_850x565\";i:5;s:14:\"harika_220x220\";i:6;s:9:\"harika-80\";i:7;s:14:\"archives-image\";i:8;s:14:\"harika-700-450\";i:9;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14260", "imagify_optimize_media_batch_5d903abed4d27fd2d345598186aeb7ff", "a:1:{i:0;a:5:{s:2:\"id\";i:965;s:5:\"sizes\";a:8:{i:0;s:4:\"full\";i:1;s:6:\"medium\";i:2;s:9:\"thumbnail\";i:3;s:14:\"harika_220x220\";i:4;s:9:\"harika-80\";i:5;s:14:\"archives-image\";i:6;s:14:\"harika-700-450\";i:7;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14263", "imagify_optimize_media_batch_aacbb3a43185050b2cc54af403241fc2", "a:1:{i:0;a:5:{s:2:\"id\";i:964;s:5:\"sizes\";a:12:{i:0;s:4:\"full\";i:1;s:6:\"medium\";i:2;s:5:\"large\";i:3;s:9:\"thumbnail\";i:4;s:12:\"medium_large\";i:5;s:14:\"harika_850x565\";i:6;s:14:\"harika_220x220\";i:7;s:9:\"harika-80\";i:8;s:12:\"single-image\";i:9;s:14:\"archives-image\";i:10;s:14:\"harika-700-450\";i:11;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14266", "imagify_optimize_media_batch_01fbc5bfbc0dd387e083931dd8d10e49", "a:1:{i:0;a:5:{s:2:\"id\";i:790;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14269", "imagify_optimize_media_batch_17c633dac5e0af940a73f62ffce2ecee", "a:1:{i:0;a:5:{s:2:\"id\";i:789;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14272", "imagify_optimize_media_batch_0a30ee849ca6f9d34f1bcb0fea512d9a", "a:1:{i:0;a:5:{s:2:\"id\";i:788;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14275", "imagify_optimize_media_batch_2306c7a40411912d6fef203c65136a48", "a:1:{i:0;a:5:{s:2:\"id\";i:787;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14278", "imagify_optimize_media_batch_dd1f7cca634f14d71cfdee28394fc3cb", "a:1:{i:0;a:5:{s:2:\"id\";i:786;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14281", "imagify_optimize_media_batch_25d6b8ccdc3914a57642733b21045436", "a:1:{i:0;a:5:{s:2:\"id\";i:785;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14284", "imagify_optimize_media_batch_bec8dea3ef971ad3240a998f96bc4e91", "a:1:{i:0;a:5:{s:2:\"id\";i:784;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14287", "imagify_optimize_media_batch_52a7238f1a45f13b95cee62e35108366", "a:1:{i:0;a:5:{s:2:\"id\";i:783;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14290", "imagify_optimize_media_batch_830d89710f51539ab22ab363b7b6f454", "a:1:{i:0;a:5:{s:2:\"id\";i:782;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14293", "imagify_optimize_media_batch_6eaf8fe96948f74695c44331040697ef", "a:1:{i:0;a:5:{s:2:\"id\";i:781;s:5:\"sizes\";a:20:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:27:\"harika_850x565@imagify-webp\";i:6;s:25:\"medium_large@imagify-webp\";i:7;s:22:\"thumbnail@imagify-webp\";i:8;s:19:\"medium@imagify-webp\";i:9;s:17:\"full@imagify-webp\";i:10;s:4:\"full\";i:11;s:6:\"medium\";i:12;s:9:\"thumbnail\";i:13;s:12:\"medium_large\";i:14;s:14:\"harika_850x565\";i:15;s:14:\"harika_220x220\";i:16;s:9:\"harika-80\";i:17;s:14:\"archives-image\";i:18;s:14:\"harika-700-450\";i:19;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14296", "imagify_optimize_media_batch_4aab26d1c88413c2a2f71c076b17bf22", "a:1:{i:0;a:5:{s:2:\"id\";i:780;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14299", "imagify_optimize_media_batch_193c6e6bd8a072215c666eb9428db57b", "a:1:{i:0;a:5:{s:2:\"id\";i:779;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14302", "imagify_optimize_media_batch_4309a8901c57a70b6b95626256f29494", "a:1:{i:0;a:5:{s:2:\"id\";i:778;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14305", "imagify_optimize_media_batch_f36c64b9eab36985b6ccf6b03a2638ad", "a:1:{i:0;a:5:{s:2:\"id\";i:777;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14308", "imagify_optimize_media_batch_78425d6d996101ded6556935dbed7600", "a:1:{i:0;a:5:{s:2:\"id\";i:776;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14311", "imagify_optimize_media_batch_01be0463bd43418fa17688f45a26cb22", "a:1:{i:0;a:5:{s:2:\"id\";i:593;s:5:\"sizes\";a:14:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"archives-image@imagify-webp\";i:2;s:22:\"harika-80@imagify-webp\";i:3;s:27:\"harika_220x220@imagify-webp\";i:4;s:22:\"thumbnail@imagify-webp\";i:5;s:19:\"medium@imagify-webp\";i:6;s:17:\"full@imagify-webp\";i:7;s:4:\"full\";i:8;s:6:\"medium\";i:9;s:9:\"thumbnail\";i:10;s:14:\"harika_220x220\";i:11;s:9:\"harika-80\";i:12;s:14:\"archives-image\";i:13;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14314", "imagify_optimize_media_batch_55e587f7d4b5753f3c3bdcedc7d41e03", "a:1:{i:0;a:5:{s:2:\"id\";i:589;s:5:\"sizes\";a:14:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"archives-image@imagify-webp\";i:2;s:22:\"harika-80@imagify-webp\";i:3;s:27:\"harika_220x220@imagify-webp\";i:4;s:22:\"thumbnail@imagify-webp\";i:5;s:19:\"medium@imagify-webp\";i:6;s:17:\"full@imagify-webp\";i:7;s:4:\"full\";i:8;s:6:\"medium\";i:9;s:9:\"thumbnail\";i:10;s:14:\"harika_220x220\";i:11;s:9:\"harika-80\";i:12;s:14:\"archives-image\";i:13;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14317", "imagify_optimize_media_batch_529431c207ffc6f11c01f113a8dd6e61", "a:1:{i:0;a:5:{s:2:\"id\";i:587;s:5:\"sizes\";a:14:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"archives-image@imagify-webp\";i:2;s:22:\"harika-80@imagify-webp\";i:3;s:27:\"harika_220x220@imagify-webp\";i:4;s:22:\"thumbnail@imagify-webp\";i:5;s:19:\"medium@imagify-webp\";i:6;s:17:\"full@imagify-webp\";i:7;s:4:\"full\";i:8;s:6:\"medium\";i:9;s:9:\"thumbnail\";i:10;s:14:\"harika_220x220\";i:11;s:9:\"harika-80\";i:12;s:14:\"archives-image\";i:13;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14320", "imagify_optimize_media_batch_d9b216780e93cc4508447148ec1a2971", "a:1:{i:0;a:5:{s:2:\"id\";i:585;s:5:\"sizes\";a:30:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:22:\"2048x2048@imagify-webp\";i:9;s:22:\"1536x1536@imagify-webp\";i:10;s:25:\"medium_large@imagify-webp\";i:11;s:22:\"thumbnail@imagify-webp\";i:12;s:18:\"large@imagify-webp\";i:13;s:19:\"medium@imagify-webp\";i:14;s:17:\"full@imagify-webp\";i:15;s:4:\"full\";i:16;s:6:\"medium\";i:17;s:5:\"large\";i:18;s:9:\"thumbnail\";i:19;s:12:\"medium_large\";i:20;s:9:\"1536x1536\";i:21;s:9:\"2048x2048\";i:22;s:14:\"harika_850x565\";i:23;s:15:\"harika_1290x650\";i:24;s:14:\"harika_220x220\";i:25;s:9:\"harika-80\";i:26;s:12:\"single-image\";i:27;s:14:\"archives-image\";i:28;s:14:\"harika-700-450\";i:29;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14323", "imagify_optimize_media_batch_de306227d6438a091695955e4f1c7494", "a:1:{i:0;a:5:{s:2:\"id\";i:582;s:5:\"sizes\";a:22:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:19:\"medium@imagify-webp\";i:10;s:17:\"full@imagify-webp\";i:11;s:4:\"full\";i:12;s:6:\"medium\";i:13;s:9:\"thumbnail\";i:14;s:12:\"medium_large\";i:15;s:14:\"harika_850x565\";i:16;s:15:\"harika_1290x650\";i:17;s:14:\"harika_220x220\";i:18;s:9:\"harika-80\";i:19;s:14:\"archives-image\";i:20;s:14:\"harika-700-450\";i:21;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14326", "imagify_optimize_media_batch_1f7905bd5c58f6e9b88f060a6e7e6917", "a:1:{i:0;a:5:{s:2:\"id\";i:579;s:5:\"sizes\";a:26:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:25:\"medium_large@imagify-webp\";i:9;s:22:\"thumbnail@imagify-webp\";i:10;s:18:\"large@imagify-webp\";i:11;s:19:\"medium@imagify-webp\";i:12;s:17:\"full@imagify-webp\";i:13;s:4:\"full\";i:14;s:6:\"medium\";i:15;s:5:\"large\";i:16;s:9:\"thumbnail\";i:17;s:12:\"medium_large\";i:18;s:14:\"harika_850x565\";i:19;s:15:\"harika_1290x650\";i:20;s:14:\"harika_220x220\";i:21;s:9:\"harika-80\";i:22;s:12:\"single-image\";i:23;s:14:\"archives-image\";i:24;s:14:\"harika-700-450\";i:25;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14329", "imagify_optimize_media_batch_303c96e55e4b14395cccf675086f5c9f", "a:1:{i:0;a:5:{s:2:\"id\";i:575;s:5:\"sizes\";a:8:{i:0;s:4:\"full\";i:1;s:6:\"medium\";i:2;s:9:\"thumbnail\";i:3;s:14:\"harika_220x220\";i:4;s:9:\"harika-80\";i:5;s:14:\"archives-image\";i:6;s:14:\"harika-700-450\";i:7;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14332", "imagify_optimize_media_batch_a218a90d38f89834d3e0e4d01da213ec", "a:1:{i:0;a:5:{s:2:\"id\";i:550;s:5:\"sizes\";a:9:{i:0;s:4:\"full\";i:1;s:6:\"medium\";i:2;s:9:\"thumbnail\";i:3;s:12:\"medium_large\";i:4;s:14:\"harika_220x220\";i:5;s:9:\"harika-80\";i:6;s:14:\"archives-image\";i:7;s:14:\"harika-700-450\";i:8;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14335", "imagify_optimize_media_batch_86cd4abedf872234a6cd65947d78a7e2", "a:1:{i:0;a:5:{s:2:\"id\";i:539;s:5:\"sizes\";a:22:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:19:\"medium@imagify-webp\";i:10;s:17:\"full@imagify-webp\";i:11;s:4:\"full\";i:12;s:6:\"medium\";i:13;s:9:\"thumbnail\";i:14;s:12:\"medium_large\";i:15;s:14:\"harika_850x565\";i:16;s:15:\"harika_1290x650\";i:17;s:14:\"harika_220x220\";i:18;s:9:\"harika-80\";i:19;s:14:\"archives-image\";i:20;s:14:\"harika-700-450\";i:21;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14338", "imagify_optimize_media_batch_0fa566a5bf1c640ba0705a78b36efbd3", "a:1:{i:0;a:5:{s:2:\"id\";i:511;s:5:\"sizes\";a:12:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:22:\"harika-80@imagify-webp\";i:2;s:27:\"harika_220x220@imagify-webp\";i:3;s:22:\"thumbnail@imagify-webp\";i:4;s:19:\"medium@imagify-webp\";i:5;s:17:\"full@imagify-webp\";i:6;s:4:\"full\";i:7;s:6:\"medium\";i:8;s:9:\"thumbnail\";i:9;s:14:\"harika_220x220\";i:10;s:9:\"harika-80\";i:11;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14341", "imagify_optimize_media_batch_112ca21ffa865157d8f103341bf4d8e6", "a:1:{i:0;a:5:{s:2:\"id\";i:510;s:5:\"sizes\";a:12:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:22:\"harika-80@imagify-webp\";i:2;s:27:\"harika_220x220@imagify-webp\";i:3;s:22:\"thumbnail@imagify-webp\";i:4;s:19:\"medium@imagify-webp\";i:5;s:17:\"full@imagify-webp\";i:6;s:4:\"full\";i:7;s:6:\"medium\";i:8;s:9:\"thumbnail\";i:9;s:14:\"harika_220x220\";i:10;s:9:\"harika-80\";i:11;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14344", "imagify_optimize_media_batch_c308604636bcc40eb85ffccf92b56a18", "a:1:{i:0;a:5:{s:2:\"id\";i:507;s:5:\"sizes\";a:18:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:25:\"medium_large@imagify-webp\";i:6;s:22:\"thumbnail@imagify-webp\";i:7;s:19:\"medium@imagify-webp\";i:8;s:17:\"full@imagify-webp\";i:9;s:4:\"full\";i:10;s:6:\"medium\";i:11;s:9:\"thumbnail\";i:12;s:12:\"medium_large\";i:13;s:14:\"harika_220x220\";i:14;s:9:\"harika-80\";i:15;s:14:\"archives-image\";i:16;s:14:\"harika-700-450\";i:17;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14347", "imagify_optimize_media_batch_09e8671e34f90a0c181588c15523a6e5", "a:1:{i:0;a:5:{s:2:\"id\";i:322;s:5:\"sizes\";a:28:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:25:\"single-image@imagify-webp\";i:4;s:22:\"harika-80@imagify-webp\";i:5;s:27:\"harika_220x220@imagify-webp\";i:6;s:28:\"harika_1290x650@imagify-webp\";i:7;s:27:\"harika_850x565@imagify-webp\";i:8;s:22:\"1536x1536@imagify-webp\";i:9;s:25:\"medium_large@imagify-webp\";i:10;s:22:\"thumbnail@imagify-webp\";i:11;s:18:\"large@imagify-webp\";i:12;s:19:\"medium@imagify-webp\";i:13;s:17:\"full@imagify-webp\";i:14;s:4:\"full\";i:15;s:6:\"medium\";i:16;s:5:\"large\";i:17;s:9:\"thumbnail\";i:18;s:12:\"medium_large\";i:19;s:9:\"1536x1536\";i:20;s:14:\"harika_850x565\";i:21;s:15:\"harika_1290x650\";i:22;s:14:\"harika_220x220\";i:23;s:9:\"harika-80\";i:24;s:12:\"single-image\";i:25;s:14:\"archives-image\";i:26;s:14:\"harika-700-450\";i:27;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14350", "imagify_optimize_media_batch_221eb7c1281d74b125407f72f8e10930", "a:1:{i:0;a:5:{s:2:\"id\";i:321;s:5:\"sizes\";a:24:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:18:\"large@imagify-webp\";i:10;s:19:\"medium@imagify-webp\";i:11;s:17:\"full@imagify-webp\";i:12;s:4:\"full\";i:13;s:6:\"medium\";i:14;s:5:\"large\";i:15;s:9:\"thumbnail\";i:16;s:12:\"medium_large\";i:17;s:14:\"harika_850x565\";i:18;s:15:\"harika_1290x650\";i:19;s:14:\"harika_220x220\";i:20;s:9:\"harika-80\";i:21;s:14:\"archives-image\";i:22;s:14:\"harika-700-450\";i:23;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14353", "imagify_optimize_media_batch_985283b3ccbb6ab995c68ea5ad61a146", "a:1:{i:0;a:5:{s:2:\"id\";i:320;s:5:\"sizes\";a:24:{i:0;s:23:\"harika-300@imagify-webp\";i:1;s:27:\"harika-700-450@imagify-webp\";i:2;s:27:\"archives-image@imagify-webp\";i:3;s:22:\"harika-80@imagify-webp\";i:4;s:27:\"harika_220x220@imagify-webp\";i:5;s:28:\"harika_1290x650@imagify-webp\";i:6;s:27:\"harika_850x565@imagify-webp\";i:7;s:25:\"medium_large@imagify-webp\";i:8;s:22:\"thumbnail@imagify-webp\";i:9;s:18:\"large@imagify-webp\";i:10;s:19:\"medium@imagify-webp\";i:11;s:17:\"full@imagify-webp\";i:12;s:4:\"full\";i:13;s:6:\"medium\";i:14;s:5:\"large\";i:15;s:9:\"thumbnail\";i:16;s:12:\"medium_large\";i:17;s:14:\"harika_850x565\";i:18;s:15:\"harika_1290x650\";i:19;s:14:\"harika_220x220\";i:20;s:9:\"harika-80\";i:21;s:14:\"archives-image\";i:22;s:14:\"harika-700-450\";i:23;s:10:\"harika-300\";}s:18:\"optimization_level\";i:2;s:13:\"process_class\";s:31:\"Imagify\\Optimization\\Process\\WP\";s:4:\"data\";a:1:{s:11:\"hook_suffix\";s:14:\"optimize_media\";}}}", "off");
INSERT INTO `wp_options` VALUES("14372", "imagify_optimize_media_status", "1", "off");
INSERT INTO `wp_options` VALUES("14383", "ewww_image_optimizer_relative_migration_status", "done", "auto");
INSERT INTO `wp_options` VALUES("14385", "ewww_image_optimizer_background_optimization", "1", "off");
INSERT INTO `wp_options` VALUES("14386", "ewww_image_optimizer_noauto", "", "auto");
INSERT INTO `wp_options` VALUES("14387", "ewww_image_optimizer_auto", "", "auto");
INSERT INTO `wp_options` VALUES("14388", "ewww_image_optimizer_ludicrous_mode", "", "auto");
INSERT INTO `wp_options` VALUES("14389", "ewww_image_optimizer_jpg_only_mode", "", "auto");
INSERT INTO `wp_options` VALUES("14390", "ewww_image_optimizer_disable_editor", "", "auto");
INSERT INTO `wp_options` VALUES("14391", "ewww_image_optimizer_debug", "", "auto");
INSERT INTO `wp_options` VALUES("14392", "ewww_image_optimizer_metadata_remove", "1", "auto");
INSERT INTO `wp_options` VALUES("14393", "ewww_image_optimizer_maxmediawidth", "2560", "auto");
INSERT INTO `wp_options` VALUES("14394", "ewww_image_optimizer_maxmediaheight", "2560", "auto");
INSERT INTO `wp_options` VALUES("14395", "ewww_image_optimizer_cloud_key", "", "auto");
INSERT INTO `wp_options` VALUES("14396", "ewww_image_optimizer_jpg_level", "10", "auto");
INSERT INTO `wp_options` VALUES("14397", "ewww_image_optimizer_png_level", "10", "auto");
INSERT INTO `wp_options` VALUES("14398", "ewww_image_optimizer_gif_level", "10", "auto");
INSERT INTO `wp_options` VALUES("14399", "ewww_image_optimizer_pdf_level", "0", "auto");
INSERT INTO `wp_options` VALUES("14400", "ewww_image_optimizer_svg_level", "0", "auto");
INSERT INTO `wp_options` VALUES("14401", "ewww_image_optimizer_webp_level", "0", "auto");
INSERT INTO `wp_options` VALUES("14402", "ewww_image_optimizer_webp_conversion_method", "local", "auto");
INSERT INTO `wp_options` VALUES("14403", "ewww_image_optimizer_webp", "1", "auto");
INSERT INTO `wp_options` VALUES("14404", "ewww_image_optimizer_jpg_quality", "", "auto");
INSERT INTO `wp_options` VALUES("14405", "ewww_image_optimizer_webp_quality", "", "auto");
INSERT INTO `wp_options` VALUES("14406", "ewww_image_optimizer_backup_files", "local", "auto");
INSERT INTO `wp_options` VALUES("14407", "ewww_image_optimizer_resize_existing", "1", "auto");
INSERT INTO `wp_options` VALUES("14408", "ewww_image_optimizer_exactdn", "", "auto");
INSERT INTO `wp_options` VALUES("14409", "ewww_image_optimizer_exactdn_plan_id", "0", "auto");
INSERT INTO `wp_options` VALUES("14410", "exactdn_all_the_things", "1", "auto");
INSERT INTO `wp_options` VALUES("14411", "exactdn_lossy", "1", "auto");
INSERT INTO `wp_options` VALUES("14412", "exactdn_hidpi", "1", "off");
INSERT INTO `wp_options` VALUES("14413", "exactdn_exclude", "", "auto");
INSERT INTO `wp_options` VALUES("14414", "exactdn_sub_folder", "", "off");
INSERT INTO `wp_options` VALUES("14415", "exactdn_prevent_db_queries", "", "auto");
INSERT INTO `wp_options` VALUES("14416", "exactdn_asset_domains", "", "auto");
INSERT INTO `wp_options` VALUES("14417", "ewww_image_optimizer_lazy_load", "1", "auto");
INSERT INTO `wp_options` VALUES("14418", "ewww_image_optimizer_add_missing_dims", "", "auto");
INSERT INTO `wp_options` VALUES("14419", "ewww_image_optimizer_use_siip", "", "auto");
INSERT INTO `wp_options` VALUES("14420", "ewww_image_optimizer_use_lqip", "", "auto");
INSERT INTO `wp_options` VALUES("14421", "ewww_image_optimizer_use_dcip", "", "auto");
INSERT INTO `wp_options` VALUES("14422", "ewww_image_optimizer_ll_exclude", "", "auto");
INSERT INTO `wp_options` VALUES("14423", "ewww_image_optimizer_ll_all_things", "", "auto");
INSERT INTO `wp_options` VALUES("14424", "ewww_image_optimizer_disable_pngout", "1", "auto");
INSERT INTO `wp_options` VALUES("14425", "ewww_image_optimizer_disable_svgcleaner", "1", "auto");
INSERT INTO `wp_options` VALUES("14426", "ewww_image_optimizer_optipng_level", "2", "auto");
INSERT INTO `wp_options` VALUES("14427", "ewww_image_optimizer_pngout_level", "2", "auto");
INSERT INTO `wp_options` VALUES("14428", "ewww_image_optimizer_webp_for_cdn", "", "auto");
INSERT INTO `wp_options` VALUES("14429", "ewww_image_optimizer_force_gif2webp", "1", "auto");
INSERT INTO `wp_options` VALUES("14430", "ewww_image_optimizer_picture_webp", "", "auto");
INSERT INTO `wp_options` VALUES("14431", "ewww_image_optimizer_webp_rewrite_exclude", "", "auto");
INSERT INTO `wp_options` VALUES("14435", "ewww_image_optimizer_ll_autoscale", "1", "off");
INSERT INTO `wp_options` VALUES("14436", "exactdn_never_been_active", "1", "off");
INSERT INTO `wp_options` VALUES("14437", "ewww_image_optimizer_bulk_resume", "", "auto");
INSERT INTO `wp_options` VALUES("14438", "ewww_image_optimizer_aux_resume", "", "auto");
INSERT INTO `wp_options` VALUES("14439", "ewww_image_optimizer_flag_attachments", "", "off");
INSERT INTO `wp_options` VALUES("14440", "ewww_image_optimizer_ngg_attachments", "", "off");
INSERT INTO `wp_options` VALUES("14442", "ewww_image_optimizer_review_time", "1750028523", "off");
INSERT INTO `wp_options` VALUES("14443", "ewww_image_optimizer_version", "814", "auto");
INSERT INTO `wp_options` VALUES("14444", "ewww_image_optimizer_dismiss_utf8", "1", "auto");
INSERT INTO `wp_options` VALUES("14447", "ewww_image_optimizer_goal_save_space", "1", "off");
INSERT INTO `wp_options` VALUES("14448", "ewww_image_optimizer_goal_site_speed", "1", "off");
INSERT INTO `wp_options` VALUES("14450", "ewww_image_optimizer_tracking_notice", "1", "auto");
INSERT INTO `wp_options` VALUES("14451", "ewww_image_optimizer_wizard_complete", "1", "off");
INSERT INTO `wp_options` VALUES("14452", "ewww_image_optimizer_delay", "0", "auto");
INSERT INTO `wp_options` VALUES("14453", "ewww_image_optimizer_scan_args", "", "auto");
INSERT INTO `wp_options` VALUES("14518", "ewww_image_optimizer_aux_folders_completed", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("19307", "duplicator_expire_search-replace-wpcode", "{\"expire\":1752049768,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.0\"}}", "on");
INSERT INTO `wp_options` VALUES("19308", "duplicator_expire_wp-mail-smtp", "{\"expire\":1752049769,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.4\"}}", "on");
INSERT INTO `wp_options` VALUES("19309", "duplicator_expire_insert-headers-and-footers", "{\"expire\":1752049769,\"value\":{\"wp_version\":\"4.6\",\"php_version\":\"5.5\"}}", "on");
INSERT INTO `wp_options` VALUES("19313", "duplicator_migration_data", "{\n    \"plugin\": \"dup-lite\",\n    \"installerVersion\": \"1.5.12\",\n    \"installType\": -1,\n    \"logicModes\": [\n        \"CLASSIC\"\n    ],\n    \"template\": \"base\",\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"\\/home\\/webdevde\\/public_html\\/harika\\/harika\\/harika_v42_48311dd100aa70af9775_20250625083028_archive.zip\",\n    \"packageHash\": \"48311dd-25083028\",\n    \"installerPath\": \"\\/home\\/webdevde\\/public_html\\/harika\\/harika\\/installer.php\",\n    \"installerBootLog\": \"\\/home\\/webdevde\\/public_html\\/harika\\/harika\\/dup-installer-bootlog__3c30b4e-25083028.txt\",\n    \"installerLog\": \"\\/home\\/webdevde\\/public_html\\/harika\\/harika\\/dup-installer\\/dup-installer-log__3c30b4e-25083028.txt\",\n    \"dupInstallerPath\": \"\\/home\\/webdevde\\/public_html\\/harika\\/harika\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/home\\/webdevde\\/public_html\\/harika\\/harika\\/dup-installer\\/original_files_48311dd-25083028\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true,\n    \"licenseType\": 0,\n    \"phpVersion\": \"7.4.25\",\n    \"archiveType\": \"zip\",\n    \"siteSize\": 373842881,\n    \"siteNumFiles\": 11996,\n    \"siteDbSize\": 52183040,\n    \"siteDBNumTables\": 19,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"ustatIdentifier\": \"\",\n    \"time\": 1750842945\n}", "no");
INSERT INTO `wp_options` VALUES("19319", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"1831f4a91c8f95e8a4a207c2e9318038\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_options` VALUES("19326", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"Ara&RWjFUg4=luLYwk6E,EW5hyaXYmLxkcvmqrYR4,W2\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 341.4,\n    \"siteNumFiles\": 10907,\n    \"siteDbSizeMB\": 49.91,\n    \"siteDbNumTables\": 25\n}", "auto");
INSERT INTO `wp_options` VALUES("19352", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("19365", "theme_mods_hello-elementor", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:6:\"menu-1\";i:2;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1751275197;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:3:{i:0;s:8:\"search-2\";i:1;s:12:\"categories-2\";i:2;s:14:\"recent-posts-2\";}}}}", "off");
INSERT INTO `wp_options` VALUES("19366", "hello_theme_version", "3.4.4", "auto");
INSERT INTO `wp_options` VALUES("19370", "_hello-elementor_notifications", "a:2:{s:7:\"timeout\";i:1751318398;s:5:\"value\";s:7532:\"[{\"id\":\"hello-theme-3.4.4\",\"title\":\"3.4.4 - 2025-06-08\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Improve Header\\/Footer edit access from theme Home<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.3\",\"title\":\"3.4.3 - 2025-05-26\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Fix: Settings page empty after 3.4.0 in translated sites<\\/li>\\n\\t\\t\\t\\t<li>Fix: PHP 8.4 deprecation notice<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.2\",\"title\":\"3.4.2 - 2025-05-19\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Set Home links font weight to regular<\\/li>\\n  \\t\\t        <li>Tweak: Dart SASS 3.0.0 - resolve scss deprecated warnings<\\/li>\\n    \\t\\t    <li>Fix: Settings page empty after 3.4.0<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.0\",\"title\":\"3.4.0 - 2025-05-05\",\"description\":\"\\n            <ul>\\n                <li>New: Added Theme Home<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update theme settings page style<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update tested up to version 6.8<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.3.0\",\"title\":\"3.3.0 - 2025-01-21\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Added changelog link in theme settings<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n  \\t\\t        <li>Tweak: Update autoprefixer to latest versions<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.1\",\"title\":\"3.2.1 - 2024-12-16\",\"description\":\"\\n            <ul>\\n                <li>\\n                    Fix: Gutenberg editor expanded disproportionately after adding support for <code>theme.json<\\/code>\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/430\\\" target=\\\"_blank\\\">#430<\\/a>)\\n                <\\/li>\\n                <li>Fix: Use CSS logical properties in the theme<\\/li>\\n                <li>Fix: Add ARIA attributes to header nav menu<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.0\",\"title\":\"3.2.0 - 2024-12-15\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Convert classic to hybrid theme with block-editor support<\\/li>\\n                <li>Tweak: Added new design options to header\\/footer<\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.7<\\/code><\\/li>\\n                <li>\\n                    Fix: Minify JS files\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/419\\\" target=\\\"_blank\\\">#419<\\/a>)\\n                <\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.1\",\"title\":\"3.1.1 - 2024-07-30\",\"description\":\"\\n            <ul>\\n                <li>Fix: Use consistent <code>&lt;h2&gt;<\\/code> for comments title and comment form<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.0\",\"title\":\"3.1.0 - 2024-06-19\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Update <code>Requires PHP 7.4<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.5<\\/code><\\/li>\\n                <li>Tweak: Add the ability to style the brand layout<\\/li>\\n                <li>Tweak: Remove deprecated Elementor code<\\/li>\\n                <li>Tweak: Restore default focus styling inside the theme<\\/li>\\n                <li>Tweak: Add <code>aria-label<\\/code> attribute to various <code>&lt;nav&gt;<\\/code> elements<\\/li>\\n                <li>Tweak: Improve mobile menu keyboard accessibility<\\/li>\\n                <li>Tweak: Semantic mobile menu toggle button<\\/li>\\n                <li>Fix: The header renders redundant <code>&lt;p&gt;<\\/code> when tagline is empty<\\/li>\\n                <li>Fix: Single post renders redundant wrapping <code>&lt;div&gt;<\\/code> when it has no tags<\\/li>\\n                <li>Fix: Remove redundant wrapping <code>&lt;div&gt;<\\/code> from <code>wp_nav_menu()<\\/code> output<\\/li>\\n                <li>Fix: Wrap page <code>&lt;h1&gt;<\\/code> with <code>&lt;div&gt;<\\/code>, not <code>&lt;header&gt;<\\/code><\\/li>\\n                <li>Fix: Use consistent <code>&lt;h3&gt;<\\/code> for comments title and comment form<\\/li>\\n                <li>Fix: Remove heading tags from dynamic header\\/footer<\\/li>\\n                <li>\\n                    Fix: Mobile Menu hamburger is not visible for logged-out users in some cases\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/369\\\" target=\\\"_blank\\\">#369<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove duplicate ID attributes in the header mobile menu<\\/li>\\n                <li>\\n                    Fix: Remove redundant table styles\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/311\\\" target=\\\"_blank\\\">#311<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove redundant space below Site Logo in the header\\/footer<\\/li>\\n                <li>Fix: Remove redundant CSS from dynamic header\\/footer layout<\\/li>\\n                <li>\\n                    Fix: Separate post tags in single post\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/304\\\" target=\\\"_blank\\\">#304<\\/a>)\\n                <\\/li>\\n                <li>Fix: Display <code>the_tags()<\\/code> after <code>wp_link_pages()<\\/code><\\/li>\\n                <li>Fix: Remove page break navigation from archives when using <code>&lt;!--nextpage--&gt;<\\/code><\\/li>\\n                <li>Fix: Style posts pagination component layout<\\/li>\\n                <li>Fix: Add RTL support to pagination arrows in archive pages<\\/li>\\n                <li>\\n                    Fix: Update pagination prev\\/next labels and positions\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/404\\\" target=\\\"_blank\\\">#404<\\/a>)\\n                <\\/li>\\n                <li>Fix: Check if Elementor is loaded when using dynamic header & footer<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.2\",\"title\":\"3.0.2 - 2024-05-28\",\"description\":\"\\n            <ul>\\n                <li>Internal: Version bump release to refresh WordPress repository<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.1\",\"title\":\"3.0.1 - 2024-01-24\",\"description\":\"\\n            <ul>\\n                <li>Fix: Harden security for admin notice dismiss button<\\/li>\\n                <li>Fix: Add <code>alt<\\/code> attribute to all the images in the dashboard<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.0\",\"title\":\"3.0.0 - 2023-12-26\",\"description\":\"\\n            <ul>\\n                <li>New: Option to disable cross-site header & footer<\\/li>\\n                <li>Tweak: Update <code>Requires PHP 7.3<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.4<\\/code><\\/li>\\n                <li>Tweak: Move cross-site header & footer styles to a separate CSS file<\\/li>\\n                <li>Tweak: Don\'t load <code>header-footer.min.css<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Don\'t load <code>hello-frontend.min.js<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in the frontend<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in WordPress admin<\\/li>\\n                <li>Tweak: Remove unused JS code from the frontend<\\/li>\\n                <li>Tweak: Remove unused CSS code from the editor<\\/li>\\n                <li>Tweak: Remove unnecessary <code>role<\\/code> attributes from HTML landmark elements<\\/li>\\n                <li>Tweak: Link from Elementor Site Settings to Hello Theme Settings<\\/li>\\n                <li>Fix: Dynamic script version for better caching<\\/li>\\n            <\\/ul>\"}]\";}", "off");
INSERT INTO `wp_options` VALUES("19378", "theme_mods_ridda", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:12:\"primary_menu\";i:2;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1750857680;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"primary_sidebar\";a:3:{i:0;s:8:\"search-2\";i:6;s:12:\"categories-2\";i:7;s:14:\"recent-posts-2\";}}}}", "off");
INSERT INTO `wp_options` VALUES("20318", "_transient_health-check-site-status-result", "{\"good\":17,\"recommended\":4,\"critical\":2}", "on");
INSERT INTO `wp_options` VALUES("21900", "_site_transient_timeout_browser_7ddeda88d0c599cc494da0dece6554d5", "1753093496", "off");
INSERT INTO `wp_options` VALUES("21901", "_site_transient_browser_7ddeda88d0c599cc494da0dece6554d5", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"138.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("21914", "rtl_rsm_healthyServer", "0", "off");
INSERT INTO `wp_options` VALUES("21916", "_site_transient_timeout_php_check_1ad0acda4da6c4fcb37046d1f090be2c", "1753094423", "off");
INSERT INTO `wp_options` VALUES("21917", "_site_transient_php_check_1ad0acda4da6c4fcb37046d1f090be2c", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("22233", "can_compress_scripts", "0", "auto");
INSERT INTO `wp_options` VALUES("22706", "duplicator_install_info", "a:3:{s:7:\"version\";s:8:\"1.5.10.2\";s:4:\"time\";i:1724340264;s:10:\"updateTime\";i:1752857046;}", "off");
INSERT INTO `wp_options` VALUES("22707", "duplicator_notifications", "a:4:{s:6:\"update\";i:1753087704;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("22719", "theme_mods_twentytwentyfive", "a:5:{i:0;b:0;s:19:\"wp_classic_sidebars\";a:3:{s:15:\"primary_sidebar\";a:11:{s:4:\"name\";s:26:\"سایدبار پست ها\";s:2:\"id\";s:15:\"primary_sidebar\";s:11:\"description\";s:49:\"نمایش در سایدبار سینگل پست.\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:35:\"<div id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:6:\"</div>\";s:12:\"before_title\";s:25:\"<h4 class=\"widget-title\">\";s:11:\"after_title\";s:5:\"</h4>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}s:13:\"pages_sidebar\";a:11:{s:4:\"name\";s:23:\"سایدبار صفحه\";s:2:\"id\";s:13:\"pages_sidebar\";s:11:\"description\";s:45:\"نمایش در سایدبار برگه ها.\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:35:\"<div id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:6:\"</div>\";s:12:\"before_title\";s:25:\"<h4 class=\"widget-title\">\";s:11:\"after_title\";s:5:\"</h4>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}s:14:\"footer_widgets\";a:11:{s:4:\"name\";s:28:\"ابزارک های فوتر\";s:2:\"id\";s:14:\"footer_widgets\";s:11:\"description\";s:43:\"ابزارک ها را اضافه کنید.\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:35:\"<div id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:6:\"</div>\";s:12:\"before_title\";s:25:\"<h4 class=\"widget-title\">\";s:11:\"after_title\";s:5:\"</h4>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}}s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1752859419;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"primary_sidebar\";a:3:{i:0;s:8:\"search-2\";i:6;s:12:\"categories-2\";i:7;s:14:\"recent-posts-2\";}s:13:\"pages_sidebar\";a:0:{}s:14:\"footer_widgets\";a:0:{}}}}", "off");
INSERT INTO `wp_options` VALUES("22723", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.8.2\";s:5:\"files\";a:536:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:26:\"post-content/style-rtl.css\";i:309;s:30:\"post-content/style-rtl.min.css\";i:310;s:22:\"post-content/style.css\";i:311;s:26:\"post-content/style.min.css\";i:312;s:23:\"post-date/style-rtl.css\";i:313;s:27:\"post-date/style-rtl.min.css\";i:314;s:19:\"post-date/style.css\";i:315;s:23:\"post-date/style.min.css\";i:316;s:27:\"post-excerpt/editor-rtl.css\";i:317;s:31:\"post-excerpt/editor-rtl.min.css\";i:318;s:23:\"post-excerpt/editor.css\";i:319;s:27:\"post-excerpt/editor.min.css\";i:320;s:26:\"post-excerpt/style-rtl.css\";i:321;s:30:\"post-excerpt/style-rtl.min.css\";i:322;s:22:\"post-excerpt/style.css\";i:323;s:26:\"post-excerpt/style.min.css\";i:324;s:34:\"post-featured-image/editor-rtl.css\";i:325;s:38:\"post-featured-image/editor-rtl.min.css\";i:326;s:30:\"post-featured-image/editor.css\";i:327;s:34:\"post-featured-image/editor.min.css\";i:328;s:33:\"post-featured-image/style-rtl.css\";i:329;s:37:\"post-featured-image/style-rtl.min.css\";i:330;s:29:\"post-featured-image/style.css\";i:331;s:33:\"post-featured-image/style.min.css\";i:332;s:34:\"post-navigation-link/style-rtl.css\";i:333;s:38:\"post-navigation-link/style-rtl.min.css\";i:334;s:30:\"post-navigation-link/style.css\";i:335;s:34:\"post-navigation-link/style.min.css\";i:336;s:27:\"post-template/style-rtl.css\";i:337;s:31:\"post-template/style-rtl.min.css\";i:338;s:23:\"post-template/style.css\";i:339;s:27:\"post-template/style.min.css\";i:340;s:24:\"post-terms/style-rtl.css\";i:341;s:28:\"post-terms/style-rtl.min.css\";i:342;s:20:\"post-terms/style.css\";i:343;s:24:\"post-terms/style.min.css\";i:344;s:24:\"post-title/style-rtl.css\";i:345;s:28:\"post-title/style-rtl.min.css\";i:346;s:20:\"post-title/style.css\";i:347;s:24:\"post-title/style.min.css\";i:348;s:26:\"preformatted/style-rtl.css\";i:349;s:30:\"preformatted/style-rtl.min.css\";i:350;s:22:\"preformatted/style.css\";i:351;s:26:\"preformatted/style.min.css\";i:352;s:24:\"pullquote/editor-rtl.css\";i:353;s:28:\"pullquote/editor-rtl.min.css\";i:354;s:20:\"pullquote/editor.css\";i:355;s:24:\"pullquote/editor.min.css\";i:356;s:23:\"pullquote/style-rtl.css\";i:357;s:27:\"pullquote/style-rtl.min.css\";i:358;s:19:\"pullquote/style.css\";i:359;s:23:\"pullquote/style.min.css\";i:360;s:23:\"pullquote/theme-rtl.css\";i:361;s:27:\"pullquote/theme-rtl.min.css\";i:362;s:19:\"pullquote/theme.css\";i:363;s:23:\"pullquote/theme.min.css\";i:364;s:39:\"query-pagination-numbers/editor-rtl.css\";i:365;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:366;s:35:\"query-pagination-numbers/editor.css\";i:367;s:39:\"query-pagination-numbers/editor.min.css\";i:368;s:31:\"query-pagination/editor-rtl.css\";i:369;s:35:\"query-pagination/editor-rtl.min.css\";i:370;s:27:\"query-pagination/editor.css\";i:371;s:31:\"query-pagination/editor.min.css\";i:372;s:30:\"query-pagination/style-rtl.css\";i:373;s:34:\"query-pagination/style-rtl.min.css\";i:374;s:26:\"query-pagination/style.css\";i:375;s:30:\"query-pagination/style.min.css\";i:376;s:25:\"query-title/style-rtl.css\";i:377;s:29:\"query-title/style-rtl.min.css\";i:378;s:21:\"query-title/style.css\";i:379;s:25:\"query-title/style.min.css\";i:380;s:25:\"query-total/style-rtl.css\";i:381;s:29:\"query-total/style-rtl.min.css\";i:382;s:21:\"query-total/style.css\";i:383;s:25:\"query-total/style.min.css\";i:384;s:20:\"query/editor-rtl.css\";i:385;s:24:\"query/editor-rtl.min.css\";i:386;s:16:\"query/editor.css\";i:387;s:20:\"query/editor.min.css\";i:388;s:19:\"quote/style-rtl.css\";i:389;s:23:\"quote/style-rtl.min.css\";i:390;s:15:\"quote/style.css\";i:391;s:19:\"quote/style.min.css\";i:392;s:19:\"quote/theme-rtl.css\";i:393;s:23:\"quote/theme-rtl.min.css\";i:394;s:15:\"quote/theme.css\";i:395;s:19:\"quote/theme.min.css\";i:396;s:23:\"read-more/style-rtl.css\";i:397;s:27:\"read-more/style-rtl.min.css\";i:398;s:19:\"read-more/style.css\";i:399;s:23:\"read-more/style.min.css\";i:400;s:18:\"rss/editor-rtl.css\";i:401;s:22:\"rss/editor-rtl.min.css\";i:402;s:14:\"rss/editor.css\";i:403;s:18:\"rss/editor.min.css\";i:404;s:17:\"rss/style-rtl.css\";i:405;s:21:\"rss/style-rtl.min.css\";i:406;s:13:\"rss/style.css\";i:407;s:17:\"rss/style.min.css\";i:408;s:21:\"search/editor-rtl.css\";i:409;s:25:\"search/editor-rtl.min.css\";i:410;s:17:\"search/editor.css\";i:411;s:21:\"search/editor.min.css\";i:412;s:20:\"search/style-rtl.css\";i:413;s:24:\"search/style-rtl.min.css\";i:414;s:16:\"search/style.css\";i:415;s:20:\"search/style.min.css\";i:416;s:20:\"search/theme-rtl.css\";i:417;s:24:\"search/theme-rtl.min.css\";i:418;s:16:\"search/theme.css\";i:419;s:20:\"search/theme.min.css\";i:420;s:24:\"separator/editor-rtl.css\";i:421;s:28:\"separator/editor-rtl.min.css\";i:422;s:20:\"separator/editor.css\";i:423;s:24:\"separator/editor.min.css\";i:424;s:23:\"separator/style-rtl.css\";i:425;s:27:\"separator/style-rtl.min.css\";i:426;s:19:\"separator/style.css\";i:427;s:23:\"separator/style.min.css\";i:428;s:23:\"separator/theme-rtl.css\";i:429;s:27:\"separator/theme-rtl.min.css\";i:430;s:19:\"separator/theme.css\";i:431;s:23:\"separator/theme.min.css\";i:432;s:24:\"shortcode/editor-rtl.css\";i:433;s:28:\"shortcode/editor-rtl.min.css\";i:434;s:20:\"shortcode/editor.css\";i:435;s:24:\"shortcode/editor.min.css\";i:436;s:24:\"site-logo/editor-rtl.css\";i:437;s:28:\"site-logo/editor-rtl.min.css\";i:438;s:20:\"site-logo/editor.css\";i:439;s:24:\"site-logo/editor.min.css\";i:440;s:23:\"site-logo/style-rtl.css\";i:441;s:27:\"site-logo/style-rtl.min.css\";i:442;s:19:\"site-logo/style.css\";i:443;s:23:\"site-logo/style.min.css\";i:444;s:27:\"site-tagline/editor-rtl.css\";i:445;s:31:\"site-tagline/editor-rtl.min.css\";i:446;s:23:\"site-tagline/editor.css\";i:447;s:27:\"site-tagline/editor.min.css\";i:448;s:26:\"site-tagline/style-rtl.css\";i:449;s:30:\"site-tagline/style-rtl.min.css\";i:450;s:22:\"site-tagline/style.css\";i:451;s:26:\"site-tagline/style.min.css\";i:452;s:25:\"site-title/editor-rtl.css\";i:453;s:29:\"site-title/editor-rtl.min.css\";i:454;s:21:\"site-title/editor.css\";i:455;s:25:\"site-title/editor.min.css\";i:456;s:24:\"site-title/style-rtl.css\";i:457;s:28:\"site-title/style-rtl.min.css\";i:458;s:20:\"site-title/style.css\";i:459;s:24:\"site-title/style.min.css\";i:460;s:26:\"social-link/editor-rtl.css\";i:461;s:30:\"social-link/editor-rtl.min.css\";i:462;s:22:\"social-link/editor.css\";i:463;s:26:\"social-link/editor.min.css\";i:464;s:27:\"social-links/editor-rtl.css\";i:465;s:31:\"social-links/editor-rtl.min.css\";i:466;s:23:\"social-links/editor.css\";i:467;s:27:\"social-links/editor.min.css\";i:468;s:26:\"social-links/style-rtl.css\";i:469;s:30:\"social-links/style-rtl.min.css\";i:470;s:22:\"social-links/style.css\";i:471;s:26:\"social-links/style.min.css\";i:472;s:21:\"spacer/editor-rtl.css\";i:473;s:25:\"spacer/editor-rtl.min.css\";i:474;s:17:\"spacer/editor.css\";i:475;s:21:\"spacer/editor.min.css\";i:476;s:20:\"spacer/style-rtl.css\";i:477;s:24:\"spacer/style-rtl.min.css\";i:478;s:16:\"spacer/style.css\";i:479;s:20:\"spacer/style.min.css\";i:480;s:20:\"table/editor-rtl.css\";i:481;s:24:\"table/editor-rtl.min.css\";i:482;s:16:\"table/editor.css\";i:483;s:20:\"table/editor.min.css\";i:484;s:19:\"table/style-rtl.css\";i:485;s:23:\"table/style-rtl.min.css\";i:486;s:15:\"table/style.css\";i:487;s:19:\"table/style.min.css\";i:488;s:19:\"table/theme-rtl.css\";i:489;s:23:\"table/theme-rtl.min.css\";i:490;s:15:\"table/theme.css\";i:491;s:19:\"table/theme.min.css\";i:492;s:24:\"tag-cloud/editor-rtl.css\";i:493;s:28:\"tag-cloud/editor-rtl.min.css\";i:494;s:20:\"tag-cloud/editor.css\";i:495;s:24:\"tag-cloud/editor.min.css\";i:496;s:23:\"tag-cloud/style-rtl.css\";i:497;s:27:\"tag-cloud/style-rtl.min.css\";i:498;s:19:\"tag-cloud/style.css\";i:499;s:23:\"tag-cloud/style.min.css\";i:500;s:28:\"template-part/editor-rtl.css\";i:501;s:32:\"template-part/editor-rtl.min.css\";i:502;s:24:\"template-part/editor.css\";i:503;s:28:\"template-part/editor.min.css\";i:504;s:27:\"template-part/theme-rtl.css\";i:505;s:31:\"template-part/theme-rtl.min.css\";i:506;s:23:\"template-part/theme.css\";i:507;s:27:\"template-part/theme.min.css\";i:508;s:30:\"term-description/style-rtl.css\";i:509;s:34:\"term-description/style-rtl.min.css\";i:510;s:26:\"term-description/style.css\";i:511;s:30:\"term-description/style.min.css\";i:512;s:27:\"text-columns/editor-rtl.css\";i:513;s:31:\"text-columns/editor-rtl.min.css\";i:514;s:23:\"text-columns/editor.css\";i:515;s:27:\"text-columns/editor.min.css\";i:516;s:26:\"text-columns/style-rtl.css\";i:517;s:30:\"text-columns/style-rtl.min.css\";i:518;s:22:\"text-columns/style.css\";i:519;s:26:\"text-columns/style.min.css\";i:520;s:19:\"verse/style-rtl.css\";i:521;s:23:\"verse/style-rtl.min.css\";i:522;s:15:\"verse/style.css\";i:523;s:19:\"verse/style.min.css\";i:524;s:20:\"video/editor-rtl.css\";i:525;s:24:\"video/editor-rtl.min.css\";i:526;s:16:\"video/editor.css\";i:527;s:20:\"video/editor.min.css\";i:528;s:19:\"video/style-rtl.css\";i:529;s:23:\"video/style-rtl.min.css\";i:530;s:15:\"video/style.css\";i:531;s:19:\"video/style.min.css\";i:532;s:19:\"video/theme-rtl.css\";i:533;s:23:\"video/theme-rtl.min.css\";i:534;s:15:\"video/theme.css\";i:535;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("22793", "_elementor_home_screen_data", "a:2:{s:7:\"timeout\";i:1752879860;s:5:\"value\";s:10885:\"{\"top_with_licences\":[{\"license\":[\"free\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Start building your website with Elementor\'s no code drag & drop editor.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=le72grP_Q6k&t=1s\",\"youtube_embed_id\":\"le72grP_Q6k?si=g2akyWNODL6usu6u\"},{\"license\":[\"pro\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Now you\'ve got all the tools to start creating professional, high-performing websites - and that journey begins by creating your first page.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=QdkDGrS8ZZs\",\"youtube_embed_id\":\"QdkDGrS8ZZs?si=s_VjZCQR6Fh1jgB5\"}],\"get_started\":[{\"license\":[\"free\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&page=popup_templates\",\"is_relative_url\":true,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\",\"title_small_color\":\"text.tertiary\"}]},{\"license\":[\"pro\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&tabs_group=popup&elementor_library_type=popup\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\"}]}],\"add_ons\":{\"header\":{\"title\":\"Expand your design toolkit\",\"description\":\"These plugins, add-ons, and tools, have been selected to streamline your workflow and maximize your creativity.\"},\"repeater\":[{\"file_path\":\"send-app\\/send-app.php\",\"title\":\"Send \\u2013 Marketing Automation\",\"url\":\"\",\"description\":\"Supercharge your WooCommerce store with Send\\u2014an all-in-one toolkit for emails, popups & more. Built for WordPress. No plugins, no hassle.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/send-logo.svg\",\"type\":\"wporg\"},{\"file_path\":\"site-mailer\\/site-mailer.php\",\"title\":\"Site Mailer\",\"url\":\"\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-mailer.svg\",\"type\":\"wporg\"},{\"file_path\":\"image-optimization\\/image-optimization.php\",\"title\":\"Image Optimizer\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-io\\/\",\"description\":\"Check out this incredibly useful plugin that will compress and optimize your images, giving you leaner, faster websites.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/image-optimizer.svg\",\"type\":\"wporg\"},{\"title\":\"Elementor AI\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-ai\\/\",\"description\":\"Boost creativity with Elementor AI. Craft & enhance copy, create custom CSS & Code, and generate images to elevate your website.\",\"button_label\":\"Let\'s go\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/elementor.svg\",\"type\":\"link\",\"condition\":{\"key\":\"introduction_meta\",\"value\":\"ai_get_started\"}}],\"footer\":{\"label\":\"Explore more add-ons\",\"file_path\":\"wp-admin\\/admin.php?page=elementor-apps\"}},\"sidebar_upgrade\":[{\"license\":[\"free\"],\"show\":\"true\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]},{\"license\":[\"pro\"],\"show\":\"false\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}],\"sidebar_promotion_variants\":[{\"license\":[\"essential\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/essential-upgrade.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-advanced-home-sidebar-upgrade\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/upgrade-free.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\"}},{\"license\":[\"expired\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/upgrade-free.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-expired\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}},{\"license\":[\"pro\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}}],\"external_links\":[{\"label\":\"Help Center\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-question-mark.svg\",\"url\":\"https:\\/\\/elementor.com\\/help\\/\"},{\"label\":\"Youtube\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-youtube.svg\",\"url\":\"https:\\/\\/www.youtube.com\\/@Elementor\"},{\"label\":\"Facebook Community\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-community.svg\",\"url\":\"https:\\/\\/www.facebook.com\\/groups\\/Elementors\"},{\"label\":\"Blog\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-academic-hat.svg\",\"url\":\"https:\\/\\/elementor.com\\/blog\\/\"}]}\";}", "off");
INSERT INTO `wp_options` VALUES("23079", "_transient_timeout_RTL-CareUnit-Updates", "1753122717", "off");
INSERT INTO `wp_options` VALUES("23080", "_transient_RTL-CareUnit-Updates", "O:8:\"stdClass\":16:{s:4:\"name\";s:41:\"مدیریت لایسنس راست چین\";s:4:\"slug\";s:12:\"RTL-CareUnit\";s:7:\"version\";s:5:\"2.6.3\";s:6:\"author\";s:14:\"راستچین\";s:14:\"author_profile\";s:26:\"https://www.rtl-theme.com/\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.4\";s:12:\"last_updated\";s:19:\"2025-03-31 10:12:00\";s:8:\"homepage\";s:26:\"https://www.rtl-theme.com/\";s:8:\"sections\";a:5:{s:11:\"description\";s:126:\"افزونه ای جهت فعالسازی، بروزرسانی و مراقبت از محصولات وردپرس راستچین\";s:12:\"installation\";s:0:\"\";s:3:\"faq\";s:0:\"\";s:9:\"changelog\";s:0:\"\";s:11:\"screenshots\";s:0:\"\";}s:13:\"download_link\";s:53:\"https://files.rtl-theme.com/plugins/rtlRsm/rtlRsm.zip\";s:11:\"screenshots\";a:0:{}s:4:\"tags\";a:0:{}s:8:\"versions\";a:0:{}s:7:\"banners\";a:2:{s:3:\"low\";s:61:\"https://files.rtl-theme.com/plugins/rtlRsm/banner-772x250.jpg\";s:4:\"high\";s:62:\"https://files.rtl-theme.com/plugins/rtlRsm/banner-1544x500.jpg\";}}", "off");
INSERT INTO `wp_options` VALUES("23153", "_transient_timeout_elementor_remote_info_api_data_3.30.2", "1753121021", "off");
INSERT INTO `wp_options` VALUES("23154", "_transient_elementor_remote_info_api_data_3.30.2", "a:4:{s:9:\"timestamp\";s:10:\"1753074414\";s:14:\"upgrade_notice\";a:3:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"message\";s:0:\"\";s:11:\"update_link\";s:0:\"\";}s:11:\"pro_widgets\";a:82:{i:0;a:4:{s:4:\"name\";s:6:\"search\";s:5:\"title\";s:6:\"Search\";s:4:\"icon\";s:17:\"eicon-site-search\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:1;a:4:{s:4:\"name\";s:5:\"posts\";s:5:\"title\";s:5:\"Posts\";s:4:\"icon\";s:15:\"eicon-post-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:2;a:4:{s:4:\"name\";s:9:\"portfolio\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:18:\"eicon-gallery-grid\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:3;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-2\";s:5:\"title\";s:7:\"Classic\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:4;a:4:{s:4:\"name\";s:9:\"mega-menu\";s:5:\"title\";s:4:\"Menu\";s:4:\"icon\";s:15:\"eicon-mega-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:5;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-3\";s:5:\"title\";s:8:\"Showcase\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:6;a:4:{s:4:\"name\";s:4:\"form\";s:5:\"title\";s:4:\"Form\";s:4:\"icon\";s:21:\"eicon-form-horizontal\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:7;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-4\";s:5:\"title\";s:5:\"Links\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:8;a:4:{s:4:\"name\";s:9:\"loop-grid\";s:5:\"title\";s:9:\"Loop Grid\";s:4:\"icon\";s:18:\"eicon-loop-builder\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:9;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-5\";s:5:\"title\";s:8:\"Services\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:10;a:4:{s:4:\"name\";s:13:\"loop-carousel\";s:5:\"title\";s:13:\"Loop Carousel\";s:4:\"icon\";s:19:\"eicon-carousel-loop\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:11;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-6\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:12;a:4:{s:4:\"name\";s:7:\"gallery\";s:5:\"title\";s:7:\"Gallery\";s:4:\"icon\";s:23:\"eicon-gallery-justified\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:13;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-7\";s:5:\"title\";s:13:\"Business Card\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:14;a:4:{s:4:\"name\";s:17:\"animated-headline\";s:5:\"title\";s:17:\"Animated Headline\";s:4:\"icon\";s:23:\"eicon-animated-headline\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:15;a:4:{s:4:\"name\";s:10:\"price-list\";s:5:\"title\";s:10:\"Price List\";s:4:\"icon\";s:16:\"eicon-price-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:16;a:4:{s:4:\"name\";s:11:\"price-table\";s:5:\"title\";s:11:\"Price Table\";s:4:\"icon\";s:17:\"eicon-price-table\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:17;a:4:{s:4:\"name\";s:8:\"flip-box\";s:5:\"title\";s:8:\"Flip Box\";s:4:\"icon\";s:14:\"eicon-flip-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:18;a:4:{s:4:\"name\";s:14:\"call-to-action\";s:5:\"title\";s:14:\"Call to Action\";s:4:\"icon\";s:20:\"eicon-image-rollover\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:19;a:4:{s:4:\"name\";s:14:\"media-carousel\";s:5:\"title\";s:14:\"Media Carousel\";s:4:\"icon\";s:20:\"eicon-media-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:20;a:4:{s:4:\"name\";s:15:\"nested-carousel\";s:5:\"title\";s:8:\"Carousel\";s:4:\"icon\";s:21:\"eicon-nested-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:21;a:4:{s:4:\"name\";s:10:\"off-canvas\";s:5:\"title\";s:10:\"Off-Canvas\";s:4:\"icon\";s:16:\"eicon-off-canvas\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:22;a:4:{s:4:\"name\";s:9:\"countdown\";s:5:\"title\";s:9:\"Countdown\";s:4:\"icon\";s:15:\"eicon-countdown\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:23;a:4:{s:4:\"name\";s:13:\"share-buttons\";s:5:\"title\";s:13:\"Share Buttons\";s:4:\"icon\";s:11:\"eicon-share\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:24;a:4:{s:4:\"name\";s:10:\"blockquote\";s:5:\"title\";s:10:\"Blockquote\";s:4:\"icon\";s:16:\"eicon-blockquote\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:25;a:4:{s:4:\"name\";s:6:\"lottie\";s:5:\"title\";s:6:\"Lottie\";s:4:\"icon\";s:12:\"eicon-lottie\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:26;a:4:{s:4:\"name\";s:7:\"hotspot\";s:5:\"title\";s:7:\"Hotspot\";s:4:\"icon\";s:19:\"eicon-image-hotspot\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:27;a:4:{s:4:\"name\";s:13:\"paypal-button\";s:5:\"title\";s:13:\"PayPal Button\";s:4:\"icon\";s:19:\"eicon-paypal-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:28;a:4:{s:4:\"name\";s:14:\"code-highlight\";s:5:\"title\";s:14:\"Code Highlight\";s:4:\"icon\";s:20:\"eicon-code-highlight\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:29;a:4:{s:4:\"name\";s:14:\"video-playlist\";s:5:\"title\";s:14:\"Video Playlist\";s:4:\"icon\";s:20:\"eicon-video-playlist\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:30;a:4:{s:4:\"name\";s:8:\"template\";s:5:\"title\";s:8:\"Template\";s:4:\"icon\";s:19:\"eicon-document-file\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:31;a:4:{s:4:\"name\";s:13:\"stripe-button\";s:5:\"title\";s:13:\"Stripe Button\";s:4:\"icon\";s:19:\"eicon-stripe-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:32;a:4:{s:4:\"name\";s:16:\"progress-tracker\";s:5:\"title\";s:16:\"Progress Tracker\";s:4:\"icon\";s:22:\"eicon-progress-tracker\";s:10:\"categories\";s:40:\"[\"pro-elements\",\"theme-elements-single\"]\";}i:33;a:4:{s:4:\"name\";s:8:\"nav-menu\";s:5:\"title\";s:8:\"Nav Menu\";s:4:\"icon\";s:14:\"eicon-nav-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:34;a:4:{s:4:\"name\";s:17:\"table-of-contents\";s:5:\"title\";s:17:\"Table of Contents\";s:4:\"icon\";s:23:\"eicon-table-of-contents\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:35;a:4:{s:4:\"name\";s:5:\"login\";s:5:\"title\";s:5:\"Login\";s:4:\"icon\";s:15:\"eicon-lock-user\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:36;a:4:{s:4:\"name\";s:6:\"slides\";s:5:\"title\";s:6:\"Slides\";s:4:\"icon\";s:12:\"eicon-slides\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:37;a:4:{s:4:\"name\";s:20:\"testimonial-carousel\";s:5:\"title\";s:20:\"Testimonial Carousel\";s:4:\"icon\";s:26:\"eicon-testimonial-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:38;a:4:{s:4:\"name\";s:7:\"reviews\";s:5:\"title\";s:7:\"Reviews\";s:4:\"icon\";s:12:\"eicon-review\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:39;a:4:{s:4:\"name\";s:15:\"facebook-button\";s:5:\"title\";s:15:\"Facebook Button\";s:4:\"icon\";s:23:\"eicon-facebook-like-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:40;a:4:{s:4:\"name\";s:17:\"facebook-comments\";s:5:\"title\";s:17:\"Facebook Comments\";s:4:\"icon\";s:23:\"eicon-facebook-comments\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:41;a:4:{s:4:\"name\";s:14:\"facebook-embed\";s:5:\"title\";s:14:\"Facebook Embed\";s:4:\"icon\";s:14:\"eicon-fb-embed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:42;a:4:{s:4:\"name\";s:13:\"facebook-page\";s:5:\"title\";s:13:\"Facebook Page\";s:4:\"icon\";s:13:\"eicon-fb-feed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:43;a:4:{s:4:\"name\";s:15:\"theme-site-logo\";s:5:\"title\";s:9:\"Site Logo\";s:4:\"icon\";s:15:\"eicon-site-logo\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:44;a:4:{s:4:\"name\";s:16:\"theme-site-title\";s:5:\"title\";s:10:\"Site Title\";s:4:\"icon\";s:16:\"eicon-site-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:45;a:4:{s:4:\"name\";s:16:\"theme-page-title\";s:5:\"title\";s:10:\"Page Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:46;a:4:{s:4:\"name\";s:16:\"theme-post-title\";s:5:\"title\";s:10:\"Post Title\";s:4:\"icon\";s:16:\"eicon-post-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:47;a:4:{s:4:\"name\";s:18:\"theme-post-excerpt\";s:5:\"title\";s:12:\"Post Excerpt\";s:4:\"icon\";s:18:\"eicon-post-excerpt\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:48;a:4:{s:4:\"name\";s:25:\"theme-post-featured-image\";s:5:\"title\";s:14:\"Featured Image\";s:4:\"icon\";s:20:\"eicon-featured-image\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:49;a:4:{s:4:\"name\";s:19:\"theme-archive-title\";s:5:\"title\";s:13:\"Archive Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:50;a:4:{s:4:\"name\";s:13:\"archive-posts\";s:5:\"title\";s:13:\"Archive Posts\";s:4:\"icon\";s:19:\"eicon-archive-posts\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:51;a:4:{s:4:\"name\";s:10:\"author-box\";s:5:\"title\";s:10:\"Author Box\";s:4:\"icon\";s:12:\"eicon-person\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:52;a:4:{s:4:\"name\";s:13:\"post-comments\";s:5:\"title\";s:13:\"Post Comments\";s:4:\"icon\";s:14:\"eicon-comments\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:53;a:4:{s:4:\"name\";s:15:\"post-navigation\";s:5:\"title\";s:15:\"Post Navigation\";s:4:\"icon\";s:21:\"eicon-post-navigation\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:54;a:4:{s:4:\"name\";s:9:\"post-info\";s:5:\"title\";s:9:\"Post Info\";s:4:\"icon\";s:15:\"eicon-post-info\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:55;a:4:{s:4:\"name\";s:7:\"sitemap\";s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:13:\"eicon-sitemap\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:56;a:4:{s:4:\"name\";s:11:\"breadcrumbs\";s:5:\"title\";s:11:\"Breadcrumbs\";s:4:\"icon\";s:11:\"eicon-yoast\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:57;a:4:{s:4:\"name\";s:21:\"woocommerce-menu-cart\";s:5:\"title\";s:9:\"Menu Cart\";s:4:\"icon\";s:10:\"eicon-cart\";s:10:\"categories\";s:41:\"[\"theme-elements\",\"woocommerce-elements\"]\";}i:58;a:4:{s:4:\"name\";s:19:\"wc-archive-products\";s:5:\"title\";s:16:\"Archive Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:59;a:4:{s:4:\"name\";s:31:\"woocommerce-archive-description\";s:5:\"title\";s:19:\"Archive Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:60;a:4:{s:4:\"name\";s:20:\"woocommerce-products\";s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:61;a:4:{s:4:\"name\";s:22:\"woocommerce-breadcrumb\";s:5:\"title\";s:23:\"WooCommerce Breadcrumbs\";s:4:\"icon\";s:25:\"eicon-product-breadcrumbs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:62;a:4:{s:4:\"name\";s:14:\"wc-add-to-cart\";s:5:\"title\";s:18:\"Custom Add To Cart\";s:4:\"icon\";s:17:\"eicon-woocommerce\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:63;a:4:{s:4:\"name\";s:11:\"wc-elements\";s:5:\"title\";s:17:\"WooCommerce Pages\";s:4:\"icon\";s:19:\"eicon-product-pages\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:64;a:4:{s:4:\"name\";s:13:\"wc-categories\";s:5:\"title\";s:18:\"Product Categories\";s:4:\"icon\";s:24:\"eicon-product-categories\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:65;a:4:{s:4:\"name\";s:25:\"woocommerce-product-title\";s:5:\"title\";s:13:\"Product Title\";s:4:\"icon\";s:19:\"eicon-product-title\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:66;a:4:{s:4:\"name\";s:26:\"woocommerce-product-images\";s:5:\"title\";s:14:\"Product Images\";s:4:\"icon\";s:20:\"eicon-product-images\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:67;a:4:{s:4:\"name\";s:25:\"woocommerce-product-price\";s:5:\"title\";s:13:\"Product Price\";s:4:\"icon\";s:19:\"eicon-product-price\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:68;a:4:{s:4:\"name\";s:31:\"woocommerce-product-add-to-cart\";s:5:\"title\";s:11:\"Add To Cart\";s:4:\"icon\";s:25:\"eicon-product-add-to-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:69;a:4:{s:4:\"name\";s:26:\"woocommerce-product-rating\";s:5:\"title\";s:14:\"Product Rating\";s:4:\"icon\";s:20:\"eicon-product-rating\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:70;a:4:{s:4:\"name\";s:25:\"woocommerce-product-stock\";s:5:\"title\";s:13:\"Product Stock\";s:4:\"icon\";s:19:\"eicon-product-stock\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:71;a:4:{s:4:\"name\";s:24:\"woocommerce-product-meta\";s:5:\"title\";s:12:\"Product Meta\";s:4:\"icon\";s:18:\"eicon-product-meta\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:72;a:4:{s:4:\"name\";s:37:\"woocommerce-product-short-description\";s:5:\"title\";s:17:\"Short Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:73;a:4:{s:4:\"name\";s:29:\"woocommerce-product-data-tabs\";s:5:\"title\";s:17:\"Product Data Tabs\";s:4:\"icon\";s:18:\"eicon-product-tabs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:74;a:4:{s:4:\"name\";s:42:\"woocommerce-product-additional-information\";s:5:\"title\";s:22:\"Additional Information\";s:4:\"icon\";s:19:\" eicon-product-info\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:75;a:4:{s:4:\"name\";s:27:\"woocommerce-product-related\";s:5:\"title\";s:15:\"Product Related\";s:4:\"icon\";s:21:\"eicon-product-related\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:76;a:4:{s:4:\"name\";s:26:\"woocommerce-product-upsell\";s:5:\"title\";s:7:\"Upsells\";s:4:\"icon\";s:20:\"eicon-product-upsell\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:77;a:4:{s:4:\"name\";s:25:\"woocommerce-checkout-page\";s:5:\"title\";s:8:\"Checkout\";s:4:\"icon\";s:14:\"eicon-checkout\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:78;a:4:{s:4:\"name\";s:16:\"woocommerce-cart\";s:5:\"title\";s:4:\"Cart\";s:4:\"icon\";s:14:\"eicon-woo-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:79;a:4:{s:4:\"name\";s:22:\"woocommerce-my-account\";s:5:\"title\";s:10:\"My Account\";s:4:\"icon\";s:16:\"eicon-my-account\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:80;a:4:{s:4:\"name\";s:28:\"woocommerce-purchase-summary\";s:5:\"title\";s:16:\"Purchase Summary\";s:4:\"icon\";s:22:\"eicon-purchase-summary\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:81;a:4:{s:4:\"name\";s:19:\"woocommerce-notices\";s:5:\"title\";s:19:\"WooCommerce Notices\";s:4:\"icon\";s:25:\"eicon-woocommerce-notices\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:11:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.6.0\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"6.8.2\";s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"conditions\";a:0:{}}}", "off");
INSERT INTO `wp_options` VALUES("23174", "_site_transient_timeout_available_translations", "1753098506", "off");
INSERT INTO `wp_options` VALUES("23175", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.9\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.9/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.5/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-10 08:09:09\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.5/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2024-12-26 00:37:42\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.26/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-26 09:35:39\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-01 14:03:28\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-10 13:56:56\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.7.2\";s:7:\"updated\";s:19:\"2025-05-15 15:31:31\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-11 16:48:51\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-10 07:10:07\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-04-24 21:44:57\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-09 20:17:04\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-09 20:13:10\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.8.2/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-04-24 21:46:51\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.8.2/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-05 10:10:20\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-05 16:34:49\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-05 09:19:20\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-05-25 12:26:44\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-05-22 08:43:39\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-04 17:42:40\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-05-22 11:56:25\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-11 09:05:01\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-05-26 16:45:13\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2024-10-16 21:04:12\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-05-27 00:56:11\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-14 15:46:25\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-11 05:24:36\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-09 10:04:44\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.10/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.16/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-05 19:07:27\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.21\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.21/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-05 12:26:55\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-02-14 17:29:08\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-12 18:44:02\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-05-12 09:41:09\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-04-29 15:18:18\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-17 13:42:46\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.6/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-16 11:10:04\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-24 18:50:16\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.34\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.34/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2025-02-06 05:17:11\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-13 10:59:05\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-09 13:56:03\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-15 02:43:12\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.26/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-11 21:28:29\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-11 12:59:20\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.26/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-04-14 08:02:58\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.21\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.21/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-13 10:36:33\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-18 05:34:36\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-08 23:20:54\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.2/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-17 05:00:42\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.2/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-13 13:11:03\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-15 19:11:43\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.9\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.9/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.7.2\";s:7:\"updated\";s:19:\"2025-03-20 16:41:38\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-19 11:39:21\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.15\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.15/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-11 03:23:53\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-21 11:55:40\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-05-26 13:34:38\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-13 19:35:47\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-14 10:43:29\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.8.2/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-15 10:57:19\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.35\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.35/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-05-05 11:53:58\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-05-02 11:51:48\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-05-02 11:55:29\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.8.2/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-09 11:31:16\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-16 13:29:55\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.16/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-18 10:06:37\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-04-24 16:58:02\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.2/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-15 06:12:29\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-04-18 09:38:51\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"6.7.2\";s:7:\"updated\";s:19:\"2024-09-20 22:15:56\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.2/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-08 16:28:16\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-28 12:50:48\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.10/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-08 16:09:09\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-04-16 23:11:08\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-18 21:39:23\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"6.8\";s:7:\"updated\";s:19:\"2025-04-18 21:10:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.8/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.16/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-19 02:17:53\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-05-04 17:30:55\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-16 04:41:52\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "off");
INSERT INTO `wp_options` VALUES("23193", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.8.2.zip\";s:6:\"locale\";s:5:\"fa_IR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.8.2.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.8.2\";s:7:\"version\";s:5:\"6.8.2\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1753090964;s:15:\"version_checked\";s:5:\"6.8.2\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("23195", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1753091023;s:7:\"checked\";a:1:{s:6:\"harika\";s:3:\"4.2\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:0:{}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("23196", "wp_mail_smtp_initial_version", "4.5.0", "off");
INSERT INTO `wp_options` VALUES("23197", "wp_mail_smtp_version", "4.5.0", "off");
INSERT INTO `wp_options` VALUES("23198", "wp_mail_smtp", "a:21:{s:4:\"mail\";a:6:{s:10:\"from_email\";s:19:\"info@webdev-demo.ir\";s:9:\"from_name\";s:21:\"قالب هاریکا\";s:6:\"mailer\";s:4:\"smtp\";s:11:\"return_path\";b:0;s:16:\"from_email_force\";b:1;s:15:\"from_name_force\";b:1;}s:4:\"smtp\";a:7:{s:7:\"autotls\";b:1;s:4:\"auth\";b:1;s:4:\"host\";s:21:\"mana.shetabanhost.com\";s:4:\"port\";i:587;s:10:\"encryption\";s:3:\"tls\";s:4:\"user\";s:19:\"info@webdev-demo.ir\";s:4:\"pass\";s:76:\"zoAaUndFpVlxukCo2+rjqmTPaExsGVMF620cmRPhh1G7mefGY60zxPnZ3CUV/6wlFHAXxTHr0gU=\";}s:7:\"general\";a:1:{s:29:\"summary_report_email_disabled\";b:0;}s:9:\"sendlayer\";a:1:{s:7:\"api_key\";s:0:\"\";}s:7:\"smtpcom\";a:2:{s:7:\"api_key\";s:0:\"\";s:7:\"channel\";s:0:\"\";}s:10:\"sendinblue\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";}s:10:\"mailersend\";a:2:{s:7:\"api_key\";s:0:\"\";s:12:\"has_pro_plan\";b:0;}s:7:\"mailgun\";a:3:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";s:6:\"region\";s:2:\"US\";}s:7:\"mailjet\";a:2:{s:7:\"api_key\";s:0:\"\";s:10:\"secret_key\";s:0:\"\";}s:8:\"sendgrid\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";}s:7:\"smtp2go\";a:1:{s:7:\"api_key\";s:0:\"\";}s:9:\"sparkpost\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"region\";s:2:\"US\";}s:8:\"postmark\";a:2:{s:16:\"server_api_token\";s:0:\"\";s:14:\"message_stream\";s:0:\"\";}s:9:\"amazonses\";a:3:{s:9:\"client_id\";s:0:\"\";s:13:\"client_secret\";s:0:\"\";s:6:\"region\";s:9:\"us-east-1\";}s:12:\"elasticemail\";a:1:{s:7:\"api_key\";s:0:\"\";}s:5:\"gmail\";a:8:{s:9:\"client_id\";s:0:\"\";s:13:\"client_secret\";s:0:\"\";s:12:\"access_token\";a:0:{}s:13:\"refresh_token\";s:0:\"\";s:12:\"user_details\";a:1:{s:5:\"email\";s:0:\"\";}s:23:\"one_click_setup_enabled\";b:0;s:27:\"one_click_setup_credentials\";a:2:{s:3:\"key\";s:0:\"\";s:5:\"token\";s:0:\"\";}s:28:\"one_click_setup_user_details\";a:1:{s:5:\"email\";s:0:\"\";}}s:7:\"outlook\";a:8:{s:9:\"client_id\";s:0:\"\";s:13:\"client_secret\";s:0:\"\";s:12:\"access_token\";a:0:{}s:13:\"refresh_token\";s:0:\"\";s:12:\"user_details\";a:1:{s:5:\"email\";s:0:\"\";}s:23:\"one_click_setup_enabled\";b:0;s:27:\"one_click_setup_credentials\";a:3:{s:12:\"access_token\";s:0:\"\";s:13:\"refresh_token\";s:0:\"\";s:7:\"expires\";s:0:\"\";}s:28:\"one_click_setup_user_details\";a:1:{s:5:\"email\";s:0:\"\";}}s:4:\"zoho\";a:6:{s:9:\"client_id\";s:0:\"\";s:13:\"client_secret\";s:0:\"\";s:6:\"domain\";s:3:\"com\";s:12:\"access_token\";a:0:{}s:13:\"refresh_token\";s:0:\"\";s:12:\"user_details\";a:1:{s:5:\"email\";s:0:\"\";}}s:4:\"logs\";a:5:{s:7:\"enabled\";b:0;s:17:\"log_email_content\";b:0;s:16:\"save_attachments\";b:0;s:19:\"open_email_tracking\";b:0;s:19:\"click_link_tracking\";b:0;}s:11:\"alert_email\";a:2:{s:7:\"enabled\";b:0;s:11:\"connections\";a:0:{}}s:7:\"license\";a:5:{s:3:\"key\";s:0:\"\";s:10:\"is_expired\";b:0;s:11:\"is_disabled\";b:0;s:10:\"is_invalid\";b:0;s:16:\"is_limit_reached\";b:0;}}", "off");
INSERT INTO `wp_options` VALUES("23199", "wp_mail_smtp_activated_time", "1753090966", "off");
INSERT INTO `wp_options` VALUES("23200", "wp_mail_smtp_activated", "a:1:{s:4:\"lite\";i:1753090966;}", "auto");
INSERT INTO `wp_options` VALUES("23201", "_transient_timeout_wp_mail_smtp_just_activated", "1753091026", "off");
INSERT INTO `wp_options` VALUES("23202", "_transient_wp_mail_smtp_just_activated", "1", "off");
INSERT INTO `wp_options` VALUES("23205", "_transient_timeout_as-post-store-dependencies-met", "1753177367", "off");
INSERT INTO `wp_options` VALUES("23206", "_transient_as-post-store-dependencies-met", "yes", "off");
INSERT INTO `wp_options` VALUES("23208", "wp_mail_smtp_migration_version", "5", "on");
INSERT INTO `wp_options` VALUES("23209", "wp_mail_smtp_debug_events_db_version", "1", "on");
INSERT INTO `wp_options` VALUES("23210", "wp_mail_smtp_activation_prevent_redirect", "1", "auto");
INSERT INTO `wp_options` VALUES("23211", "wp_mail_smtp_setup_wizard_stats", "a:3:{s:13:\"launched_time\";i:1753090973;s:14:\"completed_time\";i:1753091041;s:14:\"was_successful\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("23212", "wp_mail_smtp_mail_key", "JRVyMXIVl0QY4xdPHo5tzQt7lC4zT6GzRd/LN4KCFZE=", "auto");
INSERT INTO `wp_options` VALUES("23215", "wpforms_activation_redirect", "1", "auto");
INSERT INTO `wp_options` VALUES("23216", "wpforms_installation_source", "wp-mail-smtp-setup-wizard", "auto");
INSERT INTO `wp_options` VALUES("23217", "wpforms_version", "1.9.6.2", "auto");
INSERT INTO `wp_options` VALUES("23218", "wpforms_version_lite", "1.9.6.2", "auto");
INSERT INTO `wp_options` VALUES("23219", "wpforms_activated", "a:1:{s:4:\"lite\";i:1753091024;}", "auto");
INSERT INTO `wp_options` VALUES("23220", "_transient_timeout_wpforms_just_activated", "1753091084", "off");
INSERT INTO `wp_options` VALUES("23221", "_transient_wpforms_just_activated", "lite", "off");
INSERT INTO `wp_options` VALUES("23224", "wpforms_versions_lite", "a:14:{s:5:\"1.5.9\";i:0;s:7:\"1.6.7.2\";i:0;s:5:\"1.6.8\";i:0;s:5:\"1.7.5\";i:0;s:7:\"1.7.5.1\";i:0;s:5:\"1.7.7\";i:0;s:5:\"1.8.2\";i:0;s:5:\"1.8.3\";i:0;s:5:\"1.8.4\";i:0;s:5:\"1.8.6\";i:0;s:5:\"1.8.7\";i:0;s:5:\"1.9.1\";i:0;s:5:\"1.9.2\";i:0;s:7:\"1.9.6.2\";i:1753091038;}", "auto");
INSERT INTO `wp_options` VALUES("23225", "wpforms_constant_contact_version", "3", "auto");
INSERT INTO `wp_options` VALUES("23226", "widget_wpforms-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("23227", "wpforms_settings", "a:3:{s:13:\"modern-markup\";s:1:\"1\";s:20:\"modern-markup-is-set\";b:1;s:26:\"modern-markup-hide-setting\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("23229", "wpforms_admin_notices", "a:1:{s:14:\"review_request\";a:2:{s:4:\"time\";i:1753091039;s:9:\"dismissed\";b:0;}}", "auto");
INSERT INTO `wp_options` VALUES("23230", "wp_mail_smtp_debug", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("23231", "wp_mail_smtp_lite_sent_email_counter", "5", "on");
INSERT INTO `wp_options` VALUES("23232", "wp_mail_smtp_lite_weekly_sent_email_counter", "a:1:{i:30;i:5;}", "on");
INSERT INTO `wp_options` VALUES("23235", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1753091047;s:8:\"response\";a:0:{}s:12:\"translations\";a:1:{i:0;a:7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:12:\"wpforms-lite\";s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:7:\"1.9.6.2\";s:7:\"updated\";s:19:\"2025-04-29 10:31:38\";s:7:\"package\";s:81:\"https://downloads.wordpress.org/translation/plugin/wpforms-lite/1.9.6.2/fa_IR.zip\";s:10:\"autoupdate\";b:1;}}s:9:\"no_update\";a:7:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"5.5\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/akismet.5.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731\";s:2:\"1x\";s:62:\"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";}s:33:\"classic-editor/classic-editor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/classic-editor\";s:4:\"slug\";s:14:\"classic-editor\";s:6:\"plugin\";s:33:\"classic-editor/classic-editor.php\";s:11:\"new_version\";s:5:\"1.6.7\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/classic-editor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/classic-editor.1.6.7.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-256x256.png?rev=1998671\";s:2:\"1x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-128x128.png?rev=1998671\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/classic-editor/assets/banner-1544x500.png?rev=1998671\";s:2:\"1x\";s:69:\"https://ps.w.org/classic-editor/assets/banner-772x250.png?rev=1998676\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:3:\"6.1\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.6.1.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.7\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.5.13\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.5.13.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";}s:23:\"elementor/elementor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:6:\"3.30.2\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}s:24:\"wpforms-lite/wpforms.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:26:\"w.org/plugins/wpforms-lite\";s:4:\"slug\";s:12:\"wpforms-lite\";s:6:\"plugin\";s:24:\"wpforms-lite/wpforms.php\";s:11:\"new_version\";s:7:\"1.9.6.2\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/wpforms-lite/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/wpforms-lite.1.9.6.2.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:57:\"https://ps.w.org/wpforms-lite/assets/icon.svg?rev=3254748\";s:3:\"svg\";s:57:\"https://ps.w.org/wpforms-lite/assets/icon.svg?rev=3254748\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/wpforms-lite/assets/banner-1544x500.png?rev=3091364\";s:2:\"1x\";s:67:\"https://ps.w.org/wpforms-lite/assets/banner-772x250.png?rev=3091364\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/wpforms-lite/assets/banner-1544x500-rtl.png?rev=3254748\";s:2:\"1x\";s:71:\"https://ps.w.org/wpforms-lite/assets/banner-772x250-rtl.png?rev=3254748\";}s:8:\"requires\";s:3:\"5.5\";}s:29:\"wp-mail-smtp/wp_mail_smtp.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:26:\"w.org/plugins/wp-mail-smtp\";s:4:\"slug\";s:12:\"wp-mail-smtp\";s:6:\"plugin\";s:29:\"wp-mail-smtp/wp_mail_smtp.php\";s:11:\"new_version\";s:5:\"4.5.0\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/wp-mail-smtp/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wp-mail-smtp.4.5.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/wp-mail-smtp/assets/icon-256x256.png?rev=1755440\";s:2:\"1x\";s:65:\"https://ps.w.org/wp-mail-smtp/assets/icon-128x128.png?rev=1755440\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/wp-mail-smtp/assets/banner-1544x500.png?rev=3206423\";s:2:\"1x\";s:67:\"https://ps.w.org/wp-mail-smtp/assets/banner-772x250.png?rev=3206423\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.5\";}}s:7:\"checked\";a:8:{s:19:\"akismet/akismet.php\";s:3:\"5.5\";s:33:\"classic-editor/classic-editor.php\";s:5:\"1.6.7\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:3:\"6.1\";s:25:\"duplicator/duplicator.php\";s:6:\"1.5.13\";s:23:\"elementor/elementor.php\";s:6:\"3.30.2\";s:24:\"wpforms-lite/wpforms.php\";s:7:\"1.9.6.2\";s:29:\"wp-mail-smtp/wp_mail_smtp.php\";s:5:\"4.5.0\";s:29:\"RTL-CareUnit/RTL-CareUnit.php\";s:5:\"2.5.2\";}}", "off");
INSERT INTO `wp_options` VALUES("23236", "wpforms_splash_version", "1.8.6", "auto");
INSERT INTO `wp_options` VALUES("23237", "wp_mail_smtp_review_notice", "a:2:{s:4:\"time\";i:1753091047;s:9:\"dismissed\";b:0;}", "auto");
INSERT INTO `wp_options` VALUES("23238", "rtl_rsm_isSendFirstLicenseEmail", "1", "off");
INSERT INTO `wp_options` VALUES("23239", "rtl_rsm_isSendSecondLicenseEmail", "1", "off");
INSERT INTO `wp_options` VALUES("23240", "rtl_rsm_isSendLastLicenseEmail", "1", "off");
INSERT INTO `wp_options` VALUES("23242", "_wpforms_transient_upload_htaccess_file", "a:3:{s:4:\"size\";i:737;s:5:\"mtime\";i:1753091131;s:5:\"ctime\";i:1753091131;}", "on");
INSERT INTO `wp_options` VALUES("23243", "wpforms_email_summaries_fetch_info_blocks_last_run", "1753091131", "auto");
INSERT INTO `wp_options` VALUES("23244", "wpforms_process_forms_locator_status", "completed", "auto");
INSERT INTO `wp_options` VALUES("23246", "wp_mail_smtp_notifications", "a:4:{s:6:\"update\";i:1753091132;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("23247", "_wpforms_transient_timeout_addons.json", "1753695942", "off");
INSERT INTO `wp_options` VALUES("23248", "_wpforms_transient_addons.json", "1753091142", "off");
INSERT INTO `wp_options` VALUES("23249", "_transient_timeout_action_scheduler_last_pastdue_actions_check", "1753112743", "off");
INSERT INTO `wp_options` VALUES("23250", "_transient_action_scheduler_last_pastdue_actions_check", "1753091143", "off");
INSERT INTO `wp_options` VALUES("23273", "elementor-custom-breakpoints-files", "a:23:{s:23:\"custom-apple-webkit.min\";a:1:{s:4:\"time\";i:1753100379;}s:19:\"custom-lightbox.min\";a:1:{s:4:\"time\";i:1753100379;}s:23:\"custom-frontend-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:31:\"custom-widget-accordion-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:27:\"custom-widget-alert-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:30:\"custom-widget-icon-box-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:31:\"custom-widget-icon-list-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:31:\"custom-widget-image-box-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:35:\"custom-widget-image-gallery-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:30:\"custom-widget-progress-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:33:\"custom-widget-star-rating-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:26:\"custom-widget-tabs-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:28:\"custom-widget-toggle-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:33:\"custom-widget-nested-tabs-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:33:\"custom-widget-link-in-bio-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:38:\"custom-widget-link-in-bio-base-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:38:\"custom-widget-floating-buttons-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:40:\"custom-widget-floating-bars-base-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:41:\"custom-widget-floating-bars-var-3-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:42:\"custom-widget-contact-buttons-base-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:43:\"custom-widget-contact-buttons-var-7-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:43:\"custom-widget-contact-buttons-var-9-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}s:44:\"custom-widget-contact-buttons-var-10-rtl.min\";a:1:{s:4:\"time\";i:1753100379;}}", "auto");
INSERT INTO `wp_options` VALUES("23279", "_site_transient_timeout_theme_roots", "1753105114", "off");
INSERT INTO `wp_options` VALUES("23280", "_site_transient_theme_roots", "a:1:{s:6:\"harika\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("23281", "_site_transient_timeout_wp_theme_files_patterns-4affef7b7e17fb82d44ce76c0dcfec7d", "1753105286", "off");
INSERT INTO `wp_options` VALUES("23282", "_site_transient_wp_theme_files_patterns-4affef7b7e17fb82d44ce76c0dcfec7d", "a:2:{s:7:\"version\";s:3:\"4.2\";s:8:\"patterns\";a:0:{}}", "off");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("3", "5", "_form", "[text* your-name placeholder \"نام شما\"]\n\n[email* your-email placeholder \"ایمیل شما\"]\n\n[text* your-subject placeholder \"موضوع\"]\n\n[textarea your-message placeholder \"متن پیام\"]\n\n[submit \"ارسال پیام\"]");
INSERT INTO `wp_postmeta` VALUES("4", "5", "_mail", "a:9:{s:6:\"active\";b:1;s:7:\"subject\";s:30:\"[_site_title] \"[your-subject]\"\";s:6:\"sender\";s:35:\"[_site_title] <wpthemeir@gmail.com>\";s:9:\"recipient\";s:19:\"[_site_admin_email]\";s:4:\"body\";s:203:\"از : [your-name] <[your-email]>\nموضوع: [your-subject]\n\nمحتوای پیام :\n[your-message]\n\n-- \nاین ایمیل از فرم تماس در [_site_title] ([_site_url]) ارسال شده است.\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("5", "5", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:30:\"[_site_title] \"[your-subject]\"\";s:6:\"sender\";s:35:\"[_site_title] <wpthemeir@gmail.com>\";s:9:\"recipient\";s:12:\"[your-email]\";s:4:\"body\";s:220:\"Message Body:\n[your-message]\n\n-- \nThis email is a receipt for your contact form submission on our website ([_site_title] [_site_url]) in which your email address was used. If that was not you, please ignore this message.\";s:18:\"additional_headers\";s:29:\"Reply-To: [_site_admin_email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("6", "5", "_messages", "a:22:{s:12:\"mail_sent_ok\";s:88:\"از پیام شما متشکریم، پیام شما با موفقیت ارسال شد.\";s:12:\"mail_sent_ng\";s:135:\"هنگام تلاش برای ارسال پیام شما خطایی روی داد. لطفا بعدا دوباره امتحان کنید.\";s:16:\"validation_error\";s:128:\"یک یا چند فیلد دارای یک خطا هستند. لطفا بررسی کنید و دوباره امتحان کنید.\";s:4:\"spam\";s:54:\"ارسال به عنوان هرزنامه ثبت شد.\";s:12:\"accept_terms\";s:89:\"قبل از ارسال پیام باید شرایط و ضوابط را قبول کنید.\";s:16:\"invalid_required\";s:34:\"فیلد مورد نیاز است.\";s:16:\"invalid_too_long\";s:47:\"این زمینه خیلی طولانی است.\";s:17:\"invalid_too_short\";s:45:\"این زمینه خیلی کوتاه است.\";s:13:\"upload_failed\";s:64:\"مشکلی در آپلود فایل شما رخ داده است.\";s:24:\"upload_file_type_invalid\";s:79:\"شما اجازه ندارید از این نوع فایل آپلود کنید.\";s:21:\"upload_file_too_large\";s:50:\"حجم فایل شما بسیار زیاد است.\";s:23:\"upload_failed_php_error\";s:64:\"مشکلی در آپلود فایل شما رخ داده است.\";s:12:\"invalid_date\";s:91:\"لطفا تاریخ را با فرمت YYYY-MM-DD (روز-ماه-سال) وارد کنید.\";s:14:\"date_too_early\";s:56:\"این زمینه تاریخ خیلی زودی دارد.\";s:13:\"date_too_late\";s:56:\"این زمینه تاریخ خیلی دیری دارد.\";s:14:\"invalid_number\";s:43:\"لطفا یک شماره وارد کنید.\";s:16:\"number_too_small\";s:62:\"این زمینه شماره بسیار کوتاهی دارد.\";s:16:\"number_too_large\";s:62:\"این زمینه شماره بسیار طولانی دارد.\";s:23:\"quiz_answer_not_correct\";s:52:\"جواب شما به آزمون اشتباه است.\";s:13:\"invalid_email\";s:52:\"لطفا یک آدرس ایمیل وارد کنید.\";s:11:\"invalid_url\";s:48:\"لطفا یک نشانی وب وارد کنید.\";s:11:\"invalid_tel\";s:52:\"لطفا یک شماره تلفن وارد کنید.\";}");
INSERT INTO `wp_postmeta` VALUES("7", "5", "_additional_settings", "");
INSERT INTO `wp_postmeta` VALUES("8", "5", "_locale", "fa_IR");
INSERT INTO `wp_postmeta` VALUES("9", "5", "_hash", "e194050d1e58cb1f32007c7bd685c725750f0956");
INSERT INTO `wp_postmeta` VALUES("10", "6", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("11", "6", "_elementor_template_type", "kit");
INSERT INTO `wp_postmeta` VALUES("14", "9", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("15", "9", "_edit_lock", "1749998301:1");
INSERT INTO `wp_postmeta` VALUES("16", "9", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("17", "9", "harika_page_meta", "a:5:{s:23:\"select_page_header_meta\";s:1:\"0\";s:23:\"select_page_footer_meta\";s:1:\"0\";s:23:\"primary_page_color_meta\";s:0:\"\";s:25:\"secondary_page_color_meta\";s:0:\"\";s:20:\"body_page_color_meta\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("18", "9", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("19", "9", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("20", "9", "_elementor_version", "3.29.1");
INSERT INTO `wp_postmeta` VALUES("28", "12", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("29", "12", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("30", "12", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("31", "12", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("32", "13", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("33", "13", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("34", "13", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("35", "13", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("36", "9", "_elementor_data", "[{\"id\":\"78a8815\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"padding\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[{\"id\":\"8e60622\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"tile_style\":\"1\",\"image_size\":\"harika-700-450\",\"image_hover_scale\":\"1.1\",\"scale_speed\":{\"unit\":\"px\",\"size\":0.5,\"sizes\":[]},\"show_date\":\"\",\"title_wrap\":\"\",\"excerpt_length\":6,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_source\":\"manual_selection\",\"posts_selected_ids\":[\"530\",\"529\",\"528\",\"527\"],\"posts_orderby\":\"ID\"},\"elements\":[],\"widgetType\":\"HarikaHero1\"}],\"isInner\":false},{\"id\":\"a19cd4a\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"flex_direction_tablet\":\"column\",\"flex_align_items_tablet\":\"center\",\"margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"62a1183\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":75},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"3d9ae75\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"image_size\":\"harika-700-450\",\"date_type\":\"modified\",\"excerpt_length\":32,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_order\":\"asc\",\"views_show\":\"yes\"},\"elements\":[],\"widgetType\":\"HarikaList1\"}],\"isInner\":true},{\"id\":\"1899e81\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"px\",\"size\":320},\"flex_gap\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"sidebar-col\",\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"121d9e2\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u0686\\u06cc\\u0632\\u06cc \\u0645\\u06cc \\u06af\\u0631\\u062f\\u06cc\\u061f\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-search\"},{\"id\":\"96ea533\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u0633\\u06a9\\u0627\\u06cc\\u067e\",\"icon\":{\"value\":\"fab fa-skype\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#00AFF0\",\"main_background_background\":\"classic\",\"main_background_color\":\"#00AFF0\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"cfbfbc9\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u06cc\\u0646\\u0633\\u062a\\u0627\\u06af\\u0631\\u0627\\u0645\",\"icon\":{\"value\":\"fab fa-instagram\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#FF0088\",\"main_background_background\":\"classic\",\"main_background_color\":\"#FF0088\",\"main_background_color_b\":\"#6A3CCE\",\"main_background_gradient_angle\":{\"unit\":\"deg\",\"size\":206,\"sizes\":[]},\"main_background_gradient_position\":\"center left\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"2fe72ae\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0641\\u06cc\\u0633 \\u0628\\u0648\\u06a9\",\"icon\":{\"value\":\"fab fa-facebook-square\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#3B5998\",\"main_background_background\":\"classic\",\"main_background_color\":\"#3B5998\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"ecb40e1\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u067e\\u06cc\\u0646\\u062a\\u0631\\u0633\\u062a\",\"icon\":{\"value\":\"fab fa-pinterest\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u067e\\u06cc\\u0646 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#F0002A\",\"main_background_background\":\"classic\",\"main_background_color\":\"#F0002A\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"9861dcb\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0647\\u0627\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-categories\"},{\"id\":\"6eff5a3\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"wp-widget-recent-posts\"},{\"id\":\"e327c82\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u0628\\u0631\\u0686\\u0633\\u0628 \\u0647\\u0627\",\"taxonomy\":\"post_tag\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-tag_cloud\"},{\"id\":\"8f7dd80\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u0622\\u062e\\u0631\\u06cc\\u0646 \\u067e\\u0633\\u062a \\u0647\\u0627\",\"post_count\":\"5\",\"sticky\":\"\"},\"section_sticky_on\":\"yes\",\"section_sticky_offset\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"wp-widget-harika_recent_post_widget\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"e7771f1\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"13db4a0\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"title\":\"\\u0648\\u06cc\\u062f\\u06cc\\u0648 \\u0647\\u0627\\u06cc \\u0647\\u0627\\u0631\\u06cc\\u06a9\\u0627\",\"icon\":{\"value\":\"far fa-play-circle\",\"library\":\"fa-regular\"}},\"elements\":[],\"widgetType\":\"HarikaHeading\"},{\"id\":\"9ca19cc\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"playlist_title\":\"\\u0631\\u0633\\u0627\\u0646\\u0647 \\u0647\\u0627\\u0631\\u06cc\\u06a9\\u0627\",\"videos\":[{\"title\":\"\\u0633\\u0631\\u06cc \\u0631\\u0648\\u0631\\u0648\\u0646\\u06cc \\u06a9\\u0646\\u0634\\u06cc\\u0646\\u060c \\u0645\\u0647\\u0627\\u0631\\u062a \\u0647\\u0627\\u06cc \\u0628\\u06cc \\u0646\\u0638\\u06cc\\u0631 \\u0634\\u0645\\u0634\\u06cc\\u0631 \\u0632\\u0646 \\u062f\\u0648\\u0631\\u0647 \\u06af\\u0631\\u062f\",\"_id\":\"99f65ac\",\"aparat_iframe\":\"<style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}<\\/style><div class=\\\"h_iframe-aparat_embed_frame\\\"><span style=\\\"display: block;padding-top: 57%\\\"><\\/span><iframe src=\\\"https:\\/\\/www.aparat.com\\/video\\/video\\/embed\\/videohash\\/slk4Q\\/vt\\/frame\\\"  allowFullScreen=\\\"true\\\" webkitallowfullscreen=\\\"true\\\" mozallowfullscreen=\\\"true\\\"><\\/iframe><\\/div>\",\"insert_url\":\"yes\",\"external_url\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/videos\\/rurouni-kenshin.mp4\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"pooster\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/AA1A3_3701.jpg\",\"id\":1455,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"thumbnail\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/AA1A3_3701.jpg\",\"id\":1455,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"get_video_duration\":\"01:57\"},{\"_id\":\"ead583b\",\"title\":\"\\u0645\\u0635\\u0627\\u062d\\u0628\\u0647 \\u062c\\u06cc\\u0645\\u06cc \\u0641\\u0644\\u0646 \\u0628\\u0627 \\u062c\\u0646\\u0627 \\u0627\\u0648\\u0631\\u062a\\u06af\\u0627 \\u0628\\u0627\\u0632\\u06cc\\u06af\\u0631 \\u0633\\u0631\\u06cc\\u0627\\u0644 \\u0648\\u0646\\u0632\\u062f\\u06cc\",\"aparat_iframe\":\"<style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}<\\/style><div class=\\\"h_iframe-aparat_embed_frame\\\"><span style=\\\"display: block;padding-top: 57%\\\"><\\/span><iframe src=\\\"https:\\/\\/www.aparat.com\\/video\\/video\\/embed\\/videohash\\/slk4Q\\/vt\\/frame\\\"  allowFullScreen=\\\"true\\\" webkitallowfullscreen=\\\"true\\\" mozallowfullscreen=\\\"true\\\"><\\/iframe><\\/div>\",\"insert_url\":\"yes\",\"external_url\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/videos\\/jenna-ortega.mp4\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"pooster\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/jenna-jimmy.jpg\",\"id\":1471,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"thumbnail\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/jenna-jimmy.jpg\",\"id\":1471,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"get_video_duration\":\"06:08\"},{\"_id\":\"827fcce\",\"title\":\"\\u0645\\u06cc\\u06a9\\u0633 \\u0628\\u06cc \\u0646\\u0638\\u06cc\\u0631 \\u0627\\u0632 \\u0633\\u0631\\u06cc\\u0627\\u0644 The 100 \\u0628\\u0627 \\u0645\\u0648\\u0632\\u06cc\\u06a9 Born for this\",\"aparat_iframe\":\"<style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}<\\/style><div class=\\\"h_iframe-aparat_embed_frame\\\"><span style=\\\"display: block;padding-top: 57%\\\"><\\/span><iframe src=\\\"https:\\/\\/www.aparat.com\\/video\\/video\\/embed\\/videohash\\/slk4Q\\/vt\\/frame\\\"  allowFullScreen=\\\"true\\\" webkitallowfullscreen=\\\"true\\\" mozallowfullscreen=\\\"true\\\"><\\/iframe><\\/div>\",\"insert_url\":\"yes\",\"external_url\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/videos\\/the-100.mp4\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"pooster\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/The-100-Season-8-1.jpeg\",\"id\":1472,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"thumbnail\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/The-100-Season-8-1.jpeg\",\"id\":1472,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"get_video_duration\":\"04:14\"},{\"_id\":\"86386c8\",\"title\":\"\\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a \\u0647\\u06cc\\u062c\\u0627\\u0646 \\u0627\\u0646\\u06af\\u06cc\\u0632 \\u062a\\u0644\\u0648\\u06cc\\u0632\\u06cc\\u0648\\u0646\\u06cc \\u0686\\u06af\\u0648\\u0646\\u0647 \\u0633\\u0627\\u062e\\u062a\\u0647 \\u0645\\u06cc \\u0634\\u0648\\u0646\\u062f\",\"aparat_iframe\":\"<style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}<\\/style><div class=\\\"h_iframe-aparat_embed_frame\\\"><span style=\\\"display: block;padding-top: 57%\\\"><\\/span><iframe src=\\\"https:\\/\\/www.aparat.com\\/video\\/video\\/embed\\/videohash\\/slk4Q\\/vt\\/frame\\\"  allowFullScreen=\\\"true\\\" webkitallowfullscreen=\\\"true\\\" mozallowfullscreen=\\\"true\\\"><\\/iframe><\\/div>\",\"insert_url\":\"yes\",\"external_url\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/videos\\/smint.mp4\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"pooster\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/smint.jpg\",\"id\":1473,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"thumbnail\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/smint.jpg\",\"id\":1473,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"}}],\"playlist_title_icon_select\":{\"value\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/video-list-title-icon-1.svg\",\"id\":1453},\"library\":\"svg\"},\"video_title_icon_select\":{\"value\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/Attachment-2.svg\",\"id\":1454},\"library\":\"svg\"}},\"elements\":[],\"widgetType\":\"HarikaVideoPlayList\"}],\"isInner\":false},{\"id\":\"c259213\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"30\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"491e57d\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"title\":\"\\u0628\\u06cc\\u0634\\u062a\\u0631 \\u0628\\u062e\\u0648\\u0627\\u0646\\u06cc\\u062f ...\"},\"elements\":[],\"widgetType\":\"HarikaHeading\"},{\"id\":\"e8fd020\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"columns_number\":4,\"columns_number_tablet\":2,\"columns_number_mobile\":1,\"image_size\":\"harika-700-450\",\"show_excerpt\":\"\",\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_orderby\":\"rand\"},\"elements\":[],\"widgetType\":\"HarikaGrid1\"}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("37", "14", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("38", "14", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("39", "14", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("40", "14", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("41", "14", "_elementor_data", "[{\"id\":\"d52d5cf\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"8d12a53\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[],\"isInner\":false}],\"isInner\":false},{\"id\":\"ef36dd4\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"a2d0ba2\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"f5b21d5\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0627\\u06cc\\u0646\\u062c\\u0627 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f\"},\"elements\":[],\"widgetType\":\"button\"},{\"id\":\"820df5c\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u062a\\u0646 \\u0633\\u0631\\u0628\\u0631\\u06af \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("49", "16", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("50", "16", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("51", "16", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("52", "16", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("53", "16", "_elementor_data", "[{\"id\":\"d52d5cf\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"8d12a53\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[],\"isInner\":false}],\"isInner\":false},{\"id\":\"ef36dd4\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"a2d0ba2\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"f5b21d5\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0627\\u06cc\\u0646\\u062c\\u0627 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f\"},\"elements\":[],\"widgetType\":\"button\"},{\"id\":\"820df5c\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u062a\\u0646 \\u0633\\u0631\\u0628\\u0631\\u06af \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("55", "17", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("56", "17", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("57", "17", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("58", "17", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("59", "17", "_elementor_data", "[{\"id\":\"d52d5cf\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"8d12a53\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[],\"isInner\":false}],\"isInner\":false},{\"id\":\"ef36dd4\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"a2d0ba2\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"f5b21d5\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0627\\u06cc\\u0646\\u062c\\u0627 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f\"},\"elements\":[],\"widgetType\":\"button\"},{\"id\":\"820df5c\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u062a\\u0646 \\u0633\\u0631\\u0628\\u0631\\u06af \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("61", "18", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("62", "18", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("63", "18", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("64", "18", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("65", "18", "_elementor_data", "[{\"id\":\"d52d5cf\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"8d12a53\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[],\"isInner\":false}],\"isInner\":false},{\"id\":\"ef36dd4\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"a2d0ba2\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"f5b21d5\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0627\\u06cc\\u0646\\u062c\\u0627 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f\",\"hover_color\":\"#EE0606\"},\"elements\":[],\"widgetType\":\"button\"},{\"id\":\"820df5c\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u062a\\u0646 \\u0633\\u0631\\u0628\\u0631\\u06af \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("67", "19", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("68", "19", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("69", "19", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("70", "19", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("71", "19", "_elementor_data", "[{\"id\":\"d52d5cf\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"8d12a53\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[],\"isInner\":false}],\"isInner\":false},{\"id\":\"ef36dd4\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"a2d0ba2\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"f5b21d5\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0627\\u06cc\\u0646\\u062c\\u0627 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f\",\"hover_color\":\"#EE0606\"},\"elements\":[],\"widgetType\":\"button\"},{\"id\":\"820df5c\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u062a\\u0646 \\u0633\\u0631\\u0628\\u0631\\u06af \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("73", "20", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("74", "20", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("75", "20", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("76", "20", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("77", "20", "_elementor_data", "[{\"id\":\"d52d5cf\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"8d12a53\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[],\"isInner\":false}],\"isInner\":false},{\"id\":\"ef36dd4\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"a2d0ba2\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"f5b21d5\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0627\\u06cc\\u0646\\u062c\\u0627 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f\",\"hover_color\":\"#EE0606\"},\"elements\":[],\"widgetType\":\"button\"},{\"id\":\"820df5c\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u062a\\u0646 \\u0633\\u0631\\u0628\\u0631\\u06af \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("79", "21", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("80", "21", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("81", "21", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("82", "21", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("83", "21", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("85", "22", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("86", "22", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("87", "22", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("88", "22", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("89", "22", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("91", "23", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("92", "23", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("93", "23", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("94", "23", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("95", "23", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("97", "24", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("98", "24", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("99", "24", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("100", "24", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("101", "24", "_elementor_data", "[{\"id\":\"250367b\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"780bef2\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"0a8a9e7\",\"elType\":\"widget\",\"settings\":{\"title_text\":\"\\u0627\\u06cc\\u0646 \\u06cc\\u06a9 \\u0639\\u0646\\u0648\\u0627\\u0646 \\u0627\\u0633\\u062a\",\"description_text\":\"\\u0628\\u0631\\u0627\\u06cc \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u0627\\u06cc\\u0646 \\u0645\\u062a\\u0646 \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u062f\\u06a9\\u0645\\u0647 \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f. \\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a.\"},\"elements\":[],\"widgetType\":\"icon-box\"},{\"id\":\"3129387\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u0647\\u0627\\u0631\\u062a \\u0647\\u0627\\u06cc \\u0645\\u0646\",\"inner_text\":\"\\u0637\\u0631\\u0627\\u062d \\u0648\\u0628\"},\"elements\":[],\"widgetType\":\"progress\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("105", "25", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("106", "25", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("107", "25", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("108", "25", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("109", "25", "_elementor_data", "[{\"id\":\"250367b\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"780bef2\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"0a8a9e7\",\"elType\":\"widget\",\"settings\":{\"title_text\":\"\\u0627\\u06cc\\u0646 \\u06cc\\u06a9 \\u0639\\u0646\\u0648\\u0627\\u0646 \\u0627\\u0633\\u062a\",\"description_text\":\"\\u0628\\u0631\\u0627\\u06cc \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u0627\\u06cc\\u0646 \\u0645\\u062a\\u0646 \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u062f\\u06a9\\u0645\\u0647 \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f. \\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a.\"},\"elements\":[],\"widgetType\":\"icon-box\"},{\"id\":\"3129387\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u0647\\u0627\\u0631\\u062a \\u0647\\u0627\\u06cc \\u0645\\u0646\",\"inner_text\":\"\\u0637\\u0631\\u0627\\u062d \\u0648\\u0628\"},\"elements\":[],\"widgetType\":\"progress\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("113", "26", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("114", "26", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("115", "26", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("116", "26", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("117", "26", "_elementor_data", "[{\"id\":\"250367b\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"780bef2\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"0a8a9e7\",\"elType\":\"widget\",\"settings\":{\"title_text\":\"\\u0627\\u06cc\\u0646 \\u06cc\\u06a9 \\u0639\\u0646\\u0648\\u0627\\u0646 \\u0627\\u0633\\u062a\",\"description_text\":\"\\u0628\\u0631\\u0627\\u06cc \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u0627\\u06cc\\u0646 \\u0645\\u062a\\u0646 \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u062f\\u06a9\\u0645\\u0647 \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f. \\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a.\"},\"elements\":[],\"widgetType\":\"icon-box\"},{\"id\":\"3129387\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u0647\\u0627\\u0631\\u062a \\u0647\\u0627\\u06cc \\u0645\\u0646\",\"inner_text\":\"\\u0637\\u0631\\u0627\\u062d \\u0648\\u0628\"},\"elements\":[],\"widgetType\":\"progress\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("121", "27", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("122", "27", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("123", "27", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("124", "27", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("125", "27", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("131", "28", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("132", "28", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("133", "28", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("134", "28", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("135", "28", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("137", "29", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("138", "29", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("139", "29", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("140", "29", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("141", "29", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("143", "30", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("144", "30", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("145", "30", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("146", "30", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("147", "30", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("149", "31", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("150", "31", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("151", "31", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("152", "31", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("153", "31", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("155", "32", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("156", "32", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("157", "32", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("158", "32", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("159", "32", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("161", "33", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("162", "33", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("163", "33", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("164", "33", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("165", "33", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("167", "34", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("168", "34", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("169", "34", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("170", "34", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("171", "34", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("173", "35", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("174", "35", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("175", "35", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("176", "35", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("177", "35", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("179", "36", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("180", "36", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("181", "36", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("182", "36", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("183", "36", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("185", "37", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("186", "37", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("187", "37", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("188", "37", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("189", "37", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("191", "38", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("192", "38", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("193", "38", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("194", "38", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("195", "38", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("197", "39", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("198", "39", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("199", "39", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("200", "39", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("201", "39", "_elementor_data", "[{\"id\":\"0f43037\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"71f10f8\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"cb7c23b\",\"elType\":\"widget\",\"settings\":{\"playlist_title\":\"\\u0644\\u06cc\\u0633\\u062a \\u067e\\u062e\\u0634 \\u0648\\u06cc\\u062f\\u06cc\\u0648\",\"videos\":[{\"title\":\"\\u0648\\u06cc\\u0698\\u06af\\u06cc \\u0647\\u0627\\u06cc \\u0642\\u0627\\u0644\\u0628 \\u0647\\u0627\\u0631\\u06cc\\u06a9\\u0627\",\"_id\":\"36b1c33\",\"aparat_iframe\":\"<style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}<\\/style><div class=\\\"h_iframe-aparat_embed_frame\\\"><span style=\\\"display: block;padding-top: 57%\\\"><\\/span><iframe src=\\\"https:\\/\\/www.aparat.com\\/video\\/video\\/embed\\/videohash\\/slk4Q\\/vt\\/frame\\\"  allowFullScreen=\\\"true\\\" webkitallowfullscreen=\\\"true\\\" mozallowfullscreen=\\\"true\\\"><\\/iframe><\\/div>\"}]},\"elements\":[],\"widgetType\":\"HarikaVideoPlayList\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("205", "40", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("206", "40", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("207", "40", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("208", "40", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("209", "40", "_elementor_data", "[{\"id\":\"0f43037\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"71f10f8\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"cb7c23b\",\"elType\":\"widget\",\"settings\":{\"playlist_title\":\"\\u0644\\u06cc\\u0633\\u062a \\u067e\\u062e\\u0634 \\u0648\\u06cc\\u062f\\u06cc\\u0648\",\"videos\":[{\"title\":\"\\u0648\\u06cc\\u0698\\u06af\\u06cc \\u0647\\u0627\\u06cc \\u0642\\u0627\\u0644\\u0628 \\u0647\\u0627\\u0631\\u06cc\\u06a9\\u0627\",\"_id\":\"36b1c33\",\"aparat_iframe\":\"<style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}<\\/style><div class=\\\"h_iframe-aparat_embed_frame\\\"><span style=\\\"display: block;padding-top: 57%\\\"><\\/span><iframe src=\\\"https:\\/\\/www.aparat.com\\/video\\/video\\/embed\\/videohash\\/slk4Q\\/vt\\/frame\\\"  allowFullScreen=\\\"true\\\" webkitallowfullscreen=\\\"true\\\" mozallowfullscreen=\\\"true\\\"><\\/iframe><\\/div>\"}]},\"elements\":[],\"widgetType\":\"HarikaVideoPlayList\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("213", "41", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("214", "41", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("215", "41", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("216", "41", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("217", "41", "_elementor_data", "[{\"id\":\"0f43037\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"71f10f8\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"cb7c23b\",\"elType\":\"widget\",\"settings\":{\"playlist_title\":\"\\u0644\\u06cc\\u0633\\u062a \\u067e\\u062e\\u0634 \\u0648\\u06cc\\u062f\\u06cc\\u0648\",\"videos\":[{\"title\":\"\\u0648\\u06cc\\u0698\\u06af\\u06cc \\u0647\\u0627\\u06cc \\u0642\\u0627\\u0644\\u0628 \\u0647\\u0627\\u0631\\u06cc\\u06a9\\u0627\",\"_id\":\"36b1c33\",\"aparat_iframe\":\"<style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}<\\/style><div class=\\\"h_iframe-aparat_embed_frame\\\"><span style=\\\"display: block;padding-top: 57%\\\"><\\/span><iframe src=\\\"https:\\/\\/www.aparat.com\\/video\\/video\\/embed\\/videohash\\/slk4Q\\/vt\\/frame\\\"  allowFullScreen=\\\"true\\\" webkitallowfullscreen=\\\"true\\\" mozallowfullscreen=\\\"true\\\"><\\/iframe><\\/div>\"}]},\"elements\":[],\"widgetType\":\"HarikaVideoPlayList\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("221", "42", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("222", "42", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("223", "42", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("224", "42", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("225", "42", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("230", "43", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("231", "43", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("232", "43", "_menu_item_object_id", "43");
INSERT INTO `wp_postmeta` VALUES("233", "43", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("234", "43", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("235", "43", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("236", "43", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("237", "43", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("239", "43", "_menu_item_menuposition", "");
INSERT INTO `wp_postmeta` VALUES("240", "43", "_menu_item_megamenu", "");
INSERT INTO `wp_postmeta` VALUES("241", "43", "_menu_item_template", "");
INSERT INTO `wp_postmeta` VALUES("242", "43", "_menu_item_menuwidth", "");
INSERT INTO `wp_postmeta` VALUES("243", "43", "_menu_item_disablet", "");
INSERT INTO `wp_postmeta` VALUES("272", "46", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("273", "46", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("274", "46", "_menu_item_object_id", "46");
INSERT INTO `wp_postmeta` VALUES("275", "46", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("276", "46", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("277", "46", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("278", "46", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("279", "46", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("281", "46", "_menu_item_menuposition", "");
INSERT INTO `wp_postmeta` VALUES("282", "46", "_menu_item_megamenu", "");
INSERT INTO `wp_postmeta` VALUES("283", "46", "_menu_item_template", "");
INSERT INTO `wp_postmeta` VALUES("284", "46", "_menu_item_menuwidth", "");
INSERT INTO `wp_postmeta` VALUES("285", "46", "_menu_item_disablet", "");
INSERT INTO `wp_postmeta` VALUES("314", "49", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("315", "49", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("316", "49", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("317", "49", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("318", "49", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("320", "50", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("321", "50", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("322", "50", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("323", "50", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("324", "50", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("326", "51", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("327", "51", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("328", "51", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("329", "51", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("330", "51", "_elementor_data", "[{\"id\":\"1ce44fd\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"4a03439\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"17ce765\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0646\\u0645\\u0648\\u0646\\u0647 \\u0639\\u0646\\u0648\\u0627\\u0646\",\"btn_title\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0647\\u0645\\u0647\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("334", "52", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("335", "52", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("336", "52", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("337", "52", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("338", "52", "_elementor_data", "[{\"id\":\"1ce44fd\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"4a03439\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"17ce765\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0646\\u0645\\u0648\\u0646\\u0647 \\u0639\\u0646\\u0648\\u0627\\u0646\",\"btn_title\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0647\\u0645\\u0647\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("342", "53", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("343", "53", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("344", "53", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("345", "53", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("346", "53", "_elementor_data", "[{\"id\":\"1ce44fd\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"4a03439\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"17ce765\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0646\\u0645\\u0648\\u0646\\u0647 \\u0639\\u0646\\u0648\\u0627\\u0646\",\"btn_title\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0647\\u0645\\u0647\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("350", "54", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("351", "54", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("352", "54", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("353", "54", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("354", "54", "_elementor_data", "[{\"id\":\"1ce44fd\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"4a03439\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"17ce765\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0646\\u0645\\u0648\\u0646\\u0647 \\u0639\\u0646\\u0648\\u0627\\u0646\",\"btn_title\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0647\\u0645\\u0647\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"6649259\",\"elType\":\"widget\",\"settings\":{\"playlist_title\":\"\\u0644\\u06cc\\u0633\\u062a \\u067e\\u062e\\u0634 \\u0648\\u06cc\\u062f\\u06cc\\u0648\",\"videos\":[{\"title\":\"\\u0648\\u06cc\\u0698\\u06af\\u06cc \\u0647\\u0627\\u06cc \\u0642\\u0627\\u0644\\u0628 \\u0647\\u0627\\u0631\\u06cc\\u06a9\\u0627\",\"_id\":\"190deb5\",\"aparat_iframe\":\"<style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}<\\/style><div class=\\\"h_iframe-aparat_embed_frame\\\"><span style=\\\"display: block;padding-top: 57%\\\"><\\/span><iframe src=\\\"https:\\/\\/www.aparat.com\\/video\\/video\\/embed\\/videohash\\/slk4Q\\/vt\\/frame\\\"  allowFullScreen=\\\"true\\\" webkitallowfullscreen=\\\"true\\\" mozallowfullscreen=\\\"true\\\"><\\/iframe><\\/div>\"}]},\"elements\":[],\"widgetType\":\"HarikaVideoPlayList\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("360", "6", "_edit_lock", "1725140219:1");
INSERT INTO `wp_postmeta` VALUES("361", "55", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("362", "55", "_elementor_template_type", "kit");
INSERT INTO `wp_postmeta` VALUES("364", "6", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("365", "6", "_elementor_page_settings", "a:18:{s:13:\"system_colors\";a:4:{i:0;a:3:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"اولیه\";s:5:\"color\";s:7:\"#2b39be\";}i:1;a:3:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:13:\"رنگ دوم\";s:5:\"color\";s:7:\"#ebebed\";}i:2;a:3:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:6:\"متن\";s:5:\"color\";s:7:\"#7A7A7A\";}i:3;a:3:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"شدت\";s:5:\"color\";s:7:\"#61CE70\";}}s:13:\"custom_colors\";a:0:{}s:17:\"system_typography\";a:4:{i:0;a:5:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"اولیه\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:6:\"Roboto\";s:22:\"typography_font_weight\";s:3:\"600\";}i:1;a:5:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:13:\"رنگ دوم\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:11:\"Roboto Slab\";s:22:\"typography_font_weight\";s:3:\"400\";}i:2;a:5:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:6:\"متن\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:6:\"Roboto\";s:22:\"typography_font_weight\";s:3:\"400\";}i:3;a:5:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"شدت\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:6:\"Roboto\";s:22:\"typography_font_weight\";s:3:\"500\";}}s:17:\"custom_typography\";a:0:{}s:21:\"default_generic_fonts\";s:10:\"Sans-serif\";s:9:\"site_name\";s:21:\"قالب هاریکا\";s:19:\"page_title_selector\";s:14:\"h1.entry-title\";s:19:\"viewport_widescreen\";s:4:\"1400\";s:11:\"viewport_md\";i:768;s:11:\"viewport_lg\";i:1025;s:26:\"container_width_widescreen\";a:2:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:4:\"1400\";}s:22:\"container_width_tablet\";a:2:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:4:\"1024\";}s:22:\"container_width_mobile\";a:2:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:3:\"768\";}s:32:\"colors_enable_styleguide_preview\";s:3:\"yes\";s:15:\"activeItemIndex\";i:1;s:18:\"active_breakpoints\";a:3:{i:0;s:15:\"viewport_mobile\";i:1;s:15:\"viewport_tablet\";i:2;s:19:\"viewport_widescreen\";}s:12:\"site_favicon\";a:5:{s:3:\"url\";s:72:\"https://webdev-demo.ir/harika/harika/wp-content/uploads/2024/09/fav1.png\";s:2:\"id\";s:4:\"2147\";s:4:\"size\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:6:\"source\";s:7:\"library\";}s:15:\"container_width\";a:2:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:4:\"1140\";}}");
INSERT INTO `wp_postmeta` VALUES("366", "6", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("367", "56", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("368", "56", "_elementor_template_type", "kit");
INSERT INTO `wp_postmeta` VALUES("370", "56", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("371", "56", "_elementor_page_settings", "a:11:{s:13:\"system_colors\";a:4:{i:0;a:3:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"اولیه\";s:5:\"color\";s:7:\"#6EC1E4\";}i:1;a:3:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:13:\"رنگ دوم\";s:5:\"color\";s:7:\"#54595F\";}i:2;a:3:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:6:\"متن\";s:5:\"color\";s:7:\"#7A7A7A\";}i:3;a:3:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"شدت\";s:5:\"color\";s:7:\"#61CE70\";}}s:13:\"custom_colors\";a:0:{}s:17:\"system_typography\";a:4:{i:0;a:5:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"اولیه\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:6:\"Roboto\";s:22:\"typography_font_weight\";s:3:\"600\";}i:1;a:5:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:13:\"رنگ دوم\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:11:\"Roboto Slab\";s:22:\"typography_font_weight\";s:3:\"400\";}i:2;a:5:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:6:\"متن\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:6:\"Roboto\";s:22:\"typography_font_weight\";s:3:\"400\";}i:3;a:5:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"شدت\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:6:\"Roboto\";s:22:\"typography_font_weight\";s:3:\"500\";}}s:17:\"custom_typography\";a:0:{}s:21:\"default_generic_fonts\";s:10:\"Sans-serif\";s:9:\"site_name\";s:21:\"قالب هاریکا\";s:19:\"page_title_selector\";s:14:\"h1.entry-title\";s:18:\"active_breakpoints\";a:3:{i:0;s:15:\"viewport_mobile\";i:1;s:15:\"viewport_tablet\";i:2;s:19:\"viewport_widescreen\";}s:19:\"viewport_widescreen\";i:1400;s:11:\"viewport_md\";i:768;s:11:\"viewport_lg\";i:1025;}");
INSERT INTO `wp_postmeta` VALUES("372", "56", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("374", "6", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("378", "57", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("379", "57", "_edit_lock", "1750861537:1");
INSERT INTO `wp_postmeta` VALUES("380", "57", "harika_tb_settings", "a:1:{s:13:\"template_type\";s:6:\"header\";}");
INSERT INTO `wp_postmeta` VALUES("381", "57", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("382", "57", "_elementor_template_type", "wp-post");
INSERT INTO `wp_postmeta` VALUES("383", "57", "_elementor_version", "3.27.6");
INSERT INTO `wp_postmeta` VALUES("385", "57", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("386", "57", "_elementor_data", "[{\"id\":\"f7d11b0\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"content_width\":\"full\",\"background_background\":\"classic\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"25\",\"bottom\":\"0\",\"left\":\"25\",\"isLinked\":false},\"__globals__\":{\"background_color\":\"globals\\/colors?id=primary\"}},\"elements\":[{\"id\":\"0da2304\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"flex_justify_content\":\"flex-start\",\"flex_align_items\":\"center\",\"padding\":{\"unit\":\"px\",\"top\":\"4\",\"right\":\"10\",\"bottom\":\"4\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[{\"id\":\"8a85754\",\"elType\":\"widget\",\"settings\":{\"newsticker_title\":\"\\u0628\\u06cc\\u0634\\u062a\\u0631 \\u0628\\u062e\\u0648\\u0627\\u0646\\u06cc\\u062f\",\"posts_include_by\":[\"terms\"],\"posts_exclude_by\":[],\"posts_exclude_ids\":[],\"item_limit\":{\"unit\":\"px\",\"size\":5,\"sizes\":[]},\"posts_include_ids\":[\"23\"],\"posts_selected_ids\":[],\"newsticker_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"newsticker_animation_duration_mobile\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]},\"__globals__\":{\"newsticker_before_color\":\"globals\\/colors?id=harika_primary\",\"newsticker_after_color\":\"globals\\/colors?id=harika_primary\"},\"posts_include_term_ids\":[\"20\"],\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaHFNewsTicker\"}],\"isInner\":true},{\"id\":\"de4bc04\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row-reverse\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"flex_justify_content\":\"flex-start\",\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"0\",\"row\":\"0\",\"isLinked\":true,\"unit\":\"px\",\"size\":0},\"padding\":{\"unit\":\"px\",\"top\":\"4\",\"right\":\"10\",\"bottom\":\"4\",\"left\":\"10\",\"isLinked\":false},\"hide_mobile\":\"hidden-mobile\"},\"elements\":[{\"id\":\"21806ed\",\"elType\":\"widget\",\"settings\":{\"format\":\"j F Y\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"15\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_element_width\":\"auto\",\"_border_border\":\"solid\",\"_border_width\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_border_color\":\"#00000033\",\"date_color\":\"#FFFFFF\",\"icon_color\":\"#FFFFFF\",\"icon\":{\"value\":\"\",\"library\":\"\"},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaHFDate\"},{\"id\":\"58c6591\",\"elType\":\"widget\",\"settings\":{\"icon\":{\"value\":\"fab fa-instagram\",\"library\":\"fa-brands\"},\"icon_width\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"icon_typography_typography\":\"custom\",\"icon_typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"5\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_element_width\":\"auto\",\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\",\"icon_box_background_background\":\"classic\",\"icon_box_background_color\":\"#FFFFFF33\",\"icon_box_padding\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"icon_box_background_hover_background\":\"classic\",\"icon_box_background_hover_color\":\"#00000033\"},\"elements\":[],\"widgetType\":\"HarikaHFSimpleIcon\"},{\"id\":\"c060248\",\"elType\":\"widget\",\"settings\":{\"icon\":{\"value\":\"fab fa-whatsapp\",\"library\":\"fa-brands\"},\"icon_width\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"icon_typography_typography\":\"custom\",\"icon_typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"5\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_element_width\":\"auto\",\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\",\"icon_box_background_background\":\"classic\",\"icon_box_background_color\":\"#FFFFFF33\",\"icon_box_background_hover_background\":\"classic\",\"icon_box_background_hover_color\":\"#00000033\"},\"elements\":[],\"widgetType\":\"HarikaHFSimpleIcon\"},{\"id\":\"4b881e4\",\"elType\":\"widget\",\"settings\":{\"icon\":{\"value\":\"fab fa-dribbble\",\"library\":\"fa-brands\"},\"icon_width\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"icon_typography_typography\":\"custom\",\"icon_typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"5\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_element_width\":\"auto\",\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\",\"icon_box_background_background\":\"classic\",\"icon_box_background_color\":\"#FFFFFF33\",\"icon_box_padding\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"icon_box_background_hover_background\":\"classic\",\"icon_box_background_hover_color\":\"#00000033\"},\"elements\":[],\"widgetType\":\"HarikaHFSimpleIcon\"},{\"id\":\"068f351\",\"elType\":\"widget\",\"settings\":{\"icon\":{\"value\":\"fab fa-wordpress-simple\",\"library\":\"fa-brands\"},\"icon_width\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"icon_typography_typography\":\"custom\",\"icon_typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"5\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_element_width\":\"auto\",\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\",\"icon_box_background_background\":\"classic\",\"icon_box_background_color\":\"#FFFFFF33\",\"icon_box_padding\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"icon_box_background_hover_background\":\"classic\",\"icon_box_background_hover_color\":\"#00000033\"},\"elements\":[],\"widgetType\":\"HarikaHFSimpleIcon\"},{\"id\":\"0cbccec\",\"elType\":\"widget\",\"settings\":{\"icon\":{\"value\":\"fab fa-pinterest-p\",\"library\":\"fa-brands\"},\"icon_width\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"icon_typography_typography\":\"custom\",\"icon_typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"5\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_element_width\":\"auto\",\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\",\"icon_box_background_background\":\"classic\",\"icon_box_background_color\":\"#FFFFFF33\",\"icon_box_padding\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"icon_box_background_hover_background\":\"classic\",\"icon_box_background_hover_color\":\"#00000033\"},\"elements\":[],\"widgetType\":\"HarikaHFSimpleIcon\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"e246aca\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"content_width\":\"full\",\"background_background\":\"classic\",\"background_color\":\"#FFFFFF\",\"box_shadow_box_shadow_type\":\"yes\",\"box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":15,\"blur\":20,\"spread\":0,\"color\":\"rgba(0, 0, 0, 0.03)\"},\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"30\",\"isLinked\":false},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"25\",\"bottom\":\"0\",\"left\":\"25\",\"isLinked\":false},\"flex_direction_tablet\":\"row\",\"flex_align_items_tablet\":\"stretch\",\"section_background_dark_background\":\"classic\",\"section_background_dark_color\":\"#232328\"},\"elements\":[{\"id\":\"1503b56\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":18},\"flex_justify_content\":\"flex-start\",\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"\",\"row\":\"\",\"isLinked\":true,\"unit\":\"px\",\"size\":null},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]}},\"elements\":[{\"id\":\"3f6b943\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":58,\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/home-1-logo.svg\"},\"image_size\":\"full\",\"_padding\":{\"unit\":\"px\",\"top\":\"7\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"image_dark\":{\"id\":59,\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/dark-logo.svg\"},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\",\"align_tablet\":\"flex-start\",\"width_tablet\":{\"unit\":\"px\",\"size\":140,\"sizes\":[]},\"width_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]}},\"elements\":[],\"widgetType\":\"HarikaHFLogo\"}],\"isInner\":true},{\"id\":\"b5fd668\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":64},\"flex_justify_content\":\"center\",\"flex_align_items\":\"stretch\",\"hide_tablet\":\"hidden-tablet\",\"hide_mobile\":\"hidden-mobile\"},\"elements\":[{\"id\":\"de7fd5e\",\"elType\":\"widget\",\"settings\":{\"menu\":\"%d9%85%d9%86%d9%88-%d8%a7%d8%b5%d9%84%db%8c\",\"menu_mobile\":\"%d9%85%d9%86%d9%88-%d9%85%d9%88%d8%a8%d8%a7%db%8c%d9%84\",\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\",\"__globals__\":{\"desktop_main-item-color_hover\":\"globals\\/colors?id=harika_primary\",\"desktop_main_item_arrow_color_hover\":\"globals\\/colors?id=harika_primary\",\"desktop_submenu_item_color_hover\":\"globals\\/colors?id=harika_primary\",\"desktop_submenu_item_arrow_color_hover\":\"globals\\/colors?id=harika_primary\"}},\"elements\":[],\"widgetType\":\"HarikaHFMenu\"}],\"isInner\":true},{\"id\":\"42bb4f1\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row-reverse\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":18},\"flex_justify_content\":\"flex-start\",\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"0\",\"row\":\"0\",\"isLinked\":true,\"unit\":\"px\",\"size\":0},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]}},\"elements\":[{\"id\":\"20e1c40\",\"elType\":\"widget\",\"settings\":{\"menu\":\"%d9%85%d9%86%d9%88-%d8%a7%d8%b5%d9%84%db%8c\",\"text_align\":\"\",\"_element_width\":\"auto\",\"icon_color\":\"#6A7196\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"10\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"template\":\"1418\",\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaHFStickySidebar\"},{\"id\":\"bd6166e\",\"elType\":\"widget\",\"settings\":{\"search_title_first\":\":: \\u0628\\u0631\\u0627\\u06cc \\u062c\\u0633\\u062a\\u062c\\u0648\",\"search_title_second\":\"\\u062a\\u0627\\u06cc\\u067e\",\"search_title_third\":\"\\u06a9\\u0646\\u06cc\\u062f ::\",\"search_input_title\":\"\\u062c\\u0633\\u062a\\u062c\\u0648 ...\",\"icon\":{\"value\":{\"id\":60,\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/search-icon1.svg\"},\"library\":\"svg\"},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"10\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_element_width\":\"auto\",\"text_align\":\"\",\"search_box_icon_svg_stroke_color\":\"#FFFFFF\",\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaHFSearch\"},{\"id\":\"ebd1e28\",\"elType\":\"widget\",\"settings\":{\"_element_width\":\"auto\",\"light_icon\":{\"value\":{\"id\":61,\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/h-moon.svg\"},\"library\":\"svg\"},\"dark_icon\":{\"value\":{\"id\":62,\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/h-sun.svg\"},\"library\":\"svg\"},\"icon_width\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]},\"icon_box_padding\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\",\"_custom_css_f_ele_css_desktop\":\"selector .moon svg path {\\n    fill: var(--harika-primary-color);\\n}\"},\"elements\":[],\"widgetType\":\"HarikaHFDarkMode\"}],\"isInner\":true}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("388", "58", "_wp_attached_file", "2024/08/home-1-logo.svg");
INSERT INTO `wp_postmeta` VALUES("389", "58", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:34090;s:5:\"width\";i:175;s:6:\"height\";i:58;}");
INSERT INTO `wp_postmeta` VALUES("390", "58", "_elementor_source_image_hash", "949856007793ce71eeefdbfc02386348244fd5c7");
INSERT INTO `wp_postmeta` VALUES("391", "59", "_wp_attached_file", "2024/08/dark-logo.svg");
INSERT INTO `wp_postmeta` VALUES("392", "59", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:34088;s:5:\"width\";i:175;s:6:\"height\";i:58;}");
INSERT INTO `wp_postmeta` VALUES("393", "59", "_elementor_source_image_hash", "2bfb68b1feae829b0c90a7462d4e60bacd28d1b9");
INSERT INTO `wp_postmeta` VALUES("396", "60", "_wp_attached_file", "2024/08/search-icon1.svg");
INSERT INTO `wp_postmeta` VALUES("397", "60", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:680;s:5:\"width\";i:19;s:6:\"height\";i:19;}");
INSERT INTO `wp_postmeta` VALUES("398", "60", "_elementor_source_image_hash", "1cb8bd9064d377bd84a22b1931661f032823f46f");
INSERT INTO `wp_postmeta` VALUES("399", "61", "_wp_attached_file", "2024/08/h-moon.svg");
INSERT INTO `wp_postmeta` VALUES("400", "61", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:1193;s:5:\"width\";i:19;s:6:\"height\";i:21;}");
INSERT INTO `wp_postmeta` VALUES("401", "61", "_elementor_source_image_hash", "f9b43c91f84cca86ea6ef47949b2d82fc683017b");
INSERT INTO `wp_postmeta` VALUES("402", "62", "_wp_attached_file", "2024/08/h-sun.svg");
INSERT INTO `wp_postmeta` VALUES("403", "62", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:1406;s:5:\"width\";i:21;s:6:\"height\";i:21;}");
INSERT INTO `wp_postmeta` VALUES("404", "62", "_elementor_source_image_hash", "39cf88b9b86044e2b61ecd7b5eccc248959a919d");
INSERT INTO `wp_postmeta` VALUES("416", "64", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("417", "64", "_elementor_template_type", "kit");
INSERT INTO `wp_postmeta` VALUES("418", "64", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("419", "64", "_elementor_page_settings", "a:15:{s:13:\"system_colors\";a:4:{i:0;a:3:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"اولیه\";s:5:\"color\";s:7:\"#2B39BE\";}i:1;a:3:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:13:\"رنگ دوم\";s:5:\"color\";s:7:\"#ebebed\";}i:2;a:3:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:6:\"متن\";s:5:\"color\";s:7:\"#7A7A7A\";}i:3;a:3:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"شدت\";s:5:\"color\";s:7:\"#61CE70\";}}s:13:\"custom_colors\";a:0:{}s:17:\"system_typography\";a:4:{i:0;a:5:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"اولیه\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:6:\"Roboto\";s:22:\"typography_font_weight\";s:3:\"600\";}i:1;a:5:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:13:\"رنگ دوم\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:11:\"Roboto Slab\";s:22:\"typography_font_weight\";s:3:\"400\";}i:2;a:5:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:6:\"متن\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:6:\"Roboto\";s:22:\"typography_font_weight\";s:3:\"400\";}i:3;a:5:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"شدت\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:6:\"Roboto\";s:22:\"typography_font_weight\";s:3:\"500\";}}s:17:\"custom_typography\";a:0:{}s:21:\"default_generic_fonts\";s:10:\"Sans-serif\";s:9:\"site_name\";s:21:\"قالب هاریکا\";s:19:\"page_title_selector\";s:14:\"h1.entry-title\";s:18:\"active_breakpoints\";a:3:{i:0;s:15:\"viewport_mobile\";i:1;s:15:\"viewport_tablet\";i:2;s:19:\"viewport_widescreen\";}s:19:\"viewport_widescreen\";i:1400;s:11:\"viewport_md\";i:768;s:11:\"viewport_lg\";i:1025;s:26:\"container_width_widescreen\";a:2:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:4:\"1300\";}s:15:\"container_width\";a:2:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:4:\"1140\";}s:22:\"container_width_tablet\";a:2:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:4:\"1024\";}s:22:\"container_width_mobile\";a:2:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:3:\"768\";}}");
INSERT INTO `wp_postmeta` VALUES("420", "64", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("422", "64", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("440", "65", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("441", "65", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("442", "65", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("443", "65", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("444", "65", "_elementor_data", "[{\"id\":\"1ce44fd\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"4a03439\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"17ce765\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0646\\u0645\\u0648\\u0646\\u0647 \\u0639\\u0646\\u0648\\u0627\\u0646\",\"btn_title\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0647\\u0645\\u0647\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"6649259\",\"elType\":\"widget\",\"settings\":{\"playlist_title\":\"\\u0644\\u06cc\\u0633\\u062a \\u067e\\u062e\\u0634 \\u0648\\u06cc\\u062f\\u06cc\\u0648\",\"videos\":[{\"title\":\"\\u0648\\u06cc\\u0698\\u06af\\u06cc \\u0647\\u0627\\u06cc \\u0642\\u0627\\u0644\\u0628 \\u0647\\u0627\\u0631\\u06cc\\u06a9\\u0627\",\"_id\":\"190deb5\",\"aparat_iframe\":\"<style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}<\\/style><div class=\\\"h_iframe-aparat_embed_frame\\\"><span style=\\\"display: block;padding-top: 57%\\\"><\\/span><iframe src=\\\"https:\\/\\/www.aparat.com\\/video\\/video\\/embed\\/videohash\\/slk4Q\\/vt\\/frame\\\"  allowFullScreen=\\\"true\\\" webkitallowfullscreen=\\\"true\\\" mozallowfullscreen=\\\"true\\\"><\\/iframe><\\/div>\"}]},\"elements\":[],\"widgetType\":\"HarikaVideoPlayList\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("448", "66", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("449", "66", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("450", "66", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("451", "66", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("452", "66", "_elementor_data", "[{\"id\":\"1ce44fd\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"4a03439\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"17ce765\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0646\\u0645\\u0648\\u0646\\u0647 \\u0639\\u0646\\u0648\\u0627\\u0646\",\"btn_title\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0647\\u0645\\u0647\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"6649259\",\"elType\":\"widget\",\"settings\":{\"playlist_title\":\"\\u0644\\u06cc\\u0633\\u062a \\u067e\\u062e\\u0634 \\u0648\\u06cc\\u062f\\u06cc\\u0648\",\"videos\":[{\"title\":\"\\u0648\\u06cc\\u0698\\u06af\\u06cc \\u0647\\u0627\\u06cc \\u0642\\u0627\\u0644\\u0628 \\u0647\\u0627\\u0631\\u06cc\\u06a9\\u0627\",\"_id\":\"190deb5\",\"aparat_iframe\":\"<style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}<\\/style><div class=\\\"h_iframe-aparat_embed_frame\\\"><span style=\\\"display: block;padding-top: 57%\\\"><\\/span><iframe src=\\\"https:\\/\\/www.aparat.com\\/video\\/video\\/embed\\/videohash\\/slk4Q\\/vt\\/frame\\\"  allowFullScreen=\\\"true\\\" webkitallowfullscreen=\\\"true\\\" mozallowfullscreen=\\\"true\\\"><\\/iframe><\\/div>\"}]},\"elements\":[],\"widgetType\":\"HarikaVideoPlayList\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("456", "67", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("457", "67", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("458", "67", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("459", "67", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("460", "67", "_elementor_data", "[{\"id\":\"1ce44fd\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"4a03439\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"17ce765\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0646\\u0645\\u0648\\u0646\\u0647 \\u0639\\u0646\\u0648\\u0627\\u0646\",\"btn_title\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0647\\u0645\\u0647\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"6649259\",\"elType\":\"widget\",\"settings\":{\"playlist_title\":\"\\u0644\\u06cc\\u0633\\u062a \\u067e\\u062e\\u0634 \\u0648\\u06cc\\u062f\\u06cc\\u0648\",\"videos\":[{\"title\":\"\\u0648\\u06cc\\u0698\\u06af\\u06cc \\u0647\\u0627\\u06cc \\u0642\\u0627\\u0644\\u0628 \\u0647\\u0627\\u0631\\u06cc\\u06a9\\u0627\",\"_id\":\"190deb5\",\"aparat_iframe\":\"<style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}<\\/style><div class=\\\"h_iframe-aparat_embed_frame\\\"><span style=\\\"display: block;padding-top: 57%\\\"><\\/span><iframe src=\\\"https:\\/\\/www.aparat.com\\/video\\/video\\/embed\\/videohash\\/slk4Q\\/vt\\/frame\\\"  allowFullScreen=\\\"true\\\" webkitallowfullscreen=\\\"true\\\" mozallowfullscreen=\\\"true\\\"><\\/iframe><\\/div>\"}]},\"elements\":[],\"widgetType\":\"HarikaVideoPlayList\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("466", "15", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("467", "15", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("468", "15", "harika-meta-main-color", "");
INSERT INTO `wp_postmeta` VALUES("469", "15", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("470", "15", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("471", "15", "harika-meta-header-select", "default");
INSERT INTO `wp_postmeta` VALUES("472", "15", "harika-meta-footer-select", "default");
INSERT INTO `wp_postmeta` VALUES("473", "15", "_elementor_template_type", "wp-post");
INSERT INTO `wp_postmeta` VALUES("474", "15", "_elementor_version", "3.9.2");
INSERT INTO `wp_postmeta` VALUES("475", "15", "_elementor_pro_version", "3.9.2");
INSERT INTO `wp_postmeta` VALUES("476", "15", "harika-meta-direct-video", "https://webdev-demo.ir/harika/videos/rurouni-kenshin.mp4");
INSERT INTO `wp_postmeta` VALUES("477", "15", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("478", "15", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("479", "15", "harika-meta-single-select", "default");
INSERT INTO `wp_postmeta` VALUES("480", "15", "_thumbnail_id", "593");
INSERT INTO `wp_postmeta` VALUES("481", "15", "harika-meta-video-duration", "");
INSERT INTO `wp_postmeta` VALUES("482", "15", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("483", "69", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("484", "69", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("485", "69", "harika-meta-main-color", "");
INSERT INTO `wp_postmeta` VALUES("486", "69", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("487", "69", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("488", "69", "harika-meta-header-select", "default");
INSERT INTO `wp_postmeta` VALUES("489", "69", "harika-meta-footer-select", "default");
INSERT INTO `wp_postmeta` VALUES("490", "69", "_wp_old_slug", "%d9%be%d8%b3%d8%aa-%d8%b4%d9%85%d8%a7%d8%b1%d9%87-%d8%af%d9%88");
INSERT INTO `wp_postmeta` VALUES("491", "69", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("492", "69", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("493", "69", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("494", "69", "harika-meta-single-select", "default");
INSERT INTO `wp_postmeta` VALUES("495", "69", "_thumbnail_id", "587");
INSERT INTO `wp_postmeta` VALUES("496", "70", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("497", "70", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("498", "70", "harika-meta-main-color", "");
INSERT INTO `wp_postmeta` VALUES("499", "70", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("500", "70", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("501", "70", "harika-meta-header-select", "default");
INSERT INTO `wp_postmeta` VALUES("502", "70", "harika-meta-footer-select", "default");
INSERT INTO `wp_postmeta` VALUES("503", "70", "_wp_old_slug", "%d9%be%d8%b3%d8%aa-%d8%b4%d9%85%d8%a7%d8%b1%d9%87-%d8%b3%d9%87");
INSERT INTO `wp_postmeta` VALUES("504", "70", "harika-meta-single-select", "default");
INSERT INTO `wp_postmeta` VALUES("505", "70", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("506", "70", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("507", "70", "harika-meta-direct-audio", "https://webdev-demo.ir/harika/videos/Get-Away.mp3");
INSERT INTO `wp_postmeta` VALUES("508", "70", "_thumbnail_id", "585");
INSERT INTO `wp_postmeta` VALUES("509", "71", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("510", "71", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("511", "71", "harika-meta-main-color", "");
INSERT INTO `wp_postmeta` VALUES("512", "71", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("513", "71", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("514", "71", "harika-meta-header-select", "default");
INSERT INTO `wp_postmeta` VALUES("515", "71", "harika-meta-footer-select", "default");
INSERT INTO `wp_postmeta` VALUES("516", "71", "_wp_old_slug", "%d9%be%d8%b3%d8%aa-%d8%b4%d9%85%d8%a7%d8%b1%d9%87-%da%86%d9%87%d8%a7%d8%b1");
INSERT INTO `wp_postmeta` VALUES("517", "71", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("518", "71", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("519", "71", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("520", "71", "harika-meta-single-select", "default");
INSERT INTO `wp_postmeta` VALUES("521", "71", "_thumbnail_id", "582");
INSERT INTO `wp_postmeta` VALUES("522", "523", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("523", "523", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("524", "523", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("525", "523", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("526", "523", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("527", "523", "harika-meta-main-color", "");
INSERT INTO `wp_postmeta` VALUES("528", "523", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("529", "523", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("530", "523", "harika-meta-header-select", "default");
INSERT INTO `wp_postmeta` VALUES("531", "523", "harika-meta-footer-select", "default");
INSERT INTO `wp_postmeta` VALUES("532", "523", "harika-meta-single-select", "default");
INSERT INTO `wp_postmeta` VALUES("533", "523", "_thumbnail_id", "579");
INSERT INTO `wp_postmeta` VALUES("534", "524", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("535", "524", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("536", "524", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("537", "524", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("538", "524", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("539", "524", "harika-meta-main-color", "");
INSERT INTO `wp_postmeta` VALUES("540", "524", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("541", "524", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("542", "524", "harika-meta-header-select", "default");
INSERT INTO `wp_postmeta` VALUES("543", "524", "harika-meta-footer-select", "default");
INSERT INTO `wp_postmeta` VALUES("544", "524", "harika-meta-single-select", "default");
INSERT INTO `wp_postmeta` VALUES("545", "524", "_thumbnail_id", "589");
INSERT INTO `wp_postmeta` VALUES("546", "525", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("547", "525", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("548", "525", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("549", "525", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("550", "525", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("551", "525", "harika-meta-main-color", "");
INSERT INTO `wp_postmeta` VALUES("552", "525", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("553", "525", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("554", "525", "harika-meta-header-select", "default");
INSERT INTO `wp_postmeta` VALUES("555", "525", "harika-meta-footer-select", "default");
INSERT INTO `wp_postmeta` VALUES("556", "525", "harika-meta-single-select", "default");
INSERT INTO `wp_postmeta` VALUES("557", "525", "_thumbnail_id", "575");
INSERT INTO `wp_postmeta` VALUES("558", "526", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("559", "526", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("560", "526", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("561", "526", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("562", "526", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("563", "526", "harika-meta-main-color", "");
INSERT INTO `wp_postmeta` VALUES("564", "526", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("565", "526", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("566", "526", "harika-meta-header-select", "default");
INSERT INTO `wp_postmeta` VALUES("567", "526", "harika-meta-footer-select", "default");
INSERT INTO `wp_postmeta` VALUES("568", "526", "harika-meta-single-select", "default");
INSERT INTO `wp_postmeta` VALUES("569", "526", "_thumbnail_id", "539");
INSERT INTO `wp_postmeta` VALUES("570", "527", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("571", "527", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("572", "527", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("573", "527", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("574", "527", "harika-meta-direct-audio", "https://webdev-demo.ir/harika/videos/Get-Away.mp3");
INSERT INTO `wp_postmeta` VALUES("575", "527", "harika-meta-main-color", "");
INSERT INTO `wp_postmeta` VALUES("576", "527", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("577", "527", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("578", "527", "harika-meta-header-select", "default");
INSERT INTO `wp_postmeta` VALUES("579", "527", "harika-meta-footer-select", "default");
INSERT INTO `wp_postmeta` VALUES("580", "527", "harika-meta-single-select", "default");
INSERT INTO `wp_postmeta` VALUES("581", "527", "_thumbnail_id", "322");
INSERT INTO `wp_postmeta` VALUES("582", "528", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("583", "528", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("584", "528", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("585", "528", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("586", "528", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("587", "528", "harika-meta-main-color", "");
INSERT INTO `wp_postmeta` VALUES("588", "528", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("589", "528", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("590", "528", "harika-meta-header-select", "default");
INSERT INTO `wp_postmeta` VALUES("591", "528", "harika-meta-footer-select", "default");
INSERT INTO `wp_postmeta` VALUES("592", "528", "harika-meta-single-select", "default");
INSERT INTO `wp_postmeta` VALUES("593", "528", "_thumbnail_id", "320");
INSERT INTO `wp_postmeta` VALUES("594", "529", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("595", "529", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("596", "529", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("597", "529", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("598", "529", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("599", "529", "harika-meta-main-color", "");
INSERT INTO `wp_postmeta` VALUES("600", "529", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("601", "529", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("602", "529", "harika-meta-header-select", "default");
INSERT INTO `wp_postmeta` VALUES("603", "529", "harika-meta-footer-select", "default");
INSERT INTO `wp_postmeta` VALUES("604", "529", "harika-meta-single-select", "default");
INSERT INTO `wp_postmeta` VALUES("605", "529", "_thumbnail_id", "321");
INSERT INTO `wp_postmeta` VALUES("606", "530", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("607", "530", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("608", "530", "harika-meta-direct-video", "https://webdev-demo.ir/harika/videos/jenna-ortega.mp4");
INSERT INTO `wp_postmeta` VALUES("609", "530", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("610", "530", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("611", "530", "harika-meta-main-color", "");
INSERT INTO `wp_postmeta` VALUES("612", "530", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("613", "530", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("614", "530", "harika-meta-header-select", "default");
INSERT INTO `wp_postmeta` VALUES("615", "530", "harika-meta-footer-select", "default");
INSERT INTO `wp_postmeta` VALUES("616", "530", "harika-meta-single-select", "default");
INSERT INTO `wp_postmeta` VALUES("617", "530", "_thumbnail_id", "550");
INSERT INTO `wp_postmeta` VALUES("618", "530", "harika-meta-video-duration", "06:08");
INSERT INTO `wp_postmeta` VALUES("619", "530", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("620", "699", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("621", "699", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("622", "699", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("623", "699", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("624", "699", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("625", "699", "harika-meta-main-color", "#514ce6");
INSERT INTO `wp_postmeta` VALUES("626", "699", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("627", "699", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("628", "699", "harika-meta-header-select", "665");
INSERT INTO `wp_postmeta` VALUES("629", "699", "harika-meta-footer-select", "679");
INSERT INTO `wp_postmeta` VALUES("630", "699", "harika-meta-single-select", "1491");
INSERT INTO `wp_postmeta` VALUES("631", "699", "_thumbnail_id", "776");
INSERT INTO `wp_postmeta` VALUES("632", "699", "harika-meta-swtl-select", "2");
INSERT INTO `wp_postmeta` VALUES("633", "700", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("634", "700", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("635", "700", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("636", "700", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("637", "700", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("638", "700", "harika-meta-main-color", "#514ce6");
INSERT INTO `wp_postmeta` VALUES("639", "700", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("640", "700", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("641", "700", "harika-meta-header-select", "665");
INSERT INTO `wp_postmeta` VALUES("642", "700", "harika-meta-footer-select", "679");
INSERT INTO `wp_postmeta` VALUES("643", "700", "harika-meta-single-select", "1491");
INSERT INTO `wp_postmeta` VALUES("644", "700", "_thumbnail_id", "777");
INSERT INTO `wp_postmeta` VALUES("645", "700", "harika-meta-swtl-select", "2");
INSERT INTO `wp_postmeta` VALUES("646", "701", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("647", "701", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("648", "701", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("649", "701", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("650", "701", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("651", "701", "harika-meta-main-color", "#514ce6");
INSERT INTO `wp_postmeta` VALUES("652", "701", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("653", "701", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("654", "701", "harika-meta-header-select", "665");
INSERT INTO `wp_postmeta` VALUES("655", "701", "harika-meta-footer-select", "679");
INSERT INTO `wp_postmeta` VALUES("656", "701", "harika-meta-single-select", "1491");
INSERT INTO `wp_postmeta` VALUES("657", "701", "_thumbnail_id", "778");
INSERT INTO `wp_postmeta` VALUES("658", "701", "harika-meta-swtl-select", "2");
INSERT INTO `wp_postmeta` VALUES("659", "702", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("660", "702", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("661", "702", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("662", "702", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("663", "702", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("664", "702", "harika-meta-main-color", "#514ce6");
INSERT INTO `wp_postmeta` VALUES("665", "702", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("666", "702", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("667", "702", "harika-meta-header-select", "665");
INSERT INTO `wp_postmeta` VALUES("668", "702", "harika-meta-footer-select", "679");
INSERT INTO `wp_postmeta` VALUES("669", "702", "harika-meta-single-select", "1491");
INSERT INTO `wp_postmeta` VALUES("670", "702", "_thumbnail_id", "779");
INSERT INTO `wp_postmeta` VALUES("671", "702", "harika-meta-swtl-select", "2");
INSERT INTO `wp_postmeta` VALUES("672", "703", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("673", "703", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("674", "703", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("675", "703", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("676", "703", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("677", "703", "harika-meta-main-color", "#514ce6");
INSERT INTO `wp_postmeta` VALUES("678", "703", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("679", "703", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("680", "703", "harika-meta-header-select", "665");
INSERT INTO `wp_postmeta` VALUES("681", "703", "harika-meta-footer-select", "679");
INSERT INTO `wp_postmeta` VALUES("682", "703", "harika-meta-single-select", "1491");
INSERT INTO `wp_postmeta` VALUES("683", "703", "_thumbnail_id", "780");
INSERT INTO `wp_postmeta` VALUES("684", "703", "harika-meta-swtl-select", "2");
INSERT INTO `wp_postmeta` VALUES("685", "704", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("686", "704", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("687", "704", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("688", "704", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("689", "704", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("690", "704", "harika-meta-main-color", "#514ce6");
INSERT INTO `wp_postmeta` VALUES("691", "704", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("692", "704", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("693", "704", "harika-meta-header-select", "665");
INSERT INTO `wp_postmeta` VALUES("694", "704", "harika-meta-footer-select", "679");
INSERT INTO `wp_postmeta` VALUES("695", "704", "harika-meta-single-select", "1491");
INSERT INTO `wp_postmeta` VALUES("696", "704", "_thumbnail_id", "781");
INSERT INTO `wp_postmeta` VALUES("697", "704", "harika-meta-swtl-select", "2");
INSERT INTO `wp_postmeta` VALUES("698", "705", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("699", "705", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("700", "705", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("701", "705", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("702", "705", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("703", "705", "harika-meta-main-color", "#514ce6");
INSERT INTO `wp_postmeta` VALUES("704", "705", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("705", "705", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("706", "705", "harika-meta-header-select", "665");
INSERT INTO `wp_postmeta` VALUES("707", "705", "harika-meta-footer-select", "679");
INSERT INTO `wp_postmeta` VALUES("708", "705", "harika-meta-single-select", "1491");
INSERT INTO `wp_postmeta` VALUES("709", "705", "_thumbnail_id", "782");
INSERT INTO `wp_postmeta` VALUES("710", "705", "harika-meta-swtl-select", "2");
INSERT INTO `wp_postmeta` VALUES("711", "709", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("712", "709", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("713", "709", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("714", "709", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("715", "709", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("716", "709", "harika-meta-main-color", "#514ce6");
INSERT INTO `wp_postmeta` VALUES("717", "709", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("718", "709", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("719", "709", "harika-meta-header-select", "665");
INSERT INTO `wp_postmeta` VALUES("720", "709", "harika-meta-footer-select", "679");
INSERT INTO `wp_postmeta` VALUES("721", "709", "harika-meta-single-select", "1491");
INSERT INTO `wp_postmeta` VALUES("722", "709", "_wp_old_slug", "p22");
INSERT INTO `wp_postmeta` VALUES("723", "709", "_wp_old_slug", "p20-2");
INSERT INTO `wp_postmeta` VALUES("724", "709", "_thumbnail_id", "783");
INSERT INTO `wp_postmeta` VALUES("725", "709", "harika-meta-swtl-select", "2");
INSERT INTO `wp_postmeta` VALUES("726", "707", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("727", "707", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("728", "707", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("729", "707", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("730", "707", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("731", "707", "harika-meta-main-color", "#514ce6");
INSERT INTO `wp_postmeta` VALUES("732", "707", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("733", "707", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("734", "707", "harika-meta-header-select", "665");
INSERT INTO `wp_postmeta` VALUES("735", "707", "harika-meta-footer-select", "679");
INSERT INTO `wp_postmeta` VALUES("736", "707", "harika-meta-single-select", "1491");
INSERT INTO `wp_postmeta` VALUES("737", "707", "_wp_old_slug", "p20");
INSERT INTO `wp_postmeta` VALUES("738", "707", "_wp_old_slug", "p80");
INSERT INTO `wp_postmeta` VALUES("739", "707", "_thumbnail_id", "784");
INSERT INTO `wp_postmeta` VALUES("740", "707", "harika-meta-swtl-select", "2");
INSERT INTO `wp_postmeta` VALUES("741", "708", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("742", "708", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("743", "708", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("744", "708", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("745", "708", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("746", "708", "harika-meta-main-color", "#514ce6");
INSERT INTO `wp_postmeta` VALUES("747", "708", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("748", "708", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("749", "708", "harika-meta-header-select", "665");
INSERT INTO `wp_postmeta` VALUES("750", "708", "harika-meta-footer-select", "679");
INSERT INTO `wp_postmeta` VALUES("751", "708", "harika-meta-single-select", "1491");
INSERT INTO `wp_postmeta` VALUES("752", "708", "_wp_old_slug", "p21");
INSERT INTO `wp_postmeta` VALUES("753", "708", "_wp_old_slug", "p801");
INSERT INTO `wp_postmeta` VALUES("754", "708", "_thumbnail_id", "785");
INSERT INTO `wp_postmeta` VALUES("755", "708", "harika-meta-swtl-select", "2");
INSERT INTO `wp_postmeta` VALUES("756", "712", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("757", "712", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("758", "712", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("759", "712", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("760", "712", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("761", "712", "harika-meta-main-color", "#514ce6");
INSERT INTO `wp_postmeta` VALUES("762", "712", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("763", "712", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("764", "712", "harika-meta-header-select", "665");
INSERT INTO `wp_postmeta` VALUES("765", "712", "harika-meta-footer-select", "679");
INSERT INTO `wp_postmeta` VALUES("766", "712", "harika-meta-single-select", "1491");
INSERT INTO `wp_postmeta` VALUES("767", "712", "_wp_old_slug", "p25");
INSERT INTO `wp_postmeta` VALUES("768", "712", "_wp_old_slug", "p803");
INSERT INTO `wp_postmeta` VALUES("769", "712", "_thumbnail_id", "787");
INSERT INTO `wp_postmeta` VALUES("770", "712", "harika-meta-swtl-select", "2");
INSERT INTO `wp_postmeta` VALUES("771", "713", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("772", "713", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("773", "713", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("774", "713", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("775", "713", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("776", "713", "harika-meta-main-color", "#514ce6");
INSERT INTO `wp_postmeta` VALUES("777", "713", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("778", "713", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("779", "713", "harika-meta-header-select", "665");
INSERT INTO `wp_postmeta` VALUES("780", "713", "harika-meta-footer-select", "679");
INSERT INTO `wp_postmeta` VALUES("781", "713", "harika-meta-single-select", "1491");
INSERT INTO `wp_postmeta` VALUES("782", "713", "_wp_old_slug", "p24");
INSERT INTO `wp_postmeta` VALUES("783", "713", "_wp_old_slug", "p802");
INSERT INTO `wp_postmeta` VALUES("784", "713", "_thumbnail_id", "786");
INSERT INTO `wp_postmeta` VALUES("785", "713", "harika-meta-swtl-select", "2");
INSERT INTO `wp_postmeta` VALUES("786", "714", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("787", "714", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("788", "714", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("789", "714", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("790", "714", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("791", "714", "harika-meta-main-color", "#514ce6");
INSERT INTO `wp_postmeta` VALUES("792", "714", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("793", "714", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("794", "714", "harika-meta-header-select", "665");
INSERT INTO `wp_postmeta` VALUES("795", "714", "harika-meta-footer-select", "679");
INSERT INTO `wp_postmeta` VALUES("796", "714", "harika-meta-single-select", "1491");
INSERT INTO `wp_postmeta` VALUES("797", "714", "_wp_old_slug", "p26");
INSERT INTO `wp_postmeta` VALUES("798", "714", "_wp_old_slug", "p806");
INSERT INTO `wp_postmeta` VALUES("799", "714", "_thumbnail_id", "790");
INSERT INTO `wp_postmeta` VALUES("800", "714", "harika-meta-swtl-select", "2");
INSERT INTO `wp_postmeta` VALUES("801", "715", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("802", "715", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("803", "715", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("804", "715", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("805", "715", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("806", "715", "harika-meta-main-color", "#514ce6");
INSERT INTO `wp_postmeta` VALUES("807", "715", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("808", "715", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("809", "715", "harika-meta-header-select", "665");
INSERT INTO `wp_postmeta` VALUES("810", "715", "harika-meta-footer-select", "679");
INSERT INTO `wp_postmeta` VALUES("811", "715", "harika-meta-single-select", "1491");
INSERT INTO `wp_postmeta` VALUES("812", "715", "_wp_old_slug", "p23");
INSERT INTO `wp_postmeta` VALUES("813", "715", "_wp_old_slug", "p804");
INSERT INTO `wp_postmeta` VALUES("814", "715", "_thumbnail_id", "788");
INSERT INTO `wp_postmeta` VALUES("815", "715", "harika-meta-swtl-select", "2");
INSERT INTO `wp_postmeta` VALUES("816", "716", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("817", "716", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("818", "716", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("819", "716", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("820", "716", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("821", "716", "harika-meta-main-color", "#514ce6");
INSERT INTO `wp_postmeta` VALUES("822", "716", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("823", "716", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("824", "716", "harika-meta-header-select", "665");
INSERT INTO `wp_postmeta` VALUES("825", "716", "harika-meta-footer-select", "679");
INSERT INTO `wp_postmeta` VALUES("826", "716", "harika-meta-single-select", "1491");
INSERT INTO `wp_postmeta` VALUES("827", "716", "_wp_old_slug", "p27");
INSERT INTO `wp_postmeta` VALUES("828", "716", "_wp_old_slug", "p805");
INSERT INTO `wp_postmeta` VALUES("829", "716", "_thumbnail_id", "789");
INSERT INTO `wp_postmeta` VALUES("830", "716", "harika-meta-swtl-select", "2");
INSERT INTO `wp_postmeta` VALUES("831", "930", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("832", "930", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("833", "930", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("834", "930", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("835", "930", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("836", "930", "harika-meta-main-color", "#ef233c");
INSERT INTO `wp_postmeta` VALUES("837", "930", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("838", "930", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("839", "930", "harika-meta-header-select", "890");
INSERT INTO `wp_postmeta` VALUES("840", "930", "harika-meta-footer-select", "906");
INSERT INTO `wp_postmeta` VALUES("841", "930", "harika-meta-single-select", "1496");
INSERT INTO `wp_postmeta` VALUES("842", "930", "_thumbnail_id", "965");
INSERT INTO `wp_postmeta` VALUES("843", "930", "harika-meta-swtl-select", "3");
INSERT INTO `wp_postmeta` VALUES("844", "931", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("845", "931", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("846", "931", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("847", "931", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("848", "931", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("849", "931", "harika-meta-main-color", "#ef233c");
INSERT INTO `wp_postmeta` VALUES("850", "931", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("851", "931", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("852", "931", "harika-meta-header-select", "890");
INSERT INTO `wp_postmeta` VALUES("853", "931", "harika-meta-footer-select", "906");
INSERT INTO `wp_postmeta` VALUES("854", "931", "harika-meta-single-select", "1496");
INSERT INTO `wp_postmeta` VALUES("855", "931", "_thumbnail_id", "966");
INSERT INTO `wp_postmeta` VALUES("856", "931", "harika-meta-swtl-select", "3");
INSERT INTO `wp_postmeta` VALUES("857", "932", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("858", "932", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("859", "932", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("860", "932", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("861", "932", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("862", "932", "harika-meta-main-color", "#ef233c");
INSERT INTO `wp_postmeta` VALUES("863", "932", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("864", "932", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("865", "932", "harika-meta-header-select", "890");
INSERT INTO `wp_postmeta` VALUES("866", "932", "harika-meta-footer-select", "906");
INSERT INTO `wp_postmeta` VALUES("867", "932", "harika-meta-single-select", "1496");
INSERT INTO `wp_postmeta` VALUES("868", "932", "_thumbnail_id", "968");
INSERT INTO `wp_postmeta` VALUES("869", "932", "harika-meta-swtl-select", "3");
INSERT INTO `wp_postmeta` VALUES("870", "933", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("871", "933", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("872", "933", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("873", "933", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("874", "933", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("875", "933", "harika-meta-main-color", "#ef233c");
INSERT INTO `wp_postmeta` VALUES("876", "933", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("877", "933", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("878", "933", "harika-meta-header-select", "890");
INSERT INTO `wp_postmeta` VALUES("879", "933", "harika-meta-footer-select", "906");
INSERT INTO `wp_postmeta` VALUES("880", "933", "harika-meta-single-select", "1496");
INSERT INTO `wp_postmeta` VALUES("881", "933", "_thumbnail_id", "967");
INSERT INTO `wp_postmeta` VALUES("882", "933", "harika-meta-swtl-select", "3");
INSERT INTO `wp_postmeta` VALUES("883", "934", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("884", "934", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("885", "934", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("886", "934", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("887", "934", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("888", "934", "harika-meta-main-color", "#ef233c");
INSERT INTO `wp_postmeta` VALUES("889", "934", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("890", "934", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("891", "934", "harika-meta-header-select", "890");
INSERT INTO `wp_postmeta` VALUES("892", "934", "harika-meta-footer-select", "906");
INSERT INTO `wp_postmeta` VALUES("893", "934", "harika-meta-single-select", "1496");
INSERT INTO `wp_postmeta` VALUES("894", "934", "_thumbnail_id", "969");
INSERT INTO `wp_postmeta` VALUES("895", "934", "harika-meta-swtl-select", "3");
INSERT INTO `wp_postmeta` VALUES("896", "935", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("897", "935", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("898", "935", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("899", "935", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("900", "935", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("901", "935", "harika-meta-main-color", "#ef233c");
INSERT INTO `wp_postmeta` VALUES("902", "935", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("903", "935", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("904", "935", "harika-meta-header-select", "890");
INSERT INTO `wp_postmeta` VALUES("905", "935", "harika-meta-footer-select", "906");
INSERT INTO `wp_postmeta` VALUES("906", "935", "harika-meta-single-select", "1496");
INSERT INTO `wp_postmeta` VALUES("907", "935", "_thumbnail_id", "971");
INSERT INTO `wp_postmeta` VALUES("908", "935", "harika-meta-swtl-select", "3");
INSERT INTO `wp_postmeta` VALUES("909", "936", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("910", "936", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("911", "936", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("912", "936", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("913", "936", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("914", "936", "harika-meta-main-color", "#ef233c");
INSERT INTO `wp_postmeta` VALUES("915", "936", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("916", "936", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("917", "936", "harika-meta-header-select", "890");
INSERT INTO `wp_postmeta` VALUES("918", "936", "harika-meta-footer-select", "906");
INSERT INTO `wp_postmeta` VALUES("919", "936", "harika-meta-single-select", "1496");
INSERT INTO `wp_postmeta` VALUES("920", "936", "_thumbnail_id", "975");
INSERT INTO `wp_postmeta` VALUES("921", "936", "harika-meta-swtl-select", "3");
INSERT INTO `wp_postmeta` VALUES("922", "937", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("923", "937", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("924", "937", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("925", "937", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("926", "937", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("927", "937", "harika-meta-main-color", "#ef233c");
INSERT INTO `wp_postmeta` VALUES("928", "937", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("929", "937", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("930", "937", "harika-meta-header-select", "890");
INSERT INTO `wp_postmeta` VALUES("931", "937", "harika-meta-footer-select", "906");
INSERT INTO `wp_postmeta` VALUES("932", "937", "harika-meta-single-select", "1496");
INSERT INTO `wp_postmeta` VALUES("933", "937", "_thumbnail_id", "976");
INSERT INTO `wp_postmeta` VALUES("934", "937", "harika-meta-swtl-select", "3");
INSERT INTO `wp_postmeta` VALUES("935", "938", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("936", "938", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("937", "938", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("938", "938", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("939", "938", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("940", "938", "harika-meta-main-color", "#ef233c");
INSERT INTO `wp_postmeta` VALUES("941", "938", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("942", "938", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("943", "938", "harika-meta-header-select", "890");
INSERT INTO `wp_postmeta` VALUES("944", "938", "harika-meta-footer-select", "906");
INSERT INTO `wp_postmeta` VALUES("945", "938", "harika-meta-single-select", "1496");
INSERT INTO `wp_postmeta` VALUES("946", "938", "_thumbnail_id", "977");
INSERT INTO `wp_postmeta` VALUES("947", "938", "harika-meta-swtl-select", "3");
INSERT INTO `wp_postmeta` VALUES("948", "939", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("949", "939", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("950", "939", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("951", "939", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("952", "939", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("953", "939", "harika-meta-main-color", "#ef233c");
INSERT INTO `wp_postmeta` VALUES("954", "939", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("955", "939", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("956", "939", "harika-meta-header-select", "890");
INSERT INTO `wp_postmeta` VALUES("957", "939", "harika-meta-footer-select", "906");
INSERT INTO `wp_postmeta` VALUES("958", "939", "harika-meta-single-select", "1496");
INSERT INTO `wp_postmeta` VALUES("959", "939", "_thumbnail_id", "970");
INSERT INTO `wp_postmeta` VALUES("960", "939", "harika-meta-swtl-select", "3");
INSERT INTO `wp_postmeta` VALUES("961", "940", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("962", "940", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("963", "940", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("964", "940", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("965", "940", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("966", "940", "harika-meta-main-color", "#ef233c");
INSERT INTO `wp_postmeta` VALUES("967", "940", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("968", "940", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("969", "940", "harika-meta-header-select", "890");
INSERT INTO `wp_postmeta` VALUES("970", "940", "harika-meta-footer-select", "906");
INSERT INTO `wp_postmeta` VALUES("971", "940", "harika-meta-single-select", "1496");
INSERT INTO `wp_postmeta` VALUES("972", "940", "_thumbnail_id", "964");
INSERT INTO `wp_postmeta` VALUES("973", "940", "harika-meta-swtl-select", "3");
INSERT INTO `wp_postmeta` VALUES("974", "942", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("975", "942", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("976", "942", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("977", "942", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("978", "942", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("979", "942", "harika-meta-main-color", "#ef233c");
INSERT INTO `wp_postmeta` VALUES("980", "942", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("981", "942", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("982", "942", "harika-meta-header-select", "890");
INSERT INTO `wp_postmeta` VALUES("983", "942", "harika-meta-footer-select", "906");
INSERT INTO `wp_postmeta` VALUES("984", "942", "harika-meta-single-select", "1496");
INSERT INTO `wp_postmeta` VALUES("985", "942", "_thumbnail_id", "982");
INSERT INTO `wp_postmeta` VALUES("986", "942", "harika-meta-swtl-select", "3");
INSERT INTO `wp_postmeta` VALUES("987", "944", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("988", "944", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("989", "944", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("990", "944", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("991", "944", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("992", "944", "harika-meta-main-color", "#ef233c");
INSERT INTO `wp_postmeta` VALUES("993", "944", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("994", "944", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("995", "944", "harika-meta-header-select", "890");
INSERT INTO `wp_postmeta` VALUES("996", "944", "harika-meta-footer-select", "906");
INSERT INTO `wp_postmeta` VALUES("997", "944", "harika-meta-single-select", "1496");
INSERT INTO `wp_postmeta` VALUES("998", "944", "_thumbnail_id", "980");
INSERT INTO `wp_postmeta` VALUES("999", "944", "harika-meta-swtl-select", "3");
INSERT INTO `wp_postmeta` VALUES("1000", "941", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1001", "941", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1002", "941", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1003", "941", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1004", "941", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1005", "941", "harika-meta-main-color", "#ef233c");
INSERT INTO `wp_postmeta` VALUES("1006", "941", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1007", "941", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1008", "941", "harika-meta-header-select", "890");
INSERT INTO `wp_postmeta` VALUES("1009", "941", "harika-meta-footer-select", "906");
INSERT INTO `wp_postmeta` VALUES("1010", "941", "harika-meta-single-select", "1496");
INSERT INTO `wp_postmeta` VALUES("1011", "941", "_thumbnail_id", "984");
INSERT INTO `wp_postmeta` VALUES("1012", "941", "harika-meta-swtl-select", "3");
INSERT INTO `wp_postmeta` VALUES("1013", "946", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1014", "946", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1015", "946", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1016", "946", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1017", "946", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1018", "946", "harika-meta-main-color", "#ef233c");
INSERT INTO `wp_postmeta` VALUES("1019", "946", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1020", "946", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1021", "946", "harika-meta-header-select", "890");
INSERT INTO `wp_postmeta` VALUES("1022", "946", "harika-meta-footer-select", "906");
INSERT INTO `wp_postmeta` VALUES("1023", "946", "harika-meta-single-select", "1496");
INSERT INTO `wp_postmeta` VALUES("1024", "946", "_thumbnail_id", "986");
INSERT INTO `wp_postmeta` VALUES("1025", "946", "harika-meta-swtl-select", "3");
INSERT INTO `wp_postmeta` VALUES("1026", "1104", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1027", "1104", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1028", "1104", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1029", "1104", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1030", "1104", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1031", "1104", "harika-meta-main-color", "#0055ff");
INSERT INTO `wp_postmeta` VALUES("1032", "1104", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1033", "1104", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1034", "1104", "harika-meta-header-select", "1279");
INSERT INTO `wp_postmeta` VALUES("1035", "1104", "harika-meta-footer-select", "1184");
INSERT INTO `wp_postmeta` VALUES("1036", "1104", "harika-meta-single-select", "1533");
INSERT INTO `wp_postmeta` VALUES("1037", "1104", "_thumbnail_id", "1144");
INSERT INTO `wp_postmeta` VALUES("1038", "1104", "harika-meta-swtl-select", "4");
INSERT INTO `wp_postmeta` VALUES("1039", "1105", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1040", "1105", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1041", "1105", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1042", "1105", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1043", "1105", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1044", "1105", "harika-meta-main-color", "#0055ff");
INSERT INTO `wp_postmeta` VALUES("1045", "1105", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1046", "1105", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1047", "1105", "harika-meta-header-select", "1279");
INSERT INTO `wp_postmeta` VALUES("1048", "1105", "harika-meta-footer-select", "1184");
INSERT INTO `wp_postmeta` VALUES("1049", "1105", "harika-meta-single-select", "1533");
INSERT INTO `wp_postmeta` VALUES("1050", "1105", "_thumbnail_id", "1148");
INSERT INTO `wp_postmeta` VALUES("1051", "1105", "harika-meta-swtl-select", "4");
INSERT INTO `wp_postmeta` VALUES("1052", "1106", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1053", "1106", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1054", "1106", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1055", "1106", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1056", "1106", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1057", "1106", "harika-meta-main-color", "#0055ff");
INSERT INTO `wp_postmeta` VALUES("1058", "1106", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1059", "1106", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1060", "1106", "harika-meta-header-select", "1279");
INSERT INTO `wp_postmeta` VALUES("1061", "1106", "harika-meta-footer-select", "1184");
INSERT INTO `wp_postmeta` VALUES("1062", "1106", "harika-meta-single-select", "1533");
INSERT INTO `wp_postmeta` VALUES("1063", "1106", "_thumbnail_id", "1152");
INSERT INTO `wp_postmeta` VALUES("1064", "1106", "harika-meta-swtl-select", "4");
INSERT INTO `wp_postmeta` VALUES("1065", "1107", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1066", "1107", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1067", "1107", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1068", "1107", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1069", "1107", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1070", "1107", "harika-meta-main-color", "#0055ff");
INSERT INTO `wp_postmeta` VALUES("1071", "1107", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1072", "1107", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1073", "1107", "harika-meta-header-select", "1279");
INSERT INTO `wp_postmeta` VALUES("1074", "1107", "harika-meta-footer-select", "1184");
INSERT INTO `wp_postmeta` VALUES("1075", "1107", "harika-meta-single-select", "1533");
INSERT INTO `wp_postmeta` VALUES("1076", "1107", "_thumbnail_id", "1150");
INSERT INTO `wp_postmeta` VALUES("1077", "1107", "harika-meta-swtl-select", "4");
INSERT INTO `wp_postmeta` VALUES("1078", "1108", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1079", "1108", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1080", "1108", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1081", "1108", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1082", "1108", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1083", "1108", "harika-meta-main-color", "#0055ff");
INSERT INTO `wp_postmeta` VALUES("1084", "1108", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1085", "1108", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1086", "1108", "harika-meta-header-select", "1279");
INSERT INTO `wp_postmeta` VALUES("1087", "1108", "harika-meta-footer-select", "1184");
INSERT INTO `wp_postmeta` VALUES("1088", "1108", "harika-meta-single-select", "1533");
INSERT INTO `wp_postmeta` VALUES("1089", "1108", "_thumbnail_id", "1153");
INSERT INTO `wp_postmeta` VALUES("1090", "1108", "harika-meta-swtl-select", "4");
INSERT INTO `wp_postmeta` VALUES("1091", "1109", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1092", "1109", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1093", "1109", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1094", "1109", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1095", "1109", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1096", "1109", "harika-meta-main-color", "#0055ff");
INSERT INTO `wp_postmeta` VALUES("1097", "1109", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1098", "1109", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1099", "1109", "harika-meta-header-select", "1279");
INSERT INTO `wp_postmeta` VALUES("1100", "1109", "harika-meta-footer-select", "1184");
INSERT INTO `wp_postmeta` VALUES("1101", "1109", "harika-meta-single-select", "1533");
INSERT INTO `wp_postmeta` VALUES("1102", "1109", "_thumbnail_id", "1155");
INSERT INTO `wp_postmeta` VALUES("1103", "1109", "harika-meta-swtl-select", "4");
INSERT INTO `wp_postmeta` VALUES("1104", "1110", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1105", "1110", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1106", "1110", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1107", "1110", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1108", "1110", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1109", "1110", "harika-meta-main-color", "#0055ff");
INSERT INTO `wp_postmeta` VALUES("1110", "1110", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1111", "1110", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1112", "1110", "harika-meta-header-select", "1279");
INSERT INTO `wp_postmeta` VALUES("1113", "1110", "harika-meta-footer-select", "1184");
INSERT INTO `wp_postmeta` VALUES("1114", "1110", "harika-meta-single-select", "1533");
INSERT INTO `wp_postmeta` VALUES("1115", "1110", "_thumbnail_id", "1157");
INSERT INTO `wp_postmeta` VALUES("1116", "1110", "harika-meta-swtl-select", "4");
INSERT INTO `wp_postmeta` VALUES("1117", "1111", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1118", "1111", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1119", "1111", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1120", "1111", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1121", "1111", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1122", "1111", "harika-meta-main-color", "#0055ff");
INSERT INTO `wp_postmeta` VALUES("1123", "1111", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1124", "1111", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1125", "1111", "harika-meta-header-select", "1279");
INSERT INTO `wp_postmeta` VALUES("1126", "1111", "harika-meta-footer-select", "1184");
INSERT INTO `wp_postmeta` VALUES("1127", "1111", "harika-meta-single-select", "1533");
INSERT INTO `wp_postmeta` VALUES("1128", "1111", "_thumbnail_id", "1156");
INSERT INTO `wp_postmeta` VALUES("1129", "1111", "harika-meta-swtl-select", "4");
INSERT INTO `wp_postmeta` VALUES("1130", "1112", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1131", "1112", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1132", "1112", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1133", "1112", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1134", "1112", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1135", "1112", "harika-meta-main-color", "#0055ff");
INSERT INTO `wp_postmeta` VALUES("1136", "1112", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1137", "1112", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1138", "1112", "harika-meta-header-select", "1279");
INSERT INTO `wp_postmeta` VALUES("1139", "1112", "harika-meta-footer-select", "1184");
INSERT INTO `wp_postmeta` VALUES("1140", "1112", "harika-meta-single-select", "1533");
INSERT INTO `wp_postmeta` VALUES("1141", "1112", "_thumbnail_id", "1159");
INSERT INTO `wp_postmeta` VALUES("1142", "1112", "harika-meta-swtl-select", "4");
INSERT INTO `wp_postmeta` VALUES("1143", "1114", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1144", "1114", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1145", "1114", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1146", "1114", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1147", "1114", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1148", "1114", "harika-meta-main-color", "#0055ff");
INSERT INTO `wp_postmeta` VALUES("1149", "1114", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1150", "1114", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1151", "1114", "harika-meta-header-select", "1279");
INSERT INTO `wp_postmeta` VALUES("1152", "1114", "harika-meta-footer-select", "1184");
INSERT INTO `wp_postmeta` VALUES("1153", "1114", "harika-meta-single-select", "1533");
INSERT INTO `wp_postmeta` VALUES("1154", "1114", "_thumbnail_id", "1158");
INSERT INTO `wp_postmeta` VALUES("1155", "1114", "harika-meta-swtl-select", "4");
INSERT INTO `wp_postmeta` VALUES("1156", "1115", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1157", "1115", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1158", "1115", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1159", "1115", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1160", "1115", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1161", "1115", "harika-meta-main-color", "#0055ff");
INSERT INTO `wp_postmeta` VALUES("1162", "1115", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1163", "1115", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1164", "1115", "harika-meta-header-select", "1279");
INSERT INTO `wp_postmeta` VALUES("1165", "1115", "harika-meta-footer-select", "1184");
INSERT INTO `wp_postmeta` VALUES("1166", "1115", "harika-meta-single-select", "1533");
INSERT INTO `wp_postmeta` VALUES("1167", "1115", "_thumbnail_id", "1160");
INSERT INTO `wp_postmeta` VALUES("1168", "1115", "harika-meta-swtl-select", "4");
INSERT INTO `wp_postmeta` VALUES("1169", "1116", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1170", "1116", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1171", "1116", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1172", "1116", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1173", "1116", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1174", "1116", "harika-meta-main-color", "#0055ff");
INSERT INTO `wp_postmeta` VALUES("1175", "1116", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1176", "1116", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1177", "1116", "harika-meta-header-select", "1279");
INSERT INTO `wp_postmeta` VALUES("1178", "1116", "harika-meta-footer-select", "1184");
INSERT INTO `wp_postmeta` VALUES("1179", "1116", "harika-meta-single-select", "1533");
INSERT INTO `wp_postmeta` VALUES("1180", "1116", "_thumbnail_id", "1161");
INSERT INTO `wp_postmeta` VALUES("1181", "1116", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("1182", "1117", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1183", "1117", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1184", "1117", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1185", "1117", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1186", "1117", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1187", "1117", "harika-meta-main-color", "#0055ff");
INSERT INTO `wp_postmeta` VALUES("1188", "1117", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1189", "1117", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1190", "1117", "harika-meta-header-select", "1279");
INSERT INTO `wp_postmeta` VALUES("1191", "1117", "harika-meta-footer-select", "1184");
INSERT INTO `wp_postmeta` VALUES("1192", "1117", "harika-meta-single-select", "1533");
INSERT INTO `wp_postmeta` VALUES("1193", "1117", "_thumbnail_id", "1162");
INSERT INTO `wp_postmeta` VALUES("1194", "1117", "harika-meta-swtl-select", "4");
INSERT INTO `wp_postmeta` VALUES("1195", "1118", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1196", "1118", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1197", "1118", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1198", "1118", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1199", "1118", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1200", "1118", "harika-meta-main-color", "#0055ff");
INSERT INTO `wp_postmeta` VALUES("1201", "1118", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1202", "1118", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1203", "1118", "harika-meta-header-select", "1279");
INSERT INTO `wp_postmeta` VALUES("1204", "1118", "harika-meta-footer-select", "1184");
INSERT INTO `wp_postmeta` VALUES("1205", "1118", "harika-meta-single-select", "1533");
INSERT INTO `wp_postmeta` VALUES("1206", "1118", "_thumbnail_id", "1163");
INSERT INTO `wp_postmeta` VALUES("1207", "1118", "harika-meta-swtl-select", "4");
INSERT INTO `wp_postmeta` VALUES("1208", "1350", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1209", "1350", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1210", "1350", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1211", "1350", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1212", "1350", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1213", "1350", "harika-meta-main-color", "#434e64");
INSERT INTO `wp_postmeta` VALUES("1214", "1350", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1215", "1350", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1216", "1350", "harika-meta-header-select", "1204");
INSERT INTO `wp_postmeta` VALUES("1217", "1350", "harika-meta-footer-select", "1328");
INSERT INTO `wp_postmeta` VALUES("1218", "1350", "harika-meta-single-select", "1509");
INSERT INTO `wp_postmeta` VALUES("1219", "1350", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("1220", "1350", "_thumbnail_id", "1397");
INSERT INTO `wp_postmeta` VALUES("1221", "1351", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1222", "1351", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1223", "1351", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1224", "1351", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1225", "1351", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1226", "1351", "harika-meta-main-color", "#434e64");
INSERT INTO `wp_postmeta` VALUES("1227", "1351", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1228", "1351", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1229", "1351", "harika-meta-header-select", "1204");
INSERT INTO `wp_postmeta` VALUES("1230", "1351", "harika-meta-footer-select", "1328");
INSERT INTO `wp_postmeta` VALUES("1231", "1351", "harika-meta-single-select", "1509");
INSERT INTO `wp_postmeta` VALUES("1232", "1351", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("1233", "1351", "_thumbnail_id", "1398");
INSERT INTO `wp_postmeta` VALUES("1234", "1354", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1235", "1354", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1236", "1354", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1237", "1354", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1238", "1354", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1239", "1354", "harika-meta-main-color", "#434e64");
INSERT INTO `wp_postmeta` VALUES("1240", "1354", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1241", "1354", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1242", "1354", "harika-meta-header-select", "1204");
INSERT INTO `wp_postmeta` VALUES("1243", "1354", "harika-meta-footer-select", "1328");
INSERT INTO `wp_postmeta` VALUES("1244", "1354", "harika-meta-single-select", "1509");
INSERT INTO `wp_postmeta` VALUES("1245", "1354", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("1246", "1354", "_thumbnail_id", "1400");
INSERT INTO `wp_postmeta` VALUES("1247", "1356", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1248", "1356", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1249", "1356", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1250", "1356", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1251", "1356", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1252", "1356", "harika-meta-main-color", "#434e64");
INSERT INTO `wp_postmeta` VALUES("1253", "1356", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1254", "1356", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1255", "1356", "harika-meta-header-select", "1204");
INSERT INTO `wp_postmeta` VALUES("1256", "1356", "harika-meta-footer-select", "1328");
INSERT INTO `wp_postmeta` VALUES("1257", "1356", "harika-meta-single-select", "1509");
INSERT INTO `wp_postmeta` VALUES("1258", "1356", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("1259", "1356", "_thumbnail_id", "1399");
INSERT INTO `wp_postmeta` VALUES("1260", "320", "_wp_attached_file", "2023/01/ww.jpg");
INSERT INTO `wp_postmeta` VALUES("1261", "320", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:675;s:4:\"file\";s:14:\"2023/01/ww.jpg\";s:8:\"filesize\";i:160138;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"ww-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12141;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"ww-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:85807;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"ww-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6475;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"ww-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54596;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"ww-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:71812;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"ww-1200x650.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:113804;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"ww-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11736;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"ww-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2353;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"ww-400x225.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19581;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"ww-700x394.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47870;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"ww-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19148;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1262", "321", "_wp_attached_file", "2023/01/The-100-Season-8-1.jpeg");
INSERT INTO `wp_postmeta` VALUES("1263", "321", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:675;s:4:\"file\";s:31:\"2023/01/The-100-Season-8-1.jpeg\";s:8:\"filesize\";i:119588;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"The-100-Season-8-1-300x169.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11745;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"The-100-Season-8-1-1024x576.jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:86074;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"The-100-Season-8-1-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7010;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:31:\"The-100-Season-8-1-768x432.jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54015;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:31:\"The-100-Season-8-1-850x565.jpeg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:76514;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:32:\"The-100-Season-8-1-1200x650.jpeg\";s:5:\"width\";i:1200;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:116918;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:31:\"The-100-Season-8-1-220x220.jpeg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12688;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:29:\"The-100-Season-8-1-80x80.jpeg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2486;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:31:\"The-100-Season-8-1-400x225.jpeg\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19001;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:31:\"The-100-Season-8-1-700x394.jpeg\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:46994;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:31:\"The-100-Season-8-1-300x300.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20801;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1264", "322", "_wp_attached_file", "2023/01/finch_2021_photo_9.jpg");
INSERT INTO `wp_postmeta` VALUES("1265", "322", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:4:\"file\";s:30:\"2023/01/finch_2021_photo_9.jpg\";s:8:\"filesize\";i:247938;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"finch_2021_photo_9-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11888;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"finch_2021_photo_9-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:89758;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"finch_2021_photo_9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6341;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"finch_2021_photo_9-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:55613;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:31:\"finch_2021_photo_9-1536x864.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:173706;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:30:\"finch_2021_photo_9-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:75518;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:31:\"finch_2021_photo_9-1290x650.jpg\";s:5:\"width\";i:1290;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:118937;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:30:\"finch_2021_photo_9-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11565;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:28:\"finch_2021_photo_9-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2309;}s:12:\"single-image\";a:5:{s:4:\"file\";s:31:\"finch_2021_photo_9-1200x675.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:118065;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:30:\"finch_2021_photo_9-400x225.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18887;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:30:\"finch_2021_photo_9-700x394.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:48541;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:30:\"finch_2021_photo_9-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19358;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1266", "507", "_wp_attached_file", "2023/01/ads.png");
INSERT INTO `wp_postmeta` VALUES("1267", "507", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:778;s:6:\"height\";i:90;s:4:\"file\";s:15:\"2023/01/ads.png\";s:8:\"filesize\";i:55118;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"ads-300x35.png\";s:5:\"width\";i:300;s:6:\"height\";i:35;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:11648;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"ads-150x90.png\";s:5:\"width\";i:150;s:6:\"height\";i:90;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10046;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"ads-768x89.png\";s:5:\"width\";i:768;s:6:\"height\";i:89;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:56136;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"ads-220x90.png\";s:5:\"width\";i:220;s:6:\"height\";i:90;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:15222;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:13:\"ads-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4290;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"ads-400x46.png\";s:5:\"width\";i:400;s:6:\"height\";i:46;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:18349;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"ads-700x81.png\";s:5:\"width\";i:700;s:6:\"height\";i:81;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:48509;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"ads-300x90.png\";s:5:\"width\";i:300;s:6:\"height\";i:90;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:21113;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1268", "510", "_wp_attached_file", "2023/01/single-pic1.png");
INSERT INTO `wp_postmeta` VALUES("1269", "510", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:350;s:6:\"height\";i:250;s:4:\"file\";s:23:\"2023/01/single-pic1.png\";s:8:\"filesize\";i:144512;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:23:\"single-pic1-300x214.png\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:99527;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:23:\"single-pic1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:33416;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:23:\"single-pic1-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:67094;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:21:\"single-pic1-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10338;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:23:\"single-pic1-300x250.png\";s:5:\"width\";i:300;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:110548;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1270", "585", "_wp_attached_file", "2023/01/1540625563-katherine-langford-min-scaled-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1271", "585", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1744;s:4:\"file\";s:54:\"2023/01/1540625563-katherine-langford-min-scaled-1.jpg\";s:8:\"filesize\";i:353446;s:5:\"sizes\";a:14:{s:6:\"medium\";a:5:{s:4:\"file\";s:54:\"1540625563-katherine-langford-min-scaled-1-300x204.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:204;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11762;}s:5:\"large\";a:5:{s:4:\"file\";s:55:\"1540625563-katherine-langford-min-scaled-1-1024x698.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:698;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:82651;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:54:\"1540625563-katherine-langford-min-scaled-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5981;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:54:\"1540625563-katherine-langford-min-scaled-1-768x523.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:523;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:51339;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:56:\"1540625563-katherine-langford-min-scaled-1-1536x1046.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1046;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:157587;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:56:\"1540625563-katherine-langford-min-scaled-1-2048x1395.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1395;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:245130;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:54:\"1540625563-katherine-langford-min-scaled-1-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58587;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:55:\"1540625563-katherine-langford-min-scaled-1-1290x650.jpg\";s:5:\"width\";i:1290;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:74426;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:54:\"1540625563-katherine-langford-min-scaled-1-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10381;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:52:\"1540625563-katherine-langford-min-scaled-1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2305;}s:12:\"single-image\";a:5:{s:4:\"file\";s:55:\"1540625563-katherine-langford-min-scaled-1-1200x818.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:818;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:106489;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:54:\"1540625563-katherine-langford-min-scaled-1-400x273.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:273;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18102;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:54:\"1540625563-katherine-langford-min-scaled-1-661x450.jpg\";s:5:\"width\";i:661;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40468;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:54:\"1540625563-katherine-langford-min-scaled-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16781;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1272", "587", "_wp_attached_file", "2023/01/image-1-for-saturday-18-dec-2010-paper-pics-gallery-213817209.jpg");
INSERT INTO `wp_postmeta` VALUES("1273", "587", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:615;s:6:\"height\";i:422;s:4:\"file\";s:73:\"2023/01/image-1-for-saturday-18-dec-2010-paper-pics-gallery-213817209.jpg\";s:8:\"filesize\";i:41768;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:73:\"image-1-for-saturday-18-dec-2010-paper-pics-gallery-213817209-300x206.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13984;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:73:\"image-1-for-saturday-18-dec-2010-paper-pics-gallery-213817209-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6325;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:73:\"image-1-for-saturday-18-dec-2010-paper-pics-gallery-213817209-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11676;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:71:\"image-1-for-saturday-18-dec-2010-paper-pics-gallery-213817209-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2340;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:73:\"image-1-for-saturday-18-dec-2010-paper-pics-gallery-213817209-400x274.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:274;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21774;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:73:\"image-1-for-saturday-18-dec-2010-paper-pics-gallery-213817209-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18676;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1274", "589", "_wp_attached_file", "2023/01/b923b1da-7f1c-4651-9d4d-dd503066ee1f.jpg");
INSERT INTO `wp_postmeta` VALUES("1275", "589", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:640;s:6:\"height\";i:370;s:4:\"file\";s:48:\"2023/01/b923b1da-7f1c-4651-9d4d-dd503066ee1f.jpg\";s:8:\"filesize\";i:85022;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:48:\"b923b1da-7f1c-4651-9d4d-dd503066ee1f-300x173.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:173;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14079;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:48:\"b923b1da-7f1c-4651-9d4d-dd503066ee1f-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7119;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:48:\"b923b1da-7f1c-4651-9d4d-dd503066ee1f-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12440;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:46:\"b923b1da-7f1c-4651-9d4d-dd503066ee1f-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2705;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:48:\"b923b1da-7f1c-4651-9d4d-dd503066ee1f-400x231.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:231;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21864;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:48:\"b923b1da-7f1c-4651-9d4d-dd503066ee1f-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19622;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1276", "593", "_wp_attached_file", "2023/01/rurouni-kenshin-kyoto-inferno-movie-still.jpg");
INSERT INTO `wp_postmeta` VALUES("1277", "593", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:670;s:6:\"height\";i:395;s:4:\"file\";s:53:\"2023/01/rurouni-kenshin-kyoto-inferno-movie-still.jpg\";s:8:\"filesize\";i:32061;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:53:\"rurouni-kenshin-kyoto-inferno-movie-still-300x177.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:177;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14826;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:53:\"rurouni-kenshin-kyoto-inferno-movie-still-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7399;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:53:\"rurouni-kenshin-kyoto-inferno-movie-still-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12816;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:51:\"rurouni-kenshin-kyoto-inferno-movie-still-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2751;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:53:\"rurouni-kenshin-kyoto-inferno-movie-still-400x236.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:236;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22129;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:53:\"rurouni-kenshin-kyoto-inferno-movie-still-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20057;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1278", "1352", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1279", "1352", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1280", "1352", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1281", "1352", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1282", "1352", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1283", "1352", "harika-meta-main-color", "#434e64");
INSERT INTO `wp_postmeta` VALUES("1284", "1352", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1285", "1352", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1286", "1352", "harika-meta-header-select", "1204");
INSERT INTO `wp_postmeta` VALUES("1287", "1352", "harika-meta-footer-select", "1328");
INSERT INTO `wp_postmeta` VALUES("1288", "1352", "harika-meta-single-select", "1509");
INSERT INTO `wp_postmeta` VALUES("1289", "1352", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("1290", "1352", "_thumbnail_id", "1401");
INSERT INTO `wp_postmeta` VALUES("1291", "1353", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1292", "1353", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1293", "1353", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1294", "1353", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1295", "1353", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1296", "1353", "harika-meta-main-color", "#434e64");
INSERT INTO `wp_postmeta` VALUES("1297", "1353", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1298", "1353", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1299", "1353", "harika-meta-header-select", "1204");
INSERT INTO `wp_postmeta` VALUES("1300", "1353", "harika-meta-footer-select", "1328");
INSERT INTO `wp_postmeta` VALUES("1301", "1353", "harika-meta-single-select", "1509");
INSERT INTO `wp_postmeta` VALUES("1302", "1353", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("1303", "1353", "_thumbnail_id", "1403");
INSERT INTO `wp_postmeta` VALUES("1304", "1355", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1305", "1355", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1306", "1355", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1307", "1355", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1308", "1355", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1309", "1355", "harika-meta-main-color", "#434e64");
INSERT INTO `wp_postmeta` VALUES("1310", "1355", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1311", "1355", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1312", "1355", "harika-meta-header-select", "1204");
INSERT INTO `wp_postmeta` VALUES("1313", "1355", "harika-meta-footer-select", "1328");
INSERT INTO `wp_postmeta` VALUES("1314", "1355", "harika-meta-single-select", "1509");
INSERT INTO `wp_postmeta` VALUES("1315", "1355", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("1316", "1355", "_thumbnail_id", "1402");
INSERT INTO `wp_postmeta` VALUES("1317", "1357", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1318", "1357", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1319", "1357", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1320", "1357", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1321", "1357", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1322", "1357", "harika-meta-main-color", "#434e64");
INSERT INTO `wp_postmeta` VALUES("1323", "1357", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1324", "1357", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1325", "1357", "harika-meta-header-select", "1204");
INSERT INTO `wp_postmeta` VALUES("1326", "1357", "harika-meta-footer-select", "1328");
INSERT INTO `wp_postmeta` VALUES("1327", "1357", "harika-meta-single-select", "1509");
INSERT INTO `wp_postmeta` VALUES("1328", "1357", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("1329", "1357", "_thumbnail_id", "1404");
INSERT INTO `wp_postmeta` VALUES("1330", "1358", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1331", "1358", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1332", "1358", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1333", "1358", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1334", "1358", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1335", "1358", "harika-meta-main-color", "#434e64");
INSERT INTO `wp_postmeta` VALUES("1336", "1358", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1337", "1358", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1338", "1358", "harika-meta-header-select", "1204");
INSERT INTO `wp_postmeta` VALUES("1339", "1358", "harika-meta-footer-select", "1328");
INSERT INTO `wp_postmeta` VALUES("1340", "1358", "harika-meta-single-select", "1509");
INSERT INTO `wp_postmeta` VALUES("1341", "1358", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("1342", "1358", "_thumbnail_id", "1405");
INSERT INTO `wp_postmeta` VALUES("1343", "1359", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1344", "1359", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1345", "1359", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1346", "1359", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1347", "1359", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1348", "1359", "harika-meta-main-color", "#434e64");
INSERT INTO `wp_postmeta` VALUES("1349", "1359", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1350", "1359", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1351", "1359", "harika-meta-header-select", "1204");
INSERT INTO `wp_postmeta` VALUES("1352", "1359", "harika-meta-footer-select", "1328");
INSERT INTO `wp_postmeta` VALUES("1353", "1359", "harika-meta-single-select", "1509");
INSERT INTO `wp_postmeta` VALUES("1354", "1359", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("1355", "1359", "_thumbnail_id", "1406");
INSERT INTO `wp_postmeta` VALUES("1356", "1360", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1357", "1360", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1358", "1360", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1359", "1360", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1360", "1360", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1361", "1360", "harika-meta-main-color", "#434e64");
INSERT INTO `wp_postmeta` VALUES("1362", "1360", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1363", "1360", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1364", "1360", "harika-meta-header-select", "1204");
INSERT INTO `wp_postmeta` VALUES("1365", "1360", "harika-meta-footer-select", "1328");
INSERT INTO `wp_postmeta` VALUES("1366", "1360", "harika-meta-single-select", "1509");
INSERT INTO `wp_postmeta` VALUES("1367", "1360", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("1368", "1360", "_thumbnail_id", "1407");
INSERT INTO `wp_postmeta` VALUES("1369", "1361", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1370", "1361", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1371", "1361", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1372", "1361", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1373", "1361", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1374", "1361", "harika-meta-main-color", "#434e64");
INSERT INTO `wp_postmeta` VALUES("1375", "1361", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1376", "1361", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1377", "1361", "harika-meta-header-select", "1204");
INSERT INTO `wp_postmeta` VALUES("1378", "1361", "harika-meta-footer-select", "1328");
INSERT INTO `wp_postmeta` VALUES("1379", "1361", "harika-meta-single-select", "1509");
INSERT INTO `wp_postmeta` VALUES("1380", "1361", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("1381", "1361", "_thumbnail_id", "1408");
INSERT INTO `wp_postmeta` VALUES("1382", "1362", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1383", "1362", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1384", "1362", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1385", "1362", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1386", "1362", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1387", "1362", "harika-meta-main-color", "#434e64");
INSERT INTO `wp_postmeta` VALUES("1388", "1362", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1389", "1362", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1390", "1362", "harika-meta-header-select", "1204");
INSERT INTO `wp_postmeta` VALUES("1391", "1362", "harika-meta-footer-select", "1328");
INSERT INTO `wp_postmeta` VALUES("1392", "1362", "harika-meta-single-select", "1509");
INSERT INTO `wp_postmeta` VALUES("1393", "1362", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("1394", "1362", "_thumbnail_id", "1409");
INSERT INTO `wp_postmeta` VALUES("1395", "1363", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1396", "1363", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1397", "1363", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1398", "1363", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1399", "1363", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1400", "1363", "harika-meta-main-color", "#434e64");
INSERT INTO `wp_postmeta` VALUES("1401", "1363", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1402", "1363", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1403", "1363", "harika-meta-header-select", "1204");
INSERT INTO `wp_postmeta` VALUES("1404", "1363", "harika-meta-footer-select", "1328");
INSERT INTO `wp_postmeta` VALUES("1405", "1363", "harika-meta-single-select", "1509");
INSERT INTO `wp_postmeta` VALUES("1406", "1363", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("1407", "1363", "_thumbnail_id", "1410");
INSERT INTO `wp_postmeta` VALUES("1408", "1364", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1409", "1364", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1410", "1364", "harika-meta-direct-video", "");
INSERT INTO `wp_postmeta` VALUES("1411", "1364", "harika-meta-aparat-video", "");
INSERT INTO `wp_postmeta` VALUES("1412", "1364", "harika-meta-direct-audio", "");
INSERT INTO `wp_postmeta` VALUES("1413", "1364", "harika-meta-main-color", "#434e64");
INSERT INTO `wp_postmeta` VALUES("1414", "1364", "harika-meta-second-color", "");
INSERT INTO `wp_postmeta` VALUES("1415", "1364", "harika-meta-background-color", "");
INSERT INTO `wp_postmeta` VALUES("1416", "1364", "harika-meta-header-select", "1204");
INSERT INTO `wp_postmeta` VALUES("1417", "1364", "harika-meta-footer-select", "1328");
INSERT INTO `wp_postmeta` VALUES("1418", "1364", "harika-meta-single-select", "1509");
INSERT INTO `wp_postmeta` VALUES("1419", "1364", "harika-meta-swtl-select", "0");
INSERT INTO `wp_postmeta` VALUES("1420", "1364", "_thumbnail_id", "1411");
INSERT INTO `wp_postmeta` VALUES("1421", "1364", "_wp_old_date", "2023-01-24");
INSERT INTO `wp_postmeta` VALUES("1422", "511", "_wp_attached_file", "2023/01/single-pic2.png");
INSERT INTO `wp_postmeta` VALUES("1423", "511", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:350;s:6:\"height\";i:250;s:4:\"file\";s:23:\"2023/01/single-pic2.png\";s:8:\"filesize\";i:86231;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:23:\"single-pic2-300x214.png\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:60455;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:23:\"single-pic2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:21114;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:23:\"single-pic2-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:40134;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:21:\"single-pic2-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7276;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:23:\"single-pic2-300x250.png\";s:5:\"width\";i:300;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:64417;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1424", "539", "_wp_attached_file", "2023/01/westworld-s1e3-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1425", "539", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:980;s:6:\"height\";i:653;s:4:\"file\";s:28:\"2023/01/westworld-s1e3-1.jpg\";s:8:\"filesize\";i:107897;s:5:\"sizes\";a:10:{s:6:\"medium\";a:5:{s:4:\"file\";s:28:\"westworld-s1e3-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16033;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:28:\"westworld-s1e3-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7694;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:28:\"westworld-s1e3-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:79329;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:28:\"westworld-s1e3-1-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:93675;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:28:\"westworld-s1e3-1-980x650.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:127384;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:28:\"westworld-s1e3-1-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14326;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:26:\"westworld-s1e3-1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2619;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:28:\"westworld-s1e3-1-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26476;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:28:\"westworld-s1e3-1-675x450.jpg\";s:5:\"width\";i:675;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:64808;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:28:\"westworld-s1e3-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24512;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1426", "550", "_wp_attached_file", "2023/01/Wednesday.webp");
INSERT INTO `wp_postmeta` VALUES("1427", "550", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:800;s:6:\"height\";i:533;s:4:\"file\";s:22:\"2023/01/Wednesday.webp\";s:8:\"filesize\";i:103634;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"Wednesday-300x200.webp\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:18136;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"Wednesday-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7896;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:22:\"Wednesday-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:64830;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:22:\"Wednesday-220x220.webp\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:13668;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:20:\"Wednesday-80x80.webp\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:2830;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:22:\"Wednesday-400x267.webp\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:28418;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:22:\"Wednesday-675x450.webp\";s:5:\"width\";i:675;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:56052;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:22:\"Wednesday-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:21868;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1428", "575", "_wp_attached_file", "2023/01/selena.webp");
INSERT INTO `wp_postmeta` VALUES("1429", "575", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:720;s:6:\"height\";i:404;s:4:\"file\";s:19:\"2023/01/selena.webp\";s:8:\"filesize\";i:20472;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"selena-300x168.webp\";s:5:\"width\";i:300;s:6:\"height\";i:168;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7974;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"selena-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:3684;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:19:\"selena-220x220.webp\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:5898;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:17:\"selena-80x80.webp\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:1534;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:19:\"selena-400x224.webp\";s:5:\"width\";i:400;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:11906;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:19:\"selena-700x393.webp\";s:5:\"width\";i:700;s:6:\"height\";i:393;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:24994;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:19:\"selena-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:8864;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1430", "579", "_wp_attached_file", "2023/01/gelsin-hayat-bildigi-gibi-canli-izle-show-tv-gelsin-hayat-bildigi-gibi-yeni-bolum-izle-222.jpg");
INSERT INTO `wp_postmeta` VALUES("1431", "579", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1500;s:6:\"height\";i:775;s:4:\"file\";s:102:\"2023/01/gelsin-hayat-bildigi-gibi-canli-izle-show-tv-gelsin-hayat-bildigi-gibi-yeni-bolum-izle-222.jpg\";s:8:\"filesize\";i:362602;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:102:\"gelsin-hayat-bildigi-gibi-canli-izle-show-tv-gelsin-hayat-bildigi-gibi-yeni-bolum-izle-222-300x155.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:155;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18136;}s:5:\"large\";a:5:{s:4:\"file\";s:103:\"gelsin-hayat-bildigi-gibi-canli-izle-show-tv-gelsin-hayat-bildigi-gibi-yeni-bolum-izle-222-1024x529.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:529;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:147869;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:102:\"gelsin-hayat-bildigi-gibi-canli-izle-show-tv-gelsin-hayat-bildigi-gibi-yeni-bolum-izle-222-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9475;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:102:\"gelsin-hayat-bildigi-gibi-canli-izle-show-tv-gelsin-hayat-bildigi-gibi-yeni-bolum-izle-222-768x397.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:397;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:90594;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:102:\"gelsin-hayat-bildigi-gibi-canli-izle-show-tv-gelsin-hayat-bildigi-gibi-yeni-bolum-izle-222-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:127327;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:103:\"gelsin-hayat-bildigi-gibi-canli-izle-show-tv-gelsin-hayat-bildigi-gibi-yeni-bolum-izle-222-1290x650.jpg\";s:5:\"width\";i:1290;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:209064;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:102:\"gelsin-hayat-bildigi-gibi-canli-izle-show-tv-gelsin-hayat-bildigi-gibi-yeni-bolum-izle-222-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17237;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:100:\"gelsin-hayat-bildigi-gibi-canli-izle-show-tv-gelsin-hayat-bildigi-gibi-yeni-bolum-izle-222-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3184;}s:12:\"single-image\";a:5:{s:4:\"file\";s:103:\"gelsin-hayat-bildigi-gibi-canli-izle-show-tv-gelsin-hayat-bildigi-gibi-yeni-bolum-izle-222-1200x620.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:620;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:190270;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:102:\"gelsin-hayat-bildigi-gibi-canli-izle-show-tv-gelsin-hayat-bildigi-gibi-yeni-bolum-izle-222-400x207.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:207;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28898;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:102:\"gelsin-hayat-bildigi-gibi-canli-izle-show-tv-gelsin-hayat-bildigi-gibi-yeni-bolum-izle-222-700x362.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:362;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:77958;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:102:\"gelsin-hayat-bildigi-gibi-canli-izle-show-tv-gelsin-hayat-bildigi-gibi-yeni-bolum-izle-222-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29390;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1432", "582", "_wp_attached_file", "2023/01/Riverdale-Cast-Cole-Sprouse.jpg");
INSERT INTO `wp_postmeta` VALUES("1433", "582", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1024;s:6:\"height\";i:699;s:4:\"file\";s:39:\"2023/01/Riverdale-Cast-Cole-Sprouse.jpg\";s:8:\"filesize\";i:157620;s:5:\"sizes\";a:10:{s:6:\"medium\";a:5:{s:4:\"file\";s:39:\"Riverdale-Cast-Cole-Sprouse-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18236;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:39:\"Riverdale-Cast-Cole-Sprouse-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8365;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:39:\"Riverdale-Cast-Cole-Sprouse-768x524.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:524;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:80127;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:39:\"Riverdale-Cast-Cole-Sprouse-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:92648;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:40:\"Riverdale-Cast-Cole-Sprouse-1024x650.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:123919;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:39:\"Riverdale-Cast-Cole-Sprouse-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15007;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:37:\"Riverdale-Cast-Cole-Sprouse-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2941;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:39:\"Riverdale-Cast-Cole-Sprouse-400x273.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:273;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28833;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:39:\"Riverdale-Cast-Cole-Sprouse-659x450.jpg\";s:5:\"width\";i:659;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:63620;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:39:\"Riverdale-Cast-Cole-Sprouse-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24438;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"5.6\";s:6:\"credit\";s:32:\"NBCU Photo Bank/NBCUniversal via\";s:6:\"camera\";s:21:\"Canon EOS 5D Mark III\";s:7:\"caption\";s:299:\"THE TONIGHT SHOW STARRING JIMMY FALLON -- Episode 0750 -- Pictured: (l-r) The Cast of \"Riverdale\" Cole Sprouse, Madelaine Petsch, Camila Mendes, Lili Reinhart, KJ Apa during an interview on October 3, 2017 -- (Photo by: Andrew Lipovsky/NBCU Photo Bank/NBCUniversal via Getty Images via Getty Images)\";s:17:\"created_timestamp\";s:0:\"\";s:9:\"copyright\";s:28:\"2017 NBCUniversal Media, LLC\";s:12:\"focal_length\";s:2:\"70\";s:3:\"iso\";s:4:\"6400\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:49:\"The Tonight Show Starring Jimmy Fallon - Season 5\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:1:{i:0;s:64:\"2010\'s,2016-2017,Color Image,Episodic,Indoor,Talk Show,Late Nigh\";}}}");
INSERT INTO `wp_postmeta` VALUES("1434", "776", "_wp_attached_file", "2023/01/13.png");
INSERT INTO `wp_postmeta` VALUES("1435", "776", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:14:\"2023/01/13.png\";s:8:\"filesize\";i:469193;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"13-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:35381;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"13-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:321245;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"13-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:18618;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"13-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:191142;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"13-850x565.png\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:267963;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"13-1280x650.png\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:434494;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"13-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:35156;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"13-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7083;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"13-1200x675.png\";s:5:\"width\";i:1200;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:438492;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"13-400x225.png\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:58711;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"13-700x394.png\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:162272;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"13-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:57989;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1436", "777", "_wp_attached_file", "2023/01/14.png");
INSERT INTO `wp_postmeta` VALUES("1437", "777", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:14:\"2023/01/14.png\";s:8:\"filesize\";i:249087;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"14-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:35188;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"14-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:202708;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"14-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:19757;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"14-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:135377;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"14-850x565.png\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:181016;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"14-1280x650.png\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:234268;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"14-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:35104;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"14-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7504;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"14-1200x675.png\";s:5:\"width\";i:1200;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:251670;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"14-400x225.png\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:53826;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"14-700x394.png\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:119407;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"14-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:54884;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1438", "778", "_wp_attached_file", "2023/01/15.png");
INSERT INTO `wp_postmeta` VALUES("1439", "778", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:14:\"2023/01/15.png\";s:8:\"filesize\";i:425900;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"15-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:28680;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"15-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:273323;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"15-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:16449;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"15-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:162032;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"15-850x565.png\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:227666;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"15-1280x650.png\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:390231;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"15-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:30889;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"15-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6079;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"15-1200x675.png\";s:5:\"width\";i:1200;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:369723;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"15-400x225.png\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:48452;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"15-700x394.png\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:136177;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"15-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:52349;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1440", "779", "_wp_attached_file", "2023/01/16.png");
INSERT INTO `wp_postmeta` VALUES("1441", "779", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:14:\"2023/01/16.png\";s:8:\"filesize\";i:409200;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"16-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:29460;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"16-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:260189;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"16-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14618;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"16-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:152479;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"16-850x565.png\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:207650;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"16-1280x650.png\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:366631;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"16-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:25432;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"16-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5921;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"16-1200x675.png\";s:5:\"width\";i:1200;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:360666;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"16-400x225.png\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:47891;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"16-700x394.png\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:129094;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"16-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:40915;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1442", "780", "_wp_attached_file", "2023/01/17.png");
INSERT INTO `wp_postmeta` VALUES("1443", "780", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:14:\"2023/01/17.png\";s:8:\"filesize\";i:423787;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"17-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:21664;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"17-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:261974;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"17-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12011;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"17-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:141491;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"17-850x565.png\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:218279;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"17-1280x650.png\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:379697;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"17-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:22394;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"17-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4855;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"17-1200x675.png\";s:5:\"width\";i:1200;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:373959;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"17-400x225.png\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:36902;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"17-700x394.png\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:116772;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"17-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:38520;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1444", "781", "_wp_attached_file", "2023/01/18.png");
INSERT INTO `wp_postmeta` VALUES("1445", "781", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1024;s:6:\"height\";i:576;s:4:\"file\";s:14:\"2023/01/18.png\";s:8:\"filesize\";i:66550;s:5:\"sizes\";a:9:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"18-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:26518;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"18-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:16022;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"18-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:126448;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"18-850x565.png\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:175433;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"18-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:29284;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"18-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6509;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"18-400x225.png\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:42219;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"18-700x394.png\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:111511;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"18-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:48386;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1446", "782", "_wp_attached_file", "2023/01/19.png");
INSERT INTO `wp_postmeta` VALUES("1447", "782", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:14:\"2023/01/19.png\";s:8:\"filesize\";i:648099;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"19-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:41470;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"19-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:402052;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"19-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:19888;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"19-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:236698;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"19-850x565.png\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:340357;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"19-1280x650.png\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:597885;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"19-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:39533;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"19-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7196;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"19-1200x675.png\";s:5:\"width\";i:1200;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:542835;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"19-400x225.png\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:69820;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"19-700x394.png\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:198214;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"19-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:70002;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1448", "783", "_wp_attached_file", "2023/01/20.png");
INSERT INTO `wp_postmeta` VALUES("1449", "783", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:14:\"2023/01/20.png\";s:8:\"filesize\";i:338560;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"20-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:30436;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"20-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:266543;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"20-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12855;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"20-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:164397;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"20-850x565.png\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:214674;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"20-1280x650.png\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:303035;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"20-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:24909;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"20-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5147;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"20-1200x675.png\";s:5:\"width\";i:1200;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:335531;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"20-400x225.png\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:50406;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"20-700x394.png\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:139593;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"20-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:41800;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1450", "784", "_wp_attached_file", "2023/01/21.png");
INSERT INTO `wp_postmeta` VALUES("1451", "784", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:14:\"2023/01/21.png\";s:8:\"filesize\";i:464639;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"21-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:27449;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"21-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:283018;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"21-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:15742;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"21-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:160422;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"21-850x565.png\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:240614;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"21-1280x650.png\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:420261;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"21-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:28512;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"21-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6504;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"21-1200x675.png\";s:5:\"width\";i:1200;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:394809;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"21-400x225.png\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:45291;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"21-700x394.png\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:133067;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"21-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:48099;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1452", "785", "_wp_attached_file", "2023/01/22.png");
INSERT INTO `wp_postmeta` VALUES("1453", "785", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:14:\"2023/01/22.png\";s:8:\"filesize\";i:152197;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"22-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:33820;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"22-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:331012;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"22-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:19604;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"22-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:189508;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"22-850x565.png\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:284474;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"22-1280x650.png\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:140067;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"22-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:35649;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"22-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8064;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"22-1200x675.png\";s:5:\"width\";i:1200;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:452619;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"22-400x225.png\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:54878;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"22-700x394.png\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:158066;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"22-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:58788;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1454", "786", "_wp_attached_file", "2023/01/23.png");
INSERT INTO `wp_postmeta` VALUES("1455", "786", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:14:\"2023/01/23.png\";s:8:\"filesize\";i:524657;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"23-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:33308;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"23-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:323078;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"23-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:16236;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"23-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:186388;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"23-850x565.png\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:269173;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"23-1280x650.png\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:469649;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"23-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:30340;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"23-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6101;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"23-1200x675.png\";s:5:\"width\";i:1200;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:444721;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"23-400x225.png\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:54648;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"23-700x394.png\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:155194;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"23-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:51701;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1456", "787", "_wp_attached_file", "2023/01/24.png");
INSERT INTO `wp_postmeta` VALUES("1457", "787", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:14:\"2023/01/24.png\";s:8:\"filesize\";i:265374;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"24-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:45659;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"24-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:560508;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"24-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:21326;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"24-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:308439;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"24-850x565.png\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:462071;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"24-1280x650.png\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:245528;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"24-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:43254;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"24-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7680;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"24-1200x675.png\";s:5:\"width\";i:1200;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:777402;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"24-400x225.png\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:79922;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"24-700x394.png\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:249913;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"24-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:78571;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1458", "788", "_wp_attached_file", "2023/01/25.png");
INSERT INTO `wp_postmeta` VALUES("1459", "788", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:14:\"2023/01/25.png\";s:8:\"filesize\";i:179458;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"25-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:28944;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"25-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:410362;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"25-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8939;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"25-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:236809;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"25-850x565.png\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:341353;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"25-1280x650.png\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:160438;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"25-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:19888;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"25-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3150;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"25-1200x675.png\";s:5:\"width\";i:1200;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:580274;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"25-400x225.png\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:54434;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"25-700x394.png\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:197327;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"25-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:38333;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1460", "789", "_wp_attached_file", "2023/01/26.png");
INSERT INTO `wp_postmeta` VALUES("1461", "789", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:14:\"2023/01/26.png\";s:8:\"filesize\";i:825737;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"26-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:62414;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"26-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:536761;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"26-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:33119;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"26-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:320723;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"26-850x565.png\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:463907;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"26-1280x650.png\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:776441;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"26-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:62979;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"26-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:11662;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"26-1200x675.png\";s:5:\"width\";i:1200;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:717544;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"26-400x225.png\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:101496;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"26-700x394.png\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:271683;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"26-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:106932;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1462", "790", "_wp_attached_file", "2023/01/27.png");
INSERT INTO `wp_postmeta` VALUES("1463", "790", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:14:\"2023/01/27.png\";s:8:\"filesize\";i:442796;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"27-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:25394;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"27-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:268186;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"27-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12340;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"27-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:153126;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"27-850x565.png\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:217404;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"27-1280x650.png\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:389611;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"27-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:22612;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"27-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5096;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"27-1200x675.png\";s:5:\"width\";i:1200;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:374567;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"27-400x225.png\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:42357;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"27-700x394.png\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:126759;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"27-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:38299;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1464", "964", "_wp_attached_file", "2023/01/28.webp");
INSERT INTO `wp_postmeta` VALUES("1465", "964", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1240;s:6:\"height\";i:620;s:4:\"file\";s:15:\"2023/01/28.webp\";s:8:\"filesize\";i:139250;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"28-300x150.webp\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:14034;}s:5:\"large\";a:5:{s:4:\"file\";s:16:\"28-1024x512.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:72252;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"28-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:8018;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:15:\"28-768x384.webp\";s:5:\"width\";i:768;s:6:\"height\";i:384;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:50066;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:15:\"28-850x565.webp\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:65838;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:15:\"28-220x220.webp\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:13586;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:13:\"28-80x80.webp\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:2950;}s:12:\"single-image\";a:5:{s:4:\"file\";s:16:\"28-1200x600.webp\";s:5:\"width\";i:1200;s:6:\"height\";i:600;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:85730;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:15:\"28-400x200.webp\";s:5:\"width\";i:400;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:20908;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:15:\"28-700x350.webp\";s:5:\"width\";i:700;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:44828;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:15:\"28-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:21004;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1466", "965", "_wp_attached_file", "2023/01/29.webp");
INSERT INTO `wp_postmeta` VALUES("1467", "965", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:720;s:6:\"height\";i:405;s:4:\"file\";s:15:\"2023/01/29.webp\";s:8:\"filesize\";i:28560;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"29-300x169.webp\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:11690;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"29-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:5544;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:15:\"29-220x220.webp\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:8898;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:13:\"29-80x80.webp\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:2292;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:15:\"29-400x225.webp\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:16684;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:15:\"29-700x394.webp\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:31656;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:15:\"29-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:12810;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1468", "966", "_wp_attached_file", "2023/01/30.webp");
INSERT INTO `wp_postmeta` VALUES("1469", "966", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:896;s:6:\"height\";i:500;s:4:\"file\";s:15:\"2023/01/30.webp\";s:8:\"filesize\";i:43400;s:5:\"sizes\";a:9:{s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"30-300x167.webp\";s:5:\"width\";i:300;s:6:\"height\";i:167;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:11932;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"30-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:6084;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:15:\"30-768x429.webp\";s:5:\"width\";i:768;s:6:\"height\";i:429;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:40202;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:15:\"30-850x500.webp\";s:5:\"width\";i:850;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:51262;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:15:\"30-220x220.webp\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:10234;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:13:\"30-80x80.webp\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:2444;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:15:\"30-400x223.webp\";s:5:\"width\";i:400;s:6:\"height\";i:223;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:17906;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:15:\"30-700x391.webp\";s:5:\"width\";i:700;s:6:\"height\";i:391;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:36828;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:15:\"30-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:15340;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1470", "967", "_wp_attached_file", "2023/01/31.webp");
INSERT INTO `wp_postmeta` VALUES("1471", "967", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:668;s:6:\"height\";i:376;s:4:\"file\";s:15:\"2023/01/31.webp\";s:8:\"filesize\";i:386388;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"31-300x169.webp\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:22644;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"31-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:12046;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:15:\"31-220x220.webp\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:22762;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:13:\"31-80x80.webp\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:3904;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:15:\"31-400x225.webp\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:36204;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:15:\"31-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:36990;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1472", "968", "_wp_attached_file", "2023/01/32.webp");
INSERT INTO `wp_postmeta` VALUES("1473", "968", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:720;s:6:\"height\";i:405;s:4:\"file\";s:15:\"2023/01/32.webp\";s:8:\"filesize\";i:53650;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"32-300x169.webp\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:14522;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"32-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7954;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:15:\"32-220x220.webp\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:14270;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:13:\"32-80x80.webp\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:2746;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:15:\"32-400x225.webp\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:23078;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:15:\"32-700x394.webp\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:54282;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:15:\"32-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:22798;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1474", "969", "_wp_attached_file", "2023/01/33.webp");
INSERT INTO `wp_postmeta` VALUES("1475", "969", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:896;s:6:\"height\";i:500;s:4:\"file\";s:15:\"2023/01/33.webp\";s:8:\"filesize\";i:67512;s:5:\"sizes\";a:9:{s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"33-300x167.webp\";s:5:\"width\";i:300;s:6:\"height\";i:167;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:12642;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"33-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:5768;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:15:\"33-768x429.webp\";s:5:\"width\";i:768;s:6:\"height\";i:429;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:54758;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:15:\"33-850x500.webp\";s:5:\"width\";i:850;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:81886;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:15:\"33-220x220.webp\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:10208;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:13:\"33-80x80.webp\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:2214;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:15:\"33-400x223.webp\";s:5:\"width\";i:400;s:6:\"height\";i:223;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:19622;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:15:\"33-700x391.webp\";s:5:\"width\";i:700;s:6:\"height\";i:391;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:47514;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:15:\"33-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:16650;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1476", "970", "_wp_attached_file", "2023/01/34.jpg");
INSERT INTO `wp_postmeta` VALUES("1477", "970", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1240;s:6:\"height\";i:827;s:4:\"file\";s:14:\"2023/01/34.jpg\";s:8:\"filesize\";i:51195;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"34-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11075;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"34-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:76761;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"34-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5255;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"34-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:48665;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"34-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:57261;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"34-1240x650.jpg\";s:5:\"width\";i:1240;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:59393;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"34-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9388;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"34-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2090;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"34-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:97018;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"34-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17319;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"34-675x450.jpg\";s:5:\"width\";i:675;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39978;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"34-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15152;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1478", "971", "_wp_attached_file", "2023/01/35.webp");
INSERT INTO `wp_postmeta` VALUES("1479", "971", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1240;s:6:\"height\";i:827;s:4:\"file\";s:15:\"2023/01/35.webp\";s:8:\"filesize\";i:313548;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"35-300x200.webp\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:20554;}s:5:\"large\";a:5:{s:4:\"file\";s:16:\"35-1024x683.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:156848;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"35-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:8376;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:15:\"35-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:102026;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:15:\"35-850x565.webp\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:121872;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:16:\"35-1240x650.webp\";s:5:\"width\";i:1240;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:197254;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:15:\"35-220x220.webp\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:16314;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:13:\"35-80x80.webp\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:2618;}s:12:\"single-image\";a:5:{s:4:\"file\";s:16:\"35-1200x800.webp\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:194922;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:15:\"35-400x267.webp\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:34378;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:15:\"35-675x450.webp\";s:5:\"width\";i:675;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:84330;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:15:\"35-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:28210;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1480", "975", "_wp_attached_file", "2023/01/36.webp");
INSERT INTO `wp_postmeta` VALUES("1481", "975", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1240;s:6:\"height\";i:827;s:4:\"file\";s:15:\"2023/01/36.webp\";s:8:\"filesize\";i:68102;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"36-300x200.webp\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:8600;}s:5:\"large\";a:5:{s:4:\"file\";s:16:\"36-1024x683.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:39298;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"36-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:4616;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:15:\"36-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:27224;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:15:\"36-850x565.webp\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:30964;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:16:\"36-1240x650.webp\";s:5:\"width\";i:1240;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:45162;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:15:\"36-220x220.webp\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7268;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:13:\"36-80x80.webp\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:2014;}s:12:\"single-image\";a:5:{s:4:\"file\";s:16:\"36-1200x800.webp\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:48574;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:15:\"36-400x267.webp\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:12082;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:15:\"36-675x450.webp\";s:5:\"width\";i:675;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:23588;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:15:\"36-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:11004;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1482", "976", "_wp_attached_file", "2023/01/37.webp");
INSERT INTO `wp_postmeta` VALUES("1483", "976", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1240;s:6:\"height\";i:620;s:4:\"file\";s:15:\"2023/01/37.webp\";s:8:\"filesize\";i:157586;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"37-300x150.webp\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:11250;}s:5:\"large\";a:5:{s:4:\"file\";s:16:\"37-1024x512.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:75436;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"37-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:6194;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:15:\"37-768x384.webp\";s:5:\"width\";i:768;s:6:\"height\";i:384;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:48406;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:15:\"37-850x565.webp\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:68478;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:15:\"37-220x220.webp\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:11176;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:13:\"37-80x80.webp\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:2262;}s:12:\"single-image\";a:5:{s:4:\"file\";s:16:\"37-1200x600.webp\";s:5:\"width\";i:1200;s:6:\"height\";i:600;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:95326;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:15:\"37-400x200.webp\";s:5:\"width\";i:400;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:17702;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:15:\"37-700x350.webp\";s:5:\"width\";i:700;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:42314;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:15:\"37-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:18080;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1484", "977", "_wp_attached_file", "2023/01/38.jpg");
INSERT INTO `wp_postmeta` VALUES("1485", "977", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1024;s:6:\"height\";i:576;s:4:\"file\";s:14:\"2023/01/38.jpg\";s:8:\"filesize\";i:244783;s:5:\"sizes\";a:9:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"38-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14200;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"38-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6883;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"38-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:75449;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"38-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:103607;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"38-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13103;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"38-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2423;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"38-400x225.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23591;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"38-700x394.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:63983;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"38-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22701;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1486", "980", "_wp_attached_file", "2023/01/39.jpg");
INSERT INTO `wp_postmeta` VALUES("1487", "980", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:720;s:6:\"height\";i:405;s:4:\"file\";s:14:\"2023/01/39.jpg\";s:8:\"filesize\";i:36180;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"39-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10710;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"39-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6023;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"39-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10645;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"39-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2390;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"39-400x225.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16414;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"39-700x394.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38250;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"39-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17170;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1488", "982", "_wp_attached_file", "2023/01/40.jpg");
INSERT INTO `wp_postmeta` VALUES("1489", "982", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:564;s:4:\"file\";s:14:\"2023/01/40.jpg\";s:8:\"filesize\";i:450052;s:5:\"sizes\";a:9:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"40-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10096;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"40-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5462;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"40-768x433.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38273;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"40-850x564.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:564;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54420;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"40-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9308;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"40-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2231;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"40-400x226.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:226;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15150;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"40-700x395.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:395;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:33378;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"40-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14718;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1490", "984", "_wp_attached_file", "2023/01/41.png");
INSERT INTO `wp_postmeta` VALUES("1491", "984", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1024;s:6:\"height\";i:576;s:4:\"file\";s:14:\"2023/01/41.png\";s:8:\"filesize\";i:708967;s:5:\"sizes\";a:9:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"41-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:70256;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"41-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:31690;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"41-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:393628;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"41-850x565.png\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:531341;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"41-220x220.png\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:63314;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"41-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10689;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"41-400x225.png\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:117941;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"41-700x394.png\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:326082;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"41-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:111083;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1492", "986", "_wp_attached_file", "2023/01/42.jpg");
INSERT INTO `wp_postmeta` VALUES("1493", "986", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:14:\"2023/01/42.jpg\";s:8:\"filesize\";i:246375;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"42-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15763;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"42-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:100825;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"42-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7121;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"42-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65045;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"42-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:76473;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"42-1200x650.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:115054;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"42-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12780;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"42-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2673;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"42-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24330;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"42-675x450.jpg\";s:5:\"width\";i:675;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54406;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"42-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20644;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"4\";s:6:\"credit\";s:14:\"Jeremy Freeman\";s:6:\"camera\";s:22:\"Canon EOS-1D X Mark II\";s:7:\"caption\";s:41:\"HLN Talent On-set 2019 Robin Meade 648457\";s:17:\"created_timestamp\";s:10:\"1569320763\";s:9:\"copyright\";s:71:\"© 2019 Cable News Network. A WarnerMedia Company. All Rights Reserved.\";s:12:\"focal_length\";s:2:\"50\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:41:\"HLN Talent On-set 2019 Robin Meade 648457\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1494", "1144", "_wp_attached_file", "2023/01/43.jpg");
INSERT INTO `wp_postmeta` VALUES("1495", "1144", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:803;s:4:\"file\";s:14:\"2023/01/43.jpg\";s:8:\"filesize\";i:121911;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"43-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16850;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"43-1024x685.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:685;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:128815;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"43-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7829;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"43-768x514.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:514;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:79794;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"43-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:94507;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"43-1200x650.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:150587;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"43-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14091;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"43-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2755;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"43-400x268.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:268;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26860;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"43-672x450.jpg\";s:5:\"width\";i:672;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:63558;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"43-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23415;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1496", "1148", "_wp_attached_file", "2023/01/44.jpg");
INSERT INTO `wp_postmeta` VALUES("1497", "1148", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:675;s:4:\"file\";s:14:\"2023/01/44.jpg\";s:8:\"filesize\";i:65140;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"44-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9353;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"44-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:63638;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"44-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5416;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"44-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40382;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"44-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:55606;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"44-1200x650.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:85434;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"44-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9825;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"44-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2072;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"44-400x225.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14579;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"44-700x394.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35152;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"44-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15769;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1498", "1150", "_wp_attached_file", "2023/01/45.jpg");
INSERT INTO `wp_postmeta` VALUES("1499", "1150", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:719;s:4:\"file\";s:14:\"2023/01/45.jpg\";s:8:\"filesize\";i:96168;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"45-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8768;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"45-1024x575.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:57745;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"45-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4873;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"45-768x431.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:431;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35590;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"45-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:51940;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"45-1280x650.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:87002;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"45-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8252;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"45-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2197;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"45-1200x674.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:674;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:75156;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"45-400x225.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12667;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"45-700x393.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:393;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30522;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"45-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13542;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1500", "1152", "_wp_attached_file", "2023/01/46.jpg");
INSERT INTO `wp_postmeta` VALUES("1501", "1152", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:14:\"2023/01/46.jpg\";s:8:\"filesize\";i:84774;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"46-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7803;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"46-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:41993;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"46-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4964;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"46-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28439;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"46-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39874;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"46-1280x650.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:57395;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"46-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8096;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"46-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2043;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"46-1200x675.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54747;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"46-400x225.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11656;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"46-700x394.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24955;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"46-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12585;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1502", "1153", "_wp_attached_file", "2023/01/47.jpg");
INSERT INTO `wp_postmeta` VALUES("1503", "1153", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:719;s:4:\"file\";s:14:\"2023/01/47.jpg\";s:8:\"filesize\";i:75397;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"47-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8694;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"47-1024x575.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54000;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"47-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5904;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"47-768x431.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:431;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37241;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"47-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:50881;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"47-1280x650.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:68005;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"47-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10683;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"47-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1993;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"47-1200x674.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:674;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:66706;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"47-400x225.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13962;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"47-700x393.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:393;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31995;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"47-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17675;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1504", "1155", "_wp_attached_file", "2023/01/48.jpg");
INSERT INTO `wp_postmeta` VALUES("1505", "1155", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:14:\"2023/01/48.jpg\";s:8:\"filesize\";i:93383;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"48-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11501;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"48-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:62538;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"48-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5017;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"48-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42187;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"48-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:44145;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"48-1280x650.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:66519;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"48-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8605;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"48-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2135;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"48-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:79162;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"48-400x300.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17046;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"48-600x450.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30026;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"48-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13376;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1506", "1156", "_wp_attached_file", "2023/01/49.jpg");
INSERT INTO `wp_postmeta` VALUES("1507", "1156", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:14:\"2023/01/49.jpg\";s:8:\"filesize\";i:39132;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"49-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5598;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"49-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:32395;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"49-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3205;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"49-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21508;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"49-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25041;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"49-1200x650.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37376;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"49-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5343;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"49-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1434;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"49-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8302;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"49-675x450.jpg\";s:5:\"width\";i:675;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18155;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"49-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8045;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1508", "1157", "_wp_attached_file", "2023/01/50.jpg");
INSERT INTO `wp_postmeta` VALUES("1509", "1157", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:14:\"2023/01/50.jpg\";s:8:\"filesize\";i:81595;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"50-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10374;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"50-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:74781;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"50-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6126;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"50-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:46912;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"50-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:55794;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"50-1200x650.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:96204;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"50-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11142;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"50-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2362;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"50-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16373;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"50-675x450.jpg\";s:5:\"width\";i:675;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38332;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"50-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18412;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1510", "1158", "_wp_attached_file", "2023/01/51.jpg");
INSERT INTO `wp_postmeta` VALUES("1511", "1158", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:630;s:4:\"file\";s:14:\"2023/01/51.jpg\";s:8:\"filesize\";i:184846;s:5:\"sizes\";a:10:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"51-300x158.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:158;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18499;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"51-1024x538.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:538;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:147174;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"51-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9739;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"51-768x403.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:403;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:92199;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"51-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:125193;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"51-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17877;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"51-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3263;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"51-400x210.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31382;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"51-700x368.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:368;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:79056;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"51-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30110;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1512", "1159", "_wp_attached_file", "2023/01/52.jpg");
INSERT INTO `wp_postmeta` VALUES("1513", "1159", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:675;s:4:\"file\";s:14:\"2023/01/52.jpg\";s:8:\"filesize\";i:102075;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"52-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12347;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"52-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:68752;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"52-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6199;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"52-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:46122;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"52-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58638;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"52-1200x650.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:85505;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"52-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10640;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"52-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2512;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"52-400x225.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18586;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"52-700x394.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40964;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"52-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16185;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1514", "1160", "_wp_attached_file", "2023/01/53.jpg");
INSERT INTO `wp_postmeta` VALUES("1515", "1160", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1269;s:6:\"height\";i:838;s:4:\"file\";s:14:\"2023/01/53.jpg\";s:8:\"filesize\";i:116677;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"53-300x198.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:198;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17446;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"53-1024x676.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:676;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:102410;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"53-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8739;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"53-768x507.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:507;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:67879;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"53-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:79460;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"53-1269x650.jpg\";s:5:\"width\";i:1269;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:124581;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"53-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15090;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"53-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3305;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"53-1200x792.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:792;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:128087;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"53-400x264.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:264;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26350;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"53-681x450.jpg\";s:5:\"width\";i:681;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:57511;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"53-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23926;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1516", "1161", "_wp_attached_file", "2023/01/54.jpeg");
INSERT INTO `wp_postmeta` VALUES("1517", "1161", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:675;s:4:\"file\";s:15:\"2023/01/54.jpeg\";s:8:\"filesize\";i:106749;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"54-300x169.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8828;}s:5:\"large\";a:5:{s:4:\"file\";s:16:\"54-1024x576.jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65281;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"54-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4341;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:15:\"54-768x432.jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40064;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:15:\"54-850x565.jpeg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:55834;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:16:\"54-1200x650.jpeg\";s:5:\"width\";i:1200;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:95215;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:15:\"54-220x220.jpeg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8135;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:13:\"54-80x80.jpeg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1629;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:15:\"54-400x225.jpeg\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14048;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:15:\"54-700x394.jpeg\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34668;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:15:\"54-300x300.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13443;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1518", "1162", "_wp_attached_file", "2023/01/55.jpg");
INSERT INTO `wp_postmeta` VALUES("1519", "1162", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1600;s:6:\"height\";i:750;s:4:\"file\";s:14:\"2023/01/55.jpg\";s:8:\"filesize\";i:114727;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"55-300x141.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:141;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9110;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"55-1024x480.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:46366;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"55-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4797;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"55-768x360.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31566;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:15:\"55-1536x720.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:79146;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"55-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:43502;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"55-1290x650.jpg\";s:5:\"width\";i:1290;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:66782;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"55-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7868;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"55-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1992;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"55-1200x563.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:563;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:57644;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"55-400x188.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:188;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13402;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"55-700x328.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:328;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27881;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"55-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11767;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1520", "1163", "_wp_attached_file", "2023/01/56-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1521", "1163", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:600;s:4:\"file\";s:16:\"2023/01/56-1.jpg\";s:8:\"filesize\";i:135295;s:5:\"sizes\";a:10:{s:6:\"medium\";a:5:{s:4:\"file\";s:16:\"56-1-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11214;}s:5:\"large\";a:5:{s:4:\"file\";s:17:\"56-1-1024x512.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:67708;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:16:\"56-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6233;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:16:\"56-1-768x384.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:384;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45451;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:16:\"56-1-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:60552;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:16:\"56-1-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10797;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:14:\"56-1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2315;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:16:\"56-1-400x200.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17598;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:16:\"56-1-700x350.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40319;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:16:\"56-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17135;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1522", "1164", "_wp_attached_file", "2023/01/57.jpg");
INSERT INTO `wp_postmeta` VALUES("1523", "1164", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:675;s:4:\"file\";s:14:\"2023/01/57.jpg\";s:8:\"filesize\";i:240286;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"57-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13774;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"57-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:101016;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"57-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6844;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"57-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:63516;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"57-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:85223;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"57-1200x650.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:140105;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"57-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12722;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"57-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2502;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"57-400x225.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22427;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"57-700x394.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:394;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:55212;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"57-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20819;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1524", "1397", "_wp_attached_file", "2023/01/57-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1525", "1397", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1200;s:4:\"file\";s:16:\"2023/01/57-1.jpg\";s:8:\"filesize\";i:656175;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:16:\"57-1-300x188.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:188;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17265;}s:5:\"large\";a:5:{s:4:\"file\";s:17:\"57-1-1024x640.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:640;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:154744;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:16:\"57-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8008;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:16:\"57-1-768x480.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:93038;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:17:\"57-1-1536x960.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:960;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:312592;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:16:\"57-1-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:119634;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:17:\"57-1-1290x650.jpg\";s:5:\"width\";i:1290;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:194116;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:16:\"57-1-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15231;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:14:\"57-1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2681;}s:12:\"single-image\";a:5:{s:4:\"file\";s:17:\"57-1-1200x750.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:206431;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:16:\"57-1-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28703;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:16:\"57-1-700x438.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:438;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:78770;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:16:\"57-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26751;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1526", "1398", "_wp_attached_file", "2023/01/58.jpg");
INSERT INTO `wp_postmeta` VALUES("1527", "1398", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:14:\"2023/01/58.jpg\";s:8:\"filesize\";i:570029;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"58-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21907;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"58-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:162202;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"58-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9422;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"58-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:103332;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:16:\"58-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:296712;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"58-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:122077;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"58-1290x650.jpg\";s:5:\"width\";i:1290;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:171734;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"58-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17592;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"58-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3050;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"58-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:206892;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"58-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35925;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"58-675x450.jpg\";s:5:\"width\";i:675;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:85531;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"58-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29353;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1528", "1399", "_wp_attached_file", "2023/01/59.jpg");
INSERT INTO `wp_postmeta` VALUES("1529", "1399", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:799;s:4:\"file\";s:14:\"2023/01/59.jpg\";s:8:\"filesize\";i:237582;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"59-300x187.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:187;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20589;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"59-1024x639.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:639;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:143621;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"59-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9263;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"59-768x479.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:479;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:92737;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"59-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:112976;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"59-1280x650.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:173885;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"59-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16390;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"59-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3185;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"59-1200x749.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:749;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:183989;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"59-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:32824;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"59-700x437.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:437;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:80804;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"59-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26817;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1530", "1400", "_wp_attached_file", "2023/01/60.jpg");
INSERT INTO `wp_postmeta` VALUES("1531", "1400", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:550;s:6:\"height\";i:550;s:4:\"file\";s:14:\"2023/01/60.jpg\";s:8:\"filesize\";i:91704;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"60-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26598;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"60-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8668;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"60-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16015;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"60-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2848;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"60-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:41126;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"60-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:50865;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"60-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26598;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1532", "1401", "_wp_attached_file", "2023/01/61.jpg");
INSERT INTO `wp_postmeta` VALUES("1533", "1401", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:800;s:6:\"height\";i:614;s:4:\"file\";s:14:\"2023/01/61.jpg\";s:8:\"filesize\";i:68026;s:5:\"sizes\";a:9:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"61-300x230.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15061;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"61-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6730;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"61-768x589.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:589;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:70724;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"61-800x565.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:69920;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"61-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12427;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"61-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2418;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"61-400x307.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:307;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25374;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"61-586x450.jpg\";s:5:\"width\";i:586;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:46147;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"61-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20902;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1534", "1402", "_wp_attached_file", "2023/01/62.jpg");
INSERT INTO `wp_postmeta` VALUES("1535", "1402", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:550;s:6:\"height\";i:550;s:4:\"file\";s:14:\"2023/01/62.jpg\";s:8:\"filesize\";i:70347;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"62-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18407;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"62-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5354;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"62-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10743;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"62-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1911;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"62-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30203;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"62-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38189;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"62-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18407;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1536", "1403", "_wp_attached_file", "2023/01/63.jpg");
INSERT INTO `wp_postmeta` VALUES("1537", "1403", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1100;s:6:\"height\";i:1100;s:4:\"file\";s:14:\"2023/01/63.jpg\";s:8:\"filesize\";i:510341;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"63-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29347;}s:5:\"large\";a:5:{s:4:\"file\";s:16:\"63-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:279172;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"63-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7889;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"63-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:171525;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"63-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:137254;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"63-1100x650.jpg\";s:5:\"width\";i:1100;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:202158;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"63-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16366;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"63-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2406;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"63-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:50412;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"63-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65089;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"63-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29347;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1538", "1404", "_wp_attached_file", "2023/01/64.jpg");
INSERT INTO `wp_postmeta` VALUES("1539", "1404", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:550;s:6:\"height\";i:550;s:4:\"file\";s:14:\"2023/01/64.jpg\";s:8:\"filesize\";i:105464;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"64-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26710;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"64-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8125;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"64-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15760;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"64-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2633;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"64-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42096;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"64-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:52566;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"64-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26710;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1540", "1405", "_wp_attached_file", "2023/01/65.jpg");
INSERT INTO `wp_postmeta` VALUES("1541", "1405", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1100;s:4:\"file\";s:14:\"2023/01/65.jpg\";s:8:\"filesize\";i:240662;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"65-300x172.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:172;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14005;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"65-1024x587.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:587;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:127448;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"65-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6675;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"65-768x440.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:440;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:77054;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:15:\"65-1536x880.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:880;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:246777;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"65-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:104618;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"65-1290x650.jpg\";s:5:\"width\";i:1290;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:169016;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"65-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12945;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"65-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2286;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"65-1200x688.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:688;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:166730;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"65-400x229.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:229;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23222;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"65-700x401.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:401;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65492;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"65-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22272;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1542", "1406", "_wp_attached_file", "2023/01/66.jpg");
INSERT INTO `wp_postmeta` VALUES("1543", "1406", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:550;s:6:\"height\";i:550;s:4:\"file\";s:14:\"2023/01/66.jpg\";s:8:\"filesize\";i:93823;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"66-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24087;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"66-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7422;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"66-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14114;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"66-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2479;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"66-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37915;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"66-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47495;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"66-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24087;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1544", "1407", "_wp_attached_file", "2023/01/67.jpg");
INSERT INTO `wp_postmeta` VALUES("1545", "1407", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1100;s:6:\"height\";i:1100;s:4:\"file\";s:14:\"2023/01/67.jpg\";s:8:\"filesize\";i:98355;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"67-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23750;}s:5:\"large\";a:5:{s:4:\"file\";s:16:\"67-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:188591;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"67-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7213;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"67-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:120668;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"67-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:109035;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"67-1100x650.jpg\";s:5:\"width\";i:1100;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:147352;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"67-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13729;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"67-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2472;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"67-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39295;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"67-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:49415;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"67-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23750;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1546", "1408", "_wp_attached_file", "2023/01/68.jpg");
INSERT INTO `wp_postmeta` VALUES("1547", "1408", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1100;s:4:\"file\";s:14:\"2023/01/68.jpg\";s:8:\"filesize\";i:199668;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"68-300x172.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:172;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13797;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"68-1024x587.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:587;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:115696;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"68-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7223;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"68-768x440.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:440;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:71513;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:15:\"68-1536x880.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:880;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:218339;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"68-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:94270;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"68-1290x650.jpg\";s:5:\"width\";i:1290;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:151816;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"68-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13880;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"68-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2472;}s:12:\"single-image\";a:5:{s:4:\"file\";s:15:\"68-1200x688.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:688;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:149694;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"68-400x229.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:229;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22738;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"68-700x401.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:401;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:61318;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"68-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23555;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1548", "1409", "_wp_attached_file", "2023/01/69.jpg");
INSERT INTO `wp_postmeta` VALUES("1549", "1409", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1300;s:6:\"height\";i:1300;s:4:\"file\";s:14:\"2023/01/69.jpg\";s:8:\"filesize\";i:940061;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"69-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24617;}s:5:\"large\";a:5:{s:4:\"file\";s:16:\"69-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:166551;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"69-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7604;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"69-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:109062;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"69-850x565.jpg\";s:5:\"width\";i:850;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:85140;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:15:\"69-1290x650.jpg\";s:5:\"width\";i:1290;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:110852;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"69-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14386;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"69-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2566;}s:12:\"single-image\";a:5:{s:4:\"file\";s:16:\"69-1200x1200.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:1200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:208595;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"69-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39169;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"69-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:48696;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"69-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24617;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1550", "1410", "_wp_attached_file", "2023/01/70.jpg");
INSERT INTO `wp_postmeta` VALUES("1551", "1410", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:800;s:6:\"height\";i:1167;s:4:\"file\";s:14:\"2023/01/70.jpg\";s:8:\"filesize\";i:982038;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"70-206x300.jpg\";s:5:\"width\";i:206;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13883;}s:5:\"large\";a:5:{s:4:\"file\";s:15:\"70-702x1024.jpg\";s:5:\"width\";i:702;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:135070;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"70-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6878;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:15:\"70-768x1120.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:157804;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"70-800x565.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:140810;}s:15:\"harika_1290x650\";a:5:{s:4:\"file\";s:14:\"70-800x650.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:650;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:149292;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"70-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12369;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"70-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2342;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"70-400x584.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:584;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:48706;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"70-308x450.jpg\";s:5:\"width\";i:308;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29764;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"70-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23914;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1552", "1411", "_wp_attached_file", "2023/01/71.jpg");
INSERT INTO `wp_postmeta` VALUES("1553", "1411", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:800;s:6:\"height\";i:614;s:4:\"file\";s:14:\"2023/01/71.jpg\";s:8:\"filesize\";i:92911;s:5:\"sizes\";a:9:{s:6:\"medium\";a:5:{s:4:\"file\";s:14:\"71-300x230.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17032;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"71-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6258;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:14:\"71-768x589.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:589;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:80175;}s:14:\"harika_850x565\";a:5:{s:4:\"file\";s:14:\"71-800x565.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:565;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:85800;}s:14:\"harika_220x220\";a:5:{s:4:\"file\";s:14:\"71-220x220.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12005;}s:9:\"harika-80\";a:5:{s:4:\"file\";s:12:\"71-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2244;}s:14:\"archives-image\";a:5:{s:4:\"file\";s:14:\"71-400x307.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:307;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28899;}s:14:\"harika-700-450\";a:5:{s:4:\"file\";s:14:\"71-586x450.jpg\";s:5:\"width\";i:586;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:52904;}s:10:\"harika-300\";a:5:{s:4:\"file\";s:14:\"71-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20091;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1554", "1364", "_edit_lock", "1727188862:1");
INSERT INTO `wp_postmeta` VALUES("1565", "1414", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1566", "1414", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1567", "1414", "harika_page_meta", "a:6:{s:23:\"select_page_header_meta\";s:1:\"0\";s:23:\"select_page_footer_meta\";s:1:\"0\";s:32:\"select_page_sidebar_title_layout\";s:7:\"default\";s:23:\"primary_page_color_meta\";s:0:\"\";s:25:\"secondary_page_color_meta\";s:0:\"\";s:20:\"body_page_color_meta\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1568", "1414", "_edit_lock", "1724667883:1");
INSERT INTO `wp_postmeta` VALUES("1583", "1363", "_edit_lock", "1727188860:1");
INSERT INTO `wp_postmeta` VALUES("1586", "1363", "spc_primary_category", "-1");
INSERT INTO `wp_postmeta` VALUES("1587", "1363", "harika_post_meta", "a:7:{s:23:\"select_post_header_meta\";s:4:\"1625\";s:23:\"select_post_footer_meta\";s:4:\"1668\";s:32:\"select_post_single_template_meta\";s:4:\"1686\";s:32:\"select_post_sidebar_title_layout\";s:7:\"default\";s:23:\"primary_post_color_meta\";s:7:\"#434e64\";s:25:\"secondary_post_color_meta\";s:0:\"\";s:20:\"body_post_color_meta\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1598", "70", "_edit_lock", "1727190073:1");
INSERT INTO `wp_postmeta` VALUES("1602", "1418", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1603", "1418", "harika_tb_settings", "a:1:{s:13:\"template_type\";s:5:\"block\";}");
INSERT INTO `wp_postmeta` VALUES("1604", "1418", "_edit_lock", "1724588810:1");
INSERT INTO `wp_postmeta` VALUES("1605", "1418", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1606", "1418", "_elementor_template_type", "wp-post");
INSERT INTO `wp_postmeta` VALUES("1607", "1418", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1610", "1418", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1611", "1418", "_elementor_data", "[{\"id\":\"71df72e\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"padding\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"0\",\"bottom\":\"10\",\"left\":\"0\",\"isLinked\":false},\"css_classes\":\"sidebar-col\"},\"elements\":[{\"id\":\"c8d1fca\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u0633\\u06a9\\u0627\\u06cc\\u067e\",\"icon\":{\"value\":\"fab fa-skype\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#00AFF0\",\"main_background_background\":\"classic\",\"main_background_color\":\"#00AFF0\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-10\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"764cd5f\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u06cc\\u0646\\u0633\\u062a\\u0627\\u06af\\u0631\\u0627\\u0645\",\"icon\":{\"value\":\"fab fa-instagram\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#FF0088\",\"main_background_background\":\"classic\",\"main_background_color\":\"#FF0088\",\"main_background_color_b\":\"#6A3CCE\",\"main_background_gradient_angle\":{\"unit\":\"deg\",\"size\":206,\"sizes\":[]},\"main_background_gradient_position\":\"center left\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-10\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"d4babcd\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0641\\u06cc\\u0633 \\u0628\\u0648\\u06a9\",\"icon\":{\"value\":\"fab fa-facebook-square\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#3B5998\",\"main_background_background\":\"classic\",\"main_background_color\":\"#3B5998\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-10\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"e9eab49\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u067e\\u06cc\\u0646\\u062a\\u0631\\u0633\\u062a\",\"icon\":{\"value\":\"fab fa-pinterest\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u067e\\u06cc\\u0646 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#F0002A\",\"main_background_background\":\"classic\",\"main_background_color\":\"#F0002A\",\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"7c1c4fb\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u0622\\u062e\\u0631\\u06cc\\u0646 \\u067e\\u0633\\u062a \\u0647\\u0627\",\"post_count\":\"5\",\"sticky\":\"\"},\"section_sticky_on\":\"yes\",\"section_sticky_offset\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"wp-widget-harika_recent_post_widget\"}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1617", "1419", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1618", "1419", "_edit_lock", "1741548759:1");
INSERT INTO `wp_postmeta` VALUES("1619", "1419", "harika_tb_settings", "a:1:{s:13:\"template_type\";s:6:\"footer\";}");
INSERT INTO `wp_postmeta` VALUES("1620", "1419", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1621", "1419", "_elementor_template_type", "wp-post");
INSERT INTO `wp_postmeta` VALUES("1622", "1419", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1623", "1419", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1624", "1419", "_elementor_data", "[{\"id\":\"f083483\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_justify_content\":\"center\",\"flex_gap\":{\"column\":\"\",\"row\":\"\",\"isLinked\":true,\"unit\":\"px\",\"size\":null},\"background_background\":\"classic\",\"__globals__\":{\"background_color\":\"globals\\/colors?id=primary\"},\"content_width\":\"full\"},\"elements\":[{\"id\":\"643b85e\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"widget_title\":\"\\u0645\\u0648\\u0636\\u0648\\u0639\\u0627\\u062a \\u067e\\u0631\\u0637\\u0631\\u0641\\u062f\\u0627\\u0631\"},\"elements\":[],\"widgetType\":\"HarikaHFHotTopics\"}],\"isInner\":false},{\"id\":\"1cf5963\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#33363B\",\"section_background_dark_background\":\"classic\",\"section_background_dark_color\":\"#232328\",\"content_width\":\"full\",\"flex_align_items\":\"center\",\"padding\":{\"unit\":\"px\",\"top\":\"25\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[{\"id\":\"f100e71\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":33},\"width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"6765639\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"title\":\"\\u0634\\u0628\\u06a9\\u0647 \\u0647\\u0627\\u06cc \\u0627\\u062c\\u062a\\u0645\\u0627\\u0639\\u06cc \\u0645\\u0627\",\"align\":\"right\",\"title_color\":\"#FFFFFF\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"typography_font_weight\":\"500\",\"header_size\":\"h3\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"d99d637\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_justify_content\":\"flex-start\",\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"5\",\"row\":\"5\",\"isLinked\":true,\"unit\":\"px\",\"size\":5},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true}},\"elements\":[{\"id\":\"8e5d907\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"icon\":{\"value\":\"fab fa-pinterest-p\",\"library\":\"fa-brands\"},\"icon_width\":{\"unit\":\"px\",\"size\":34,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":34,\"sizes\":[]},\"icon_typography_typography\":\"custom\",\"icon_typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_box_background_background\":\"classic\",\"icon_box_background_color\":\"#00000000\",\"icon_box_border_border\":\"solid\",\"icon_box_border_width\":{\"unit\":\"px\",\"top\":\"2\",\"right\":\"2\",\"bottom\":\"2\",\"left\":\"2\",\"isLinked\":true},\"icon_box_border_color\":\"#3C3F44\",\"icon_box_border_radius\":{\"unit\":\"px\",\"top\":\"8\",\"right\":\"8\",\"bottom\":\"8\",\"left\":\"8\",\"isLinked\":true},\"icon_box_background_hover_background\":\"classic\",\"icon_box_background_hover_color\":\"#3C3F44\"},\"elements\":[],\"widgetType\":\"HarikaHFSimpleIcon\"},{\"id\":\"3cce768\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"icon\":{\"value\":\"fab fa-wordpress-simple\",\"library\":\"fa-brands\"},\"icon_width\":{\"unit\":\"px\",\"size\":34,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":34,\"sizes\":[]},\"icon_typography_typography\":\"custom\",\"icon_typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_box_background_background\":\"classic\",\"icon_box_background_color\":\"#00000000\",\"icon_box_border_border\":\"solid\",\"icon_box_border_width\":{\"unit\":\"px\",\"top\":\"2\",\"right\":\"2\",\"bottom\":\"2\",\"left\":\"2\",\"isLinked\":true},\"icon_box_border_color\":\"#3C3F44\",\"icon_box_border_radius\":{\"unit\":\"px\",\"top\":\"8\",\"right\":\"8\",\"bottom\":\"8\",\"left\":\"8\",\"isLinked\":true},\"icon_box_background_hover_background\":\"classic\",\"icon_box_background_hover_color\":\"#3C3F44\"},\"elements\":[],\"widgetType\":\"HarikaHFSimpleIcon\"},{\"id\":\"b2e49d4\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"icon\":{\"value\":\"fab fa-dribbble\",\"library\":\"fa-brands\"},\"icon_width\":{\"unit\":\"px\",\"size\":34,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":34,\"sizes\":[]},\"icon_typography_typography\":\"custom\",\"icon_typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_box_background_background\":\"classic\",\"icon_box_background_color\":\"#00000000\",\"icon_box_border_border\":\"solid\",\"icon_box_border_width\":{\"unit\":\"px\",\"top\":\"2\",\"right\":\"2\",\"bottom\":\"2\",\"left\":\"2\",\"isLinked\":true},\"icon_box_border_color\":\"#3C3F44\",\"icon_box_border_radius\":{\"unit\":\"px\",\"top\":\"8\",\"right\":\"8\",\"bottom\":\"8\",\"left\":\"8\",\"isLinked\":true},\"icon_box_background_hover_background\":\"classic\",\"icon_box_background_hover_color\":\"#3C3F44\"},\"elements\":[],\"widgetType\":\"HarikaHFSimpleIcon\"},{\"id\":\"02c497c\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"icon\":{\"value\":\"fab fa-whatsapp\",\"library\":\"fa-brands\"},\"icon_width\":{\"unit\":\"px\",\"size\":34,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":34,\"sizes\":[]},\"icon_typography_typography\":\"custom\",\"icon_typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_box_background_background\":\"classic\",\"icon_box_background_color\":\"#00000000\",\"icon_box_border_border\":\"solid\",\"icon_box_border_width\":{\"unit\":\"px\",\"top\":\"2\",\"right\":\"2\",\"bottom\":\"2\",\"left\":\"2\",\"isLinked\":true},\"icon_box_border_color\":\"#3C3F44\",\"icon_box_border_radius\":{\"unit\":\"px\",\"top\":\"8\",\"right\":\"8\",\"bottom\":\"8\",\"left\":\"8\",\"isLinked\":true},\"icon_box_background_hover_background\":\"classic\",\"icon_box_background_hover_color\":\"#3C3F44\"},\"elements\":[],\"widgetType\":\"HarikaHFSimpleIcon\"},{\"id\":\"740cd5e\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"icon\":{\"value\":\"fab fa-instagram\",\"library\":\"fa-brands\"},\"icon_width\":{\"unit\":\"px\",\"size\":34,\"sizes\":[]},\"icon_height\":{\"unit\":\"px\",\"size\":34,\"sizes\":[]},\"icon_typography_typography\":\"custom\",\"icon_typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"icon_box_background_background\":\"classic\",\"icon_box_background_color\":\"#00000000\",\"icon_box_border_border\":\"solid\",\"icon_box_border_width\":{\"unit\":\"px\",\"top\":\"2\",\"right\":\"2\",\"bottom\":\"2\",\"left\":\"2\",\"isLinked\":true},\"icon_box_border_color\":\"#3C3F44\",\"icon_box_border_radius\":{\"unit\":\"px\",\"top\":\"8\",\"right\":\"8\",\"bottom\":\"8\",\"left\":\"8\",\"isLinked\":true},\"icon_box_background_hover_background\":\"classic\",\"icon_box_background_hover_color\":\"#3C3F44\"},\"elements\":[],\"widgetType\":\"HarikaHFSimpleIcon\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"e810860\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":67}},\"elements\":[{\"id\":\"0ca5c52\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"title\":\"\\u0628\\u0627 \\u0645\\u0627 \\u0647\\u0645\\u0631\\u0627\\u0647 \\u0628\\u0627\\u0634\\u06cc\\u062f\",\"align\":\"right\",\"title_color\":\"#FFFFFF\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"typography_font_weight\":\"500\",\"header_size\":\"h3\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"f34c8c7\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"columns_number\":{\"unit\":\"px\",\"size\":3,\"sizes\":[]},\"columns_number_tablet\":{\"unit\":\"px\",\"size\":2,\"sizes\":[]},\"columns_number_mobile\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"HarikaHFPostsThumbs\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"2fa0e5c\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"flex_align_items\":\"center\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\"},\"background_background\":\"classic\",\"background_color\":\"#33363B\",\"section_background_dark_background\":\"classic\",\"section_background_dark_color\":\"#232328\"},\"elements\":[{\"id\":\"622abe5\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"text\":\"\\u062c\\u062f\\u0627\\u06a9\\u0646\\u0646\\u062f\\u0647\",\"color\":\"#393C41\",\"weight\":{\"unit\":\"px\",\"size\":2,\"sizes\":[]},\"gap\":{\"unit\":\"px\",\"size\":2,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"divider\"},{\"id\":\"c0a54dc\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"title\":\"1403 \\u00a9 \\u062a\\u0645\\u0627\\u0645\\u06cc \\u062d\\u0642\\u0648\\u0642 \\u0628\\u0631\\u0627\\u06cc \\u0642\\u0627\\u0644\\u0628 \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633 \\u0647\\u0627\\u0631\\u06cc\\u06a9\\u0627 \\u0645\\u062d\\u0641\\u0648\\u0638 \\u0645\\u06cc \\u0628\\u0627\\u0634\\u062f \\u0648 \\u06a9\\u067e\\u06cc \\u0628\\u0631\\u062f\\u0627\\u0631\\u06cc \\u0627\\u0632 \\u0645\\u062d\\u062a\\u0648\\u0627 \\u0645\\u062c\\u0627\\u0632 \\u0646\\u0645\\u06cc \\u0628\\u0627\\u0634\\u062f.\",\"align\":\"center\",\"title_color\":\"#ACACAC\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"500\",\"header_size\":\"p\",\"_margin\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"0\",\"bottom\":\"10\",\"left\":\"0\",\"isLinked\":false},\"typography_line_height\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1648", "1422", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1649", "1422", "harika_tb_settings", "a:1:{s:13:\"template_type\";s:11:\"post_single\";}");
INSERT INTO `wp_postmeta` VALUES("1650", "1422", "_edit_lock", "1731502840:1");
INSERT INTO `wp_postmeta` VALUES("1651", "1422", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1652", "1422", "_elementor_template_type", "wp-post");
INSERT INTO `wp_postmeta` VALUES("1653", "1422", "_elementor_version", "3.24.4");
INSERT INTO `wp_postmeta` VALUES("1654", "1422", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1655", "1422", "_elementor_data", "[{\"id\":\"0b09d6e\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"padding\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"10\",\"bottom\":\"20\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[{\"id\":\"95ec0df\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"main_title\":\"\\u0635\\u0641\\u062d\\u0647 \\u0627\\u0635\\u0644\\u06cc\",\"sep\":\" &gt; \"},\"elements\":[],\"widgetType\":\"HarikaSABreadcrumb\"}],\"isInner\":false},{\"id\":\"c9eda1e\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"flex_direction_tablet\":\"column\",\"flex_align_items_tablet\":\"center\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"64f764d\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":75},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"be94fb8\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"background_background\":\"classic\",\"background_color\":\"#FFFFFF\",\"border_radius\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"15\",\"bottom\":\"15\",\"left\":\"15\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"35\",\"right\":\"35\",\"bottom\":\"35\",\"left\":\"35\",\"isLinked\":true},\"flex_gap\":{\"column\":\"0\",\"row\":\"0\",\"isLinked\":true,\"unit\":\"px\",\"size\":0},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"25\",\"right\":\"25\",\"bottom\":\"25\",\"left\":\"25\",\"isLinked\":true},\"section_background_dark_background\":\"classic\",\"section_background_dark_color\":\"#232328\"},\"elements\":[{\"id\":\"e787211\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"10\",\"row\":\"10\",\"isLinked\":true,\"unit\":\"px\",\"size\":10},\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"25\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"6a03dca\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"title_typography_typography\":\"custom\",\"title_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"HarikaSAPostTitle\"},{\"id\":\"4c802e2\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaSACategories\"}],\"isInner\":true},{\"id\":\"c73b6b7\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"featured_type\":\"image-and-format\",\"image_size\":\"single-image\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"m_image_size\":\"medium\"},\"elements\":[],\"widgetType\":\"HarikaSAFeaturedImage\"},{\"id\":\"55acbc2\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"center\",\"flex_wrap\":\"wrap\",\"padding\":{\"unit\":\"px\",\"top\":\"25\",\"right\":\"25\",\"bottom\":\"15\",\"left\":\"25\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"25\",\"right\":\"0\",\"bottom\":\"15\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"a09da73\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"icon\":{\"value\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/Upload.svg\",\"id\":1427},\"library\":\"svg\"},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end_mobile\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_offset_y_mobile\":{\"unit\":\"px\",\"size\":-55,\"sizes\":[]},\"hide_widescreen\":\"hidden-widescreen\",\"hide_desktop\":\"hidden-desktop\",\"hide_tablet\":\"hidden-tablet\"},\"elements\":[],\"widgetType\":\"HarikaSAShare\"},{\"id\":\"08a51a0\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"author_before\":\"\\u062a\\u0648\\u0633\\u0637 : \",\"date_before\":\"\\u062a\\u0627\\u0631\\u06cc\\u062e \\u0627\\u0646\\u062a\\u0634\\u0627\\u0631 : \",\"date_icon\":{\"value\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/meta-date.svg\",\"id\":1426},\"library\":\"svg\"},\"comments_icon\":{\"value\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/meta-comments.svg\",\"id\":1428},\"library\":\"svg\"},\"views_icon\":{\"value\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/view-icon2.svg\",\"id\":2109},\"library\":\"svg\"},\"views_show\":\"yes\"},\"elements\":[],\"widgetType\":\"HarikaSAMetaData\"},{\"id\":\"6e1fde5\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"icon\":{\"value\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/Upload.svg\",\"id\":1427},\"library\":\"svg\"},\"hide_mobile\":\"hidden-mobile\"},\"elements\":[],\"widgetType\":\"HarikaSAShare\"}],\"isInner\":true},{\"id\":\"bb696c7\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"style\":\"dashed\",\"text\":\"\\u062c\\u062f\\u0627\\u06a9\\u0646\\u0646\\u062f\\u0647\",\"color\":\"#E4E6EF\",\"gap\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"divider_color_dark\":\"#666666\"},\"elements\":[],\"widgetType\":\"divider\"},{\"id\":\"72cdb51\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaSAPostContent\"}],\"isInner\":true},{\"id\":\"ddd3851\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"main_title\":\"\\u0628\\u0631\\u0686\\u0633\\u0628 \\u0647\\u0627 : \"},\"elements\":[],\"widgetType\":\"HarikaSATags\"},{\"id\":\"9ca27e1\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaSAAuthorBox\"},{\"id\":\"7a99914\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaSANextPrev\"},{\"id\":\"01a04ef\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"title\":\"\\u0645\\u0642\\u0627\\u0644\\u0627\\u062a \\u0645\\u0631\\u062a\\u0628\\u0637\"},\"elements\":[],\"widgetType\":\"HarikaHeading\"},{\"id\":\"2f04d32\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"columns_number\":3,\"excerpt_length\":12,\"columns_number_tablet\":1,\"columns_number_mobile\":1},\"elements\":[],\"widgetType\":\"HarikaSARelatedPosts\"},{\"id\":\"ba6d4f0\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaSAComments\"}],\"isInner\":true},{\"id\":\"c097369\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"px\",\"size\":320},\"flex_gap\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"sidebar-col\",\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"bb940e9\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u0686\\u06cc\\u0632\\u06cc \\u0645\\u06cc \\u06af\\u0631\\u062f\\u06cc\\u061f\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-search\"},{\"id\":\"42ca3f3\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u0633\\u06a9\\u0627\\u06cc\\u067e\",\"icon\":{\"value\":\"fab fa-skype\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#00AFF0\",\"main_background_background\":\"classic\",\"main_background_color\":\"#00AFF0\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"c45a949\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u06cc\\u0646\\u0633\\u062a\\u0627\\u06af\\u0631\\u0627\\u0645\",\"icon\":{\"value\":\"fab fa-instagram\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#FF0088\",\"main_background_background\":\"classic\",\"main_background_color\":\"#FF0088\",\"main_background_color_b\":\"#6A3CCE\",\"main_background_gradient_angle\":{\"unit\":\"deg\",\"size\":206,\"sizes\":[]},\"main_background_gradient_position\":\"center left\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"1711ad9\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0641\\u06cc\\u0633 \\u0628\\u0648\\u06a9\",\"icon\":{\"value\":\"fab fa-facebook-square\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#3B5998\",\"main_background_background\":\"classic\",\"main_background_color\":\"#3B5998\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"2d6e8f3\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u067e\\u06cc\\u0646\\u062a\\u0631\\u0633\\u062a\",\"icon\":{\"value\":\"fab fa-pinterest\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u067e\\u06cc\\u0646 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#F0002A\",\"main_background_background\":\"classic\",\"main_background_color\":\"#F0002A\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"1d29f9f\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0647\\u0627\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-categories\"},{\"id\":\"5c82cbe\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"wp-widget-recent-posts\"},{\"id\":\"ca1bb37\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u0628\\u0631\\u0686\\u0633\\u0628 \\u0647\\u0627\",\"taxonomy\":\"post_tag\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-tag_cloud\"},{\"id\":\"3f9a221\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u0622\\u062e\\u0631\\u06cc\\u0646 \\u067e\\u0633\\u062a \\u0647\\u0627\",\"post_count\":\"5\",\"sticky\":\"\"},\"section_sticky_on\":\"yes\",\"section_sticky_offset\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"wp-widget-harika_recent_post_widget\"}],\"isInner\":true}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1665", "1423", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1666", "1423", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1667", "1423", "_menu_item_object_id", "1414");
INSERT INTO `wp_postmeta` VALUES("1668", "1423", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1669", "1423", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1670", "1423", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1671", "1423", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1672", "1423", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1674", "1423", "_menu_item_menuposition", "");
INSERT INTO `wp_postmeta` VALUES("1675", "1423", "_menu_item_megamenu", "");
INSERT INTO `wp_postmeta` VALUES("1676", "1423", "_menu_item_template", "");
INSERT INTO `wp_postmeta` VALUES("1677", "1423", "_menu_item_menuwidth", "");
INSERT INTO `wp_postmeta` VALUES("1678", "1423", "_menu_item_disablet", "");
INSERT INTO `wp_postmeta` VALUES("1679", "43", "_wp_old_date", "2024-08-10");
INSERT INTO `wp_postmeta` VALUES("1681", "46", "_wp_old_date", "2024-08-10");
INSERT INTO `wp_postmeta` VALUES("1688", "1353", "_edit_lock", "1727189202:1");
INSERT INTO `wp_postmeta` VALUES("1715", "1426", "_wp_attached_file", "2024/08/meta-date.svg");
INSERT INTO `wp_postmeta` VALUES("1716", "1426", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:2874;s:5:\"width\";i:17;s:6:\"height\";i:19;}");
INSERT INTO `wp_postmeta` VALUES("1718", "1427", "_wp_attached_file", "2024/08/Upload.svg");
INSERT INTO `wp_postmeta` VALUES("1719", "1427", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:1129;s:5:\"width\";i:20;s:6:\"height\";i:22;}");
INSERT INTO `wp_postmeta` VALUES("1721", "1428", "_wp_attached_file", "2024/08/meta-comments.svg");
INSERT INTO `wp_postmeta` VALUES("1722", "1428", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:1368;s:5:\"width\";i:18;s:6:\"height\";i:18;}");
INSERT INTO `wp_postmeta` VALUES("1732", "1429", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1733", "1429", "_elementor_template_type", "page");
INSERT INTO `wp_postmeta` VALUES("1734", "1429", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1735", "1430", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1736", "1430", "_elementor_template_type", "page");
INSERT INTO `wp_postmeta` VALUES("1737", "1430", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1738", "1429", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1739", "1429", "_elementor_data", "[{\"id\":\"f19ab51\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"padding\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"10\",\"bottom\":\"20\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[{\"id\":\"7ae3e847\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"main_title\":\"\\u0635\\u0641\\u062d\\u0647 \\u0627\\u0635\\u0644\\u06cc\",\"sep\":\" &gt; \"},\"elements\":[],\"widgetType\":\"HarikaSABreadcrumb\"}],\"isInner\":false},{\"id\":\"345aa4b4\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true}},\"elements\":[{\"id\":\"45534776\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":75},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true}},\"elements\":[{\"id\":\"7e014ad0\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"background_background\":\"classic\",\"background_color\":\"#FFFFFF\",\"border_radius\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"15\",\"bottom\":\"15\",\"left\":\"15\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"35\",\"right\":\"35\",\"bottom\":\"35\",\"left\":\"35\",\"isLinked\":true},\"flex_gap\":{\"column\":\"0\",\"row\":\"0\",\"isLinked\":true,\"unit\":\"px\",\"size\":0}},\"elements\":[{\"id\":\"6e173fbb\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"10\",\"row\":\"10\",\"isLinked\":true,\"unit\":\"px\",\"size\":10},\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"25\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"4e6d9737\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaSAPostTitle\"},{\"id\":\"7994a099\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaSACategories\"}],\"isInner\":true},{\"id\":\"29c0e07e\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"featured_type\":\"image-and-format\",\"image_size\":\"single-image\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"m_image_size\":\"medium\"},\"elements\":[],\"widgetType\":\"HarikaSAFeaturedImage\"},{\"id\":\"2f79783\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"center\",\"flex_wrap\":\"wrap\",\"padding\":{\"unit\":\"px\",\"top\":\"25\",\"right\":\"25\",\"bottom\":\"15\",\"left\":\"25\",\"isLinked\":false}},\"elements\":[{\"id\":\"4c4884a9\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"author_before\":\"\\u062a\\u0648\\u0633\\u0637 : \",\"date_before\":\"\\u062a\\u0627\\u0631\\u06cc\\u062e \\u0627\\u0646\\u062a\\u0634\\u0627\\u0631 : \",\"date_icon\":{\"value\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/meta-date.svg\",\"id\":1426},\"library\":\"svg\"},\"comments_icon\":{\"value\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/meta-comments.svg\",\"id\":1428},\"library\":\"svg\"}},\"elements\":[],\"widgetType\":\"HarikaSAMetaData\"},{\"id\":\"7ea3bda6\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"icon\":{\"value\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/Upload.svg\",\"id\":1427},\"library\":\"svg\"}},\"elements\":[],\"widgetType\":\"HarikaSAShare\"}],\"isInner\":true},{\"id\":\"1ea667c5\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"style\":\"dashed\",\"text\":\"\\u062c\\u062f\\u0627\\u06a9\\u0646\\u0646\\u062f\\u0647\",\"color\":\"#E4E6EF\",\"gap\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"divider\"},{\"id\":\"340be373\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"editor\":\"<p>\\u0628\\u0631\\u0627\\u06cc \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u0627\\u06cc\\u0646 \\u0645\\u062a\\u0646 \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u062f\\u06a9\\u0645\\u0647 \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f. \\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a. \\u0628\\u0631\\u0627\\u06cc \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u0627\\u06cc\\u0646 \\u0645\\u062a\\u0646 \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u062f\\u06a9\\u0645\\u0647 \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f. \\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a. \\u0628\\u0631\\u0627\\u06cc \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u0627\\u06cc\\u0646 \\u0645\\u062a\\u0646 \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u062f\\u06a9\\u0645\\u0647 \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f. \\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a. \\u0628\\u0631\\u0627\\u06cc \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u0627\\u06cc\\u0646 \\u0645\\u062a\\u0646 \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u062f\\u06a9\\u0645\\u0647 \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f. \\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a. \\u0628\\u0631\\u0627\\u06cc \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u0627\\u06cc\\u0646 \\u0645\\u062a\\u0646 \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u062f\\u06a9\\u0645\\u0647 \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f. \\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a.\\u00a0<\\/p>\",\"text_color\":\"#666666\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"typography_font_weight\":\"400\",\"typography_line_height\":{\"unit\":\"px\",\"size\":38,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":true},{\"id\":\"1f45d03b\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"main_title\":\"\\u0628\\u0631\\u0686\\u0633\\u0628 \\u0647\\u0627 : \"},\"elements\":[],\"widgetType\":\"HarikaSATags\"},{\"id\":\"10a55e2a\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaSAAuthorBox\"},{\"id\":\"18e3e277\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaSANextPrev\"},{\"id\":\"4be27c1f\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"title\":\"\\u0645\\u0642\\u0627\\u0644\\u0627\\u062a \\u0645\\u0631\\u062a\\u0628\\u0637\"},\"elements\":[],\"widgetType\":\"HarikaHeading\"},{\"id\":\"5ac75c04\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"columns_number\":3,\"excerpt_length\":12},\"elements\":[],\"widgetType\":\"HarikaSARelatedPosts\"},{\"id\":\"4670a69e\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaSAComments\"}],\"isInner\":true},{\"id\":\"13aabff2\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":23},\"flex_gap\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"sidebar-col\"},\"elements\":[{\"id\":\"17604001\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u0686\\u06cc\\u0632\\u06cc \\u0645\\u06cc \\u06af\\u0631\\u062f\\u06cc\\u061f\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-search\"}],\"isInner\":true}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1740", "1431", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1741", "1431", "_elementor_template_type", "page");
INSERT INTO `wp_postmeta` VALUES("1742", "1431", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1743", "1431", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1744", "1431", "_elementor_data", "[{\"id\":\"f19ab51\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"padding\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"10\",\"bottom\":\"20\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[{\"id\":\"7ae3e847\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"main_title\":\"\\u0635\\u0641\\u062d\\u0647 \\u0627\\u0635\\u0644\\u06cc\",\"sep\":\" &gt; \"},\"elements\":[],\"widgetType\":\"HarikaSABreadcrumb\"}],\"isInner\":false},{\"id\":\"345aa4b4\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true}},\"elements\":[{\"id\":\"45534776\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":75},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true}},\"elements\":[{\"id\":\"7e014ad0\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"background_background\":\"classic\",\"background_color\":\"#FFFFFF\",\"border_radius\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"15\",\"bottom\":\"15\",\"left\":\"15\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"35\",\"right\":\"35\",\"bottom\":\"35\",\"left\":\"35\",\"isLinked\":true},\"flex_gap\":{\"column\":\"0\",\"row\":\"0\",\"isLinked\":true,\"unit\":\"px\",\"size\":0}},\"elements\":[{\"id\":\"6e173fbb\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"10\",\"row\":\"10\",\"isLinked\":true,\"unit\":\"px\",\"size\":10},\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"25\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"4e6d9737\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaSAPostTitle\"},{\"id\":\"7994a099\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaSACategories\"}],\"isInner\":true},{\"id\":\"29c0e07e\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"featured_type\":\"image-and-format\",\"image_size\":\"single-image\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"m_image_size\":\"medium\"},\"elements\":[],\"widgetType\":\"HarikaSAFeaturedImage\"},{\"id\":\"2f79783\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"center\",\"flex_wrap\":\"wrap\",\"padding\":{\"unit\":\"px\",\"top\":\"25\",\"right\":\"25\",\"bottom\":\"15\",\"left\":\"25\",\"isLinked\":false}},\"elements\":[{\"id\":\"4c4884a9\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"author_before\":\"\\u062a\\u0648\\u0633\\u0637 : \",\"date_before\":\"\\u062a\\u0627\\u0631\\u06cc\\u062e \\u0627\\u0646\\u062a\\u0634\\u0627\\u0631 : \",\"date_icon\":{\"value\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/meta-date.svg\",\"id\":1426},\"library\":\"svg\"},\"comments_icon\":{\"value\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/meta-comments.svg\",\"id\":1428},\"library\":\"svg\"}},\"elements\":[],\"widgetType\":\"HarikaSAMetaData\"},{\"id\":\"7ea3bda6\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"icon\":{\"value\":{\"url\":\"https:\\/\\/webdev-demo.ir\\/harika\\/harika\\/wp-content\\/uploads\\/2024\\/08\\/Upload.svg\",\"id\":1427},\"library\":\"svg\"}},\"elements\":[],\"widgetType\":\"HarikaSAShare\"}],\"isInner\":true},{\"id\":\"1ea667c5\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"style\":\"dashed\",\"text\":\"\\u062c\\u062f\\u0627\\u06a9\\u0646\\u0646\\u062f\\u0647\",\"color\":\"#E4E6EF\",\"gap\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"divider\"},{\"id\":\"340be373\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"editor\":\"<p>\\u0628\\u0631\\u0627\\u06cc \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u0627\\u06cc\\u0646 \\u0645\\u062a\\u0646 \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u062f\\u06a9\\u0645\\u0647 \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f. \\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a. \\u0628\\u0631\\u0627\\u06cc \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u0627\\u06cc\\u0646 \\u0645\\u062a\\u0646 \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u062f\\u06a9\\u0645\\u0647 \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f. \\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a. \\u0628\\u0631\\u0627\\u06cc \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u0627\\u06cc\\u0646 \\u0645\\u062a\\u0646 \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u062f\\u06a9\\u0645\\u0647 \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f. \\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a. \\u0628\\u0631\\u0627\\u06cc \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u0627\\u06cc\\u0646 \\u0645\\u062a\\u0646 \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u062f\\u06a9\\u0645\\u0647 \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f. \\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a. \\u0628\\u0631\\u0627\\u06cc \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u0627\\u06cc\\u0646 \\u0645\\u062a\\u0646 \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u062f\\u06a9\\u0645\\u0647 \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f. \\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a.\\u00a0<\\/p>\",\"text_color\":\"#666666\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"typography_font_weight\":\"400\",\"typography_line_height\":{\"unit\":\"px\",\"size\":38,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":true},{\"id\":\"1f45d03b\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"main_title\":\"\\u0628\\u0631\\u0686\\u0633\\u0628 \\u0647\\u0627 : \"},\"elements\":[],\"widgetType\":\"HarikaSATags\"},{\"id\":\"10a55e2a\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaSAAuthorBox\"},{\"id\":\"18e3e277\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaSANextPrev\"},{\"id\":\"4be27c1f\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"title\":\"\\u0645\\u0642\\u0627\\u0644\\u0627\\u062a \\u0645\\u0631\\u062a\\u0628\\u0637\"},\"elements\":[],\"widgetType\":\"HarikaHeading\"},{\"id\":\"5ac75c04\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"columns_number\":3,\"excerpt_length\":12},\"elements\":[],\"widgetType\":\"HarikaSARelatedPosts\"},{\"id\":\"4670a69e\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaSAComments\"}],\"isInner\":true},{\"id\":\"13aabff2\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":23},\"flex_gap\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"sidebar-col\"},\"elements\":[{\"id\":\"17604001\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u0686\\u06cc\\u0632\\u06cc \\u0645\\u06cc \\u06af\\u0631\\u062f\\u06cc\\u061f\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-search\"}],\"isInner\":true}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1806", "1435", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1807", "1435", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1808", "1435", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1809", "1435", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1810", "1435", "_elementor_data", "[{\"id\":\"1ce44fd\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"4a03439\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"17ce765\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0646\\u0645\\u0648\\u0646\\u0647 \\u0639\\u0646\\u0648\\u0627\\u0646\",\"btn_title\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0647\\u0645\\u0647\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"6649259\",\"elType\":\"widget\",\"settings\":{\"playlist_title\":\"\\u0644\\u06cc\\u0633\\u062a \\u067e\\u062e\\u0634 \\u0648\\u06cc\\u062f\\u06cc\\u0648\",\"videos\":[{\"title\":\"\\u0648\\u06cc\\u0698\\u06af\\u06cc \\u0647\\u0627\\u06cc \\u0642\\u0627\\u0644\\u0628 \\u0647\\u0627\\u0631\\u06cc\\u06a9\\u0627\",\"_id\":\"190deb5\",\"aparat_iframe\":\"<style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}<\\/style><div class=\\\"h_iframe-aparat_embed_frame\\\"><span style=\\\"display: block;padding-top: 57%\\\"><\\/span><iframe src=\\\"https:\\/\\/www.aparat.com\\/video\\/video\\/embed\\/videohash\\/slk4Q\\/vt\\/frame\\\"  allowFullScreen=\\\"true\\\" webkitallowfullscreen=\\\"true\\\" mozallowfullscreen=\\\"true\\\"><\\/iframe><\\/div>\"}]},\"elements\":[],\"widgetType\":\"HarikaVideoPlayList\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1814", "1436", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1815", "1436", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1816", "1436", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1817", "1436", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1818", "1436", "_elementor_data", "[{\"id\":\"1ce44fd\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"4a03439\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"17ce765\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0646\\u0645\\u0648\\u0646\\u0647 \\u0639\\u0646\\u0648\\u0627\\u0646\",\"btn_title\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0647\\u0645\\u0647\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"6649259\",\"elType\":\"widget\",\"settings\":{\"playlist_title\":\"\\u0644\\u06cc\\u0633\\u062a \\u067e\\u062e\\u0634 \\u0648\\u06cc\\u062f\\u06cc\\u0648\",\"videos\":[{\"title\":\"\\u0648\\u06cc\\u0698\\u06af\\u06cc \\u0647\\u0627\\u06cc \\u0642\\u0627\\u0644\\u0628 \\u0647\\u0627\\u0631\\u06cc\\u06a9\\u0627\",\"_id\":\"190deb5\",\"aparat_iframe\":\"<style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}<\\/style><div class=\\\"h_iframe-aparat_embed_frame\\\"><span style=\\\"display: block;padding-top: 57%\\\"><\\/span><iframe src=\\\"https:\\/\\/www.aparat.com\\/video\\/video\\/embed\\/videohash\\/slk4Q\\/vt\\/frame\\\"  allowFullScreen=\\\"true\\\" webkitallowfullscreen=\\\"true\\\" mozallowfullscreen=\\\"true\\\"><\\/iframe><\\/div>\"}]},\"elements\":[],\"widgetType\":\"HarikaVideoPlayList\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1822", "1437", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1823", "1437", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1824", "1437", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1825", "1437", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1826", "1437", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("1830", "1438", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1831", "1438", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1832", "1438", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1833", "1438", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1834", "1438", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("1836", "1439", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1837", "1439", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1838", "1439", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1839", "1439", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1840", "1439", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("1842", "9", "_elementor_page_settings", "a:1:{s:10:\"hide_title\";s:3:\"yes\";}");
INSERT INTO `wp_postmeta` VALUES("1843", "1440", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1844", "1440", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1845", "1440", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1846", "1440", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1847", "1440", "_elementor_data", "[{\"id\":\"78a8815\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\"},\"elements\":[{\"id\":\"8e60622\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"tile_style\":\"1\",\"image_size\":\"harika-700-450\",\"image_hover_scale\":\"1.1\",\"scale_speed\":{\"unit\":\"px\",\"size\":0.5,\"sizes\":[]},\"show_date\":\"\",\"title_wrap\":\"\",\"excerpt_length\":6,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_offset\":1},\"elements\":[],\"widgetType\":\"HarikaHero1\"}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1849", "1440", "_elementor_page_settings", "a:1:{s:10:\"hide_title\";s:3:\"yes\";}");
INSERT INTO `wp_postmeta` VALUES("1852", "1441", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1853", "1441", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1854", "1441", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1855", "1441", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1856", "1441", "_elementor_data", "[{\"id\":\"78a8815\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\"},\"elements\":[{\"id\":\"8e60622\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"tile_style\":\"1\",\"image_size\":\"harika-700-450\",\"image_hover_scale\":\"1.1\",\"scale_speed\":{\"unit\":\"px\",\"size\":0.5,\"sizes\":[]},\"show_date\":\"\",\"title_wrap\":\"\",\"excerpt_length\":6,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_offset\":1},\"elements\":[],\"widgetType\":\"HarikaHero1\"}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1858", "1441", "_elementor_page_settings", "a:1:{s:10:\"hide_title\";s:3:\"yes\";}");
INSERT INTO `wp_postmeta` VALUES("1861", "1442", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1862", "1442", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1863", "1442", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1864", "1442", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1865", "1442", "_elementor_data", "[{\"id\":\"78a8815\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\"},\"elements\":[{\"id\":\"8e60622\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"tile_style\":\"1\",\"image_size\":\"harika-700-450\",\"image_hover_scale\":\"1.1\",\"scale_speed\":{\"unit\":\"px\",\"size\":0.5,\"sizes\":[]},\"show_date\":\"\",\"title_wrap\":\"\",\"excerpt_length\":6,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_offset\":1},\"elements\":[],\"widgetType\":\"HarikaHero1\"}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1867", "1442", "_elementor_page_settings", "a:1:{s:10:\"hide_title\";s:3:\"yes\";}");
INSERT INTO `wp_postmeta` VALUES("1870", "1443", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1871", "1443", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1872", "1443", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1873", "1443", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1874", "1443", "_elementor_data", "[{\"id\":\"78a8815\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"padding\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[{\"id\":\"8e60622\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"tile_style\":\"1\",\"image_size\":\"harika-700-450\",\"image_hover_scale\":\"1.1\",\"scale_speed\":{\"unit\":\"px\",\"size\":0.5,\"sizes\":[]},\"show_date\":\"\",\"title_wrap\":\"\",\"excerpt_length\":6,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_offset\":1},\"elements\":[],\"widgetType\":\"HarikaHero1\"}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1876", "1443", "_elementor_page_settings", "a:1:{s:10:\"hide_title\";s:3:\"yes\";}");
INSERT INTO `wp_postmeta` VALUES("1881", "1444", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1882", "1444", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1883", "1444", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1884", "1444", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1885", "1444", "_elementor_data", "[{\"id\":\"78a8815\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"padding\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[{\"id\":\"8e60622\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"tile_style\":\"1\",\"image_size\":\"harika-700-450\",\"image_hover_scale\":\"1.1\",\"scale_speed\":{\"unit\":\"px\",\"size\":0.5,\"sizes\":[]},\"show_date\":\"\",\"title_wrap\":\"\",\"excerpt_length\":6,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_offset\":1},\"elements\":[],\"widgetType\":\"HarikaHero1\"}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1887", "1444", "_elementor_page_settings", "a:1:{s:10:\"hide_title\";s:3:\"yes\";}");
INSERT INTO `wp_postmeta` VALUES("1890", "1445", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1891", "1445", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1892", "1445", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1893", "1445", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1894", "1445", "_elementor_data", "[{\"id\":\"78a8815\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"padding\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[{\"id\":\"8e60622\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"tile_style\":\"1\",\"image_size\":\"harika-700-450\",\"image_hover_scale\":\"1.1\",\"scale_speed\":{\"unit\":\"px\",\"size\":0.5,\"sizes\":[]},\"show_date\":\"\",\"title_wrap\":\"\",\"excerpt_length\":6,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_offset\":1},\"elements\":[],\"widgetType\":\"HarikaHero1\"}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1896", "1445", "_elementor_page_settings", "a:1:{s:10:\"hide_title\";s:3:\"yes\";}");
INSERT INTO `wp_postmeta` VALUES("1899", "1446", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1900", "1446", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1901", "1446", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1902", "1446", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1903", "1446", "_elementor_data", "[{\"id\":\"78a8815\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"padding\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[{\"id\":\"8e60622\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"tile_style\":\"1\",\"image_size\":\"harika-700-450\",\"image_hover_scale\":\"1.1\",\"scale_speed\":{\"unit\":\"px\",\"size\":0.5,\"sizes\":[]},\"show_date\":\"\",\"title_wrap\":\"\",\"excerpt_length\":6,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_offset\":1},\"elements\":[],\"widgetType\":\"HarikaHero1\"}],\"isInner\":false},{\"id\":\"a19cd4a\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"flex_direction_tablet\":\"column\",\"flex_align_items_tablet\":\"center\",\"margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"62a1183\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":75},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[],\"isInner\":true},{\"id\":\"1899e81\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"px\",\"size\":320},\"flex_gap\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"sidebar-col\",\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"121d9e2\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u0686\\u06cc\\u0632\\u06cc \\u0645\\u06cc \\u06af\\u0631\\u062f\\u06cc\\u061f\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-search\"},{\"id\":\"96ea533\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u0633\\u06a9\\u0627\\u06cc\\u067e\",\"icon\":{\"value\":\"fab fa-skype\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#00AFF0\",\"main_background_background\":\"classic\",\"main_background_color\":\"#00AFF0\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"cfbfbc9\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u06cc\\u0646\\u0633\\u062a\\u0627\\u06af\\u0631\\u0627\\u0645\",\"icon\":{\"value\":\"fab fa-instagram\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#FF0088\",\"main_background_background\":\"classic\",\"main_background_color\":\"#FF0088\",\"main_background_color_b\":\"#6A3CCE\",\"main_background_gradient_angle\":{\"unit\":\"deg\",\"size\":206,\"sizes\":[]},\"main_background_gradient_position\":\"center left\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"2fe72ae\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0641\\u06cc\\u0633 \\u0628\\u0648\\u06a9\",\"icon\":{\"value\":\"fab fa-facebook-square\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#3B5998\",\"main_background_background\":\"classic\",\"main_background_color\":\"#3B5998\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"ecb40e1\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u067e\\u06cc\\u0646\\u062a\\u0631\\u0633\\u062a\",\"icon\":{\"value\":\"fab fa-pinterest\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u067e\\u06cc\\u0646 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#F0002A\",\"main_background_background\":\"classic\",\"main_background_color\":\"#F0002A\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"9861dcb\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0647\\u0627\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-categories\"},{\"id\":\"6eff5a3\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"wp-widget-recent-posts\"},{\"id\":\"e327c82\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u0628\\u0631\\u0686\\u0633\\u0628 \\u0647\\u0627\",\"taxonomy\":\"post_tag\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-tag_cloud\"},{\"id\":\"8f7dd80\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u0622\\u062e\\u0631\\u06cc\\u0646 \\u067e\\u0633\\u062a \\u0647\\u0627\",\"post_count\":\"5\",\"sticky\":\"\"},\"section_sticky_on\":\"yes\",\"section_sticky_offset\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"wp-widget-harika_recent_post_widget\"}],\"isInner\":true}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1905", "1446", "_elementor_page_settings", "a:1:{s:10:\"hide_title\";s:3:\"yes\";}");
INSERT INTO `wp_postmeta` VALUES("1908", "1447", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1909", "1447", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1910", "1447", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1911", "1447", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1912", "1447", "_elementor_data", "[{\"id\":\"78a8815\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"padding\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[{\"id\":\"8e60622\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"tile_style\":\"1\",\"image_size\":\"harika-700-450\",\"image_hover_scale\":\"1.1\",\"scale_speed\":{\"unit\":\"px\",\"size\":0.5,\"sizes\":[]},\"show_date\":\"\",\"title_wrap\":\"\",\"excerpt_length\":6,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_offset\":1},\"elements\":[],\"widgetType\":\"HarikaHero1\"}],\"isInner\":false},{\"id\":\"a19cd4a\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"flex_direction_tablet\":\"column\",\"flex_align_items_tablet\":\"center\",\"margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"62a1183\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":75},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[],\"isInner\":true},{\"id\":\"1899e81\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"px\",\"size\":320},\"flex_gap\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"sidebar-col\",\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"121d9e2\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u0686\\u06cc\\u0632\\u06cc \\u0645\\u06cc \\u06af\\u0631\\u062f\\u06cc\\u061f\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-search\"},{\"id\":\"96ea533\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u0633\\u06a9\\u0627\\u06cc\\u067e\",\"icon\":{\"value\":\"fab fa-skype\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#00AFF0\",\"main_background_background\":\"classic\",\"main_background_color\":\"#00AFF0\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"cfbfbc9\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u06cc\\u0646\\u0633\\u062a\\u0627\\u06af\\u0631\\u0627\\u0645\",\"icon\":{\"value\":\"fab fa-instagram\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#FF0088\",\"main_background_background\":\"classic\",\"main_background_color\":\"#FF0088\",\"main_background_color_b\":\"#6A3CCE\",\"main_background_gradient_angle\":{\"unit\":\"deg\",\"size\":206,\"sizes\":[]},\"main_background_gradient_position\":\"center left\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"2fe72ae\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0641\\u06cc\\u0633 \\u0628\\u0648\\u06a9\",\"icon\":{\"value\":\"fab fa-facebook-square\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#3B5998\",\"main_background_background\":\"classic\",\"main_background_color\":\"#3B5998\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"ecb40e1\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u067e\\u06cc\\u0646\\u062a\\u0631\\u0633\\u062a\",\"icon\":{\"value\":\"fab fa-pinterest\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u067e\\u06cc\\u0646 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#F0002A\",\"main_background_background\":\"classic\",\"main_background_color\":\"#F0002A\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"9861dcb\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0647\\u0627\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-categories\"},{\"id\":\"6eff5a3\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"wp-widget-recent-posts\"},{\"id\":\"e327c82\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u0628\\u0631\\u0686\\u0633\\u0628 \\u0647\\u0627\",\"taxonomy\":\"post_tag\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-tag_cloud\"},{\"id\":\"8f7dd80\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u0622\\u062e\\u0631\\u06cc\\u0646 \\u067e\\u0633\\u062a \\u0647\\u0627\",\"post_count\":\"5\",\"sticky\":\"\"},\"section_sticky_on\":\"yes\",\"section_sticky_offset\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"wp-widget-harika_recent_post_widget\"}],\"isInner\":true}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1914", "1447", "_elementor_page_settings", "a:1:{s:10:\"hide_title\";s:3:\"yes\";}");
INSERT INTO `wp_postmeta` VALUES("1915", "1448", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1916", "1448", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1917", "1448", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1918", "1448", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1919", "1448", "_elementor_data", "[{\"id\":\"78a8815\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"padding\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[{\"id\":\"8e60622\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"tile_style\":\"1\",\"image_size\":\"harika-700-450\",\"image_hover_scale\":\"1.1\",\"scale_speed\":{\"unit\":\"px\",\"size\":0.5,\"sizes\":[]},\"show_date\":\"\",\"title_wrap\":\"\",\"excerpt_length\":6,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_offset\":1},\"elements\":[],\"widgetType\":\"HarikaHero1\"}],\"isInner\":false},{\"id\":\"a19cd4a\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"flex_direction_tablet\":\"column\",\"flex_align_items_tablet\":\"center\",\"margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"62a1183\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":75},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[],\"isInner\":true},{\"id\":\"1899e81\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"px\",\"size\":320},\"flex_gap\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"sidebar-col\",\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"121d9e2\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u0686\\u06cc\\u0632\\u06cc \\u0645\\u06cc \\u06af\\u0631\\u062f\\u06cc\\u061f\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-search\"},{\"id\":\"96ea533\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u0633\\u06a9\\u0627\\u06cc\\u067e\",\"icon\":{\"value\":\"fab fa-skype\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#00AFF0\",\"main_background_background\":\"classic\",\"main_background_color\":\"#00AFF0\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"cfbfbc9\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u06cc\\u0646\\u0633\\u062a\\u0627\\u06af\\u0631\\u0627\\u0645\",\"icon\":{\"value\":\"fab fa-instagram\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#FF0088\",\"main_background_background\":\"classic\",\"main_background_color\":\"#FF0088\",\"main_background_color_b\":\"#6A3CCE\",\"main_background_gradient_angle\":{\"unit\":\"deg\",\"size\":206,\"sizes\":[]},\"main_background_gradient_position\":\"center left\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"2fe72ae\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0641\\u06cc\\u0633 \\u0628\\u0648\\u06a9\",\"icon\":{\"value\":\"fab fa-facebook-square\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#3B5998\",\"main_background_background\":\"classic\",\"main_background_color\":\"#3B5998\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"ecb40e1\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u067e\\u06cc\\u0646\\u062a\\u0631\\u0633\\u062a\",\"icon\":{\"value\":\"fab fa-pinterest\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u067e\\u06cc\\u0646 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#F0002A\",\"main_background_background\":\"classic\",\"main_background_color\":\"#F0002A\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"9861dcb\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0647\\u0627\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-categories\"},{\"id\":\"6eff5a3\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"wp-widget-recent-posts\"},{\"id\":\"e327c82\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u0628\\u0631\\u0686\\u0633\\u0628 \\u0647\\u0627\",\"taxonomy\":\"post_tag\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-tag_cloud\"},{\"id\":\"8f7dd80\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u0622\\u062e\\u0631\\u06cc\\u0646 \\u067e\\u0633\\u062a \\u0647\\u0627\",\"post_count\":\"5\",\"sticky\":\"\"},\"section_sticky_on\":\"yes\",\"section_sticky_offset\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"wp-widget-harika_recent_post_widget\"}],\"isInner\":true}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1921", "1448", "_elementor_page_settings", "a:1:{s:10:\"hide_title\";s:3:\"yes\";}");
INSERT INTO `wp_postmeta` VALUES("1922", "1449", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1923", "1449", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1924", "1449", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1925", "1449", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1926", "1449", "_elementor_data", "[{\"id\":\"78a8815\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"padding\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[{\"id\":\"8e60622\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"tile_style\":\"1\",\"image_size\":\"harika-700-450\",\"image_hover_scale\":\"1.1\",\"scale_speed\":{\"unit\":\"px\",\"size\":0.5,\"sizes\":[]},\"show_date\":\"\",\"title_wrap\":\"\",\"excerpt_length\":6,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_offset\":1},\"elements\":[],\"widgetType\":\"HarikaHero1\"}],\"isInner\":false},{\"id\":\"a19cd4a\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"flex_direction_tablet\":\"column\",\"flex_align_items_tablet\":\"center\",\"margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"62a1183\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":75},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"3d9ae75\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"image_size\":\"harika-700-450\",\"date_type\":\"modified\",\"excerpt_length\":32,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_order\":\"asc\"},\"elements\":[],\"widgetType\":\"HarikaList1\"}],\"isInner\":true},{\"id\":\"1899e81\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"px\",\"size\":320},\"flex_gap\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"sidebar-col\",\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"121d9e2\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u0686\\u06cc\\u0632\\u06cc \\u0645\\u06cc \\u06af\\u0631\\u062f\\u06cc\\u061f\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-search\"},{\"id\":\"96ea533\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u0633\\u06a9\\u0627\\u06cc\\u067e\",\"icon\":{\"value\":\"fab fa-skype\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#00AFF0\",\"main_background_background\":\"classic\",\"main_background_color\":\"#00AFF0\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"cfbfbc9\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u06cc\\u0646\\u0633\\u062a\\u0627\\u06af\\u0631\\u0627\\u0645\",\"icon\":{\"value\":\"fab fa-instagram\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#FF0088\",\"main_background_background\":\"classic\",\"main_background_color\":\"#FF0088\",\"main_background_color_b\":\"#6A3CCE\",\"main_background_gradient_angle\":{\"unit\":\"deg\",\"size\":206,\"sizes\":[]},\"main_background_gradient_position\":\"center left\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"2fe72ae\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0641\\u06cc\\u0633 \\u0628\\u0648\\u06a9\",\"icon\":{\"value\":\"fab fa-facebook-square\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#3B5998\",\"main_background_background\":\"classic\",\"main_background_color\":\"#3B5998\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"ecb40e1\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u067e\\u06cc\\u0646\\u062a\\u0631\\u0633\\u062a\",\"icon\":{\"value\":\"fab fa-pinterest\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u067e\\u06cc\\u0646 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#F0002A\",\"main_background_background\":\"classic\",\"main_background_color\":\"#F0002A\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"9861dcb\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0647\\u0627\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-categories\"},{\"id\":\"6eff5a3\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"wp-widget-recent-posts\"},{\"id\":\"e327c82\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u0628\\u0631\\u0686\\u0633\\u0628 \\u0647\\u0627\",\"taxonomy\":\"post_tag\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-tag_cloud\"},{\"id\":\"8f7dd80\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u0622\\u062e\\u0631\\u06cc\\u0646 \\u067e\\u0633\\u062a \\u0647\\u0627\",\"post_count\":\"5\",\"sticky\":\"\"},\"section_sticky_on\":\"yes\",\"section_sticky_offset\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"wp-widget-harika_recent_post_widget\"}],\"isInner\":true}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1928", "1449", "_elementor_page_settings", "a:1:{s:10:\"hide_title\";s:3:\"yes\";}");
INSERT INTO `wp_postmeta` VALUES("1931", "1450", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1932", "1450", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1933", "1450", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1934", "1450", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1935", "1450", "_elementor_data", "[{\"id\":\"78a8815\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"padding\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[{\"id\":\"8e60622\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"tile_style\":\"1\",\"image_size\":\"harika-700-450\",\"image_hover_scale\":\"1.1\",\"scale_speed\":{\"unit\":\"px\",\"size\":0.5,\"sizes\":[]},\"show_date\":\"\",\"title_wrap\":\"\",\"excerpt_length\":6,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_offset\":1},\"elements\":[],\"widgetType\":\"HarikaHero1\"}],\"isInner\":false},{\"id\":\"a19cd4a\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"flex_direction_tablet\":\"column\",\"flex_align_items_tablet\":\"center\",\"margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"62a1183\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":75},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"3d9ae75\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"image_size\":\"harika-700-450\",\"date_type\":\"modified\",\"excerpt_length\":32,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_order\":\"asc\"},\"elements\":[],\"widgetType\":\"HarikaList1\"}],\"isInner\":true},{\"id\":\"1899e81\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"px\",\"size\":320},\"flex_gap\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"sidebar-col\",\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"121d9e2\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u0686\\u06cc\\u0632\\u06cc \\u0645\\u06cc \\u06af\\u0631\\u062f\\u06cc\\u061f\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-search\"},{\"id\":\"96ea533\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u0633\\u06a9\\u0627\\u06cc\\u067e\",\"icon\":{\"value\":\"fab fa-skype\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#00AFF0\",\"main_background_background\":\"classic\",\"main_background_color\":\"#00AFF0\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"cfbfbc9\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u06cc\\u0646\\u0633\\u062a\\u0627\\u06af\\u0631\\u0627\\u0645\",\"icon\":{\"value\":\"fab fa-instagram\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#FF0088\",\"main_background_background\":\"classic\",\"main_background_color\":\"#FF0088\",\"main_background_color_b\":\"#6A3CCE\",\"main_background_gradient_angle\":{\"unit\":\"deg\",\"size\":206,\"sizes\":[]},\"main_background_gradient_position\":\"center left\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"2fe72ae\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0641\\u06cc\\u0633 \\u0628\\u0648\\u06a9\",\"icon\":{\"value\":\"fab fa-facebook-square\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#3B5998\",\"main_background_background\":\"classic\",\"main_background_color\":\"#3B5998\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"ecb40e1\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u067e\\u06cc\\u0646\\u062a\\u0631\\u0633\\u062a\",\"icon\":{\"value\":\"fab fa-pinterest\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u067e\\u06cc\\u0646 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#F0002A\",\"main_background_background\":\"classic\",\"main_background_color\":\"#F0002A\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"9861dcb\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0647\\u0627\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-categories\"},{\"id\":\"6eff5a3\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"wp-widget-recent-posts\"},{\"id\":\"e327c82\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u0628\\u0631\\u0686\\u0633\\u0628 \\u0647\\u0627\",\"taxonomy\":\"post_tag\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-tag_cloud\"},{\"id\":\"8f7dd80\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u0622\\u062e\\u0631\\u06cc\\u0646 \\u067e\\u0633\\u062a \\u0647\\u0627\",\"post_count\":\"5\",\"sticky\":\"\"},\"section_sticky_on\":\"yes\",\"section_sticky_offset\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"wp-widget-harika_recent_post_widget\"}],\"isInner\":true}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1937", "1450", "_elementor_page_settings", "a:1:{s:10:\"hide_title\";s:3:\"yes\";}");
INSERT INTO `wp_postmeta` VALUES("1940", "1451", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1941", "1451", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1942", "1451", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1943", "1451", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1944", "1451", "_elementor_data", "[{\"id\":\"78a8815\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"padding\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[{\"id\":\"8e60622\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"tile_style\":\"1\",\"image_size\":\"harika-700-450\",\"image_hover_scale\":\"1.1\",\"scale_speed\":{\"unit\":\"px\",\"size\":0.5,\"sizes\":[]},\"show_date\":\"\",\"title_wrap\":\"\",\"excerpt_length\":6,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_offset\":1},\"elements\":[],\"widgetType\":\"HarikaHero1\"}],\"isInner\":false},{\"id\":\"a19cd4a\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"flex_direction_tablet\":\"column\",\"flex_align_items_tablet\":\"center\",\"margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"62a1183\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":75},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"3d9ae75\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"image_size\":\"harika-700-450\",\"date_type\":\"modified\",\"excerpt_length\":32,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_order\":\"asc\"},\"elements\":[],\"widgetType\":\"HarikaList1\"}],\"isInner\":true},{\"id\":\"1899e81\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"px\",\"size\":320},\"flex_gap\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"sidebar-col\",\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"121d9e2\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u0686\\u06cc\\u0632\\u06cc \\u0645\\u06cc \\u06af\\u0631\\u062f\\u06cc\\u061f\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-search\"},{\"id\":\"96ea533\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u0633\\u06a9\\u0627\\u06cc\\u067e\",\"icon\":{\"value\":\"fab fa-skype\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#00AFF0\",\"main_background_background\":\"classic\",\"main_background_color\":\"#00AFF0\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"cfbfbc9\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u06cc\\u0646\\u0633\\u062a\\u0627\\u06af\\u0631\\u0627\\u0645\",\"icon\":{\"value\":\"fab fa-instagram\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#FF0088\",\"main_background_background\":\"classic\",\"main_background_color\":\"#FF0088\",\"main_background_color_b\":\"#6A3CCE\",\"main_background_gradient_angle\":{\"unit\":\"deg\",\"size\":206,\"sizes\":[]},\"main_background_gradient_position\":\"center left\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"2fe72ae\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0641\\u06cc\\u0633 \\u0628\\u0648\\u06a9\",\"icon\":{\"value\":\"fab fa-facebook-square\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#3B5998\",\"main_background_background\":\"classic\",\"main_background_color\":\"#3B5998\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"ecb40e1\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u067e\\u06cc\\u0646\\u062a\\u0631\\u0633\\u062a\",\"icon\":{\"value\":\"fab fa-pinterest\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u067e\\u06cc\\u0646 \\u06a9\\u0646\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#F0002A\",\"main_background_background\":\"classic\",\"main_background_color\":\"#F0002A\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"sticky_effects_offset\":0,\"sticky_effects_offset_widescreen\":\"\",\"sticky_effects_offset_tablet\":\"\",\"sticky_effects_offset_mobile\":\"\",\"sticky_parent\":\"\",\"_attributes\":\"\",\"custom_css\":\"\",\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"HarikaIconLink\"},{\"id\":\"9861dcb\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0647\\u0627\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-categories\"},{\"id\":\"6eff5a3\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\"},\"elements\":[],\"widgetType\":\"wp-widget-recent-posts\"},{\"id\":\"e327c82\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u0628\\u0631\\u0686\\u0633\\u0628 \\u0647\\u0627\",\"taxonomy\":\"post_tag\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-tag_cloud\"},{\"id\":\"8f7dd80\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u0622\\u062e\\u0631\\u06cc\\u0646 \\u067e\\u0633\\u062a \\u0647\\u0627\",\"post_count\":\"5\",\"sticky\":\"\"},\"section_sticky_on\":\"yes\",\"section_sticky_offset\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"wp-widget-harika_recent_post_widget\"}],\"isInner\":true}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("1946", "1451", "_elementor_page_settings", "a:1:{s:10:\"hide_title\";s:3:\"yes\";}");
INSERT INTO `wp_postmeta` VALUES("1949", "1452", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1950", "1452", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("1951", "1452", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("1952", "1452", "_elementor_version", "3.23.4");
INSERT INTO `wp_postmeta` VALUES("1953", "1452", "_elementor_data", "[{\"id\":\"78a8815\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"padding\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[{\"id\":\"8e60622\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"tile_style\":\"1\",\"image_size\":\"harika-700-450\",\"image_hover_scale\":\"1.1\",\"scale_speed\":{\"unit\":\"px\",\"size\":0.5,\"sizes\":[]},\"show_date\":\"\",\"title_wrap\":\"\",\"excerpt_length\":6,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_offset\":1},\"elements\":[],\"widgetType\":\"HarikaHero1\"}],\"isInner\":false},{\"id\":\"a19cd4a\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"flex_direction_tablet\":\"column\",\"flex_align_items_tablet\":\"center\",\"margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"62a1183\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":75},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"3d9ae75\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"item_limit\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"image_size\":\"harika-700-450\",\"date_type\":\"modified\",\"excerpt_length\":32,\"posts_include_by\":[\"terms\"],\"posts_include_term_ids\":[\"8\"],\"posts_order\":\"asc\"},\"elements\":[],\"widgetType\":\"HarikaList1\"}],\"isInner\":true},{\"id\":\"1899e81\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"px\",\"size\":320},\"flex_gap\":{\"column\":\"30\",\"row\":\"30\",\"isLinked\":true,\"unit\":\"px\",\"size\":30},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"sidebar-col\",\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"121d9e2\",\"elType\":\"widget\",\"settings\":{\"content_width\":\"full\",\"wp\":{\"title\":\"\\u062f\\u0646\\u0628\\u0627\\u0644 \\u0686\\u06cc\\u0632\\u06cc \\u0645\\u06cc \\u06af\\u0631\\u062f\\u06cc\\u061f\",\"sticky\":\"\"}},\"elements\":[],\"widgetType\":\"wp-widget-search\"},{\"id\":\"96ea533\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u0633\\u06a9\\u0627\\u06cc\\u067e\",\"icon\":{\"value\":\"fab fa-skype\",\"library\":\"fa-brands\"},\"btn_title\":\"\\u062a\\u0645\\u0627\\u0633 \\u0628\\u06af\\u06cc\\u0631\\u06cc\\u062f\",\"_css_classes\":\"sidebar-no-bg\",\"main_color\":\"#00AFF0\",\"main_background_background\":\"classic\",\"main_background_color\":\"#00AFF0\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-20\",\"left\":\"0\",\"isLinked\":false},\"motion_fx_motion_fx_scrolling\":\"\",\"motion_fx_translateY_effect\":\"\",\"motion_fx_translateY_direction\":\"\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateY_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_translateX_effect\":\"\",\"motion_fx_translateX_direction\":\"\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_translateX_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_opacity_effect\":\"\",\"motion_fx_opacity_direction\":\"out-in\",\"motion_fx_opacity_level\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"motion_fx_opacity_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_blur_effect\":\"\",\"motion_fx_blur_direction\":\"out-in\",\"motion_fx_blur_level\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"motion_fx_blur_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_rotateZ_effect\":\"\",\"motion_fx_rotateZ_direction\":\"\",\"motion_fx_rotateZ_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_rotateZ_affectedRange\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":0,\"end\":100}},\"motion_fx_scale_effect\":\"\",\"motion_fx_scale_direction\":\"out-in\",\"motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"motion_fx_scale_range\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":{\"start\":20,\"end\":80}},\"motion_fx_transform_origin_x\":\"center\",\"motion_fx_transform_origin_y\":\"center\",\"motion_fx_devices\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"motion_fx_range\":\"\",\"motion_fx_motion_fx_mouse\":\"\",\"motion_fx_mouseTrack_effect\":\"\",\"motion_fx_mouseTrack_direction\":\"\",\"motion_fx_mouseTrack_speed\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"motion_fx_tilt_effect\":\"\",\"motion_fx_tilt_direction\":\"\",\"motion_fx_tilt_speed\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"sticky\":\"\",\"sticky_on\":[\"widescreen\",\"desktop\",\"tablet\",\"mobile\"],\"sticky_offset\":0,\"sticky_offset_widescreen\":\"\",\"sticky_offset_tablet\":\"\",\"sticky_offset_mobile\":\"\",\"